/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.security.MessageDigest;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.TransportBulkAction;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.SecureRandomUtils;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.ObjectParserHelper;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.telemetry.metric.MeterRegistry;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterPortSettings;
import org.elasticsearch.xcontent.AbstractObjectParser;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.InstantiatingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.ScrollHelper;
import org.elasticsearch.xpack.core.security.action.ClearSecurityCacheAction;
import org.elasticsearch.xpack.core.security.action.ClearSecurityCacheRequest;
import org.elasticsearch.xpack.core.security.action.ClearSecurityCacheResponse;
import org.elasticsearch.xpack.core.security.action.apikey.AbstractCreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.ApiKey;
import org.elasticsearch.xpack.core.security.action.apikey.BaseBulkUpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.BaseUpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.BulkUpdateApiKeyResponse;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyResponse;
import org.elasticsearch.xpack.core.security.action.apikey.InvalidateApiKeyResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmDomain;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.RemoteClusterPermissions;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivileges;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.core.security.authz.store.RoleReference;
import org.elasticsearch.xpack.core.security.support.MetadataUtils;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.Authenticator;
import org.elasticsearch.xpack.security.authc.InactiveApiKeysRemover;
import org.elasticsearch.xpack.security.metric.SecurityCacheMetrics;
import org.elasticsearch.xpack.security.support.CacheInvalidatorRegistry;
import org.elasticsearch.xpack.security.support.FeatureNotEnabledException;
import org.elasticsearch.xpack.security.support.LockingAtomicCounter;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class ApiKeyService
implements Closeable {
    private static final Logger logger = LogManager.getLogger(ApiKeyService.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ApiKeyService.class);
    public static final Setting<String> STORED_HASH_ALGO_SETTING = XPackSettings.defaultStoredSecureTokenHashAlgorithmSetting((String)"xpack.security.authc.api_key.hashing.algorithm", s -> Hasher.SSHA256.name());
    public static final Setting<TimeValue> DELETE_TIMEOUT = Setting.timeSetting((String)"xpack.security.authc.api_key.delete.timeout", (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> DELETE_INTERVAL = Setting.timeSetting((String)"xpack.security.authc.api_key.delete.interval", (TimeValue)TimeValue.timeValueHours((long)24L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> DELETE_RETENTION_PERIOD = Setting.positiveTimeSetting((String)"xpack.security.authc.api_key.delete.retention_period", (TimeValue)TimeValue.timeValueDays((long)7L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<String> CACHE_HASH_ALGO_SETTING = Setting.simpleString((String)"xpack.security.authc.api_key.cache.hash_algo", (String)Hasher.SSHA256.name(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> CACHE_TTL_SETTING = Setting.timeSetting((String)"xpack.security.authc.api_key.cache.ttl", (TimeValue)TimeValue.timeValueHours((long)24L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> CACHE_MAX_KEYS_SETTING = Setting.intSetting((String)"xpack.security.authc.api_key.cache.max_keys", (int)25000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> DOC_CACHE_TTL_SETTING = Setting.timeSetting((String)"xpack.security.authc.api_key.doc_cache.ttl", (TimeValue)TimeValue.timeValueMinutes((long)5L), (TimeValue)TimeValue.timeValueMinutes((long)0L), (TimeValue)TimeValue.timeValueMinutes((long)15L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final RoleDescriptor.Parser ROLE_DESCRIPTOR_PARSER = RoleDescriptor.parserBuilder().allowRestriction(true).build();
    private final Clock clock;
    private final Client client;
    private final SecurityIndexManager securityIndex;
    private final ClusterService clusterService;
    private final Hasher hasher;
    private final boolean enabled;
    private final Settings settings;
    private final InactiveApiKeysRemover inactiveApiKeysRemover;
    private final Cache<String, ListenableFuture<CachedApiKeyHashResult>> apiKeyAuthCache;
    private final Hasher cacheHasher;
    private final ThreadPool threadPool;
    private final ApiKeyDocCache apiKeyDocCache;
    private static final int API_KEY_SECRET_NUM_BYTES = 16;
    private static final int API_KEY_SECRET_LENGTH = 22;
    private static final long EVICTION_MONITOR_INTERVAL_SECONDS = 300L;
    private static final long EVICTION_MONITOR_INTERVAL_NANOS = 300000000000L;
    private static final long EVICTION_WARNING_THRESHOLD = 4500L;
    private final AtomicLong lastEvictionCheckedAt = new AtomicLong(0L);
    private final LongAdder evictionCounter = new LongAdder();
    private final List<AutoCloseable> cacheMetrics;
    static final RoleDescriptor LEGACY_SUPERUSER_ROLE_DESCRIPTOR = new RoleDescriptor("superuser", new String[]{"all"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(new String[]{"*"}).privileges(new String[]{"all"}).allowRestrictedIndices(true).build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("*").privileges(new String[]{"*"}).resources(new String[]{"*"}).build()}, null, new String[]{"*"}, MetadataUtils.DEFAULT_RESERVED_METADATA, Collections.emptyMap());

    public ApiKeyService(Settings settings, Clock clock, Client client, SecurityIndexManager securityIndex, ClusterService clusterService, CacheInvalidatorRegistry cacheInvalidatorRegistry, ThreadPool threadPool, MeterRegistry meterRegistry) {
        this.clock = clock;
        this.client = client;
        this.securityIndex = securityIndex;
        this.clusterService = clusterService;
        this.enabled = (Boolean)XPackSettings.API_KEY_SERVICE_ENABLED_SETTING.get(settings);
        this.hasher = Hasher.resolve((String)((String)STORED_HASH_ALGO_SETTING.get(settings)));
        this.settings = settings;
        this.inactiveApiKeysRemover = new InactiveApiKeysRemover(settings, client, clusterService);
        this.threadPool = threadPool;
        this.cacheHasher = Hasher.resolve((String)((String)CACHE_HASH_ALGO_SETTING.get(settings)));
        TimeValue ttl = (TimeValue)CACHE_TTL_SETTING.get(settings);
        int maximumWeight = (Integer)CACHE_MAX_KEYS_SETTING.get(settings);
        if (ttl.getNanos() > 0L) {
            this.apiKeyAuthCache = CacheBuilder.builder().setExpireAfterAccess(ttl).setMaximumWeight((long)maximumWeight).removalListener(this.getAuthCacheRemovalListener(maximumWeight)).build();
            TimeValue doc_ttl = (TimeValue)DOC_CACHE_TTL_SETTING.get(settings);
            this.apiKeyDocCache = doc_ttl.getNanos() == 0L ? null : new ApiKeyDocCache(doc_ttl, maximumWeight);
            cacheInvalidatorRegistry.registerCacheInvalidator("api_key", new CacheInvalidatorRegistry.CacheInvalidator(){

                @Override
                public void invalidate(Collection<String> keys) {
                    if (ApiKeyService.this.apiKeyDocCache != null) {
                        ApiKeyService.this.apiKeyDocCache.invalidate(keys);
                    }
                    if (ApiKeyService.this.apiKeyAuthCache != null) {
                        keys.forEach(arg_0 -> ApiKeyService.this.apiKeyAuthCache.invalidate(arg_0));
                    }
                }

                @Override
                public void invalidateAll() {
                    if (ApiKeyService.this.apiKeyDocCache != null) {
                        ApiKeyService.this.apiKeyDocCache.invalidateAll();
                    }
                    if (ApiKeyService.this.apiKeyAuthCache != null) {
                        ApiKeyService.this.apiKeyAuthCache.invalidateAll();
                    }
                }
            });
            cacheInvalidatorRegistry.registerCacheInvalidator("api_key_doc", new CacheInvalidatorRegistry.CacheInvalidator(){

                @Override
                public void invalidate(Collection<String> keys) {
                    if (ApiKeyService.this.apiKeyDocCache != null) {
                        ApiKeyService.this.apiKeyDocCache.invalidate(keys);
                    }
                }

                @Override
                public void invalidateAll() {
                    if (ApiKeyService.this.apiKeyDocCache != null) {
                        ApiKeyService.this.apiKeyDocCache.invalidateAll();
                    }
                }
            });
        } else {
            this.apiKeyAuthCache = null;
            this.apiKeyDocCache = null;
        }
        if (this.enabled) {
            ArrayList<AutoCloseable> cacheMetrics = new ArrayList<AutoCloseable>();
            if (this.apiKeyAuthCache != null) {
                cacheMetrics.addAll(SecurityCacheMetrics.registerAsyncCacheMetrics(meterRegistry, this.apiKeyAuthCache, SecurityCacheMetrics.CacheType.API_KEY_AUTH_CACHE));
            }
            if (this.apiKeyDocCache != null) {
                cacheMetrics.addAll(SecurityCacheMetrics.registerAsyncCacheMetrics(meterRegistry, this.apiKeyDocCache.docCache, SecurityCacheMetrics.CacheType.API_KEY_DOCS_CACHE));
                cacheMetrics.addAll(SecurityCacheMetrics.registerAsyncCacheMetrics(meterRegistry, this.apiKeyDocCache.roleDescriptorsBytesCache, SecurityCacheMetrics.CacheType.API_KEY_ROLE_DESCRIPTORS_CACHE));
            }
            this.cacheMetrics = List.copyOf(cacheMetrics);
        } else {
            this.cacheMetrics = List.of();
        }
    }

    public void createApiKey(Authentication authentication, AbstractCreateApiKeyRequest request, Set<RoleDescriptor> userRoleDescriptors, ActionListener<CreateApiKeyResponse> listener) {
        assert (request.getType() != ApiKey.Type.CROSS_CLUSTER || !authentication.isApiKey()) : "cannot create derived cross-cluster API keys (name=[" + request.getName() + "], type=[" + String.valueOf(request.getType()) + "], auth=[" + String.valueOf(authentication) + "])";
        assert (request.getType() != ApiKey.Type.CROSS_CLUSTER || userRoleDescriptors.isEmpty()) : "owner user role descriptor must be empty for cross-cluster API keys (name=[" + request.getName() + "], type=[" + String.valueOf(request.getType()) + "], roles=[" + String.valueOf(userRoleDescriptors) + "])";
        this.ensureEnabled();
        if (authentication == null) {
            listener.onFailure((Exception)new IllegalArgumentException("authentication must be provided"));
        } else {
            TransportVersion transportVersion = this.getMinTransportVersion();
            if (!this.validateRoleDescriptorsForMixedCluster(listener, request.getRoleDescriptors(), transportVersion)) {
                return;
            }
            if (transportVersion.before((VersionId)RemoteClusterPortSettings.TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY) && request.getType() == ApiKey.Type.CROSS_CLUSTER) {
                listener.onFailure((Exception)new IllegalArgumentException("all nodes must have version [" + RemoteClusterPortSettings.TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY.toReleaseVersion() + "] or higher to support creating cross cluster API keys"));
                return;
            }
            IllegalArgumentException workflowsValidationException = ApiKeyService.validateWorkflowsRestrictionConstraints(transportVersion, request.getRoleDescriptors(), userRoleDescriptors);
            if (workflowsValidationException != null) {
                listener.onFailure((Exception)workflowsValidationException);
                return;
            }
            Set<RoleDescriptor> filteredRoleDescriptors = this.filterRoleDescriptorsForMixedCluster(userRoleDescriptors, transportVersion, request.getId());
            this.createApiKeyAndIndexIt(authentication, request, filteredRoleDescriptors, listener);
        }
    }

    private Set<RoleDescriptor> filterRoleDescriptorsForMixedCluster(Set<RoleDescriptor> userRoleDescriptors, TransportVersion transportVersion, String ... apiKeyIds) {
        Set<RoleDescriptor> userRolesWithoutDescription = ApiKeyService.removeUserRoleDescriptorDescriptions(userRoleDescriptors);
        return ApiKeyService.maybeRemoveRemotePrivileges(userRolesWithoutDescription, transportVersion, apiKeyIds);
    }

    private boolean validateRoleDescriptorsForMixedCluster(ActionListener<?> listener, List<RoleDescriptor> roleDescriptors, TransportVersion transportVersion) {
        if (transportVersion.before((VersionId)RemoteClusterPortSettings.TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY) && ApiKeyService.hasRemoteIndices(roleDescriptors)) {
            listener.onFailure((Exception)new IllegalArgumentException("all nodes must have version [" + RemoteClusterPortSettings.TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY.toReleaseVersion() + "] or higher to support remote indices privileges for API keys"));
            return false;
        }
        if (transportVersion.before((VersionId)RemoteClusterPermissions.ROLE_REMOTE_CLUSTER_PRIVS) && ApiKeyService.hasRemoteCluster(roleDescriptors)) {
            listener.onFailure((Exception)new IllegalArgumentException("all nodes must have version [" + RemoteClusterPermissions.ROLE_REMOTE_CLUSTER_PRIVS.toReleaseVersion() + "] or higher to support remote cluster privileges for API keys"));
            return false;
        }
        if (transportVersion.before((VersionId)TransportVersions.V_8_16_0) && ApiKeyService.hasGlobalManageRolesPrivilege(roleDescriptors)) {
            listener.onFailure((Exception)new IllegalArgumentException("all nodes must have version [" + TransportVersions.V_8_16_0.toReleaseVersion() + "] or higher to support the manage roles privilege for API keys"));
            return false;
        }
        return true;
    }

    static Set<RoleDescriptor> removeUserRoleDescriptorDescriptions(Set<RoleDescriptor> userRoleDescriptors) {
        return userRoleDescriptors.stream().map(roleDescriptor -> {
            if (roleDescriptor.hasDescription()) {
                return new RoleDescriptor(roleDescriptor.getName(), roleDescriptor.getClusterPrivileges(), roleDescriptor.getIndicesPrivileges(), roleDescriptor.getApplicationPrivileges(), roleDescriptor.getConditionalClusterPrivileges(), roleDescriptor.getRunAs(), roleDescriptor.getMetadata(), roleDescriptor.getTransientMetadata(), roleDescriptor.getRemoteIndicesPrivileges(), roleDescriptor.getRemoteClusterPermissions(), roleDescriptor.getRestriction(), null);
            }
            return roleDescriptor;
        }).collect(Collectors.toSet());
    }

    private TransportVersion getMinTransportVersion() {
        return this.clusterService.state().getMinTransportVersion();
    }

    private static boolean hasRemoteIndices(Collection<RoleDescriptor> roleDescriptors) {
        return roleDescriptors != null && roleDescriptors.stream().anyMatch(RoleDescriptor::hasRemoteIndicesPrivileges);
    }

    private static boolean hasRemoteCluster(Collection<RoleDescriptor> roleDescriptors) {
        return roleDescriptors != null && roleDescriptors.stream().anyMatch(RoleDescriptor::hasRemoteClusterPermissions);
    }

    private static boolean hasGlobalManageRolesPrivilege(Collection<RoleDescriptor> roleDescriptors) {
        return roleDescriptors != null && roleDescriptors.stream().flatMap(roleDescriptor -> Arrays.stream(roleDescriptor.getConditionalClusterPrivileges())).anyMatch(privilege -> privilege instanceof ConfigurableClusterPrivileges.ManageRolesPrivilege);
    }

    private static IllegalArgumentException validateWorkflowsRestrictionConstraints(TransportVersion transportVersion, List<RoleDescriptor> requestRoleDescriptors, Set<RoleDescriptor> userRoleDescriptors) {
        if (ApiKeyService.getNumberOfRoleDescriptorsWithRestriction(userRoleDescriptors) > 0L) {
            return new IllegalArgumentException("owner user role descriptors must not include restriction");
        }
        long numberOfRoleDescriptorsWithRestriction = ApiKeyService.getNumberOfRoleDescriptorsWithRestriction(requestRoleDescriptors);
        if (numberOfRoleDescriptorsWithRestriction > 0L) {
            if (transportVersion.before((VersionId)RoleDescriptor.WORKFLOWS_RESTRICTION_VERSION)) {
                return new IllegalArgumentException("all nodes must have version [" + RoleDescriptor.WORKFLOWS_RESTRICTION_VERSION.toReleaseVersion() + "] or higher to support restrictions for API keys");
            }
            if (numberOfRoleDescriptorsWithRestriction != 1L) {
                return new IllegalArgumentException("more than one role descriptor with restriction is not supported");
            }
            if (numberOfRoleDescriptorsWithRestriction != (long)requestRoleDescriptors.size()) {
                return new IllegalArgumentException("combining role descriptors with and without restriction is not supported");
            }
        }
        return null;
    }

    private static long getNumberOfRoleDescriptorsWithRestriction(Collection<RoleDescriptor> roleDescriptors) {
        if (roleDescriptors == null || roleDescriptors.isEmpty()) {
            return 0L;
        }
        return roleDescriptors.stream().filter(RoleDescriptor::hasRestriction).count();
    }

    private void createApiKeyAndIndexIt(Authentication authentication, AbstractCreateApiKeyRequest request, Set<RoleDescriptor> userRoleDescriptors, ActionListener<CreateApiKeyResponse> listener) {
        Instant created = this.clock.instant();
        Instant expiration = ApiKeyService.getApiKeyExpiration(created, request.getExpiration());
        SecureString apiKey = SecureRandomUtils.getBase64SecureRandomString((int)16);
        assert (ApiKey.Type.CROSS_CLUSTER != request.getType() || 22 == apiKey.length()) : "Invalid API key (name=[" + request.getName() + "], type=[" + String.valueOf(request.getType()) + "], length=[" + apiKey.length() + "])";
        this.computeHashForApiKey(apiKey, (ActionListener<char[]>)listener.delegateFailure((l, apiKeyHashChars) -> {
            try (XContentBuilder builder = ApiKeyService.newDocument(apiKeyHashChars, request.getName(), authentication, userRoleDescriptors, created, expiration, request.getRoleDescriptors(), request.getType(), ApiKey.CURRENT_API_KEY_VERSION, request.getMetadata());){
                BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
                bulkRequestBuilder.add(this.client.prepareIndex(".security").setSource(builder).setId(request.getId()).setOpType(DocWriteRequest.OpType.CREATE).request());
                bulkRequestBuilder.setRefreshPolicy(request.getRefreshPolicy());
                BulkRequest bulkRequest = bulkRequestBuilder.request();
                this.securityIndex.prepareIndexIfNeededThenExecute(arg_0 -> ((ActionListener)listener).onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)TransportBulkAction.TYPE, (ActionRequest)bulkRequest, (ActionListener)TransportBulkAction.unwrappingSingleItemBulkResponse((ActionListener)ActionListener.wrap(indexResponse -> {
                    assert (request.getId().equals(indexResponse.getId())) : "Mismatched API key (request=[" + request.getId() + "](name=[" + request.getName() + "]) index=[" + indexResponse.getId() + "])";
                    assert (indexResponse.getResult() == DocWriteResponse.Result.CREATED) : "Index response was [" + String.valueOf(indexResponse.getResult()) + "]";
                    if (this.apiKeyAuthCache != null) {
                        ListenableFuture listenableFuture = new ListenableFuture();
                        listenableFuture.onResponse((Object)new CachedApiKeyHashResult(true, apiKey));
                        this.apiKeyAuthCache.put((Object)request.getId(), (Object)listenableFuture);
                    }
                    listener.onResponse((Object)new CreateApiKeyResponse(request.getName(), request.getId(), apiKey, expiration));
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)))));
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
            }
            finally {
                Arrays.fill(apiKeyHashChars, '\u0000');
            }
        }));
    }

    public void updateApiKeys(Authentication authentication, BaseBulkUpdateApiKeyRequest request, Set<RoleDescriptor> userRoleDescriptors, ActionListener<BulkUpdateApiKeyResponse> listener) {
        assert (request.getType() != ApiKey.Type.CROSS_CLUSTER || userRoleDescriptors.isEmpty()) : "owner user role descriptor must be empty for cross-cluster API keys (ids=[" + String.valueOf(request.getIds().size() <= 10 ? request.getIds() : request.getIds().size() + " including " + String.valueOf(request.getIds().subList(0, 10))) + "], type=[" + String.valueOf(request.getType()) + "], roles=[" + String.valueOf(userRoleDescriptors) + "])";
        this.ensureEnabled();
        if (authentication == null) {
            listener.onFailure((Exception)new IllegalArgumentException("authentication must be provided"));
            return;
        }
        if (authentication.isApiKey()) {
            listener.onFailure((Exception)new IllegalArgumentException("authentication via API key not supported: only the owner user can update an API key"));
            return;
        }
        TransportVersion transportVersion = this.getMinTransportVersion();
        if (!this.validateRoleDescriptorsForMixedCluster(listener, request.getRoleDescriptors(), transportVersion)) {
            return;
        }
        IllegalArgumentException workflowsValidationException = ApiKeyService.validateWorkflowsRestrictionConstraints(transportVersion, request.getRoleDescriptors(), userRoleDescriptors);
        if (workflowsValidationException != null) {
            listener.onFailure((Exception)workflowsValidationException);
            return;
        }
        String[] apiKeyIds = (String[])request.getIds().toArray(String[]::new);
        if (logger.isDebugEnabled()) {
            logger.debug("Updating [{}] API keys", (Object)ApiKeyService.buildDelimitedStringWithLimit(10, apiKeyIds));
        }
        Set<RoleDescriptor> filteredRoleDescriptors = this.filterRoleDescriptorsForMixedCluster(userRoleDescriptors, transportVersion, apiKeyIds);
        this.findVersionedApiKeyDocsForSubject(authentication, apiKeyIds, (ActionListener<Collection<VersionedApiKeyDoc>>)ActionListener.wrap(versionedDocs -> this.updateApiKeys(authentication, request, filteredRoleDescriptors, (Collection<VersionedApiKeyDoc>)versionedDocs, listener), ex -> listener.onFailure(ApiKeyService.traceLog("bulk update", ex))));
    }

    private void updateApiKeys(Authentication authentication, BaseBulkUpdateApiKeyRequest request, Set<RoleDescriptor> userRoleDescriptors, Collection<VersionedApiKeyDoc> targetVersionedDocs, ActionListener<BulkUpdateApiKeyResponse> listener) {
        logger.trace("Found [{}] API keys of [{}] requested for update", (Object)targetVersionedDocs.size(), (Object)request.getIds().size());
        assert (targetVersionedDocs.size() <= request.getIds().size()) : "more docs were found for update than were requested. found [" + targetVersionedDocs.size() + "] requested [" + request.getIds().size() + "]";
        BulkUpdateApiKeyResponse.Builder responseBuilder = BulkUpdateApiKeyResponse.builder();
        BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
        for (VersionedApiKeyDoc versionedDoc : targetVersionedDocs) {
            String apiKeyId = versionedDoc.id();
            try {
                boolean isNoop;
                this.validateForUpdate(apiKeyId, request.getType(), authentication, versionedDoc.doc());
                IndexRequest indexRequest = this.maybeBuildIndexRequest(versionedDoc, authentication, (BaseUpdateApiKeyRequest)request, userRoleDescriptors);
                boolean bl = isNoop = indexRequest == null;
                if (isNoop) {
                    logger.debug("Detected noop update request for API key [{}]. Skipping index request", (Object)apiKeyId);
                    responseBuilder.noop(apiKeyId);
                    continue;
                }
                bulkRequestBuilder.add(indexRequest);
            }
            catch (Exception ex2) {
                responseBuilder.error(apiKeyId, ApiKeyService.traceLog("prepare index request for update", ex2));
            }
        }
        ApiKeyService.addErrorsForNotFoundApiKeys(responseBuilder, targetVersionedDocs, request.getIds());
        if (bulkRequestBuilder.numberOfActions() == 0) {
            logger.trace("No bulk request execution necessary for API key update");
            listener.onResponse((Object)responseBuilder.build());
            return;
        }
        logger.trace("Executing bulk request to update [{}] API keys", (Object)bulkRequestBuilder.numberOfActions());
        bulkRequestBuilder.setRefreshPolicy(ApiKeyService.defaultCreateDocRefreshPolicy(this.settings));
        this.securityIndex.prepareIndexIfNeededThenExecute(ex -> listener.onFailure(ApiKeyService.traceLog("prepare security index before update", ex)), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)bulkRequestBuilder.request(), (ActionListener)ActionListener.wrap(bulkResponse -> this.buildResponseAndClearCache((BulkResponse)bulkResponse, responseBuilder, listener), ex -> listener.onFailure(ApiKeyService.traceLog("execute bulk request for update", ex))), (arg_0, arg_1) -> ((Client)this.client).bulk(arg_0, arg_1)));
    }

    void validateForUpdate(String apiKeyId, ApiKey.Type expectedType, Authentication authentication, ApiKeyDoc apiKeyDoc) {
        boolean expired;
        assert (authentication.getEffectiveSubject().getUser().principal().equals(apiKeyDoc.creator.get("principal"))) : "Authenticated user should be owner (authentication=[" + String.valueOf(authentication) + "], owner=[" + String.valueOf(apiKeyDoc.creator) + "], id=[" + apiKeyId + "])";
        if (apiKeyDoc.invalidated.booleanValue()) {
            throw new IllegalArgumentException("cannot update invalidated API key [" + apiKeyId + "]");
        }
        boolean bl = expired = apiKeyDoc.expirationTime != -1L && this.clock.instant().isAfter(Instant.ofEpochMilli(apiKeyDoc.expirationTime));
        if (expired) {
            throw new IllegalArgumentException("cannot update expired API key [" + apiKeyId + "]");
        }
        if (org.elasticsearch.common.Strings.isNullOrEmpty((String)apiKeyDoc.name)) {
            throw new IllegalArgumentException("cannot update legacy API key [" + apiKeyId + "] without name");
        }
        if (expectedType != apiKeyDoc.type) {
            throw new IllegalArgumentException("cannot update API key of type [" + apiKeyDoc.type.value() + "] while expected type is [" + expectedType.value() + "]");
        }
    }

    static Set<RoleDescriptor> maybeRemoveRemotePrivileges(Set<RoleDescriptor> userRoleDescriptors, TransportVersion transportVersion, String ... apiKeyIds) {
        if (transportVersion.before((VersionId)RemoteClusterPortSettings.TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY) || transportVersion.before((VersionId)RemoteClusterPermissions.ROLE_REMOTE_CLUSTER_PRIVS)) {
            HashSet affectedRoles = new HashSet();
            Set<RoleDescriptor> result = userRoleDescriptors.stream().map(roleDescriptor -> {
                if (roleDescriptor.hasRemoteIndicesPrivileges() || roleDescriptor.hasRemoteClusterPermissions()) {
                    affectedRoles.add(roleDescriptor);
                    return new RoleDescriptor(roleDescriptor.getName(), roleDescriptor.getClusterPrivileges(), roleDescriptor.getIndicesPrivileges(), roleDescriptor.getApplicationPrivileges(), roleDescriptor.getConditionalClusterPrivileges(), roleDescriptor.getRunAs(), roleDescriptor.getMetadata(), roleDescriptor.getTransientMetadata(), (RoleDescriptor.RemoteIndicesPrivileges[])(roleDescriptor.hasRemoteIndicesPrivileges() && transportVersion.before((VersionId)RemoteClusterPortSettings.TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY) ? null : roleDescriptor.getRemoteIndicesPrivileges()), (RemoteClusterPermissions)(roleDescriptor.hasRemoteClusterPermissions() && transportVersion.before((VersionId)RemoteClusterPermissions.ROLE_REMOTE_CLUSTER_PRIVS) ? null : roleDescriptor.getRemoteClusterPermissions()), roleDescriptor.getRestriction(), roleDescriptor.getDescription());
                }
                return roleDescriptor;
            }).collect(Collectors.toSet());
            if (!affectedRoles.isEmpty()) {
                List affectedRolesNames = affectedRoles.stream().map(RoleDescriptor::getName).sorted().collect(Collectors.toList());
                if (affectedRoles.stream().anyMatch(RoleDescriptor::hasRemoteIndicesPrivileges) && transportVersion.before((VersionId)RemoteClusterPortSettings.TRANSPORT_VERSION_ADVANCED_REMOTE_CLUSTER_SECURITY)) {
                    logger.info("removed remote indices privileges from role(s) {} for API key(s) [{}]", affectedRolesNames, (Object)ApiKeyService.buildDelimitedStringWithLimit(10, apiKeyIds));
                    HeaderWarning.addWarning((String)("Removed API key's remote indices privileges from role(s) " + String.valueOf(affectedRolesNames) + ". Remote indices are not supported by all nodes in the cluster. "), (Object[])new Object[0]);
                }
                if (affectedRoles.stream().anyMatch(RoleDescriptor::hasRemoteClusterPermissions) && transportVersion.before((VersionId)RemoteClusterPermissions.ROLE_REMOTE_CLUSTER_PRIVS)) {
                    logger.info("removed remote cluster privileges from role(s) {} for API key(s) [{}]", affectedRolesNames, (Object)ApiKeyService.buildDelimitedStringWithLimit(10, apiKeyIds));
                    HeaderWarning.addWarning((String)("Removed API key's remote cluster privileges from role(s) " + String.valueOf(affectedRolesNames) + ". Remote cluster privileges are not supported by all nodes in the cluster."), (Object[])new Object[0]);
                }
            }
            return result;
        }
        return userRoleDescriptors;
    }

    static String buildDelimitedStringWithLimit(int limit, String ... values) {
        if (limit <= 0) {
            throw new IllegalArgumentException("limit must be positive number");
        }
        if (values == null || values.length <= 0) {
            return "";
        }
        int total = values.length;
        int omitted = Math.max(0, total - limit);
        int valuesToAppend = Math.min(limit, total);
        int capacityForOmittedInfoText = 5;
        int capacity = valuesToAppend + (omitted > 0 ? 5 : 0);
        StringBuilder sb = new StringBuilder(capacity);
        int counter = 0;
        while (counter < valuesToAppend) {
            sb.append(values[counter]);
            if (++counter >= valuesToAppend) continue;
            sb.append(", ");
        }
        if (omitted > 0) {
            sb.append("... (").append(total).append(" in total, ").append(omitted).append(" omitted)");
        }
        return sb.toString();
    }

    static XContentBuilder newDocument(char[] apiKeyHashChars, String name, Authentication authentication, Set<RoleDescriptor> userRoleDescriptors, Instant created, Instant expiration, List<RoleDescriptor> keyRoleDescriptors, ApiKey.Type type, ApiKey.Version version, @Nullable Map<String, Object> metadata) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject().field("doc_type", "api_key").field("type", type.value()).field("creation_time", created.toEpochMilli()).field("expiration_time", expiration == null ? null : Long.valueOf(expiration.toEpochMilli())).field("api_key_invalidated", false);
        ApiKeyService.addApiKeyHash(builder, apiKeyHashChars);
        ApiKeyService.addRoleDescriptors(builder, keyRoleDescriptors);
        ApiKeyService.addLimitedByRoleDescriptors(builder, userRoleDescriptors);
        builder.field("name", name).field("version", version.version()).field("metadata_flattened", metadata);
        ApiKeyService.addCreator(builder, authentication);
        return builder.endObject();
    }

    @Nullable
    static XContentBuilder maybeBuildUpdatedDocument(String apiKeyId, ApiKeyDoc currentApiKeyDoc, ApiKey.Version targetDocVersion, Authentication authentication, BaseUpdateApiKeyRequest request, Set<RoleDescriptor> userRoleDescriptors, Clock clock) throws IOException {
        assert (currentApiKeyDoc.type == request.getType()) : "API Key doc does not match request type (key-id=[" + apiKeyId + "], doc=[" + String.valueOf(currentApiKeyDoc.type) + "], request=[" + String.valueOf(request.getType()) + "])";
        if (ApiKeyService.isNoop(apiKeyId, currentApiKeyDoc, targetDocVersion, authentication, request, userRoleDescriptors)) {
            return null;
        }
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject().field("doc_type", "api_key").field("type", currentApiKeyDoc.type.value()).field("creation_time", currentApiKeyDoc.creationTime).field("api_key_invalidated", false);
        if (request.getExpiration() != null) {
            builder.field("expiration_time", ApiKeyService.getApiKeyExpiration(clock.instant(), request.getExpiration()).toEpochMilli());
        } else {
            builder.field("expiration_time", currentApiKeyDoc.expirationTime == -1L ? null : Long.valueOf(currentApiKeyDoc.expirationTime));
        }
        ApiKeyService.addApiKeyHash(builder, currentApiKeyDoc.hash.toCharArray());
        List keyRoles = request.getRoleDescriptors();
        if (keyRoles != null) {
            logger.trace(() -> Strings.format((String)"Building API key doc with updated role descriptors [%s]", (Object[])new Object[]{keyRoles}));
            ApiKeyService.addRoleDescriptors(builder, keyRoles);
        } else {
            assert (currentApiKeyDoc.roleDescriptorsBytes != null) : "Role descriptors for [" + apiKeyId + "] are null";
            builder.rawField("role_descriptors", (InputStream)currentApiKeyDoc.roleDescriptorsBytes.streamInput(), XContentType.JSON);
        }
        ApiKeyService.addLimitedByRoleDescriptors(builder, userRoleDescriptors);
        builder.field("name", currentApiKeyDoc.name).field("version", targetDocVersion.version());
        assert (currentApiKeyDoc.metadataFlattened == null || !MetadataUtils.containsReservedMetadata((Map)((Map)XContentHelper.convertToMap((BytesReference)currentApiKeyDoc.metadataFlattened, (boolean)false, (XContentType)XContentType.JSON).v2()))) : "API key doc [" + apiKeyId + "] to be updated contains reserved metadata";
        Map metadata = request.getMetadata();
        if (metadata != null) {
            logger.trace(() -> Strings.format((String)"Building API key doc with updated metadata [%s]", (Object[])new Object[]{metadata}));
            builder.field("metadata_flattened", metadata);
        } else {
            builder.rawField("metadata_flattened", (InputStream)(currentApiKeyDoc.metadataFlattened == null ? ApiKeyDoc.NULL_BYTES.streamInput() : currentApiKeyDoc.metadataFlattened.streamInput()), XContentType.JSON);
        }
        ApiKeyService.addCreator(builder, authentication);
        return builder.endObject();
    }

    private static boolean isNoop(String apiKeyId, ApiKeyDoc apiKeyDoc, ApiKey.Version targetDocVersion, Authentication authentication, BaseUpdateApiKeyRequest request, Set<RoleDescriptor> userRoleDescriptors) throws IOException {
        List newRoleDescriptors;
        Map newMetadata;
        if (apiKeyDoc.version != targetDocVersion.version()) {
            return false;
        }
        if (request.getExpiration() != null) {
            return false;
        }
        Map<String, Object> currentCreator = apiKeyDoc.creator;
        User user = authentication.getEffectiveSubject().getUser();
        Authentication.RealmRef sourceRealm = authentication.getEffectiveSubject().getRealm();
        if (!(Objects.equals(user.principal(), currentCreator.get("principal")) && Objects.equals(user.fullName(), currentCreator.get("full_name")) && Objects.equals(user.email(), currentCreator.get("email")) && Objects.equals(user.metadata(), currentCreator.get("metadata")) && Objects.equals(sourceRealm.getName(), currentCreator.get("realm")) && Objects.equals(sourceRealm.getType(), currentCreator.get("realm_type")))) {
            return false;
        }
        if (sourceRealm.getDomain() != null) {
            RealmDomain currentRealmDomain;
            if (currentCreator.get("realm_domain") == null) {
                return false;
            }
            Map m = (Map)currentCreator.get("realm_domain");
            try (XContentParser parser = XContentHelper.mapToXContentParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (Map)m);){
                currentRealmDomain = RealmDomain.fromXContent((XContentParser)parser);
            }
            if (!sourceRealm.getDomain().equals((Object)currentRealmDomain)) {
                return false;
            }
        } else if (currentCreator.get("realm_domain") != null) {
            return false;
        }
        if ((newMetadata = request.getMetadata()) != null) {
            if (apiKeyDoc.metadataFlattened == null) {
                return false;
            }
            Map currentMetadata = (Map)XContentHelper.convertToMap((BytesReference)apiKeyDoc.metadataFlattened, (boolean)false, (XContentType)XContentType.JSON).v2();
            if (!newMetadata.equals(currentMetadata)) {
                return false;
            }
        }
        if ((newRoleDescriptors = request.getRoleDescriptors()) != null) {
            List<RoleDescriptor> currentRoleDescriptors = ApiKeyService.parseRoleDescriptorsBytes(apiKeyId, apiKeyDoc.roleDescriptorsBytes, false);
            if (!(newRoleDescriptors.size() == currentRoleDescriptors.size() && Set.copyOf(newRoleDescriptors).containsAll(currentRoleDescriptors))) {
                return false;
            }
            if (newRoleDescriptors.size() == currentRoleDescriptors.size()) {
                for (int i = 0; i < currentRoleDescriptors.size(); ++i) {
                    if (currentRoleDescriptors.get(i).getRemoteClusterPermissions().equals((Object)((RoleDescriptor)newRoleDescriptors.get(i)).getRemoteClusterPermissions())) continue;
                    return false;
                }
            }
        }
        assert (userRoleDescriptors != null) : "API Key [" + apiKeyId + "] has null role descriptors";
        List<RoleDescriptor> currentLimitedByRoleDescriptors = ApiKeyService.parseRoleDescriptorsBytes(apiKeyId, apiKeyDoc.limitedByRoleDescriptorsBytes, false);
        return userRoleDescriptors.size() == currentLimitedByRoleDescriptors.size() && userRoleDescriptors.containsAll(currentLimitedByRoleDescriptors);
    }

    void tryAuthenticate(ThreadContext ctx, ApiKeyCredentials credentials, ActionListener<AuthenticationResult<User>> listener) {
        if (!this.isEnabled()) {
            listener.onResponse((Object)AuthenticationResult.notHandled());
        }
        assert (credentials != null) : "api key credentials must not be null";
        this.loadApiKeyAndValidateCredentials(ctx, credentials, (ActionListener<AuthenticationResult<User>>)ActionListener.wrap(response -> {
            credentials.close();
            listener.onResponse(response);
        }, e -> {
            credentials.close();
            listener.onFailure(e);
        }));
    }

    void loadApiKeyAndValidateCredentials(ThreadContext ctx, ApiKeyCredentials credentials, ActionListener<AuthenticationResult<User>> listener) {
        long invalidationCount;
        String docId = credentials.getId();
        Consumer<ApiKeyDoc> validator = apiKeyDoc -> this.validateApiKeyCredentials(docId, (ApiKeyDoc)apiKeyDoc, credentials, this.clock, (ActionListener<AuthenticationResult<User>>)listener.delegateResponse((l, e) -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof EsRejectedExecutionException) {
                l.onResponse((Object)AuthenticationResult.terminate((String)"server is too busy to respond", (Exception)e));
            } else {
                l.onFailure(e);
            }
        }));
        if (this.apiKeyDocCache != null) {
            ApiKeyDoc existing = this.apiKeyDocCache.get(docId);
            if (existing != null) {
                validator.accept(existing);
                return;
            }
            invalidationCount = this.apiKeyDocCache.getInvalidationCount();
        } else {
            invalidationCount = -1L;
        }
        GetRequest getRequest = (GetRequest)this.client.prepareGet(".security", docId).setFetchSource(true).request();
        ClientHelper.executeAsyncWithOrigin((ThreadContext)ctx, (String)"security", (Object)getRequest, (ActionListener)ActionListener.wrap(response -> {
            if (response.isExists()) {
                ApiKeyDoc apiKeyDoc;
                try (XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)response.getSourceAsBytesRef(), (XContentType)XContentType.JSON);){
                    apiKeyDoc = ApiKeyDoc.fromXContent(parser);
                }
                if (invalidationCount != -1L) {
                    this.apiKeyDocCache.putIfNoInvalidationSince(docId, apiKeyDoc, invalidationCount);
                }
                validator.accept(apiKeyDoc);
            } else {
                if (this.apiKeyAuthCache != null) {
                    this.apiKeyAuthCache.invalidate((Object)docId);
                }
                listener.onResponse((Object)AuthenticationResult.unsuccessful((String)("unable to find apikey with id " + credentials.getId()), null));
            }
        }, e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof EsRejectedExecutionException) {
                listener.onResponse((Object)AuthenticationResult.terminate((String)"server is too busy to respond", (Exception)e));
            } else {
                listener.onResponse((Object)AuthenticationResult.unsuccessful((String)("apikey authentication for id " + credentials.getId() + " encountered a failure"), (Exception)e));
            }
        }), (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1));
    }

    public List<RoleDescriptor> parseRoleDescriptors(String apiKeyId, Map<String, Object> roleDescriptorsMap, RoleReference.ApiKeyRoleType roleType) {
        if (roleDescriptorsMap == null) {
            return null;
        }
        List<RoleDescriptor> roleDescriptors = roleDescriptorsMap.entrySet().stream().map(entry -> {
            String name = (String)entry.getKey();
            Map rdMap = (Map)entry.getValue();
            try (XContentBuilder builder = XContentBuilder.builder((XContent)XContentType.JSON.xContent());){
                RoleDescriptor roleDescriptor;
                block14: {
                    builder.map(rdMap);
                    XContentParser parser = XContentHelper.createParserNotCompressed((XContentParserConfiguration)XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)new ApiKeyLoggingDeprecationHandler(deprecationLogger, apiKeyId)), (BytesReference)BytesReference.bytes((XContentBuilder)builder), (XContentType)XContentType.JSON);
                    try {
                        roleDescriptor = ROLE_DESCRIPTOR_PARSER.parse(name, parser);
                        if (parser == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    parser.close();
                }
                return roleDescriptor;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).toList();
        return roleType == RoleReference.ApiKeyRoleType.LIMITED_BY ? ApiKeyService.maybeReplaceSuperuserRoleDescriptor(apiKeyId, roleDescriptors) : roleDescriptors;
    }

    public List<RoleDescriptor> parseRoleDescriptorsBytes(String apiKeyId, BytesReference bytesReference, RoleReference.ApiKeyRoleType roleType) {
        return ApiKeyService.parseRoleDescriptorsBytes(apiKeyId, bytesReference, roleType == RoleReference.ApiKeyRoleType.LIMITED_BY);
    }

    private static List<RoleDescriptor> parseRoleDescriptorsBytes(String apiKeyId, BytesReference bytesReference, boolean replaceLegacySuperuserRoleDescriptor) {
        if (bytesReference == null) {
            return Collections.emptyList();
        }
        ArrayList<RoleDescriptor> roleDescriptors = new ArrayList<RoleDescriptor>();
        try (XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)new ApiKeyLoggingDeprecationHandler(deprecationLogger, apiKeyId)), (BytesReference)bytesReference, (XContentType)XContentType.JSON);){
            parser.nextToken();
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                parser.nextToken();
                String roleName = parser.currentName();
                roleDescriptors.add(ROLE_DESCRIPTOR_PARSER.parse(roleName, parser));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return replaceLegacySuperuserRoleDescriptor ? ApiKeyService.maybeReplaceSuperuserRoleDescriptor(apiKeyId, roleDescriptors) : roleDescriptors;
    }

    private static List<RoleDescriptor> maybeReplaceSuperuserRoleDescriptor(String apiKeyId, List<RoleDescriptor> roleDescriptors) {
        return roleDescriptors.stream().map(rd -> {
            if (rd.equals((Object)LEGACY_SUPERUSER_ROLE_DESCRIPTOR)) {
                logger.debug("replacing superuser role for API key [{}]", (Object)apiKeyId);
                return ReservedRolesStore.SUPERUSER_ROLE_DESCRIPTOR;
            }
            return rd;
        }).toList();
    }

    void validateApiKeyCredentials(String docId, ApiKeyDoc apiKeyDoc, ApiKeyCredentials credentials, Clock clock, ActionListener<AuthenticationResult<User>> listener) {
        if (!"api_key".equals(apiKeyDoc.docType)) {
            listener.onResponse((Object)AuthenticationResult.unsuccessful((String)("document [" + docId + "] is [" + apiKeyDoc.docType + "] not an api key"), null));
        } else if (apiKeyDoc.invalidated == null) {
            listener.onResponse((Object)AuthenticationResult.unsuccessful((String)"api key document is missing invalidated field", null));
        } else if (apiKeyDoc.invalidated.booleanValue()) {
            if (this.apiKeyAuthCache != null) {
                this.apiKeyAuthCache.invalidate((Object)docId);
            }
            listener.onResponse((Object)AuthenticationResult.unsuccessful((String)("api key [" + credentials.getId() + "] has been invalidated"), null));
        } else {
            if (apiKeyDoc.hash == null) {
                throw new IllegalStateException("api key hash is missing");
            }
            if (this.apiKeyAuthCache != null) {
                ListenableFuture listenableCacheEntry;
                AtomicBoolean valueAlreadyInCache = new AtomicBoolean(true);
                try {
                    listenableCacheEntry = (ListenableFuture)this.apiKeyAuthCache.computeIfAbsent((Object)credentials.getId(), k -> {
                        valueAlreadyInCache.set(false);
                        return new ListenableFuture();
                    });
                }
                catch (ExecutionException e) {
                    listener.onFailure((Exception)e);
                    return;
                }
                if (valueAlreadyInCache.get()) {
                    listenableCacheEntry.addListener(ActionListener.wrap(result -> {
                        if (result.success) {
                            if (result.verify(credentials.getKey())) {
                                ApiKeyService.validateApiKeyTypeAndExpiration(apiKeyDoc, credentials, clock, listener);
                            } else {
                                listener.onResponse((Object)AuthenticationResult.unsuccessful((String)("invalid credentials for API key [" + credentials.getId() + "]"), null));
                            }
                        } else if (result.verify(credentials.getKey())) {
                            listener.onResponse((Object)AuthenticationResult.unsuccessful((String)("invalid credentials for API key [" + credentials.getId() + "]"), null));
                        } else {
                            this.apiKeyAuthCache.invalidate((Object)credentials.getId(), (Object)listenableCacheEntry);
                            this.validateApiKeyCredentials(docId, apiKeyDoc, credentials, clock, listener);
                        }
                    }, arg_0 -> listener.onFailure(arg_0)), (Executor)this.threadPool.generic(), this.threadPool.getThreadContext());
                } else {
                    this.verifyKeyAgainstHash(apiKeyDoc.hash, credentials, (ActionListener<Boolean>)ActionListener.wrap(verified -> {
                        listenableCacheEntry.onResponse((Object)new CachedApiKeyHashResult((boolean)verified, credentials.getKey()));
                        if (verified.booleanValue()) {
                            ApiKeyService.validateApiKeyTypeAndExpiration(apiKeyDoc, credentials, clock, listener);
                        } else {
                            listener.onResponse((Object)AuthenticationResult.unsuccessful((String)("invalid credentials for API key [" + credentials.getId() + "]"), null));
                        }
                    }, exception -> {
                        logger.warn(org.elasticsearch.common.Strings.format((String)"rejecting possibly valid API key authentication because the [%s] threadpool is full", (Object[])new Object[]{"security-crypto"}));
                        this.apiKeyAuthCache.invalidate((Object)credentials.getId(), (Object)listenableCacheEntry);
                        listenableCacheEntry.onFailure(exception);
                        listener.onFailure(exception);
                    }));
                }
            } else {
                this.verifyKeyAgainstHash(apiKeyDoc.hash, credentials, (ActionListener<Boolean>)ActionListener.wrap(verified -> {
                    if (verified.booleanValue()) {
                        ApiKeyService.validateApiKeyTypeAndExpiration(apiKeyDoc, credentials, clock, listener);
                    } else {
                        listener.onResponse((Object)AuthenticationResult.unsuccessful((String)("invalid credentials for API key [" + credentials.getId() + "]"), null));
                    }
                }, arg_0 -> listener.onFailure(arg_0)));
            }
        }
    }

    CachedApiKeyHashResult getFromCache(String id) {
        return this.apiKeyAuthCache == null ? null : (CachedApiKeyHashResult)((ListenableFuture)this.apiKeyAuthCache.get((Object)id)).result();
    }

    Cache<String, ListenableFuture<CachedApiKeyHashResult>> getApiKeyAuthCache() {
        return this.apiKeyAuthCache;
    }

    Cache<String, CachedApiKeyDoc> getDocCache() {
        return this.apiKeyDocCache == null ? null : this.apiKeyDocCache.docCache;
    }

    Cache<String, BytesReference> getRoleDescriptorsBytesCache() {
        return this.apiKeyDocCache == null ? null : this.apiKeyDocCache.roleDescriptorsBytesCache;
    }

    static void validateApiKeyTypeAndExpiration(ApiKeyDoc apiKeyDoc, ApiKeyCredentials credentials, Clock clock, ActionListener<AuthenticationResult<User>> listener) {
        if (apiKeyDoc.type != credentials.expectedType) {
            listener.onResponse((Object)AuthenticationResult.terminate((String)org.elasticsearch.common.Strings.format((String)"authentication expected API key type of [%s], but API key [%s] has type [%s]", (Object[])new Object[]{credentials.expectedType.value(), credentials.getId(), apiKeyDoc.type.value()})));
            return;
        }
        if (apiKeyDoc.expirationTime == -1L || Instant.ofEpochMilli(apiKeyDoc.expirationTime).isAfter(clock.instant())) {
            String principal = Objects.requireNonNull((String)apiKeyDoc.creator.get("principal"));
            String fullName = (String)apiKeyDoc.creator.get("full_name");
            String email = (String)apiKeyDoc.creator.get("email");
            Map metadata = (Map)apiKeyDoc.creator.get("metadata");
            User apiKeyUser = new User(principal, org.elasticsearch.common.Strings.EMPTY_ARRAY, fullName, email, metadata, true);
            HashMap<String, Object> authResultMetadata = new HashMap<String, Object>();
            authResultMetadata.put("_security_api_key_creator_realm_name", apiKeyDoc.creator.get("realm"));
            authResultMetadata.put("_security_api_key_creator_realm_type", apiKeyDoc.creator.get("realm_type"));
            authResultMetadata.put("_security_api_key_role_descriptors", apiKeyDoc.roleDescriptorsBytes);
            authResultMetadata.put("_security_api_key_limited_by_role_descriptors", apiKeyDoc.limitedByRoleDescriptorsBytes);
            authResultMetadata.put("_security_api_key_id", credentials.getId());
            authResultMetadata.put("_security_api_key_name", apiKeyDoc.name);
            authResultMetadata.put("_security_api_key_type", apiKeyDoc.type.value());
            if (apiKeyDoc.metadataFlattened != null) {
                authResultMetadata.put("_security_api_key_metadata", apiKeyDoc.metadataFlattened);
            }
            listener.onResponse((Object)AuthenticationResult.success((Object)apiKeyUser, authResultMetadata));
        } else {
            listener.onResponse((Object)AuthenticationResult.unsuccessful((String)"api key is expired", null));
        }
    }

    ApiKeyCredentials parseCredentialsFromApiKeyString(SecureString apiKeyString) {
        if (!this.isEnabled()) {
            return null;
        }
        return ApiKeyService.parseApiKey(apiKeyString, ApiKey.Type.REST);
    }

    static ApiKeyCredentials getCredentialsFromHeader(String header, ApiKey.Type expectedType) {
        return ApiKeyService.parseApiKey(Authenticator.extractCredentialFromHeaderValue(header, "ApiKey"), expectedType);
    }

    public static String withApiKeyPrefix(String encodedApiKey) {
        return "ApiKey " + encodedApiKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ApiKeyCredentials parseApiKey(SecureString apiKeyString, ApiKey.Type expectedType) {
        if (apiKeyString != null) {
            byte[] decodedApiKeyCredBytes = Base64.getDecoder().decode(CharArrays.toUtf8Bytes((char[])apiKeyString.getChars()));
            char[] apiKeyCredChars = null;
            try {
                apiKeyCredChars = CharArrays.utf8BytesToChars((byte[])decodedApiKeyCredBytes);
                int colonIndex = -1;
                for (int i = 0; i < apiKeyCredChars.length; ++i) {
                    if (apiKeyCredChars[i] != ':') continue;
                    colonIndex = i;
                    break;
                }
                if (colonIndex < 1) {
                    throw new IllegalArgumentException("invalid ApiKey value");
                }
                int secretStartPos = colonIndex + 1;
                if (ApiKey.Type.CROSS_CLUSTER == expectedType && 22 != apiKeyCredChars.length - secretStartPos) {
                    throw new IllegalArgumentException("invalid cross-cluster API key value");
                }
                ApiKeyCredentials apiKeyCredentials = new ApiKeyCredentials(new String(Arrays.copyOfRange(apiKeyCredChars, 0, colonIndex)), new SecureString(Arrays.copyOfRange(apiKeyCredChars, secretStartPos, apiKeyCredChars.length)), expectedType);
                return apiKeyCredentials;
            }
            finally {
                if (apiKeyCredChars != null) {
                    Arrays.fill(apiKeyCredChars, '\u0000');
                }
            }
        }
        return null;
    }

    void computeHashForApiKey(SecureString apiKey, ActionListener<char[]> listener) {
        this.threadPool.executor("security-crypto").execute((Runnable)ActionRunnable.supply(listener, () -> this.hasher.hash(apiKey)));
    }

    protected void verifyKeyAgainstHash(String apiKeyHash, ApiKeyCredentials credentials, ActionListener<Boolean> listener) {
        this.threadPool.executor("security-crypto").execute((Runnable)ActionRunnable.supply(listener, () -> {
            Hasher hasher = Hasher.resolveFromHash((char[])apiKeyHash.toCharArray());
            char[] apiKeyHashChars = apiKeyHash.toCharArray();
            try {
                Boolean bl = hasher.verify(credentials.getKey(), apiKeyHashChars);
                return bl;
            }
            finally {
                Arrays.fill(apiKeyHashChars, '\u0000');
            }
        }));
    }

    private static Instant getApiKeyExpiration(Instant now, @Nullable TimeValue expiration) {
        if (expiration != null) {
            return now.plusSeconds(expiration.getSeconds());
        }
        return null;
    }

    private boolean isEnabled() {
        return this.enabled;
    }

    public void ensureEnabled() {
        if (!this.enabled) {
            throw new FeatureNotEnabledException(FeatureNotEnabledException.Feature.API_KEY_SERVICE, "api keys are not enabled", new Object[0]);
        }
    }

    public void crossClusterApiKeyUsageStats(ActionListener<Map<String, Object>> listener) {
        if (!this.isEnabled()) {
            listener.onResponse(Map.of());
            return;
        }
        SecurityIndexManager frozenSecurityIndex = this.securityIndex.defensiveCopy();
        if (!frozenSecurityIndex.indexExists()) {
            logger.debug("security index does not exist");
            listener.onResponse(Map.of("total", 0, "ccs", 0, "ccr", 0, "ccs_ccr", 0));
        } else if (!frozenSecurityIndex.isAvailable(SecurityIndexManager.Availability.SEARCH_SHARDS)) {
            listener.onFailure((Exception)((Object)frozenSecurityIndex.getUnavailableReason(SecurityIndexManager.Availability.SEARCH_SHARDS)));
        } else {
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"doc_type", (String)"api_key")).filter((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)ApiKey.Type.CROSS_CLUSTER.value()));
            this.findApiKeys(boolQuery, true, true, this::convertSearchHitToApiKeyInfo, ActionListener.wrap(apiKeyInfos -> {
                int ccsKeys = 0;
                int ccrKeys = 0;
                int ccsCcrKeys = 0;
                for (ApiKey apiKeyInfo : apiKeyInfos) {
                    assert (apiKeyInfo.getType() == ApiKey.Type.CROSS_CLUSTER) : "Incorrect API Key type for [" + String.valueOf(apiKeyInfo) + "] should be [" + String.valueOf(ApiKey.Type.CROSS_CLUSTER) + "]";
                    assert (apiKeyInfo.getRoleDescriptors().size() == 1) : "API Key [" + String.valueOf(apiKeyInfo) + "] has [" + apiKeyInfo.getRoleDescriptors().size() + "] role descriptors, but should be 1";
                    List<String> clusterPrivileges = Arrays.asList(((RoleDescriptor)apiKeyInfo.getRoleDescriptors().iterator().next()).getClusterPrivileges());
                    if (clusterPrivileges.contains("cross_cluster_search") && !clusterPrivileges.contains("cross_cluster_replication")) {
                        ++ccsKeys;
                        continue;
                    }
                    if (clusterPrivileges.contains("cross_cluster_replication") && !clusterPrivileges.contains("cross_cluster_search")) {
                        ++ccrKeys;
                        continue;
                    }
                    if (clusterPrivileges.contains("cross_cluster_search") && clusterPrivileges.contains("cross_cluster_replication")) {
                        ++ccsCcrKeys;
                        continue;
                    }
                    String message = "invalid cluster privileges " + String.valueOf(clusterPrivileges) + " for cross-cluster API key [" + apiKeyInfo.getId() + "]";
                    assert (false) : message;
                    listener.onFailure((Exception)new IllegalStateException(message));
                }
                listener.onResponse(Map.of("total", apiKeyInfos.size(), "ccs", ccsKeys, "ccr", ccrKeys, "ccs_ccr", ccsCcrKeys));
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    @Override
    public void close() {
        this.cacheMetrics.forEach(metric -> {
            try {
                metric.close();
            }
            catch (Exception e) {
                logger.warn("metrics close() method should not throw Exception", (Throwable)e);
            }
        });
    }

    @Nullable
    private IndexRequest maybeBuildIndexRequest(VersionedApiKeyDoc currentVersionedDoc, Authentication authentication, BaseUpdateApiKeyRequest request, Set<RoleDescriptor> userRoleDescriptors) throws IOException {
        XContentBuilder builder;
        if (logger.isTraceEnabled()) {
            logger.trace("Building index request for update of API key doc [{}] with seqNo [{}] and primaryTerm [{}]", (Object)currentVersionedDoc.id(), (Object)currentVersionedDoc.seqNo(), (Object)currentVersionedDoc.primaryTerm());
        }
        ApiKey.Version targetDocVersion = ApiKey.CURRENT_API_KEY_VERSION;
        ApiKey.Version currentDocVersion = new ApiKey.Version(currentVersionedDoc.doc().version);
        assert (currentDocVersion.onOrBefore((VersionId)targetDocVersion)) : "API key [" + currentVersionedDoc.id() + "] has version [" + String.valueOf(currentDocVersion) + " which is greater than current version [" + String.valueOf(ApiKey.CURRENT_API_KEY_VERSION) + "]";
        if (logger.isDebugEnabled() && currentDocVersion.before((VersionId)targetDocVersion)) {
            logger.debug("API key update for [{}] will update version from [{}] to [{}]", (Object)currentVersionedDoc.id(), (Object)currentDocVersion, (Object)targetDocVersion);
        }
        boolean isNoop = (builder = ApiKeyService.maybeBuildUpdatedDocument(currentVersionedDoc.id(), currentVersionedDoc.doc(), targetDocVersion, authentication, request, userRoleDescriptors, this.clock)) == null;
        return isNoop ? null : this.client.prepareIndex(".security").setId(currentVersionedDoc.id()).setSource(builder).setIfSeqNo(currentVersionedDoc.seqNo()).setIfPrimaryTerm(currentVersionedDoc.primaryTerm()).setOpType(DocWriteRequest.OpType.INDEX).request();
    }

    private static void addErrorsForNotFoundApiKeys(BulkUpdateApiKeyResponse.Builder responseBuilder, Collection<VersionedApiKeyDoc> foundDocs, List<String> requestedIds) {
        if (foundDocs.size() == requestedIds.size()) {
            return;
        }
        Set foundIds = foundDocs.stream().map(VersionedApiKeyDoc::id).collect(Collectors.toUnmodifiableSet());
        for (String id : requestedIds) {
            if (foundIds.contains(id)) continue;
            responseBuilder.error(id, (Exception)new ResourceNotFoundException("no API key owned by requesting user found for ID [" + id + "]", new Object[0]));
        }
    }

    public void invalidateApiKeys(String[] realmNames, String username, String apiKeyName, String[] apiKeyIds, boolean includeCrossClusterApiKeys, ActionListener<InvalidateApiKeyResponse> invalidateListener) {
        this.ensureEnabled();
        if (!(realmNames != null && realmNames.length != 0 || org.elasticsearch.common.Strings.hasText((String)username) || org.elasticsearch.common.Strings.hasText((String)apiKeyName) || apiKeyIds != null && apiKeyIds.length != 0)) {
            logger.trace("none of the parameters [api key id, api key name, username, realm name] were specified for invalidation");
            invalidateListener.onFailure((Exception)new IllegalArgumentException("One of [api key id, api key name, username, realm name] must be specified"));
        } else {
            this.findApiKeysForUserRealmApiKeyIdAndNameCombination(realmNames, username, apiKeyName, apiKeyIds, true, false, this::convertSearchHitToApiKeyInfo, ActionListener.wrap(apiKeys -> {
                if (apiKeys.isEmpty()) {
                    logger.debug("No active api keys to invalidate for realms {}, username [{}], api key name [{}] and api key ids {}", (Object)Arrays.toString(realmNames), (Object)username, (Object)apiKeyName, (Object)Arrays.toString(apiKeyIds));
                    invalidateListener.onResponse((Object)InvalidateApiKeyResponse.emptyResponse());
                } else {
                    this.indexInvalidation((Collection<ApiKey>)apiKeys, includeCrossClusterApiKeys, invalidateListener);
                }
            }, arg_0 -> invalidateListener.onFailure(arg_0)));
        }
    }

    private <T> void findApiKeys(BoolQueryBuilder boolQuery, boolean filterOutInvalidatedKeys, boolean filterOutExpiredKeys, Function<SearchHit, T> hitParser, ActionListener<Collection<T>> listener) {
        if (filterOutInvalidatedKeys) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"api_key_invalidated", (boolean)false));
        }
        if (filterOutExpiredKeys) {
            BoolQueryBuilder expiredQuery = QueryBuilders.boolQuery();
            expiredQuery.should((QueryBuilder)QueryBuilders.rangeQuery((String)"expiration_time").gt((Object)this.clock.instant().toEpochMilli()));
            expiredQuery.should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"expiration_time")));
            boolQuery.filter((QueryBuilder)expiredQuery);
        }
        Supplier supplier = this.client.threadPool().getThreadContext().newRestorableContext(false);
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("security");){
            SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".security"}).setScroll((TimeValue)SearchService.DEFAULT_KEEPALIVE_SETTING.get(this.settings)).setQuery((QueryBuilder)boolQuery).setVersion(false).setSize(1000).setFetchSource(true).request();
            this.securityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> this.lambda$findApiKeys$35(request, (Supplier)supplier, listener, hitParser));
        }
    }

    public static QueryBuilder filterForRealmNames(String[] realmNames) {
        if (realmNames == null || realmNames.length == 0) {
            return null;
        }
        if (realmNames.length == 1) {
            return QueryBuilders.termQuery((String)"creator.realm", (String)realmNames[0]);
        }
        BoolQueryBuilder realmsQuery = QueryBuilders.boolQuery();
        for (String realmName : realmNames) {
            realmsQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"creator.realm", (String)realmName));
        }
        realmsQuery.minimumShouldMatch(1);
        return realmsQuery;
    }

    private void findVersionedApiKeyDocsForSubject(Authentication authentication, String[] apiKeyIds, ActionListener<Collection<VersionedApiKeyDoc>> listener) {
        assert (!authentication.isApiKey()) : "Authentication [" + String.valueOf(authentication) + "] is an API key, but should not be";
        this.findApiKeysForUserRealmApiKeyIdAndNameCombination(ApiKeyService.getOwnersRealmNames(authentication), authentication.getEffectiveSubject().getUser().principal(), null, apiKeyIds, false, false, ApiKeyService::convertSearchHitToVersionedApiKeyDoc, listener);
    }

    private <T> void findApiKeysForUserRealmApiKeyIdAndNameCombination(String[] realmNames, String userName, String apiKeyName, String[] apiKeyIds, boolean filterOutInvalidatedKeys, boolean filterOutExpiredKeys, Function<SearchHit, T> hitParser, ActionListener<Collection<T>> listener) {
        SecurityIndexManager frozenSecurityIndex = this.securityIndex.defensiveCopy();
        if (!frozenSecurityIndex.indexExists()) {
            listener.onResponse(Collections.emptyList());
        } else if (!frozenSecurityIndex.isAvailable(SecurityIndexManager.Availability.SEARCH_SHARDS)) {
            listener.onFailure((Exception)((Object)frozenSecurityIndex.getUnavailableReason(SecurityIndexManager.Availability.SEARCH_SHARDS)));
        } else {
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"doc_type", (String)"api_key"));
            QueryBuilder realmsQuery = ApiKeyService.filterForRealmNames(realmNames);
            if (realmsQuery != null) {
                boolQuery.filter(realmsQuery);
            }
            if (org.elasticsearch.common.Strings.hasText((String)userName)) {
                boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"creator.principal", (String)userName));
            }
            if (org.elasticsearch.common.Strings.hasText((String)apiKeyName) && !"*".equals(apiKeyName)) {
                if (apiKeyName.endsWith("*")) {
                    boolQuery.filter((QueryBuilder)QueryBuilders.prefixQuery((String)"name", (String)apiKeyName.substring(0, apiKeyName.length() - 1)));
                } else {
                    boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"name", (String)apiKeyName));
                }
            }
            if (apiKeyIds != null && apiKeyIds.length > 0) {
                boolQuery.filter((QueryBuilder)QueryBuilders.idsQuery().addIds(apiKeyIds));
            }
            this.findApiKeys(boolQuery, filterOutInvalidatedKeys, filterOutExpiredKeys, hitParser, listener);
        }
    }

    private void indexInvalidation(Collection<ApiKey> apiKeys, boolean includeCrossClusterApiKeys, ActionListener<InvalidateApiKeyResponse> listener) {
        this.maybeStartApiKeyRemover();
        if (apiKeys.isEmpty()) {
            listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("No api key ids provided for invalidation", new Object[0])));
        } else {
            BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
            long invalidationTime = this.clock.instant().toEpochMilli();
            HashSet<String> apiKeyIdsToInvalidate = new HashSet<String>();
            HashSet<String> crossClusterApiKeyIdsToSkip = new HashSet<String>();
            ArrayList<ElasticsearchException> failedRequestResponses = new ArrayList<ElasticsearchException>();
            for (ApiKey apiKey : apiKeys) {
                String apiKeyId = apiKey.getId();
                if (apiKeyIdsToInvalidate.contains(apiKeyId) || crossClusterApiKeyIdsToSkip.contains(apiKeyId)) continue;
                if (!includeCrossClusterApiKeys && ApiKey.Type.CROSS_CLUSTER.equals((Object)apiKey.getType())) {
                    logger.debug("Skipping invalidation of cross cluster API key [{}]", (Object)apiKey);
                    failedRequestResponses.add(this.cannotInvalidateCrossClusterApiKeyException(apiKeyId));
                    crossClusterApiKeyIdsToSkip.add(apiKeyId);
                    continue;
                }
                UpdateRequestBuilder updateRequestBuilder = this.client.prepareUpdate(".security", apiKeyId).setDoc(Map.of("api_key_invalidated", true, "invalidation_time", invalidationTime));
                bulkRequestBuilder.add(updateRequestBuilder);
                apiKeyIdsToInvalidate.add(apiKeyId);
            }
            assert (!apiKeyIdsToInvalidate.isEmpty() || !crossClusterApiKeyIdsToSkip.isEmpty()) : "There are no API keys but that should never happen, original=[" + String.valueOf(apiKeys.size() > 10 ? "size=" + apiKeys.size() + " including " + String.valueOf(apiKeys.iterator().next()) : apiKeys) + "], to-invalidate=[" + String.valueOf(apiKeyIdsToInvalidate) + "], to-skip=[" + String.valueOf(crossClusterApiKeyIdsToSkip) + "]";
            if (apiKeyIdsToInvalidate.isEmpty()) {
                listener.onResponse((Object)new InvalidateApiKeyResponse(Collections.emptyList(), Collections.emptyList(), failedRequestResponses));
                return;
            }
            assert (bulkRequestBuilder.numberOfActions() > 0) : "Bulk request has [" + bulkRequestBuilder.numberOfActions() + "] actions, but there are [" + apiKeyIdsToInvalidate.size() + "] api keys to invalidate";
            bulkRequestBuilder.setRefreshPolicy(ApiKeyService.defaultCreateDocRefreshPolicy(this.settings));
            this.securityIndex.prepareIndexIfNeededThenExecute(ex -> listener.onFailure(ApiKeyService.traceLog("prepare security index", ex)), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (Object)bulkRequestBuilder.request(), (ActionListener)ActionListener.wrap(bulkResponse -> {
                ArrayList<String> previouslyInvalidated = new ArrayList<String>();
                ArrayList<String> invalidated = new ArrayList<String>();
                for (BulkItemResponse bulkItemResponse : bulkResponse.getItems()) {
                    if (bulkItemResponse.isFailed()) {
                        Exception cause = bulkItemResponse.getFailure().getCause();
                        String failedApiKeyId = bulkItemResponse.getFailure().getId();
                        ApiKeyService.traceLog("invalidate api key", failedApiKeyId, cause);
                        failedRequestResponses.add(new ElasticsearchException("Error invalidating api key", (Throwable)cause, new Object[0]));
                        continue;
                    }
                    UpdateResponse updateResponse = (UpdateResponse)bulkItemResponse.getResponse();
                    if (updateResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                        logger.debug("Invalidated api key for doc [{}]", (Object)updateResponse.getId());
                        invalidated.add(updateResponse.getId());
                        continue;
                    }
                    if (updateResponse.getResult() != DocWriteResponse.Result.NOOP) continue;
                    previouslyInvalidated.add(updateResponse.getId());
                }
                InvalidateApiKeyResponse result = new InvalidateApiKeyResponse(invalidated, previouslyInvalidated, (List)failedRequestResponses);
                this.clearCache(result, listener);
            }, e -> {
                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                ApiKeyService.traceLog("invalidate api keys", cause);
                listener.onFailure(e);
            }), (arg_0, arg_1) -> ((Client)this.client).bulk(arg_0, arg_1)));
        }
    }

    private ElasticsearchException cannotInvalidateCrossClusterApiKeyException(String apiKeyId) {
        return new ElasticsearchSecurityException("Cannot invalidate cross-cluster API key [" + apiKeyId + "]. This requires [" + ClusterPrivilegeResolver.MANAGE_SECURITY.name() + "] cluster privilege or higher", new Object[0]);
    }

    private void buildResponseAndClearCache(BulkResponse bulkResponse, BulkUpdateApiKeyResponse.Builder responseBuilder, ActionListener<BulkUpdateApiKeyResponse> listener) {
        for (BulkItemResponse bulkItemResponse : bulkResponse.getItems()) {
            String apiKeyId = bulkItemResponse.getId();
            if (bulkItemResponse.isFailed()) {
                responseBuilder.error(apiKeyId, (Exception)((Object)new ElasticsearchException("bulk request execution failure", (Throwable)bulkItemResponse.getFailure().getCause(), new Object[0])));
                continue;
            }
            assert (bulkItemResponse.getResponse().getResult() == DocWriteResponse.Result.UPDATED) : "Bulk Item [" + bulkItemResponse.getId() + "] is [" + String.valueOf(bulkItemResponse.getResponse().getResult()) + "] but should be [" + String.valueOf(DocWriteResponse.Result.UPDATED) + "]";
            responseBuilder.updated(apiKeyId);
        }
        this.clearApiKeyDocCache(responseBuilder.build(), listener);
    }

    private static void addLimitedByRoleDescriptors(XContentBuilder builder, Set<RoleDescriptor> limitedByRoleDescriptors) throws IOException {
        assert (limitedByRoleDescriptors != null);
        builder.startObject("limited_by_role_descriptors");
        for (RoleDescriptor descriptor : limitedByRoleDescriptors) {
            builder.field(descriptor.getName(), (contentBuilder, params) -> descriptor.toXContent(contentBuilder, params, true));
        }
        builder.endObject();
    }

    private static void addApiKeyHash(XContentBuilder builder, char[] apiKeyHashChars) throws IOException {
        byte[] utf8Bytes = null;
        try {
            utf8Bytes = CharArrays.toUtf8Bytes((char[])apiKeyHashChars);
            builder.field("api_key_hash").utf8Value(utf8Bytes, 0, utf8Bytes.length);
        }
        finally {
            if (utf8Bytes != null) {
                Arrays.fill(utf8Bytes, (byte)0);
            }
        }
    }

    private static void addCreator(XContentBuilder builder, Authentication authentication) throws IOException {
        User user = authentication.getEffectiveSubject().getUser();
        Authentication.RealmRef sourceRealm = authentication.getEffectiveSubject().getRealm();
        builder.startObject("creator").field("principal", user.principal()).field("full_name", user.fullName()).field("email", user.email()).field("metadata", user.metadata()).field("realm", sourceRealm.getName()).field("realm_type", sourceRealm.getType());
        if (sourceRealm.getDomain() != null) {
            builder.field("realm_domain", (ToXContent)sourceRealm.getDomain());
        }
        builder.endObject();
    }

    private static void addRoleDescriptors(XContentBuilder builder, List<RoleDescriptor> keyRoles) throws IOException {
        builder.startObject("role_descriptors");
        if (keyRoles != null && !keyRoles.isEmpty()) {
            for (RoleDescriptor descriptor : keyRoles) {
                builder.field(descriptor.getName(), (contentBuilder, params) -> descriptor.toXContent(contentBuilder, params, true));
            }
        }
        builder.endObject();
    }

    private void clearCache(InvalidateApiKeyResponse result, ActionListener<InvalidateApiKeyResponse> listener) {
        this.executeClearCacheRequest(result, listener, new ClearSecurityCacheRequest().cacheName("api_key").keys((String[])result.getInvalidatedApiKeys().toArray(String[]::new)));
    }

    private void clearApiKeyDocCache(BulkUpdateApiKeyResponse result, ActionListener<BulkUpdateApiKeyResponse> listener) {
        this.executeClearCacheRequest(result, listener, new ClearSecurityCacheRequest().cacheName("api_key_doc").keys((String[])result.getUpdated().toArray(String[]::new)));
    }

    private <T> void executeClearCacheRequest(final T result, final ActionListener<T> listener, final ClearSecurityCacheRequest clearApiKeyCacheRequest) {
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)ClearSecurityCacheAction.INSTANCE, (ActionRequest)clearApiKeyCacheRequest, (ActionListener)new ActionListener<ClearSecurityCacheResponse>(){

            public void onResponse(ClearSecurityCacheResponse nodes) {
                listener.onResponse(result);
            }

            public void onFailure(Exception e) {
                logger.error(() -> Strings.format((String)"unable to clear API key cache [%s]", (Object[])new Object[]{clearApiKeyCacheRequest.cacheName()}), (Throwable)e);
                listener.onFailure((Exception)((Object)new ElasticsearchException("clearing the API key cache failed; please clear the caches manually", (Throwable)e, new Object[0])));
            }
        });
    }

    private static <E extends Throwable> E traceLog(String action, String identifier, E exception) {
        if (logger.isTraceEnabled()) {
            if (exception instanceof ElasticsearchException) {
                ElasticsearchException esEx = (ElasticsearchException)exception;
                List detail = esEx.getHeader("error_description");
                if (detail != null) {
                    logger.trace(() -> Strings.format((String)"Failure in [%s] for id [%s] - [%s]", (Object[])new Object[]{action, identifier, detail}), (Throwable)esEx);
                } else {
                    logger.trace(() -> Strings.format((String)"Failure in [%s] for id [%s]", (Object[])new Object[]{action, identifier}), (Throwable)esEx);
                }
            } else {
                logger.trace(() -> Strings.format((String)"Failure in [%s] for id [%s]", (Object[])new Object[]{action, identifier}), exception);
            }
        }
        return exception;
    }

    private static <E extends Throwable> E traceLog(String action, E exception) {
        if (logger.isTraceEnabled()) {
            if (exception instanceof ElasticsearchException) {
                ElasticsearchException esEx = (ElasticsearchException)exception;
                List detail = esEx.getHeader("error_description");
                if (detail != null) {
                    logger.trace(() -> Strings.format((String)"Failure in [%s] - [%s]", (Object[])new Object[]{action, detail}), (Throwable)esEx);
                } else {
                    logger.trace(() -> "Failure in [" + action + "]", (Throwable)esEx);
                }
            } else {
                logger.trace(() -> "Failure in [" + action + "]", exception);
            }
        }
        return exception;
    }

    boolean isExpirationInProgress() {
        return this.inactiveApiKeysRemover.isExpirationInProgress();
    }

    long lastTimeWhenApiKeysRemoverWasTriggered() {
        return this.inactiveApiKeysRemover.getLastRunTimestamp();
    }

    private void maybeStartApiKeyRemover() {
        if (this.securityIndex.isAvailable(SecurityIndexManager.Availability.PRIMARY_SHARDS)) {
            this.inactiveApiKeysRemover.maybeSubmit(this.client.threadPool());
        }
    }

    public void getApiKeys(String[] realmNames, String username, String apiKeyName, String[] apiKeyIds, boolean withLimitedBy, boolean activeOnly, ActionListener<Collection<ApiKey>> listener) {
        this.ensureEnabled();
        this.findApiKeysForUserRealmApiKeyIdAndNameCombination(realmNames, username, apiKeyName, apiKeyIds, activeOnly, activeOnly, hit -> this.convertSearchHitToApiKeyInfo((SearchHit)hit, withLimitedBy), ActionListener.wrap(apiKeyInfos -> {
            if (apiKeyInfos.isEmpty() && logger.isDebugEnabled()) {
                logger.debug("No API keys found for realms {}, user [{}], API key name [{}], API key IDs {}, and active_only flag [{}]", (Object)Arrays.toString(realmNames), (Object)username, (Object)apiKeyName, (Object)Arrays.toString(apiKeyIds), (Object)activeOnly);
            }
            listener.onResponse(apiKeyInfos);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void queryApiKeys(SearchRequest searchRequest, boolean withLimitedBy, ActionListener<QueryApiKeysResult> listener) {
        this.ensureEnabled();
        SecurityIndexManager frozenSecurityIndex = this.securityIndex.defensiveCopy();
        if (!frozenSecurityIndex.indexExists()) {
            logger.debug("security index does not exist");
            listener.onResponse((Object)QueryApiKeysResult.EMPTY);
        } else if (!frozenSecurityIndex.isAvailable(SecurityIndexManager.Availability.SEARCH_SHARDS)) {
            listener.onFailure((Exception)((Object)frozenSecurityIndex.getUnavailableReason(SecurityIndexManager.Availability.SEARCH_SHARDS)));
        } else {
            this.securityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)TransportSearchAction.TYPE, (ActionRequest)searchRequest, (ActionListener)ActionListener.wrap(searchResponse -> {
                long total = searchResponse.getHits().getTotalHits().value;
                if (total == 0L) {
                    logger.debug("No api keys found for query [{}]", (Object)searchRequest.source().query());
                    listener.onResponse((Object)QueryApiKeysResult.EMPTY);
                    return;
                }
                SearchHit[] hits = searchResponse.getHits().getHits();
                List<ApiKey> apiKeyInfos = Arrays.stream(hits).map(hit -> this.convertSearchHitToApiKeyInfo((SearchHit)hit, withLimitedBy)).toList();
                List<Object[]> sortValues = Arrays.stream(hits).map(SearchHit::getSortValues).toList();
                listener.onResponse((Object)new QueryApiKeysResult(total, apiKeyInfos, sortValues, searchResponse.getAggregations()));
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
        }
    }

    private ApiKey convertSearchHitToApiKeyInfo(SearchHit hit) {
        return this.convertSearchHitToApiKeyInfo(hit, false);
    }

    private ApiKey convertSearchHitToApiKeyInfo(SearchHit hit, boolean withLimitedBy) {
        ApiKeyDoc apiKeyDoc = ApiKeyService.convertSearchHitToVersionedApiKeyDoc((SearchHit)hit).doc;
        String apiKeyId = hit.getId();
        Map metadata = apiKeyDoc.metadataFlattened != null ? (Map)XContentHelper.convertToMap((BytesReference)apiKeyDoc.metadataFlattened, (boolean)false, (XContentType)XContentType.JSON).v2() : Map.of();
        List<RoleDescriptor> roleDescriptors = this.parseRoleDescriptorsBytes(apiKeyId, apiKeyDoc.roleDescriptorsBytes, RoleReference.ApiKeyRoleType.ASSIGNED);
        List<RoleDescriptor> limitedByRoleDescriptors = withLimitedBy && apiKeyDoc.type != ApiKey.Type.CROSS_CLUSTER ? this.parseRoleDescriptorsBytes(apiKeyId, apiKeyDoc.limitedByRoleDescriptorsBytes, RoleReference.ApiKeyRoleType.LIMITED_BY) : null;
        return new ApiKey(apiKeyDoc.name, apiKeyId, apiKeyDoc.type, Instant.ofEpochMilli(apiKeyDoc.creationTime), apiKeyDoc.expirationTime != -1L ? Instant.ofEpochMilli(apiKeyDoc.expirationTime) : null, apiKeyDoc.invalidated.booleanValue(), apiKeyDoc.invalidation != -1L ? Instant.ofEpochMilli(apiKeyDoc.invalidation) : null, (String)apiKeyDoc.creator.get("principal"), (String)apiKeyDoc.creator.get("realm"), (String)apiKeyDoc.creator.get("realm_type"), metadata, roleDescriptors, limitedByRoleDescriptors);
    }

    private static VersionedApiKeyDoc convertSearchHitToVersionedApiKeyDoc(SearchHit hit) {
        VersionedApiKeyDoc versionedApiKeyDoc;
        block8: {
            XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)hit.getSourceRef(), (XContentType)XContentType.JSON);
            try {
                versionedApiKeyDoc = new VersionedApiKeyDoc(ApiKeyDoc.fromXContent(parser), hit.getId(), hit.getSeqNo(), hit.getPrimaryTerm());
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            parser.close();
        }
        return versionedApiKeyDoc;
    }

    private RemovalListener<String, ListenableFuture<CachedApiKeyHashResult>> getAuthCacheRemovalListener(int maximumWeight) {
        return notification -> {
            if (RemovalNotification.RemovalReason.EVICTED == notification.getRemovalReason() && this.getApiKeyAuthCache().count() >= maximumWeight) {
                this.evictionCounter.increment();
                logger.trace("API key with ID [{}] was evicted from the authentication cache, possibly due to cache size limit", notification.getKey());
                long last = this.lastEvictionCheckedAt.get();
                long now = System.nanoTime();
                if (now - last >= 300000000000L && this.lastEvictionCheckedAt.compareAndSet(last, now)) {
                    long sum = this.evictionCounter.sum();
                    this.evictionCounter.add(-sum);
                    if (sum >= 4500L) {
                        logger.warn("Possible thrashing for API key authentication cache, [{}] eviction due to cache size within last [{}] seconds", (Object)sum, (Object)300L);
                    }
                }
            }
        };
    }

    LongAdder getEvictionCounter() {
        return this.evictionCounter;
    }

    AtomicLong getLastEvictionCheckedAt() {
        return this.lastEvictionCheckedAt;
    }

    public static String getCreatorRealmName(Authentication authentication) {
        if (authentication.isApiKey() || authentication.isCrossClusterAccess()) {
            return (String)authentication.getEffectiveSubject().getMetadata().get("_security_api_key_creator_realm_name");
        }
        if (authentication.isFailedRunAs()) {
            return authentication.getAuthenticatingSubject().getRealm().getName();
        }
        return authentication.getEffectiveSubject().getRealm().getName();
    }

    public static String[] getOwnersRealmNames(Authentication authentication) {
        if (authentication.isApiKey()) {
            return new String[]{(String)authentication.getEffectiveSubject().getMetadata().get("_security_api_key_creator_realm_name")};
        }
        Authentication.RealmRef effectiveSubjectRealm = authentication.getEffectiveSubject().getRealm();
        if (effectiveSubjectRealm == null) {
            String message = "Cannot determine owner realms without an effective subject realm for non-API key authentication object [" + String.valueOf(authentication) + "]";
            assert (false) : message;
            throw new IllegalArgumentException(message);
        }
        RealmDomain domain = effectiveSubjectRealm.getDomain();
        if (domain != null) {
            return (String[])domain.realms().stream().map(RealmConfig.RealmIdentifier::getName).toArray(String[]::new);
        }
        return new String[]{effectiveSubjectRealm.getName()};
    }

    public static String getCreatorRealmType(Authentication authentication) {
        if (authentication.isApiKey()) {
            return (String)authentication.getEffectiveSubject().getMetadata().get("_security_api_key_creator_realm_type");
        }
        if (authentication.isFailedRunAs()) {
            return authentication.getAuthenticatingSubject().getRealm().getType();
        }
        return authentication.getEffectiveSubject().getRealm().getType();
    }

    public static Map<String, Object> getApiKeyMetadata(Authentication authentication) {
        if (!authentication.isAuthenticatedAsApiKey()) {
            throw new IllegalArgumentException("authentication realm must be [_es_api_key], got [" + authentication.getEffectiveSubject().getRealm().getType() + "]");
        }
        Object apiKeyMetadata = authentication.getEffectiveSubject().getMetadata().get("_security_api_key_metadata");
        if (apiKeyMetadata != null) {
            Tuple tuple = XContentHelper.convertToMap((BytesReference)((BytesReference)apiKeyMetadata), (boolean)false, (XContentType)XContentType.JSON);
            return (Map)tuple.v2();
        }
        return Map.of();
    }

    public static WriteRequest.RefreshPolicy defaultCreateDocRefreshPolicy(Settings settings) {
        return DiscoveryNode.isStateless((Settings)settings) ? WriteRequest.RefreshPolicy.IMMEDIATE : WriteRequest.RefreshPolicy.WAIT_UNTIL;
    }

    private /* synthetic */ void lambda$findApiKeys$35(SearchRequest request, Supplier supplier, ActionListener listener, Function hitParser) {
        ScrollHelper.fetchAllByEntity((Client)this.client, (SearchRequest)request, (ActionListener)new ContextPreservingActionListener(supplier, listener), (Function)hitParser);
    }

    private static final class ApiKeyDocCache {
        private final Cache<String, CachedApiKeyDoc> docCache;
        private final Cache<String, BytesReference> roleDescriptorsBytesCache;
        private final LockingAtomicCounter lockingAtomicCounter;

        ApiKeyDocCache(TimeValue ttl, int maximumWeight) {
            this.docCache = CacheBuilder.builder().setMaximumWeight((long)maximumWeight).setExpireAfterWrite(ttl).build();
            this.roleDescriptorsBytesCache = CacheBuilder.builder().setExpireAfterAccess(TimeValue.timeValueHours((long)1L)).setMaximumWeight((long)maximumWeight * 2L).build();
            this.lockingAtomicCounter = new LockingAtomicCounter();
        }

        public ApiKeyDoc get(String docId) {
            CachedApiKeyDoc existing = (CachedApiKeyDoc)this.docCache.get((Object)docId);
            if (existing != null) {
                BytesReference roleDescriptorsBytes = (BytesReference)this.roleDescriptorsBytesCache.get((Object)existing.roleDescriptorsHash);
                BytesReference limitedByRoleDescriptorsBytes = (BytesReference)this.roleDescriptorsBytesCache.get((Object)existing.limitedByRoleDescriptorsHash);
                if (roleDescriptorsBytes != null && limitedByRoleDescriptorsBytes != null) {
                    return existing.toApiKeyDoc(roleDescriptorsBytes, limitedByRoleDescriptorsBytes);
                }
            }
            return null;
        }

        public long getInvalidationCount() {
            return this.lockingAtomicCounter.get();
        }

        public void putIfNoInvalidationSince(String docId, ApiKeyDoc apiKeyDoc, long invalidationCount) {
            CachedApiKeyDoc cachedApiKeyDoc = apiKeyDoc.toCachedApiKeyDoc();
            this.lockingAtomicCounter.compareAndRun(invalidationCount, () -> {
                this.docCache.put((Object)docId, (Object)cachedApiKeyDoc);
                try {
                    this.roleDescriptorsBytesCache.computeIfAbsent((Object)cachedApiKeyDoc.roleDescriptorsHash, k -> apiKeyDoc.roleDescriptorsBytes);
                    this.roleDescriptorsBytesCache.computeIfAbsent((Object)cachedApiKeyDoc.limitedByRoleDescriptorsHash, k -> apiKeyDoc.limitedByRoleDescriptorsBytes);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        public void invalidate(Collection<String> docIds) {
            this.lockingAtomicCounter.increment();
            logger.debug("Invalidating API key doc cache with ids: [{}]", (Object)org.elasticsearch.common.Strings.collectionToCommaDelimitedString(docIds));
            docIds.forEach(arg_0 -> this.docCache.invalidate(arg_0));
        }

        public void invalidateAll() {
            this.lockingAtomicCounter.increment();
            logger.debug("Invalidating all API key doc cache and descriptor cache");
            this.docCache.invalidateAll();
            this.roleDescriptorsBytesCache.invalidateAll();
        }
    }

    private record VersionedApiKeyDoc(ApiKeyDoc doc, String id, long seqNo, long primaryTerm) {
    }

    public static final class ApiKeyDoc {
        private static final BytesReference NULL_BYTES = new BytesArray("null");
        static final InstantiatingObjectParser<ApiKeyDoc, Void> PARSER;
        final String docType;
        final ApiKey.Type type;
        final long creationTime;
        final long expirationTime;
        final Boolean invalidated;
        final long invalidation;
        final String hash;
        @Nullable
        final String name;
        final int version;
        final BytesReference roleDescriptorsBytes;
        final BytesReference limitedByRoleDescriptorsBytes;
        final Map<String, Object> creator;
        @Nullable
        final BytesReference metadataFlattened;

        public ApiKeyDoc(String docType, ApiKey.Type type, long creationTime, long expirationTime, Boolean invalidated, @Nullable Long invalidation, String hash, @Nullable String name, int version, BytesReference roleDescriptorsBytes, BytesReference limitedByRoleDescriptorsBytes, Map<String, Object> creator, @Nullable BytesReference metadataFlattened) {
            this.docType = docType;
            if (type == null) {
                logger.trace("API key document with [null] type defaults to [rest] type");
                this.type = ApiKey.Type.REST;
            } else {
                this.type = type;
            }
            this.creationTime = creationTime;
            this.expirationTime = expirationTime;
            this.invalidated = invalidated;
            this.invalidation = invalidation == null ? -1L : invalidation;
            this.hash = hash;
            this.name = name;
            this.version = version;
            this.roleDescriptorsBytes = roleDescriptorsBytes;
            this.limitedByRoleDescriptorsBytes = limitedByRoleDescriptorsBytes;
            this.creator = creator;
            this.metadataFlattened = NULL_BYTES.equals(metadataFlattened) ? null : metadataFlattened;
        }

        public CachedApiKeyDoc toCachedApiKeyDoc() {
            MessageDigest digest = MessageDigests.sha256();
            String roleDescriptorsHash = MessageDigests.toHexString((byte[])MessageDigests.digest((BytesReference)this.roleDescriptorsBytes, (MessageDigest)digest));
            digest.reset();
            String limitedByRoleDescriptorsHash = MessageDigests.toHexString((byte[])MessageDigests.digest((BytesReference)this.limitedByRoleDescriptorsBytes, (MessageDigest)digest));
            return new CachedApiKeyDoc(this.type, this.creationTime, this.expirationTime, this.invalidated, this.invalidation, this.hash, this.name, this.version, this.creator, roleDescriptorsHash, limitedByRoleDescriptorsHash, this.metadataFlattened);
        }

        static ApiKeyDoc fromXContent(XContentParser parser) {
            return (ApiKeyDoc)PARSER.apply(parser, null);
        }

        static {
            InstantiatingObjectParser.Builder builder = InstantiatingObjectParser.builder((String)"api_key_doc", (boolean)true, ApiKeyDoc.class);
            builder.declareString(ConstructingObjectParser.constructorArg(), new ParseField("doc_type", new String[0]));
            builder.declareField(ConstructingObjectParser.optionalConstructorArg(), ApiKey.Type::fromXContent, new ParseField("type", new String[0]), ObjectParser.ValueType.STRING);
            builder.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("creation_time", new String[0]));
            builder.declareLongOrNull(ConstructingObjectParser.constructorArg(), -1L, new ParseField("expiration_time", new String[0]));
            builder.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("api_key_invalidated", new String[0]));
            builder.declareLong(ConstructingObjectParser.optionalConstructorArg(), new ParseField("invalidation_time", new String[0]));
            builder.declareString(ConstructingObjectParser.constructorArg(), new ParseField("api_key_hash", new String[0]));
            builder.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("name", new String[0]));
            builder.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("version", new String[0]));
            ObjectParserHelper.declareRawObject((AbstractObjectParser)builder, (BiConsumer)ConstructingObjectParser.constructorArg(), (ParseField)new ParseField("role_descriptors", new String[0]));
            ObjectParserHelper.declareRawObject((AbstractObjectParser)builder, (BiConsumer)ConstructingObjectParser.constructorArg(), (ParseField)new ParseField("limited_by_role_descriptors", new String[0]));
            builder.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), new ParseField("creator", new String[0]));
            ObjectParserHelper.declareRawObjectOrNull((AbstractObjectParser)builder, (BiConsumer)ConstructingObjectParser.optionalConstructorArg(), (ParseField)new ParseField("metadata_flattened", new String[0]));
            PARSER = builder.build();
        }
    }

    public static final class ApiKeyCredentials
    implements AuthenticationToken,
    Closeable {
        private final String id;
        private final SecureString key;
        private final ApiKey.Type expectedType;

        public ApiKeyCredentials(String id, SecureString key, ApiKey.Type expectedType) {
            this.id = id;
            this.key = key;
            this.expectedType = expectedType;
        }

        String getId() {
            return this.id;
        }

        SecureString getKey() {
            return this.key;
        }

        @Override
        public void close() {
            this.key.close();
        }

        public String principal() {
            return this.id;
        }

        public Object credentials() {
            return this.key;
        }

        public void clearCredentials() {
            this.close();
        }

        public ApiKey.Type getExpectedType() {
            return this.expectedType;
        }
    }

    private static class ApiKeyLoggingDeprecationHandler
    implements DeprecationHandler {
        private final DeprecationLogger deprecationLogger;
        private final String apiKeyId;

        private ApiKeyLoggingDeprecationHandler(DeprecationLogger logger, String apiKeyId) {
            this.deprecationLogger = logger;
            this.apiKeyId = apiKeyId;
        }

        public void logRenamedField(String parserName, Supplier<XContentLocation> location, String oldName, String currentName) {
            String prefix = parserName == null ? "" : "[" + parserName + "][" + String.valueOf(location.get()) + "] ";
            this.deprecationLogger.warn(DeprecationCategory.API, "api_key_field", "{}Deprecated field [{}] used in api key [{}], expected [{}] instead", new Object[]{prefix, oldName, this.apiKeyId, currentName});
        }

        public void logReplacedField(String parserName, Supplier<XContentLocation> location, String oldName, String replacedName) {
            String prefix = parserName == null ? "" : "[" + parserName + "][" + String.valueOf(location.get()) + "] ";
            this.deprecationLogger.warn(DeprecationCategory.API, "api_key_field", "{}Deprecated field [{}] used in api key [{}], replaced by [{}]", new Object[]{prefix, oldName, this.apiKeyId, replacedName});
        }

        public void logRemovedField(String parserName, Supplier<XContentLocation> location, String removedName) {
            String prefix = parserName == null ? "" : "[" + parserName + "][" + String.valueOf(location.get()) + "] ";
            this.deprecationLogger.warn(DeprecationCategory.API, "api_key_field", "{}Deprecated field [{}] used in api key [{}], which is unused and will be removed entirely", new Object[]{prefix, removedName, this.apiKeyId});
        }
    }

    final class CachedApiKeyHashResult {
        final boolean success;
        final char[] hash;

        CachedApiKeyHashResult(boolean success, SecureString apiKey) {
            this.success = success;
            this.hash = ApiKeyService.this.cacheHasher.hash(apiKey);
        }

        boolean verify(SecureString password) {
            return this.hash != null && ApiKeyService.this.cacheHasher.verify(password, this.hash);
        }
    }

    public record QueryApiKeysResult(long total, Collection<ApiKey> apiKeyInfos, Collection<Object[]> sortValues, @Nullable InternalAggregations aggregations) {
        static final QueryApiKeysResult EMPTY = new QueryApiKeysResult(0L, List.of(), List.of(), null);
    }

    public static final class CachedApiKeyDoc {
        final ApiKey.Type type;
        final long creationTime;
        final long expirationTime;
        final Boolean invalidated;
        final long invalidation;
        final String hash;
        final String name;
        final int version;
        final Map<String, Object> creator;
        final String roleDescriptorsHash;
        final String limitedByRoleDescriptorsHash;
        @Nullable
        final BytesReference metadataFlattened;

        public CachedApiKeyDoc(ApiKey.Type type, long creationTime, long expirationTime, Boolean invalidated, long invalidation, String hash, String name, int version, Map<String, Object> creator, String roleDescriptorsHash, String limitedByRoleDescriptorsHash, @Nullable BytesReference metadataFlattened) {
            this.type = type;
            this.creationTime = creationTime;
            this.expirationTime = expirationTime;
            this.invalidated = invalidated;
            this.invalidation = invalidation;
            this.hash = hash;
            this.name = name;
            this.version = version;
            this.creator = creator;
            this.roleDescriptorsHash = roleDescriptorsHash;
            this.limitedByRoleDescriptorsHash = limitedByRoleDescriptorsHash;
            this.metadataFlattened = metadataFlattened;
        }

        public ApiKeyDoc toApiKeyDoc(BytesReference roleDescriptorsBytes, BytesReference limitedByRoleDescriptorsBytes) {
            return new ApiKeyDoc("api_key", this.type, this.creationTime, this.expirationTime, this.invalidated, this.invalidation, this.hash, this.name, this.version, roleDescriptorsBytes, limitedByRoleDescriptorsBytes, this.creator, this.metadataFlattened);
        }
    }
}

