/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.role;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.security.action.role.BulkPutRoleRequestBuilder;
import org.elasticsearch.xpack.core.security.action.role.BulkPutRoleRequestBuilderFactory;
import org.elasticsearch.xpack.security.rest.action.role.NativeRoleBaseRestHandler;

public class RestBulkPutRolesAction
extends NativeRoleBaseRestHandler {
    private final BulkPutRoleRequestBuilderFactory builderFactory;

    public RestBulkPutRolesAction(Settings settings, XPackLicenseState licenseState, BulkPutRoleRequestBuilderFactory builderFactory) {
        super(settings, licenseState);
        this.builderFactory = builderFactory;
    }

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_security/role").build());
    }

    public String getName() {
        return "security_bulk_put_roles_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        BulkPutRoleRequestBuilder requestBuilder = this.builderFactory.create((Client)client).content((BytesReference)request.requiredContent(), request.getXContentType());
        if (request.param("refresh") != null) {
            requestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.parse((String)request.param("refresh")));
        }
        return channel -> requestBuilder.execute((ActionListener)new RestToXContentListener(channel));
    }
}

