/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.tool;

import java.security.SecureRandom;
import org.elasticsearch.core.Nullable;

public class CommandUtils {
    static final SecureRandom SECURE_RANDOM = new SecureRandom();

    public static char[] generatePassword(int passwordLength) {
        char[] passwordChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789*-_=+".toCharArray();
        char[] characters = new char[passwordLength];
        for (int i = 0; i < passwordLength; ++i) {
            characters[i] = passwordChars[SECURE_RANDOM.nextInt(passwordChars.length)];
        }
        return characters;
    }

    protected static String generateUsername(@Nullable String prefix, @Nullable String suffix, int length) {
        char[] usernameChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
        String prefixString = null == prefix ? "" : prefix;
        String suffixString = null == suffix ? "" : prefix;
        char[] characters = new char[length];
        for (int i = 0; i < length; ++i) {
            characters[i] = usernameChars[SECURE_RANDOM.nextInt(usernameChars.length)];
        }
        return prefixString + new String(characters) + suffixString;
    }
}

