/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.stack;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.IngestPipelineConfig;
import org.elasticsearch.xpack.core.template.JsonIngestPipelineConfig;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;

public class StackTemplateRegistry
extends IndexTemplateRegistry {
    private static final Logger logger = LogManager.getLogger(StackTemplateRegistry.class);
    public static final NodeFeature STACK_TEMPLATES_FEATURE = new NodeFeature("stack.templates_supported");
    public static final NodeFeature DATA_STREAM_LIFECYCLE = new NodeFeature("data_stream.lifecycle");
    public static final int REGISTRY_VERSION = 14;
    public static final String TEMPLATE_VERSION_VARIABLE = "xpack.stack.template.version";
    public static final Setting<Boolean> STACK_TEMPLATES_ENABLED = Setting.boolSetting((String)"stack.templates.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private final ClusterService clusterService;
    private final FeatureService featureService;
    private final Map<String, ComponentTemplate> componentTemplateConfigs;
    private volatile boolean stackTemplateEnabled;
    public static final Map<String, String> ADDITIONAL_TEMPLATE_VARIABLES = Map.of("xpack.stack.template.deprecated", "false");
    public static final String DATA_STREAMS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "data-streams@mappings";
    public static final String ECS_DYNAMIC_MAPPINGS_COMPONENT_TEMPLATE_NAME = "ecs@mappings";
    public static final String ILM_7_DAYS_POLICY_NAME = "7-days@lifecycle";
    public static final String ILM_30_DAYS_POLICY_NAME = "30-days@lifecycle";
    public static final String ILM_90_DAYS_POLICY_NAME = "90-days@lifecycle";
    public static final String ILM_180_DAYS_POLICY_NAME = "180-days@lifecycle";
    public static final String ILM_365_DAYS_POLICY_NAME = "365-days@lifecycle";
    public static final String LOGS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "logs@mappings";
    public static final String LOGS_SETTINGS_COMPONENT_TEMPLATE_NAME = "logs@settings";
    public static final String LOGS_ILM_POLICY_NAME = "logs@lifecycle";
    public static final String LOGS_INDEX_TEMPLATE_NAME = "logs";
    public static final String METRICS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "metrics@mappings";
    public static final String METRICS_SETTINGS_COMPONENT_TEMPLATE_NAME = "metrics@settings";
    public static final String METRICS_TSDB_SETTINGS_COMPONENT_TEMPLATE_NAME = "metrics@tsdb-settings";
    public static final String METRICS_ILM_POLICY_NAME = "metrics@lifecycle";
    public static final String METRICS_INDEX_TEMPLATE_NAME = "metrics";
    public static final String TRACES_MAPPINGS_COMPONENT_TEMPLATE_NAME = "traces@mappings";
    public static final String TRACES_SETTINGS_COMPONENT_TEMPLATE_NAME = "traces@settings";
    public static final String TRACES_ILM_POLICY_NAME = "traces@lifecycle";
    public static final String SYNTHETICS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "synthetics@mappings";
    public static final String SYNTHETICS_SETTINGS_COMPONENT_TEMPLATE_NAME = "synthetics@settings";
    public static final String SYNTHETICS_ILM_POLICY_NAME = "synthetics@lifecycle";
    public static final String SYNTHETICS_INDEX_TEMPLATE_NAME = "synthetics";
    public static final String AGENTLESS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "agentless@mappings";
    public static final String AGENTLESS_SETTINGS_COMPONENT_TEMPLATE_NAME = "agentless@settings";
    public static final String AGENTLESS_INDEX_TEMPLATE_NAME = "agentless";
    public static final String KIBANA_REPORTING_INDEX_TEMPLATE_NAME = ".kibana-reporting";
    public static final String KIBANA_REPORTING_COMPONENT_TEMPLATE_NAME = "kibana-reporting@settings";
    private static final List<LifecyclePolicyConfig> LIFECYCLE_POLICY_CONFIGS = List.of(new LifecyclePolicyConfig("logs@lifecycle", "/logs@lifecycle.json", ADDITIONAL_TEMPLATE_VARIABLES), new LifecyclePolicyConfig("metrics@lifecycle", "/metrics@lifecycle.json", ADDITIONAL_TEMPLATE_VARIABLES), new LifecyclePolicyConfig("synthetics@lifecycle", "/synthetics@lifecycle.json", ADDITIONAL_TEMPLATE_VARIABLES), new LifecyclePolicyConfig("traces@lifecycle", "/traces@lifecycle.json", ADDITIONAL_TEMPLATE_VARIABLES), new LifecyclePolicyConfig("7-days@lifecycle", "/7-days@lifecycle.json", ADDITIONAL_TEMPLATE_VARIABLES), new LifecyclePolicyConfig("30-days@lifecycle", "/30-days@lifecycle.json", ADDITIONAL_TEMPLATE_VARIABLES), new LifecyclePolicyConfig("90-days@lifecycle", "/90-days@lifecycle.json", ADDITIONAL_TEMPLATE_VARIABLES), new LifecyclePolicyConfig("180-days@lifecycle", "/180-days@lifecycle.json", ADDITIONAL_TEMPLATE_VARIABLES), new LifecyclePolicyConfig("365-days@lifecycle", "/365-days@lifecycle.json", ADDITIONAL_TEMPLATE_VARIABLES));
    private static final Map<String, ComposableIndexTemplate> COMPOSABLE_INDEX_TEMPLATE_CONFIGS = StackTemplateRegistry.parseComposableTemplates((IndexTemplateConfig[])new IndexTemplateConfig[]{new IndexTemplateConfig("logs", "/logs@template.json", 14, "xpack.stack.template.version", ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig("metrics", "/metrics@template.json", 14, "xpack.stack.template.version", ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig("synthetics", "/synthetics@template.json", 14, "xpack.stack.template.version", ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig("agentless", "/agentless@template.json", 14, "xpack.stack.template.version", ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(".kibana-reporting", "/kibana-reporting@template.json", 14, "xpack.stack.template.version", ADDITIONAL_TEMPLATE_VARIABLES)});
    private static final List<IngestPipelineConfig> INGEST_PIPELINE_CONFIGS = List.of(new JsonIngestPipelineConfig("logs@json-pipeline", "/logs@json-pipeline.json", 14, "xpack.stack.template.version", List.of(), ADDITIONAL_TEMPLATE_VARIABLES), new JsonIngestPipelineConfig("logs@default-pipeline", "/logs@default-pipeline.json", 14, "xpack.stack.template.version", List.of(), ADDITIONAL_TEMPLATE_VARIABLES));

    public StackTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry, FeatureService featureService) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        this.clusterService = clusterService;
        this.featureService = featureService;
        this.stackTemplateEnabled = (Boolean)STACK_TEMPLATES_ENABLED.get(nodeSettings);
        this.componentTemplateConfigs = this.loadComponentTemplateConfigs();
    }

    private Map<String, ComponentTemplate> loadComponentTemplateConfigs() {
        HashMap<String, ComponentTemplate> componentTemplates = new HashMap<String, ComponentTemplate>();
        for (IndexTemplateConfig config : List.of(new IndexTemplateConfig(DATA_STREAMS_MAPPINGS_COMPONENT_TEMPLATE_NAME, "/data-streams@mappings.json", 14, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(LOGS_MAPPINGS_COMPONENT_TEMPLATE_NAME, "/logs@mappings.json", 14, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(ECS_DYNAMIC_MAPPINGS_COMPONENT_TEMPLATE_NAME, "/ecs@mappings.json", 14, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(LOGS_SETTINGS_COMPONENT_TEMPLATE_NAME, "/logs@settings.json", 14, TEMPLATE_VERSION_VARIABLE, Map.of("xpack.stack.template.deprecated", "false")), new IndexTemplateConfig(METRICS_MAPPINGS_COMPONENT_TEMPLATE_NAME, "/metrics@mappings.json", 14, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(METRICS_SETTINGS_COMPONENT_TEMPLATE_NAME, "/metrics@settings.json", 14, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(METRICS_TSDB_SETTINGS_COMPONENT_TEMPLATE_NAME, "/metrics@tsdb-settings.json", 14, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(TRACES_SETTINGS_COMPONENT_TEMPLATE_NAME, "/traces@settings.json", 14, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(TRACES_MAPPINGS_COMPONENT_TEMPLATE_NAME, "/traces@mappings.json", 14, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(SYNTHETICS_MAPPINGS_COMPONENT_TEMPLATE_NAME, "/synthetics@mappings.json", 14, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(SYNTHETICS_SETTINGS_COMPONENT_TEMPLATE_NAME, "/synthetics@settings.json", 14, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(AGENTLESS_MAPPINGS_COMPONENT_TEMPLATE_NAME, "/agentless@mappings.json", 14, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(AGENTLESS_SETTINGS_COMPONENT_TEMPLATE_NAME, "/agentless@settings.json", 14, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(KIBANA_REPORTING_COMPONENT_TEMPLATE_NAME, "/kibana-reporting@settings.json", 14, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES))) {
            try {
                componentTemplates.put(config.getTemplateName(), ComponentTemplate.parse((XContentParser)JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, config.loadBytes())));
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return Map.copyOf(componentTemplates);
    }

    public void initialize() {
        super.initialize();
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(STACK_TEMPLATES_ENABLED, this::updateEnabledSetting);
    }

    private void updateEnabledSetting(boolean newValue) {
        if (newValue) {
            this.stackTemplateEnabled = true;
        } else {
            logger.info("stack composable templates [{}] and component templates [{}] will not be installed or reinstalled", (Object)String.join((CharSequence)",", this.getComposableTemplateConfigs().keySet()), (Object)String.join((CharSequence)",", this.getComponentTemplateConfigs().keySet()));
            this.stackTemplateEnabled = false;
        }
    }

    protected List<LifecyclePolicyConfig> getLifecycleConfigs() {
        return LIFECYCLE_POLICY_CONFIGS;
    }

    protected List<LifecyclePolicy> getLifecyclePolicies() {
        return this.lifecyclePolicies;
    }

    protected Map<String, ComponentTemplate> getComponentTemplateConfigs() {
        return this.componentTemplateConfigs;
    }

    protected Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        if (this.stackTemplateEnabled) {
            return COMPOSABLE_INDEX_TEMPLATE_CONFIGS;
        }
        return Map.of();
    }

    protected List<IngestPipelineConfig> getIngestPipelines() {
        return INGEST_PIPELINE_CONFIGS;
    }

    protected String getOrigin() {
        return "stack";
    }

    protected boolean requiresMasterNode() {
        return true;
    }

    protected boolean isClusterReady(ClusterChangedEvent event) {
        return this.featureService.clusterHasFeature(event.state(), DATA_STREAM_LIFECYCLE);
    }
}

