/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.analytics.action;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.application.EnterpriseSearchBaseRestHandler;
import org.elasticsearch.xpack.application.analytics.action.PutAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.utils.LicenseUtils;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPutAnalyticsCollectionAction
extends EnterpriseSearchBaseRestHandler {
    public RestPutAnalyticsCollectionAction(XPackLicenseState licenseState) {
        super(licenseState, LicenseUtils.Product.BEHAVIORAL_ANALYTICS);
    }

    public String getName() {
        return "analytics_post_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_application/analytics/{collection_name}"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest restRequest, NodeClient client) {
        PutAnalyticsCollectionAction.Request request = new PutAnalyticsCollectionAction.Request(RestUtils.getMasterNodeTimeout((RestRequest)restRequest), restRequest.param("collection_name"));
        String location = this.routes().get(0).getPath().replace("{collection_name}", request.getName());
        return channel -> client.execute(PutAnalyticsCollectionAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel, r -> RestStatus.CREATED, _r -> location));
    }
}

