/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.search.action;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;
import org.elasticsearch.xpack.application.EnterpriseSearchBaseRestHandler;
import org.elasticsearch.xpack.application.search.action.QuerySearchApplicationAction;
import org.elasticsearch.xpack.application.search.action.SearchApplicationSearchRequest;
import org.elasticsearch.xpack.application.utils.LicenseUtils;

@ServerlessScope(value=Scope.PUBLIC)
public class RestQuerySearchApplicationAction
extends EnterpriseSearchBaseRestHandler {
    public static final String ENDPOINT_PATH = "/_application/search_application/{name}/_search";
    public static final Set<String> RESPONSE_PARAMS = Set.of("typed_keys");

    public RestQuerySearchApplicationAction(XPackLicenseState licenseState) {
        super(licenseState, LicenseUtils.Product.SEARCH_APPLICATION);
    }

    public String getName() {
        return "search_application_query_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, ENDPOINT_PATH), new RestHandler.Route(RestRequest.Method.POST, ENDPOINT_PATH));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        String searchAppName = restRequest.param("name");
        SearchApplicationSearchRequest request = restRequest.hasContentOrSourceParam() ? SearchApplicationSearchRequest.fromXContent(searchAppName, restRequest.contentOrSourceParamParser()) : new SearchApplicationSearchRequest(searchAppName);
        return channel -> {
            RestCancellableNodeClient cancelClient = new RestCancellableNodeClient(client, restRequest.getHttpChannel());
            cancelClient.execute(QuerySearchApplicationAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestRefCountedChunkedToXContentListener(channel));
        };
    }

    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }
}

