/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.settings.Settings;

public class LegacyTiersDetection {
    public static final String DEPRECATION_MESSAGE = "Configuring tiers via filtered allocation is not recommended.";
    public static final String DEPRECATION_COMMON_DETAIL = "This is typically used to create a hot/warm or tiered architecture, based on legacy guidelines. Data tiers are a recommended replacement for tiered architecture clusters.";
    public static final String DEPRECATION_HELP_URL = "https://ela.st/migrate-to-tiers";
    public static final String NODE_ATTRIBUTE = "data";
    private static final Set<String> DEPRECATED_SETTINGS = Set.of(IndexMetadata.INDEX_ROUTING_REQUIRE_GROUP_SETTING.getKey() + "data", IndexMetadata.INDEX_ROUTING_INCLUDE_GROUP_SETTING.getKey() + "data", IndexMetadata.INDEX_ROUTING_EXCLUDE_GROUP_SETTING.getKey() + "data");
    private static final Set<String> TIER_VALUES = Set.of("hot", "warm", "cold", "frozen");

    public static List<String> getDeprecatedFilteredAllocationSettings(Settings settings) {
        if (settings == null || settings.isEmpty()) {
            return List.of();
        }
        return DEPRECATED_SETTINGS.stream().filter(setting -> {
            String value = settings.get(setting);
            return value != null && TIER_VALUES.contains(value);
        }).toList();
    }

    public static boolean containsDeprecatedFilteredAllocationConfig(Map<String, String> nodeAttributeConfiguration) {
        return nodeAttributeConfiguration != null && nodeAttributeConfiguration.containsKey(NODE_ATTRIBUTE) && TIER_VALUES.contains(nodeAttributeConfiguration.get(NODE_ATTRIBUTE));
    }
}

