/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.windows.service;

import java.util.Locale;
import org.elasticsearch.windows.service.ProcrunCommand;

class WindowsServiceManagerCommand
extends ProcrunCommand {
    WindowsServiceManagerCommand() {
        super("Starts the Elasticsearch Windows Service manager", "ES");
    }

    @Override
    protected String getExecutable() {
        return "elasticsearch-service-mgr.exe";
    }

    @Override
    protected boolean includeLogArgs() {
        return false;
    }

    @Override
    protected String getSuccessMessage(String serviceId) {
        return String.format(Locale.ROOT, "Successfully started service manager for '%s'", serviceId);
    }

    @Override
    protected String getFailureMessage(String serviceId) {
        return String.format(Locale.ROOT, "Failed starting service manager for '%s'", serviceId);
    }
}

