/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations.bucket.histogram;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.KeyComparable;
import org.elasticsearch.search.aggregations.bucket.BucketReducer;
import org.elasticsearch.search.aggregations.bucket.IteratorAndCurrent;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.AbstractHistogramBucket;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramFactory;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class InternalAutoDateHistogram
extends InternalMultiBucketAggregation<InternalAutoDateHistogram, Bucket>
implements Histogram,
HistogramFactory {
    private final List<Bucket> buckets;
    private final DocValueFormat format;
    private final BucketInfo bucketInfo;
    private final int targetBuckets;
    private final long bucketInnerInterval;

    InternalAutoDateHistogram(String name, List<Bucket> buckets, int targetBuckets, BucketInfo emptyBucketInfo, DocValueFormat formatter, Map<String, Object> metadata, long bucketInnerInterval) {
        super(name, metadata);
        this.buckets = buckets;
        this.bucketInfo = emptyBucketInfo;
        this.format = formatter;
        this.targetBuckets = targetBuckets;
        this.bucketInnerInterval = bucketInnerInterval;
    }

    public InternalAutoDateHistogram(StreamInput in) throws IOException {
        super(in);
        this.bucketInfo = new BucketInfo(in);
        this.format = (DocValueFormat)in.readNamedWriteable(DocValueFormat.class);
        this.buckets = in.readCollectionAsList(stream -> Bucket.readFrom(stream, this.format));
        this.targetBuckets = in.readVInt();
        this.bucketInnerInterval = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_3_0) ? in.readVLong() : 1L;
        if (in.getTransportVersion().between((VersionId)TransportVersions.V_8_13_0, (VersionId)TransportVersions.V_8_14_0)) {
            this.buckets.sort(Comparator.comparingLong(b -> b.key));
        }
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        this.bucketInfo.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.format);
        out.writeCollection(this.buckets);
        out.writeVInt(this.targetBuckets);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_3_0)) {
            out.writeVLong(this.bucketInnerInterval);
        }
    }

    long getBucketInnerInterval() {
        return this.bucketInnerInterval;
    }

    public DateHistogramInterval getInterval() {
        AutoDateHistogramAggregationBuilder.RoundingInfo roundingInfo = this.bucketInfo.roundingInfos[this.bucketInfo.roundingIdx];
        String unitAbbreviation = roundingInfo.unitAbbreviation;
        return new DateHistogramInterval(this.bucketInnerInterval + unitAbbreviation);
    }

    public String getWriteableName() {
        return "auto_date_histogram";
    }

    public List<Bucket> getBuckets() {
        return Collections.unmodifiableList(this.buckets);
    }

    DocValueFormat getFormatter() {
        return this.format;
    }

    public int getTargetBuckets() {
        return this.targetBuckets;
    }

    BucketInfo getBucketInfo() {
        return this.bucketInfo;
    }

    public InternalAutoDateHistogram create(List<Bucket> buckets) {
        return new InternalAutoDateHistogram(this.name, buckets, this.targetBuckets, this.bucketInfo, this.format, this.metadata, this.bucketInnerInterval);
    }

    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.key, prototype.getDocCount(), prototype.getFormatter(), aggregations);
    }

    private BucketReduceResult reduceBuckets(PriorityQueue<IteratorAndCurrent<Bucket>> pq, int reduceRoundingIdx, long min, long max, AggregationReduceContext reduceContext) {
        Rounding.Prepared reduceRounding = this.prepare(reduceRoundingIdx, min, max);
        ArrayList<Bucket> reducedBuckets = new ArrayList<Bucket>();
        if (pq.size() > 0) {
            ArrayList<Bucket> currentBuckets = new ArrayList<Bucket>();
            long key = reduceRounding.round(((Bucket)((IteratorAndCurrent)pq.top()).current()).key);
            do {
                IteratorAndCurrent top = (IteratorAndCurrent)pq.top();
                if (reduceRounding.round(((Bucket)top.current()).key) != key) {
                    Bucket reduced = this.reduceBucket(currentBuckets, reduceContext);
                    reducedBuckets.add(reduced);
                    currentBuckets.clear();
                    key = reduceRounding.round(((Bucket)top.current()).key);
                }
                currentBuckets.add((Bucket)top.current());
                if (top.hasNext()) {
                    top.next();
                    assert (((Bucket)top.current()).key > key) : "shards must return data sorted by key";
                    pq.updateTop();
                    continue;
                }
                pq.pop();
            } while (pq.size() > 0);
            if (!currentBuckets.isEmpty()) {
                Bucket reduced = this.reduceBucket(currentBuckets, reduceContext);
                reducedBuckets.add(reduced);
            }
        }
        return this.mergeBucketsIfNeeded(new BucketReduceResult(reducedBuckets, reduceRoundingIdx, 1L, reduceRounding, min, max), reduceContext);
    }

    private BucketReduceResult mergeBucketsIfNeeded(BucketReduceResult firstPassResult, AggregationReduceContext reduceContext) {
        int idx = firstPassResult.roundingIdx;
        AutoDateHistogramAggregationBuilder.RoundingInfo info = this.bucketInfo.roundingInfos[idx];
        List<Bucket> buckets = firstPassResult.buckets;
        Rounding.Prepared prepared = firstPassResult.preparedRounding;
        while (buckets.size() > this.targetBuckets * info.getMaximumInnerInterval() && idx < this.bucketInfo.roundingInfos.length - 1) {
            info = this.bucketInfo.roundingInfos[++idx];
            prepared = this.prepare(idx, firstPassResult.min, firstPassResult.max);
            buckets = this.mergeBuckets(buckets, prepared, reduceContext);
        }
        return new BucketReduceResult(buckets, idx, 1L, prepared, firstPassResult.min, firstPassResult.max);
    }

    private Rounding.Prepared prepare(int idx, long min, long max) {
        Rounding rounding = this.bucketInfo.roundingInfos[idx].rounding;
        return min <= max ? rounding.prepare(min, max) : rounding.prepareForUnknown();
    }

    private List<Bucket> mergeBuckets(List<Bucket> reducedBuckets, Rounding.Prepared reduceRounding, AggregationReduceContext reduceContext) {
        ArrayList<Bucket> mergedBuckets = new ArrayList<Bucket>();
        ArrayList<Bucket> sameKeyedBuckets = new ArrayList<Bucket>();
        double key = Double.NaN;
        for (Bucket bucket : reducedBuckets) {
            long roundedBucketKey = reduceRounding.round(bucket.key);
            if (Double.isNaN(key)) {
                key = roundedBucketKey;
                sameKeyedBuckets.add(this.createBucket(key, bucket.getDocCount(), bucket.getAggregations()));
                continue;
            }
            if ((double)roundedBucketKey == key) {
                sameKeyedBuckets.add(this.createBucket(key, bucket.getDocCount(), bucket.getAggregations()));
                continue;
            }
            mergedBuckets.add(this.reduceBucket(sameKeyedBuckets, reduceContext));
            sameKeyedBuckets.clear();
            key = roundedBucketKey;
            sameKeyedBuckets.add(this.createBucket(key, bucket.getDocCount(), bucket.getAggregations()));
        }
        if (!sameKeyedBuckets.isEmpty()) {
            mergedBuckets.add(this.reduceBucket(sameKeyedBuckets, reduceContext));
        }
        reducedBuckets = mergedBuckets;
        return reducedBuckets;
    }

    private Bucket reduceBucket(List<Bucket> buckets, AggregationReduceContext context) {
        assert (!buckets.isEmpty());
        try (BucketReducer reducer = new BucketReducer((MultiBucketsAggregation.Bucket)buckets.get(0), context, buckets.size());){
            for (Bucket bucket : buckets) {
                reducer.accept((MultiBucketsAggregation.Bucket)bucket);
            }
            Object object = this.createBucket(((Bucket)reducer.getProto()).key, reducer.getDocCount(), reducer.getAggregations());
            return object;
        }
    }

    private BucketReduceResult addEmptyBuckets(BucketReduceResult current, AggregationReduceContext reduceContext) {
        List<Bucket> list = current.buckets;
        if (list.isEmpty()) {
            return current;
        }
        int roundingIdx = InternalAutoDateHistogram.getAppropriateRounding(list.get((int)0).key, list.get((int)(list.size() - 1)).key, current.roundingIdx, this.bucketInfo.roundingInfos, this.targetBuckets);
        Rounding.Prepared rounding = current.roundingIdx == roundingIdx ? current.preparedRounding : this.prepare(roundingIdx, current.min, current.max);
        list = this.mergeBuckets(list, rounding, reduceContext);
        Bucket lastBucket = null;
        ListIterator<Bucket> iter = list.listIterator();
        InternalAggregations reducedEmptySubAggs = InternalAggregations.reduce(List.of(this.bucketInfo.emptySubAggregations), (AggregationReduceContext)reduceContext);
        while (iter.hasNext()) {
            Bucket nextBucket = list.get(iter.nextIndex());
            if (lastBucket != null) {
                long key = rounding.nextRoundingValue(lastBucket.key);
                while (key < nextBucket.key) {
                    iter.add(new Bucket(key, 0L, this.format, reducedEmptySubAggs));
                    key = rounding.nextRoundingValue(key);
                }
                assert (key == nextBucket.key) : "key: " + key + ", nextBucket.key: " + nextBucket.key;
            }
            lastBucket = iter.next();
        }
        return new BucketReduceResult(list, roundingIdx, 1L, rounding, current.min, current.max);
    }

    static int getAppropriateRounding(long minKey, long maxKey, int roundingIdx, AutoDateHistogramAggregationBuilder.RoundingInfo[] roundings, int targetBuckets) {
        if (roundingIdx == roundings.length - 1) {
            return roundingIdx;
        }
        int currentRoundingIdx = roundingIdx;
        for (int i = currentRoundingIdx + 1; i < roundings.length; ++i) {
            long dataDuration = maxKey - minKey;
            long roughEstimateRequiredBuckets = dataDuration / roundings[i].getRoughEstimateDurationMillis();
            if (roughEstimateRequiredBuckets < (long)(targetBuckets * roundings[i].getMaximumInnerInterval())) {
                currentRoundingIdx = i - 1;
                break;
            }
            if (i != roundingIdx - 1) continue;
            currentRoundingIdx = i;
            break;
        }
        int requiredBuckets = 0;
        do {
            Rounding currentRounding = roundings[currentRoundingIdx].rounding;
            long currentKey = minKey;
            requiredBuckets = 0;
            while (currentKey < maxKey) {
                ++requiredBuckets;
                currentKey = currentRounding.nextRoundingValue(currentKey);
            }
        } while (requiredBuckets > targetBuckets * roundings[++currentRoundingIdx - 1].getMaximumInnerInterval() && currentRoundingIdx < roundings.length);
        return currentRoundingIdx - 1;
    }

    protected AggregatorReducer getLeaderReducer(final AggregationReduceContext reduceContext, final int size) {
        return new AggregatorReducer(){
            private final PriorityQueue<IteratorAndCurrent<Bucket>> pq;
            private int reduceRoundingIdx;
            private long min;
            private long max;
            {
                this.pq = new PriorityQueue<IteratorAndCurrent<Bucket>>(size){

                    protected boolean lessThan(IteratorAndCurrent<Bucket> a, IteratorAndCurrent<Bucket> b) {
                        return ((Bucket)a.current()).key < ((Bucket)b.current()).key;
                    }
                };
                this.reduceRoundingIdx = 0;
                this.min = Long.MAX_VALUE;
                this.max = Long.MIN_VALUE;
            }

            public void accept(InternalAggregation aggregation) {
                InternalAutoDateHistogram histogram = (InternalAutoDateHistogram)aggregation;
                this.reduceRoundingIdx = Math.max(histogram.bucketInfo.roundingIdx, this.reduceRoundingIdx);
                if (!histogram.buckets.isEmpty()) {
                    this.min = Math.min(this.min, histogram.buckets.get((int)0).key);
                    this.max = Math.max(this.max, histogram.buckets.get((int)(histogram.buckets.size() - 1)).key);
                    this.pq.add((Object)new IteratorAndCurrent(histogram.buckets.iterator()));
                }
            }

            public InternalAggregation get() {
                BucketReduceResult reducedBucketsResult = InternalAutoDateHistogram.this.reduceBuckets(this.pq, this.reduceRoundingIdx, this.min, this.max, reduceContext);
                if (reduceContext.isFinalReduce()) {
                    reducedBucketsResult = InternalAutoDateHistogram.this.addEmptyBuckets(reducedBucketsResult, reduceContext);
                    reducedBucketsResult = InternalAutoDateHistogram.this.mergeBucketsIfNeeded(reducedBucketsResult, reduceContext);
                    reducedBucketsResult = InternalAutoDateHistogram.this.maybeMergeConsecutiveBuckets(reducedBucketsResult, reduceContext);
                }
                reduceContext.consumeBucketsAndMaybeBreak(reducedBucketsResult.buckets.size());
                BucketInfo bucketInfo = new BucketInfo(InternalAutoDateHistogram.this.getBucketInfo().roundingInfos, reducedBucketsResult.roundingIdx, InternalAutoDateHistogram.this.getBucketInfo().emptySubAggregations);
                return new InternalAutoDateHistogram(InternalAutoDateHistogram.this.getName(), reducedBucketsResult.buckets, InternalAutoDateHistogram.this.targetBuckets, bucketInfo, InternalAutoDateHistogram.this.format, InternalAutoDateHistogram.this.getMetadata(), reducedBucketsResult.innerInterval);
            }
        };
    }

    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return new InternalAutoDateHistogram(this.getName(), this.buckets.stream().map(b -> b.finalizeSampling(samplingContext)).toList(), this.targetBuckets, this.bucketInfo, this.format, this.getMetadata(), this.bucketInnerInterval);
    }

    private BucketReduceResult maybeMergeConsecutiveBuckets(BucketReduceResult current, AggregationReduceContext reduceContext) {
        List<Bucket> buckets = current.buckets;
        AutoDateHistogramAggregationBuilder.RoundingInfo roundingInfo = this.bucketInfo.roundingInfos[current.roundingIdx];
        if (buckets.size() > this.targetBuckets) {
            for (int interval : roundingInfo.innerIntervals) {
                int resultingBuckets = buckets.size() / interval;
                if (buckets.size() % interval != 0) {
                    ++resultingBuckets;
                }
                if (resultingBuckets > this.targetBuckets) continue;
                return this.mergeConsecutiveBuckets(current, interval, reduceContext);
            }
        }
        return current;
    }

    private BucketReduceResult mergeConsecutiveBuckets(BucketReduceResult current, int mergeInterval, AggregationReduceContext reduceContext) {
        ArrayList<Bucket> mergedBuckets = new ArrayList<Bucket>();
        ArrayList<Bucket> sameKeyedBuckets = new ArrayList<Bucket>();
        double key = current.preparedRounding.round(current.buckets.get((int)0).key);
        for (int i = 0; i < current.buckets.size(); ++i) {
            Bucket bucket = current.buckets.get(i);
            if (i % mergeInterval == 0 && !sameKeyedBuckets.isEmpty()) {
                mergedBuckets.add(this.reduceBucket(sameKeyedBuckets, reduceContext));
                sameKeyedBuckets.clear();
                key = current.preparedRounding.round(bucket.key);
            }
            sameKeyedBuckets.add(new Bucket(Math.round(key), bucket.getDocCount(), this.format, bucket.getAggregations()));
        }
        if (!sameKeyedBuckets.isEmpty()) {
            mergedBuckets.add(this.reduceBucket(sameKeyedBuckets, reduceContext));
        }
        return new BucketReduceResult(mergedBuckets, current.roundingIdx, mergeInterval, current.preparedRounding, current.min, current.max);
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (Bucket bucket : this.buckets) {
            bucket.bucketToXContent(builder, params, this.format);
        }
        builder.endArray();
        builder.field("interval", this.getInterval().toString());
        return builder;
    }

    public Number getKey(MultiBucketsAggregation.Bucket bucket) {
        return ((Bucket)bucket).key;
    }

    public InternalAggregation createAggregation(List<MultiBucketsAggregation.Bucket> buckets) {
        List<Bucket> buckets2 = new ArrayList(buckets.size());
        for (MultiBucketsAggregation.Bucket b : buckets) {
            buckets2.add((Bucket)b);
        }
        buckets2 = Collections.unmodifiableList(buckets2);
        return new InternalAutoDateHistogram(this.name, buckets2, this.targetBuckets, this.bucketInfo, this.format, this.getMetadata(), this.bucketInnerInterval);
    }

    public Bucket createBucket(Number key, long docCount, InternalAggregations aggregations) {
        return new Bucket(key.longValue(), docCount, this.format, aggregations);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalAutoDateHistogram that = (InternalAutoDateHistogram)((Object)obj);
        return Objects.equals(this.buckets, that.buckets) && Objects.equals(this.format, that.format) && Objects.equals(this.bucketInfo, that.bucketInfo) && this.bucketInnerInterval == that.bucketInnerInterval;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.buckets, this.format, this.bucketInfo, this.bucketInnerInterval);
    }

    static class BucketInfo {
        final AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos;
        final int roundingIdx;
        final InternalAggregations emptySubAggregations;

        BucketInfo(AutoDateHistogramAggregationBuilder.RoundingInfo[] roundings, int roundingIdx, InternalAggregations subAggregations) {
            this.roundingInfos = roundings;
            this.roundingIdx = roundingIdx;
            this.emptySubAggregations = subAggregations;
        }

        BucketInfo(StreamInput in) throws IOException {
            int size = in.readVInt();
            this.roundingInfos = new AutoDateHistogramAggregationBuilder.RoundingInfo[size];
            for (int i = 0; i < size; ++i) {
                this.roundingInfos[i] = new AutoDateHistogramAggregationBuilder.RoundingInfo(in);
            }
            this.roundingIdx = in.readVInt();
            this.emptySubAggregations = InternalAggregations.readFrom((StreamInput)in);
        }

        void writeTo(StreamOutput out) throws IOException {
            out.writeArray((Writeable[])this.roundingInfos);
            out.writeVInt(this.roundingIdx);
            this.emptySubAggregations.writeTo(out);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            BucketInfo that = (BucketInfo)obj;
            return Objects.deepEquals(this.roundingInfos, that.roundingInfos) && Objects.equals(this.roundingIdx, that.roundingIdx) && Objects.equals(this.emptySubAggregations, that.emptySubAggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), Arrays.hashCode(this.roundingInfos), this.roundingIdx, this.emptySubAggregations);
        }
    }

    public static class Bucket
    extends AbstractHistogramBucket
    implements KeyComparable<Bucket> {
        final long key;

        public Bucket(long key, long docCount, DocValueFormat format, InternalAggregations aggregations) {
            super(docCount, aggregations, format);
            this.key = key;
        }

        public static Bucket readFrom(StreamInput in, DocValueFormat format) throws IOException {
            return new Bucket(in.readLong(), in.readVLong(), format, InternalAggregations.readFrom((StreamInput)in));
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != Bucket.class) {
                return false;
            }
            Bucket that = (Bucket)((Object)obj);
            return this.key == that.key && this.docCount == that.docCount && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(((Object)((Object)this)).getClass(), this.key, this.docCount, this.aggregations);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.key);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        public String getKeyAsString() {
            return this.format.format(this.key).toString();
        }

        public Object getKey() {
            return Instant.ofEpochMilli(this.key).atZone(ZoneOffset.UTC);
        }

        private void bucketToXContent(XContentBuilder builder, ToXContent.Params params, DocValueFormat format) throws IOException {
            String keyAsString = format.format(this.key).toString();
            builder.startObject();
            if (format != DocValueFormat.RAW) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), keyAsString);
            }
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
        }

        public int compareKey(Bucket other) {
            return Long.compare(this.key, other.key);
        }

        Bucket finalizeSampling(SamplingContext samplingContext) {
            return new Bucket(this.key, samplingContext.scaleUp(this.docCount), this.format, InternalAggregations.finalizeSampling((InternalAggregations)this.aggregations, (SamplingContext)samplingContext));
        }
    }

    private record BucketReduceResult(List<Bucket> buckets, int roundingIdx, long innerInterval, Rounding.Prepared preparedRounding, long min, long max) {
    }
}

