/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.bridge;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.elasticsearch.entitlement.bridge.EntitlementChecker;

class HandleLoader {
    static <T extends EntitlementChecker> T load(Class<T> checkerClass) {
        Method checkerMethod;
        Class<?> initClazz;
        String initClassName = "org.elasticsearch.entitlement.initialization.EntitlementInitialization";
        try {
            initClazz = ClassLoader.getSystemClassLoader().loadClass(initClassName);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError("java.base cannot find entitlement initialization", e);
        }
        try {
            checkerMethod = initClazz.getMethod("checker", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError("EntitlementInitialization is missing checker() method", e);
        }
        try {
            return (T)((EntitlementChecker)checkerClass.cast(checkerMethod.invoke(null, new Object[0])));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    private HandleLoader() {
    }
}

