/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rank.rrf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.search.retriever.CompoundRetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverParserContext;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.rank.rrf.RRFRankDoc;
import org.elasticsearch.xpack.rank.rrf.RRFRankPlugin;

public final class RRFRetrieverBuilder
extends CompoundRetrieverBuilder<RRFRetrieverBuilder> {
    public static final String NAME = "rrf";
    public static final NodeFeature RRF_RETRIEVER_SUPPORTED = new NodeFeature("rrf_retriever_supported", true);
    public static final NodeFeature RRF_RETRIEVER_COMPOSITION_SUPPORTED = new NodeFeature("rrf_retriever_composition_supported", true);
    public static final ParseField RETRIEVERS_FIELD = new ParseField("retrievers", new String[0]);
    public static final ParseField RANK_CONSTANT_FIELD = new ParseField("rank_constant", new String[0]);
    public static final int DEFAULT_RANK_CONSTANT = 60;
    static final ConstructingObjectParser<RRFRetrieverBuilder, RetrieverParserContext> PARSER = new ConstructingObjectParser("rrf", false, args -> {
        List childRetrievers = (List)args[0];
        List<CompoundRetrieverBuilder.RetrieverSource> innerRetrievers = childRetrievers.stream().map(r -> new CompoundRetrieverBuilder.RetrieverSource(r, null)).toList();
        int rankWindowSize = args[1] == null ? 10 : (Integer)args[1];
        int rankConstant = args[2] == null ? 60 : (Integer)args[2];
        return new RRFRetrieverBuilder(innerRetrievers, rankWindowSize, rankConstant);
    });
    private final int rankConstant;

    public static RRFRetrieverBuilder fromXContent(XContentParser parser, RetrieverParserContext context) throws IOException {
        if (!context.clusterSupportsFeature(RRF_RETRIEVER_SUPPORTED)) {
            throw new ParsingException(parser.getTokenLocation(), "unknown retriever [rrf]", new Object[0]);
        }
        if (!context.clusterSupportsFeature(RRF_RETRIEVER_COMPOSITION_SUPPORTED)) {
            throw new IllegalArgumentException("[rrf] retriever composition feature is not supported by all nodes in the cluster");
        }
        if (!RRFRankPlugin.RANK_RRF_FEATURE.check(XPackPlugin.getSharedLicenseState())) {
            throw LicenseUtils.newComplianceException((String)"Reciprocal Rank Fusion (RRF)");
        }
        return (RRFRetrieverBuilder)((Object)PARSER.apply(parser, (Object)context));
    }

    public RRFRetrieverBuilder(int rankWindowSize, int rankConstant) {
        this(new ArrayList<CompoundRetrieverBuilder.RetrieverSource>(), rankWindowSize, rankConstant);
    }

    RRFRetrieverBuilder(List<CompoundRetrieverBuilder.RetrieverSource> childRetrievers, int rankWindowSize, int rankConstant) {
        super(childRetrievers, rankWindowSize);
        this.rankConstant = rankConstant;
    }

    public String getName() {
        return NAME;
    }

    protected RRFRetrieverBuilder clone(List<CompoundRetrieverBuilder.RetrieverSource> newRetrievers, List<QueryBuilder> newPreFilterQueryBuilders) {
        RRFRetrieverBuilder clone = new RRFRetrieverBuilder(newRetrievers, this.rankWindowSize, this.rankConstant);
        clone.preFilterQueryBuilders = newPreFilterQueryBuilders;
        clone.retrieverName = this.retrieverName;
        return clone;
    }

    protected RRFRankDoc[] combineInnerRetrieverResults(List<ScoreDoc[]> rankResults, boolean explain) {
        int rank;
        int queries = rankResults.size();
        Map docsToRankResults = Maps.newMapWithExpectedSize((int)this.rankWindowSize);
        int index = 0;
        for (ScoreDoc[] rrfRankResult : rankResults) {
            rank = 1;
            for (ScoreDoc scoreDoc : rrfRankResult) {
                int findex = index;
                int frank = rank++;
                docsToRankResults.compute(new RankDoc.RankKey(scoreDoc.doc, scoreDoc.shardIndex), (key, value) -> {
                    if (value == null) {
                        value = explain ? new RRFRankDoc(scoreDoc.doc, scoreDoc.shardIndex, queries, this.rankConstant) : new RRFRankDoc(scoreDoc.doc, scoreDoc.shardIndex);
                    }
                    value.score += 1.0f / (float)(this.rankConstant + frank);
                    if (explain && value.positions != null && value.scores != null) {
                        value.positions[findex] = frank - 1;
                        value.scores[findex] = scoreDoc.score;
                    }
                    return value;
                });
            }
            ++index;
        }
        RRFRankDoc[] sortedResults = (RRFRankDoc[])docsToRankResults.values().toArray(RRFRankDoc[]::new);
        Arrays.sort((Object[])sortedResults);
        RRFRankDoc[] topResults = new RRFRankDoc[Math.min(this.rankWindowSize, sortedResults.length)];
        for (rank = 0; rank < topResults.length; ++rank) {
            topResults[rank] = sortedResults[rank];
            topResults[rank].rank = rank + 1;
        }
        return topResults;
    }

    public boolean doEquals(Object o) {
        RRFRetrieverBuilder that = (RRFRetrieverBuilder)((Object)o);
        return super.doEquals(o) && this.rankConstant == that.rankConstant;
    }

    public int doHashCode() {
        return Objects.hash(super.doHashCode(), this.rankConstant);
    }

    public void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!this.innerRetrievers.isEmpty()) {
            builder.startArray(RETRIEVERS_FIELD.getPreferredName());
            for (CompoundRetrieverBuilder.RetrieverSource entry : this.innerRetrievers) {
                entry.retriever().toXContent(builder, params);
            }
            builder.endArray();
        }
        builder.field(RANK_WINDOW_SIZE_FIELD.getPreferredName(), this.rankWindowSize);
        builder.field(RANK_CONSTANT_FIELD.getPreferredName(), this.rankConstant);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> {
            p.nextToken();
            String name = p.currentName();
            RetrieverBuilder retrieverBuilder = (RetrieverBuilder)p.namedObject(RetrieverBuilder.class, name, c);
            c.trackRetrieverUsage(retrieverBuilder.getName());
            p.nextToken();
            return retrieverBuilder;
        }, RETRIEVERS_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), RANK_WINDOW_SIZE_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), RANK_CONSTANT_FIELD);
        RetrieverBuilder.declareBaseParserFields((String)NAME, PARSER);
    }
}

