// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::ffi;
use glib::{prelude::*, translate::*};

glib::wrapper! {
    #[doc(alias = "GtkSourceStyle")]
    pub struct Style(Object<ffi::GtkSourceStyle, ffi::GtkSourceStyleClass>);

    match fn {
        type_ => || ffi::gtk_source_style_get_type(),
    }
}

impl Style {
    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Style`] objects.
    ///
    /// This method returns an instance of [`StyleBuilder`](crate::builders::StyleBuilder) which can be used to create [`Style`] objects.
    pub fn builder() -> StyleBuilder {
        StyleBuilder::new()
    }

    #[doc(alias = "gtk_source_style_apply")]
    pub fn apply(&self, tag: &impl IsA<gtk::TextTag>) {
        unsafe {
            ffi::gtk_source_style_apply(self.to_glib_none().0, tag.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_source_style_copy")]
    #[must_use]
    pub fn copy(&self) -> Style {
        unsafe { from_glib_full(ffi::gtk_source_style_copy(self.to_glib_none().0)) }
    }

    pub fn background(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "background")
    }

    #[doc(alias = "background-set")]
    pub fn is_background_set(&self) -> bool {
        ObjectExt::property(self, "background-set")
    }

    pub fn is_bold(&self) -> bool {
        ObjectExt::property(self, "bold")
    }

    #[doc(alias = "bold-set")]
    pub fn is_bold_set(&self) -> bool {
        ObjectExt::property(self, "bold-set")
    }

    pub fn foreground(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "foreground")
    }

    #[doc(alias = "foreground-set")]
    pub fn is_foreground_set(&self) -> bool {
        ObjectExt::property(self, "foreground-set")
    }

    pub fn is_italic(&self) -> bool {
        ObjectExt::property(self, "italic")
    }

    #[doc(alias = "italic-set")]
    pub fn is_italic_set(&self) -> bool {
        ObjectExt::property(self, "italic-set")
    }

    #[doc(alias = "line-background")]
    pub fn line_background(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "line-background")
    }

    #[doc(alias = "line-background-set")]
    pub fn is_line_background_set(&self) -> bool {
        ObjectExt::property(self, "line-background-set")
    }

    #[doc(alias = "pango-underline")]
    pub fn pango_underline(&self) -> pango::Underline {
        ObjectExt::property(self, "pango-underline")
    }

    pub fn scale(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "scale")
    }

    #[doc(alias = "scale-set")]
    pub fn is_scale_set(&self) -> bool {
        ObjectExt::property(self, "scale-set")
    }

    pub fn is_strikethrough(&self) -> bool {
        ObjectExt::property(self, "strikethrough")
    }

    #[doc(alias = "strikethrough-set")]
    pub fn is_strikethrough_set(&self) -> bool {
        ObjectExt::property(self, "strikethrough-set")
    }

    #[doc(alias = "underline-color")]
    pub fn underline_color(&self) -> Option<glib::GString> {
        ObjectExt::property(self, "underline-color")
    }

    #[doc(alias = "underline-color-set")]
    pub fn is_underline_color_set(&self) -> bool {
        ObjectExt::property(self, "underline-color-set")
    }

    #[doc(alias = "underline-set")]
    pub fn is_underline_set(&self) -> bool {
        ObjectExt::property(self, "underline-set")
    }

    pub fn weight(&self) -> pango::Weight {
        ObjectExt::property(self, "weight")
    }

    #[doc(alias = "weight-set")]
    pub fn is_weight_set(&self) -> bool {
        ObjectExt::property(self, "weight-set")
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Style`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct StyleBuilder {
    builder: glib::object::ObjectBuilder<'static, Style>,
}

impl StyleBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn background(self, background: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("background", background.into()),
        }
    }

    pub fn background_set(self, background_set: bool) -> Self {
        Self {
            builder: self.builder.property("background-set", background_set),
        }
    }

    pub fn bold(self, bold: bool) -> Self {
        Self {
            builder: self.builder.property("bold", bold),
        }
    }

    pub fn bold_set(self, bold_set: bool) -> Self {
        Self {
            builder: self.builder.property("bold-set", bold_set),
        }
    }

    pub fn foreground(self, foreground: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("foreground", foreground.into()),
        }
    }

    pub fn foreground_set(self, foreground_set: bool) -> Self {
        Self {
            builder: self.builder.property("foreground-set", foreground_set),
        }
    }

    pub fn italic(self, italic: bool) -> Self {
        Self {
            builder: self.builder.property("italic", italic),
        }
    }

    pub fn italic_set(self, italic_set: bool) -> Self {
        Self {
            builder: self.builder.property("italic-set", italic_set),
        }
    }

    pub fn line_background(self, line_background: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("line-background", line_background.into()),
        }
    }

    pub fn line_background_set(self, line_background_set: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("line-background-set", line_background_set),
        }
    }

    pub fn pango_underline(self, pango_underline: pango::Underline) -> Self {
        Self {
            builder: self.builder.property("pango-underline", pango_underline),
        }
    }

    pub fn scale(self, scale: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("scale", scale.into()),
        }
    }

    pub fn scale_set(self, scale_set: bool) -> Self {
        Self {
            builder: self.builder.property("scale-set", scale_set),
        }
    }

    pub fn strikethrough(self, strikethrough: bool) -> Self {
        Self {
            builder: self.builder.property("strikethrough", strikethrough),
        }
    }

    pub fn strikethrough_set(self, strikethrough_set: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("strikethrough-set", strikethrough_set),
        }
    }

    pub fn underline_color(self, underline_color: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("underline-color", underline_color.into()),
        }
    }

    pub fn underline_color_set(self, underline_color_set: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("underline-color-set", underline_color_set),
        }
    }

    pub fn underline_set(self, underline_set: bool) -> Self {
        Self {
            builder: self.builder.property("underline-set", underline_set),
        }
    }

    pub fn weight(self, weight: pango::Weight) -> Self {
        Self {
            builder: self.builder.property("weight", weight),
        }
    }

    pub fn weight_set(self, weight_set: bool) -> Self {
        Self {
            builder: self.builder.property("weight-set", weight_set),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Style`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Style {
        self.builder.build()
    }
}
