//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use objc2::__framework_prelude::*;

use crate::*;

pub type unichar = c_ushort;

// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSStringCompareOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSStringCompareOptions: NSUInteger {
        const NSCaseInsensitiveSearch = 1;
        const NSLiteralSearch = 2;
        const NSBackwardsSearch = 4;
        const NSAnchoredSearch = 8;
        const NSNumericSearch = 64;
        const NSDiacriticInsensitiveSearch = 128;
        const NSWidthInsensitiveSearch = 256;
        const NSForcedOrderingSearch = 512;
        const NSRegularExpressionSearch = 1024;
    }
}

unsafe impl Encode for NSStringCompareOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSStringCompareOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

pub type NSStringEncoding = NSUInteger;

pub const NSASCIIStringEncoding: NSStringEncoding = 1;
pub const NSNEXTSTEPStringEncoding: NSStringEncoding = 2;
pub const NSJapaneseEUCStringEncoding: NSStringEncoding = 3;
pub const NSUTF8StringEncoding: NSStringEncoding = 4;
pub const NSISOLatin1StringEncoding: NSStringEncoding = 5;
pub const NSSymbolStringEncoding: NSStringEncoding = 6;
pub const NSNonLossyASCIIStringEncoding: NSStringEncoding = 7;
pub const NSShiftJISStringEncoding: NSStringEncoding = 8;
pub const NSISOLatin2StringEncoding: NSStringEncoding = 9;
pub const NSUnicodeStringEncoding: NSStringEncoding = 10;
pub const NSWindowsCP1251StringEncoding: NSStringEncoding = 11;
pub const NSWindowsCP1252StringEncoding: NSStringEncoding = 12;
pub const NSWindowsCP1253StringEncoding: NSStringEncoding = 13;
pub const NSWindowsCP1254StringEncoding: NSStringEncoding = 14;
pub const NSWindowsCP1250StringEncoding: NSStringEncoding = 15;
pub const NSISO2022JPStringEncoding: NSStringEncoding = 21;
pub const NSMacOSRomanStringEncoding: NSStringEncoding = 30;
pub const NSUTF16StringEncoding: NSStringEncoding = NSUnicodeStringEncoding;
pub const NSUTF16BigEndianStringEncoding: NSStringEncoding = 0x90000100;
pub const NSUTF16LittleEndianStringEncoding: NSStringEncoding = 0x94000100;
pub const NSUTF32StringEncoding: NSStringEncoding = 0x8c000100;
pub const NSUTF32BigEndianStringEncoding: NSStringEncoding = 0x98000100;
pub const NSUTF32LittleEndianStringEncoding: NSStringEncoding = 0x9c000100;

// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSStringEncodingConversionOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSStringEncodingConversionOptions: NSUInteger {
        const NSStringEncodingConversionAllowLossy = 1;
        const NSStringEncodingConversionExternalRepresentation = 2;
    }
}

unsafe impl Encode for NSStringEncodingConversionOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSStringEncodingConversionOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    #[derive(PartialEq, Eq, Hash)]
    pub struct NSString;

    unsafe impl ClassType for NSString {
        type Super = NSObject;
        type Mutability = ImmutableWithMutableSubclass<NSMutableString>;
    }
);

#[cfg(feature = "NSObject")]
unsafe impl NSCoding for NSString {}

#[cfg(feature = "NSObject")]
unsafe impl NSCopying for NSString {}

#[cfg(feature = "NSObject")]
unsafe impl NSMutableCopying for NSString {}

unsafe impl NSObjectProtocol for NSString {}

#[cfg(feature = "NSObject")]
unsafe impl NSSecureCoding for NSString {}

extern_methods!(
    unsafe impl NSString {
        #[method(length)]
        pub fn length(&self) -> NSUInteger;

        #[method(characterAtIndex:)]
        pub unsafe fn characterAtIndex(&self, index: NSUInteger) -> unichar;

        #[method_id(@__retain_semantics Init init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "NSCoder")]
        #[method_id(@__retain_semantics Init initWithCoder:)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl NSString {
        #[method_id(@__retain_semantics New new)]
        pub fn new() -> Retained<Self>;
    }
);

impl DefaultRetained for NSString {
    #[inline]
    fn default_id() -> Retained<Self> {
        Self::new()
    }
}

// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSStringEnumerationOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSStringEnumerationOptions: NSUInteger {
        const NSStringEnumerationByLines = 0;
        const NSStringEnumerationByParagraphs = 1;
        const NSStringEnumerationByComposedCharacterSequences = 2;
        const NSStringEnumerationByWords = 3;
        const NSStringEnumerationBySentences = 4;
        const NSStringEnumerationByCaretPositions = 5;
        const NSStringEnumerationByDeletionClusters = 6;
        const NSStringEnumerationReverse = 1<<8;
        const NSStringEnumerationSubstringNotRequired = 1<<9;
        const NSStringEnumerationLocalized = 1<<10;
    }
}

unsafe impl Encode for NSStringEnumerationOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSStringEnumerationOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_TYPED_EXTENSIBLE_ENUM
pub type NSStringTransform = NSString;

extern "C" {
    pub static NSStringTransformLatinToKatakana: &'static NSStringTransform;
}

extern "C" {
    pub static NSStringTransformLatinToHiragana: &'static NSStringTransform;
}

extern "C" {
    pub static NSStringTransformLatinToHangul: &'static NSStringTransform;
}

extern "C" {
    pub static NSStringTransformLatinToArabic: &'static NSStringTransform;
}

extern "C" {
    pub static NSStringTransformLatinToHebrew: &'static NSStringTransform;
}

extern "C" {
    pub static NSStringTransformLatinToThai: &'static NSStringTransform;
}

extern "C" {
    pub static NSStringTransformLatinToCyrillic: &'static NSStringTransform;
}

extern "C" {
    pub static NSStringTransformLatinToGreek: &'static NSStringTransform;
}

extern "C" {
    pub static NSStringTransformToLatin: &'static NSStringTransform;
}

extern "C" {
    pub static NSStringTransformMandarinToLatin: &'static NSStringTransform;
}

extern "C" {
    pub static NSStringTransformHiraganaToKatakana: &'static NSStringTransform;
}

extern "C" {
    pub static NSStringTransformFullwidthToHalfwidth: &'static NSStringTransform;
}

extern "C" {
    pub static NSStringTransformToXMLHex: &'static NSStringTransform;
}

extern "C" {
    pub static NSStringTransformToUnicodeName: &'static NSStringTransform;
}

extern "C" {
    pub static NSStringTransformStripCombiningMarks: &'static NSStringTransform;
}

extern "C" {
    pub static NSStringTransformStripDiacritics: &'static NSStringTransform;
}

extern_methods!(
    /// NSStringExtensionMethods
    unsafe impl NSString {
        #[method_id(@__retain_semantics Other substringFromIndex:)]
        pub unsafe fn substringFromIndex(&self, from: NSUInteger) -> Retained<NSString>;

        #[method_id(@__retain_semantics Other substringToIndex:)]
        pub unsafe fn substringToIndex(&self, to: NSUInteger) -> Retained<NSString>;

        #[cfg(feature = "NSRange")]
        #[method_id(@__retain_semantics Other substringWithRange:)]
        pub unsafe fn substringWithRange(&self, range: NSRange) -> Retained<NSString>;

        #[cfg(feature = "NSRange")]
        #[method(getCharacters:range:)]
        pub unsafe fn getCharacters_range(&self, buffer: NonNull<unichar>, range: NSRange);

        #[cfg(feature = "NSObjCRuntime")]
        #[method(compare:)]
        pub fn compare(&self, string: &NSString) -> NSComparisonResult;

        #[cfg(feature = "NSObjCRuntime")]
        #[method(compare:options:)]
        pub unsafe fn compare_options(
            &self,
            string: &NSString,
            mask: NSStringCompareOptions,
        ) -> NSComparisonResult;

        #[cfg(all(feature = "NSObjCRuntime", feature = "NSRange"))]
        #[method(compare:options:range:)]
        pub unsafe fn compare_options_range(
            &self,
            string: &NSString,
            mask: NSStringCompareOptions,
            range_of_receiver_to_compare: NSRange,
        ) -> NSComparisonResult;

        #[cfg(all(feature = "NSObjCRuntime", feature = "NSRange"))]
        #[method(compare:options:range:locale:)]
        pub unsafe fn compare_options_range_locale(
            &self,
            string: &NSString,
            mask: NSStringCompareOptions,
            range_of_receiver_to_compare: NSRange,
            locale: Option<&AnyObject>,
        ) -> NSComparisonResult;

        #[cfg(feature = "NSObjCRuntime")]
        #[method(caseInsensitiveCompare:)]
        pub unsafe fn caseInsensitiveCompare(&self, string: &NSString) -> NSComparisonResult;

        #[cfg(feature = "NSObjCRuntime")]
        #[method(localizedCompare:)]
        pub unsafe fn localizedCompare(&self, string: &NSString) -> NSComparisonResult;

        #[cfg(feature = "NSObjCRuntime")]
        #[method(localizedCaseInsensitiveCompare:)]
        pub unsafe fn localizedCaseInsensitiveCompare(
            &self,
            string: &NSString,
        ) -> NSComparisonResult;

        #[cfg(feature = "NSObjCRuntime")]
        #[method(localizedStandardCompare:)]
        pub unsafe fn localizedStandardCompare(&self, string: &NSString) -> NSComparisonResult;

        #[method(isEqualToString:)]
        pub unsafe fn isEqualToString(&self, a_string: &NSString) -> bool;

        #[method(hasPrefix:)]
        pub fn hasPrefix(&self, str: &NSString) -> bool;

        #[method(hasSuffix:)]
        pub fn hasSuffix(&self, str: &NSString) -> bool;

        #[method_id(@__retain_semantics Other commonPrefixWithString:options:)]
        pub unsafe fn commonPrefixWithString_options(
            &self,
            str: &NSString,
            mask: NSStringCompareOptions,
        ) -> Retained<NSString>;

        #[method(containsString:)]
        pub unsafe fn containsString(&self, str: &NSString) -> bool;

        #[method(localizedCaseInsensitiveContainsString:)]
        pub unsafe fn localizedCaseInsensitiveContainsString(&self, str: &NSString) -> bool;

        #[method(localizedStandardContainsString:)]
        pub unsafe fn localizedStandardContainsString(&self, str: &NSString) -> bool;

        #[cfg(feature = "NSRange")]
        #[method(localizedStandardRangeOfString:)]
        pub unsafe fn localizedStandardRangeOfString(&self, str: &NSString) -> NSRange;

        #[cfg(feature = "NSRange")]
        #[method(rangeOfString:)]
        pub unsafe fn rangeOfString(&self, search_string: &NSString) -> NSRange;

        #[cfg(feature = "NSRange")]
        #[method(rangeOfString:options:)]
        pub unsafe fn rangeOfString_options(
            &self,
            search_string: &NSString,
            mask: NSStringCompareOptions,
        ) -> NSRange;

        #[cfg(feature = "NSRange")]
        #[method(rangeOfString:options:range:)]
        pub unsafe fn rangeOfString_options_range(
            &self,
            search_string: &NSString,
            mask: NSStringCompareOptions,
            range_of_receiver_to_search: NSRange,
        ) -> NSRange;

        #[cfg(all(feature = "NSLocale", feature = "NSRange"))]
        #[method(rangeOfString:options:range:locale:)]
        pub unsafe fn rangeOfString_options_range_locale(
            &self,
            search_string: &NSString,
            mask: NSStringCompareOptions,
            range_of_receiver_to_search: NSRange,
            locale: Option<&NSLocale>,
        ) -> NSRange;

        #[cfg(all(feature = "NSCharacterSet", feature = "NSRange"))]
        #[method(rangeOfCharacterFromSet:)]
        pub unsafe fn rangeOfCharacterFromSet(&self, search_set: &NSCharacterSet) -> NSRange;

        #[cfg(all(feature = "NSCharacterSet", feature = "NSRange"))]
        #[method(rangeOfCharacterFromSet:options:)]
        pub unsafe fn rangeOfCharacterFromSet_options(
            &self,
            search_set: &NSCharacterSet,
            mask: NSStringCompareOptions,
        ) -> NSRange;

        #[cfg(all(feature = "NSCharacterSet", feature = "NSRange"))]
        #[method(rangeOfCharacterFromSet:options:range:)]
        pub unsafe fn rangeOfCharacterFromSet_options_range(
            &self,
            search_set: &NSCharacterSet,
            mask: NSStringCompareOptions,
            range_of_receiver_to_search: NSRange,
        ) -> NSRange;

        #[cfg(feature = "NSRange")]
        #[method(rangeOfComposedCharacterSequenceAtIndex:)]
        pub unsafe fn rangeOfComposedCharacterSequenceAtIndex(&self, index: NSUInteger) -> NSRange;

        #[cfg(feature = "NSRange")]
        #[method(rangeOfComposedCharacterSequencesForRange:)]
        pub unsafe fn rangeOfComposedCharacterSequencesForRange(&self, range: NSRange) -> NSRange;

        #[method_id(@__retain_semantics Other stringByAppendingString:)]
        pub fn stringByAppendingString(&self, a_string: &NSString) -> Retained<NSString>;

        #[method(doubleValue)]
        pub unsafe fn doubleValue(&self) -> c_double;

        #[method(floatValue)]
        pub unsafe fn floatValue(&self) -> c_float;

        #[method(intValue)]
        pub unsafe fn intValue(&self) -> c_int;

        #[method(integerValue)]
        pub unsafe fn integerValue(&self) -> NSInteger;

        #[method(longLongValue)]
        pub unsafe fn longLongValue(&self) -> c_longlong;

        #[method(boolValue)]
        pub unsafe fn boolValue(&self) -> bool;

        #[method_id(@__retain_semantics Other uppercaseString)]
        pub unsafe fn uppercaseString(&self) -> Retained<NSString>;

        #[method_id(@__retain_semantics Other lowercaseString)]
        pub unsafe fn lowercaseString(&self) -> Retained<NSString>;

        #[method_id(@__retain_semantics Other capitalizedString)]
        pub unsafe fn capitalizedString(&self) -> Retained<NSString>;

        #[method_id(@__retain_semantics Other localizedUppercaseString)]
        pub unsafe fn localizedUppercaseString(&self) -> Retained<NSString>;

        #[method_id(@__retain_semantics Other localizedLowercaseString)]
        pub unsafe fn localizedLowercaseString(&self) -> Retained<NSString>;

        #[method_id(@__retain_semantics Other localizedCapitalizedString)]
        pub unsafe fn localizedCapitalizedString(&self) -> Retained<NSString>;

        #[cfg(feature = "NSLocale")]
        #[method_id(@__retain_semantics Other uppercaseStringWithLocale:)]
        pub unsafe fn uppercaseStringWithLocale(
            &self,
            locale: Option<&NSLocale>,
        ) -> Retained<NSString>;

        #[cfg(feature = "NSLocale")]
        #[method_id(@__retain_semantics Other lowercaseStringWithLocale:)]
        pub unsafe fn lowercaseStringWithLocale(
            &self,
            locale: Option<&NSLocale>,
        ) -> Retained<NSString>;

        #[cfg(feature = "NSLocale")]
        #[method_id(@__retain_semantics Other capitalizedStringWithLocale:)]
        pub unsafe fn capitalizedStringWithLocale(
            &self,
            locale: Option<&NSLocale>,
        ) -> Retained<NSString>;

        #[cfg(feature = "NSRange")]
        #[method(getLineStart:end:contentsEnd:forRange:)]
        pub unsafe fn getLineStart_end_contentsEnd_forRange(
            &self,
            start_ptr: *mut NSUInteger,
            line_end_ptr: *mut NSUInteger,
            contents_end_ptr: *mut NSUInteger,
            range: NSRange,
        );

        #[cfg(feature = "NSRange")]
        #[method(lineRangeForRange:)]
        pub unsafe fn lineRangeForRange(&self, range: NSRange) -> NSRange;

        #[cfg(feature = "NSRange")]
        #[method(getParagraphStart:end:contentsEnd:forRange:)]
        pub unsafe fn getParagraphStart_end_contentsEnd_forRange(
            &self,
            start_ptr: *mut NSUInteger,
            par_end_ptr: *mut NSUInteger,
            contents_end_ptr: *mut NSUInteger,
            range: NSRange,
        );

        #[cfg(feature = "NSRange")]
        #[method(paragraphRangeForRange:)]
        pub unsafe fn paragraphRangeForRange(&self, range: NSRange) -> NSRange;

        #[cfg(all(feature = "NSRange", feature = "block2"))]
        #[method(enumerateSubstringsInRange:options:usingBlock:)]
        pub unsafe fn enumerateSubstringsInRange_options_usingBlock(
            &self,
            range: NSRange,
            opts: NSStringEnumerationOptions,
            block: &block2::Block<dyn Fn(*mut NSString, NSRange, NSRange, NonNull<Bool>)>,
        );

        #[cfg(feature = "block2")]
        #[method(enumerateLinesUsingBlock:)]
        pub unsafe fn enumerateLinesUsingBlock(
            &self,
            block: &block2::Block<dyn Fn(NonNull<NSString>, NonNull<Bool>)>,
        );

        #[method(UTF8String)]
        pub fn UTF8String(&self) -> *mut c_char;

        #[method(fastestEncoding)]
        pub unsafe fn fastestEncoding(&self) -> NSStringEncoding;

        #[method(smallestEncoding)]
        pub unsafe fn smallestEncoding(&self) -> NSStringEncoding;

        #[cfg(feature = "NSData")]
        #[method_id(@__retain_semantics Other dataUsingEncoding:allowLossyConversion:)]
        pub unsafe fn dataUsingEncoding_allowLossyConversion(
            &self,
            encoding: NSStringEncoding,
            lossy: bool,
        ) -> Option<Retained<NSData>>;

        #[cfg(feature = "NSData")]
        #[method_id(@__retain_semantics Other dataUsingEncoding:)]
        pub unsafe fn dataUsingEncoding(
            &self,
            encoding: NSStringEncoding,
        ) -> Option<Retained<NSData>>;

        #[method(canBeConvertedToEncoding:)]
        pub unsafe fn canBeConvertedToEncoding(&self, encoding: NSStringEncoding) -> bool;

        #[method(cStringUsingEncoding:)]
        pub unsafe fn cStringUsingEncoding(&self, encoding: NSStringEncoding) -> *mut c_char;

        #[method(getCString:maxLength:encoding:)]
        pub unsafe fn getCString_maxLength_encoding(
            &self,
            buffer: NonNull<c_char>,
            max_buffer_count: NSUInteger,
            encoding: NSStringEncoding,
        ) -> bool;

        #[cfg(feature = "NSRange")]
        #[method(getBytes:maxLength:usedLength:encoding:options:range:remainingRange:)]
        pub unsafe fn getBytes_maxLength_usedLength_encoding_options_range_remainingRange(
            &self,
            buffer: *mut c_void,
            max_buffer_count: NSUInteger,
            used_buffer_count: *mut NSUInteger,
            encoding: NSStringEncoding,
            options: NSStringEncodingConversionOptions,
            range: NSRange,
            leftover: NSRangePointer,
        ) -> bool;

        #[method(maximumLengthOfBytesUsingEncoding:)]
        pub unsafe fn maximumLengthOfBytesUsingEncoding(&self, enc: NSStringEncoding)
            -> NSUInteger;

        #[method(lengthOfBytesUsingEncoding:)]
        pub fn lengthOfBytesUsingEncoding(&self, enc: NSStringEncoding) -> NSUInteger;

        #[method(availableStringEncodings)]
        pub unsafe fn availableStringEncodings() -> NonNull<NSStringEncoding>;

        #[method_id(@__retain_semantics Other localizedNameOfStringEncoding:)]
        pub unsafe fn localizedNameOfStringEncoding(
            encoding: NSStringEncoding,
        ) -> Retained<NSString>;

        #[method(defaultCStringEncoding)]
        pub unsafe fn defaultCStringEncoding() -> NSStringEncoding;

        #[method_id(@__retain_semantics Other decomposedStringWithCanonicalMapping)]
        pub unsafe fn decomposedStringWithCanonicalMapping(&self) -> Retained<NSString>;

        #[method_id(@__retain_semantics Other precomposedStringWithCanonicalMapping)]
        pub unsafe fn precomposedStringWithCanonicalMapping(&self) -> Retained<NSString>;

        #[method_id(@__retain_semantics Other decomposedStringWithCompatibilityMapping)]
        pub unsafe fn decomposedStringWithCompatibilityMapping(&self) -> Retained<NSString>;

        #[method_id(@__retain_semantics Other precomposedStringWithCompatibilityMapping)]
        pub unsafe fn precomposedStringWithCompatibilityMapping(&self) -> Retained<NSString>;

        #[cfg(feature = "NSArray")]
        #[method_id(@__retain_semantics Other componentsSeparatedByString:)]
        pub unsafe fn componentsSeparatedByString(
            &self,
            separator: &NSString,
        ) -> Retained<NSArray<NSString>>;

        #[cfg(all(feature = "NSArray", feature = "NSCharacterSet"))]
        #[method_id(@__retain_semantics Other componentsSeparatedByCharactersInSet:)]
        pub unsafe fn componentsSeparatedByCharactersInSet(
            &self,
            separator: &NSCharacterSet,
        ) -> Retained<NSArray<NSString>>;

        #[cfg(feature = "NSCharacterSet")]
        #[method_id(@__retain_semantics Other stringByTrimmingCharactersInSet:)]
        pub unsafe fn stringByTrimmingCharactersInSet(
            &self,
            set: &NSCharacterSet,
        ) -> Retained<NSString>;

        #[method_id(@__retain_semantics Other stringByPaddingToLength:withString:startingAtIndex:)]
        pub unsafe fn stringByPaddingToLength_withString_startingAtIndex(
            &self,
            new_length: NSUInteger,
            pad_string: &NSString,
            pad_index: NSUInteger,
        ) -> Retained<NSString>;

        #[cfg(feature = "NSLocale")]
        #[method_id(@__retain_semantics Other stringByFoldingWithOptions:locale:)]
        pub unsafe fn stringByFoldingWithOptions_locale(
            &self,
            options: NSStringCompareOptions,
            locale: Option<&NSLocale>,
        ) -> Retained<NSString>;

        #[cfg(feature = "NSRange")]
        #[method_id(@__retain_semantics Other stringByReplacingOccurrencesOfString:withString:options:range:)]
        pub unsafe fn stringByReplacingOccurrencesOfString_withString_options_range(
            &self,
            target: &NSString,
            replacement: &NSString,
            options: NSStringCompareOptions,
            search_range: NSRange,
        ) -> Retained<NSString>;

        #[method_id(@__retain_semantics Other stringByReplacingOccurrencesOfString:withString:)]
        pub unsafe fn stringByReplacingOccurrencesOfString_withString(
            &self,
            target: &NSString,
            replacement: &NSString,
        ) -> Retained<NSString>;

        #[cfg(feature = "NSRange")]
        #[method_id(@__retain_semantics Other stringByReplacingCharactersInRange:withString:)]
        pub unsafe fn stringByReplacingCharactersInRange_withString(
            &self,
            range: NSRange,
            replacement: &NSString,
        ) -> Retained<NSString>;

        #[method_id(@__retain_semantics Other stringByApplyingTransform:reverse:)]
        pub unsafe fn stringByApplyingTransform_reverse(
            &self,
            transform: &NSStringTransform,
            reverse: bool,
        ) -> Option<Retained<NSString>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[method(writeToURL:atomically:encoding:error:_)]
        pub unsafe fn writeToURL_atomically_encoding_error(
            &self,
            url: &NSURL,
            use_auxiliary_file: bool,
            enc: NSStringEncoding,
        ) -> Result<(), Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[method(writeToFile:atomically:encoding:error:_)]
        pub unsafe fn writeToFile_atomically_encoding_error(
            &self,
            path: &NSString,
            use_auxiliary_file: bool,
            enc: NSStringEncoding,
        ) -> Result<(), Retained<NSError>>;

        #[method_id(@__retain_semantics Other description)]
        pub unsafe fn description(&self) -> Retained<NSString>;

        #[method(hash)]
        pub unsafe fn hash(&self) -> NSUInteger;

        #[method_id(@__retain_semantics Init initWithCharactersNoCopy:length:freeWhenDone:)]
        pub unsafe fn initWithCharactersNoCopy_length_freeWhenDone(
            this: Allocated<Self>,
            characters: NonNull<unichar>,
            length: NSUInteger,
            free_buffer: bool,
        ) -> Retained<Self>;

        #[cfg(feature = "block2")]
        #[method_id(@__retain_semantics Init initWithCharactersNoCopy:length:deallocator:)]
        pub unsafe fn initWithCharactersNoCopy_length_deallocator(
            this: Allocated<Self>,
            chars: NonNull<unichar>,
            len: NSUInteger,
            deallocator: Option<&block2::Block<dyn Fn(NonNull<unichar>, NSUInteger)>>,
        ) -> Retained<Self>;

        #[method_id(@__retain_semantics Init initWithCharacters:length:)]
        pub unsafe fn initWithCharacters_length(
            this: Allocated<Self>,
            characters: NonNull<unichar>,
            length: NSUInteger,
        ) -> Retained<Self>;

        #[method_id(@__retain_semantics Init initWithUTF8String:)]
        pub unsafe fn initWithUTF8String(
            this: Allocated<Self>,
            null_terminated_c_string: NonNull<c_char>,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Init initWithString:)]
        pub fn initWithString(this: Allocated<Self>, a_string: &NSString) -> Retained<Self>;

        #[cfg(feature = "NSData")]
        #[method_id(@__retain_semantics Init initWithData:encoding:)]
        pub unsafe fn initWithData_encoding(
            this: Allocated<Self>,
            data: &NSData,
            encoding: NSStringEncoding,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Init initWithBytes:length:encoding:)]
        pub unsafe fn initWithBytes_length_encoding(
            this: Allocated<Self>,
            bytes: NonNull<c_void>,
            len: NSUInteger,
            encoding: NSStringEncoding,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Init initWithBytesNoCopy:length:encoding:freeWhenDone:)]
        pub unsafe fn initWithBytesNoCopy_length_encoding_freeWhenDone(
            this: Allocated<Self>,
            bytes: NonNull<c_void>,
            len: NSUInteger,
            encoding: NSStringEncoding,
            free_buffer: bool,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "block2")]
        #[method_id(@__retain_semantics Init initWithBytesNoCopy:length:encoding:deallocator:)]
        pub unsafe fn initWithBytesNoCopy_length_encoding_deallocator(
            this: Allocated<Self>,
            bytes: NonNull<c_void>,
            len: NSUInteger,
            encoding: NSStringEncoding,
            deallocator: Option<&block2::Block<dyn Fn(NonNull<c_void>, NSUInteger)>>,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Other string)]
        pub unsafe fn string() -> Retained<Self>;

        #[method_id(@__retain_semantics Other stringWithString:)]
        pub fn stringWithString(string: &NSString) -> Retained<Self>;

        #[method_id(@__retain_semantics Other stringWithCharacters:length:)]
        pub unsafe fn stringWithCharacters_length(
            characters: NonNull<unichar>,
            length: NSUInteger,
        ) -> Retained<Self>;

        #[method_id(@__retain_semantics Other stringWithUTF8String:)]
        pub unsafe fn stringWithUTF8String(
            null_terminated_c_string: NonNull<c_char>,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Init initWithCString:encoding:)]
        pub unsafe fn initWithCString_encoding(
            this: Allocated<Self>,
            null_terminated_c_string: NonNull<c_char>,
            encoding: NSStringEncoding,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Other stringWithCString:encoding:)]
        pub unsafe fn stringWithCString_encoding(
            c_string: NonNull<c_char>,
            enc: NSStringEncoding,
        ) -> Option<Retained<Self>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[method_id(@__retain_semantics Init initWithContentsOfURL:encoding:error:_)]
        pub unsafe fn initWithContentsOfURL_encoding_error(
            this: Allocated<Self>,
            url: &NSURL,
            enc: NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[method_id(@__retain_semantics Init initWithContentsOfFile:encoding:error:_)]
        pub unsafe fn initWithContentsOfFile_encoding_error(
            this: Allocated<Self>,
            path: &NSString,
            enc: NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[method_id(@__retain_semantics Other stringWithContentsOfURL:encoding:error:_)]
        pub unsafe fn stringWithContentsOfURL_encoding_error(
            url: &NSURL,
            enc: NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[method_id(@__retain_semantics Other stringWithContentsOfFile:encoding:error:_)]
        pub unsafe fn stringWithContentsOfFile_encoding_error(
            path: &NSString,
            enc: NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[method_id(@__retain_semantics Init initWithContentsOfURL:usedEncoding:error:_)]
        pub unsafe fn initWithContentsOfURL_usedEncoding_error(
            this: Allocated<Self>,
            url: &NSURL,
            enc: *mut NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[method_id(@__retain_semantics Init initWithContentsOfFile:usedEncoding:error:_)]
        pub unsafe fn initWithContentsOfFile_usedEncoding_error(
            this: Allocated<Self>,
            path: &NSString,
            enc: *mut NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[method_id(@__retain_semantics Other stringWithContentsOfURL:usedEncoding:error:_)]
        pub unsafe fn stringWithContentsOfURL_usedEncoding_error(
            url: &NSURL,
            enc: *mut NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[method_id(@__retain_semantics Other stringWithContentsOfFile:usedEncoding:error:_)]
        pub unsafe fn stringWithContentsOfFile_usedEncoding_error(
            path: &NSString,
            enc: *mut NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSString`
    ///
    /// NSStringExtensionMethods
    unsafe impl NSMutableString {
        #[method_id(@__retain_semantics Init initWithCharactersNoCopy:length:freeWhenDone:)]
        pub unsafe fn initWithCharactersNoCopy_length_freeWhenDone(
            this: Allocated<Self>,
            characters: NonNull<unichar>,
            length: NSUInteger,
            free_buffer: bool,
        ) -> Retained<Self>;

        #[cfg(feature = "block2")]
        #[method_id(@__retain_semantics Init initWithCharactersNoCopy:length:deallocator:)]
        pub unsafe fn initWithCharactersNoCopy_length_deallocator(
            this: Allocated<Self>,
            chars: NonNull<unichar>,
            len: NSUInteger,
            deallocator: Option<&block2::Block<dyn Fn(NonNull<unichar>, NSUInteger)>>,
        ) -> Retained<Self>;

        #[method_id(@__retain_semantics Init initWithCharacters:length:)]
        pub unsafe fn initWithCharacters_length(
            this: Allocated<Self>,
            characters: NonNull<unichar>,
            length: NSUInteger,
        ) -> Retained<Self>;

        #[method_id(@__retain_semantics Init initWithUTF8String:)]
        pub unsafe fn initWithUTF8String(
            this: Allocated<Self>,
            null_terminated_c_string: NonNull<c_char>,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Init initWithString:)]
        pub fn initWithString(this: Allocated<Self>, a_string: &NSString) -> Retained<Self>;

        #[cfg(feature = "NSData")]
        #[method_id(@__retain_semantics Init initWithData:encoding:)]
        pub unsafe fn initWithData_encoding(
            this: Allocated<Self>,
            data: &NSData,
            encoding: NSStringEncoding,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Init initWithBytes:length:encoding:)]
        pub unsafe fn initWithBytes_length_encoding(
            this: Allocated<Self>,
            bytes: NonNull<c_void>,
            len: NSUInteger,
            encoding: NSStringEncoding,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Init initWithBytesNoCopy:length:encoding:freeWhenDone:)]
        pub unsafe fn initWithBytesNoCopy_length_encoding_freeWhenDone(
            this: Allocated<Self>,
            bytes: NonNull<c_void>,
            len: NSUInteger,
            encoding: NSStringEncoding,
            free_buffer: bool,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "block2")]
        #[method_id(@__retain_semantics Init initWithBytesNoCopy:length:encoding:deallocator:)]
        pub unsafe fn initWithBytesNoCopy_length_encoding_deallocator(
            this: Allocated<Self>,
            bytes: NonNull<c_void>,
            len: NSUInteger,
            encoding: NSStringEncoding,
            deallocator: Option<&block2::Block<dyn Fn(NonNull<c_void>, NSUInteger)>>,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Other string)]
        pub unsafe fn string() -> Retained<Self>;

        #[method_id(@__retain_semantics Other stringWithString:)]
        pub fn stringWithString(string: &NSString) -> Retained<Self>;

        #[method_id(@__retain_semantics Other stringWithCharacters:length:)]
        pub unsafe fn stringWithCharacters_length(
            characters: NonNull<unichar>,
            length: NSUInteger,
        ) -> Retained<Self>;

        #[method_id(@__retain_semantics Other stringWithUTF8String:)]
        pub unsafe fn stringWithUTF8String(
            null_terminated_c_string: NonNull<c_char>,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Init initWithCString:encoding:)]
        pub unsafe fn initWithCString_encoding(
            this: Allocated<Self>,
            null_terminated_c_string: NonNull<c_char>,
            encoding: NSStringEncoding,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Other stringWithCString:encoding:)]
        pub unsafe fn stringWithCString_encoding(
            c_string: NonNull<c_char>,
            enc: NSStringEncoding,
        ) -> Option<Retained<Self>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[method_id(@__retain_semantics Init initWithContentsOfURL:encoding:error:_)]
        pub unsafe fn initWithContentsOfURL_encoding_error(
            this: Allocated<Self>,
            url: &NSURL,
            enc: NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[method_id(@__retain_semantics Init initWithContentsOfFile:encoding:error:_)]
        pub unsafe fn initWithContentsOfFile_encoding_error(
            this: Allocated<Self>,
            path: &NSString,
            enc: NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[method_id(@__retain_semantics Other stringWithContentsOfURL:encoding:error:_)]
        pub unsafe fn stringWithContentsOfURL_encoding_error(
            url: &NSURL,
            enc: NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[method_id(@__retain_semantics Other stringWithContentsOfFile:encoding:error:_)]
        pub unsafe fn stringWithContentsOfFile_encoding_error(
            path: &NSString,
            enc: NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[method_id(@__retain_semantics Init initWithContentsOfURL:usedEncoding:error:_)]
        pub unsafe fn initWithContentsOfURL_usedEncoding_error(
            this: Allocated<Self>,
            url: &NSURL,
            enc: *mut NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[method_id(@__retain_semantics Init initWithContentsOfFile:usedEncoding:error:_)]
        pub unsafe fn initWithContentsOfFile_usedEncoding_error(
            this: Allocated<Self>,
            path: &NSString,
            enc: *mut NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(all(feature = "NSError", feature = "NSURL"))]
        #[method_id(@__retain_semantics Other stringWithContentsOfURL:usedEncoding:error:_)]
        pub unsafe fn stringWithContentsOfURL_usedEncoding_error(
            url: &NSURL,
            enc: *mut NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSError")]
        #[method_id(@__retain_semantics Other stringWithContentsOfFile:usedEncoding:error:_)]
        pub unsafe fn stringWithContentsOfFile_usedEncoding_error(
            path: &NSString,
            enc: *mut NSStringEncoding,
        ) -> Result<Retained<Self>, Retained<NSError>>;
    }
);

// NS_TYPED_ENUM
pub type NSStringEncodingDetectionOptionsKey = NSString;

extern "C" {
    pub static NSStringEncodingDetectionSuggestedEncodingsKey:
        &'static NSStringEncodingDetectionOptionsKey;
}

extern "C" {
    pub static NSStringEncodingDetectionDisallowedEncodingsKey:
        &'static NSStringEncodingDetectionOptionsKey;
}

extern "C" {
    pub static NSStringEncodingDetectionUseOnlySuggestedEncodingsKey:
        &'static NSStringEncodingDetectionOptionsKey;
}

extern "C" {
    pub static NSStringEncodingDetectionAllowLossyKey: &'static NSStringEncodingDetectionOptionsKey;
}

extern "C" {
    pub static NSStringEncodingDetectionFromWindowsKey:
        &'static NSStringEncodingDetectionOptionsKey;
}

extern "C" {
    pub static NSStringEncodingDetectionLossySubstitutionKey:
        &'static NSStringEncodingDetectionOptionsKey;
}

extern "C" {
    pub static NSStringEncodingDetectionLikelyLanguageKey:
        &'static NSStringEncodingDetectionOptionsKey;
}

extern_methods!(
    /// NSStringEncodingDetection
    unsafe impl NSString {
        #[cfg(all(feature = "NSData", feature = "NSDictionary"))]
        #[method(stringEncodingForData:encodingOptions:convertedString:usedLossyConversion:)]
        pub unsafe fn stringEncodingForData_encodingOptions_convertedString_usedLossyConversion(
            data: &NSData,
            opts: Option<&NSDictionary<NSStringEncodingDetectionOptionsKey, AnyObject>>,
            string: Option<&mut Option<Retained<NSString>>>,
            used_lossy_conversion: *mut Bool,
        ) -> NSStringEncoding;
    }
);

extern_methods!(
    /// NSItemProvider
    unsafe impl NSString {}
);

#[cfg(feature = "NSItemProvider")]
unsafe impl NSItemProviderReading for NSString {}

#[cfg(feature = "NSItemProvider")]
unsafe impl NSItemProviderWriting for NSString {}

extern_class!(
    #[derive(PartialEq, Eq, Hash)]
    pub struct NSMutableString;

    unsafe impl ClassType for NSMutableString {
        #[inherits(NSObject)]
        type Super = NSString;
        type Mutability = MutableWithImmutableSuperclass<NSString>;
    }
);

#[cfg(feature = "NSObject")]
unsafe impl NSCoding for NSMutableString {}

#[cfg(feature = "NSObject")]
unsafe impl NSCopying for NSMutableString {}

#[cfg(feature = "NSObject")]
unsafe impl NSMutableCopying for NSMutableString {}

unsafe impl NSObjectProtocol for NSMutableString {}

#[cfg(feature = "NSObject")]
unsafe impl NSSecureCoding for NSMutableString {}

extern_methods!(
    unsafe impl NSMutableString {
        #[cfg(feature = "NSRange")]
        #[method(replaceCharactersInRange:withString:)]
        pub unsafe fn replaceCharactersInRange_withString(
            &mut self,
            range: NSRange,
            a_string: &NSString,
        );
    }
);

extern_methods!(
    /// Methods declared on superclass `NSString`
    unsafe impl NSMutableString {
        #[method_id(@__retain_semantics Init init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "NSCoder")]
        #[method_id(@__retain_semantics Init initWithCoder:)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl NSMutableString {
        #[method_id(@__retain_semantics New new)]
        pub fn new() -> Retained<Self>;
    }
);

impl DefaultRetained for NSMutableString {
    #[inline]
    fn default_id() -> Retained<Self> {
        Self::new()
    }
}

extern_methods!(
    /// NSMutableStringExtensionMethods
    unsafe impl NSMutableString {
        #[method(insertString:atIndex:)]
        pub unsafe fn insertString_atIndex(&mut self, a_string: &NSString, loc: NSUInteger);

        #[cfg(feature = "NSRange")]
        #[method(deleteCharactersInRange:)]
        pub unsafe fn deleteCharactersInRange(&mut self, range: NSRange);

        #[method(appendString:)]
        pub fn appendString(&mut self, a_string: &NSString);

        #[method(setString:)]
        pub fn setString(&mut self, a_string: &NSString);

        #[cfg(feature = "NSRange")]
        #[method(replaceOccurrencesOfString:withString:options:range:)]
        pub unsafe fn replaceOccurrencesOfString_withString_options_range(
            &mut self,
            target: &NSString,
            replacement: &NSString,
            options: NSStringCompareOptions,
            search_range: NSRange,
        ) -> NSUInteger;

        #[cfg(feature = "NSRange")]
        #[method(applyTransform:reverse:range:updatedRange:)]
        pub unsafe fn applyTransform_reverse_range_updatedRange(
            &mut self,
            transform: &NSStringTransform,
            reverse: bool,
            range: NSRange,
            resulting_range: NSRangePointer,
        ) -> bool;

        #[method_id(@__retain_semantics Init initWithCapacity:)]
        pub fn initWithCapacity(
            this: Allocated<Self>,
            capacity: NSUInteger,
        ) -> Retained<NSMutableString>;

        #[method_id(@__retain_semantics Other stringWithCapacity:)]
        pub fn stringWithCapacity(capacity: NSUInteger) -> Retained<NSMutableString>;
    }
);

extern "C" {
    #[cfg(feature = "NSObjCRuntime")]
    pub static NSCharacterConversionException: &'static NSExceptionName;
}

extern "C" {
    #[cfg(feature = "NSObjCRuntime")]
    pub static NSParseErrorException: &'static NSExceptionName;
}

extern_methods!(
    /// NSExtendedStringPropertyListParsing
    unsafe impl NSString {
        #[method_id(@__retain_semantics Other propertyList)]
        pub unsafe fn propertyList(&self) -> Retained<AnyObject>;

        #[cfg(feature = "NSDictionary")]
        #[method_id(@__retain_semantics Other propertyListFromStringsFileFormat)]
        pub unsafe fn propertyListFromStringsFileFormat(&self) -> Option<Retained<NSDictionary>>;
    }
);

extern_methods!(
    /// NSStringDeprecated
    unsafe impl NSString {
        #[deprecated = "Use -cStringUsingEncoding: instead"]
        #[method(cString)]
        pub unsafe fn cString(&self) -> *mut c_char;

        #[deprecated = "Use -cStringUsingEncoding: instead"]
        #[method(lossyCString)]
        pub unsafe fn lossyCString(&self) -> *mut c_char;

        #[deprecated = "Use -lengthOfBytesUsingEncoding: instead"]
        #[method(cStringLength)]
        pub unsafe fn cStringLength(&self) -> NSUInteger;

        #[deprecated = "Use -getCString:maxLength:encoding: instead"]
        #[method(getCString:)]
        pub unsafe fn getCString(&self, bytes: NonNull<c_char>);

        #[deprecated = "Use -getCString:maxLength:encoding: instead"]
        #[method(getCString:maxLength:)]
        pub unsafe fn getCString_maxLength(&self, bytes: NonNull<c_char>, max_length: NSUInteger);

        #[cfg(feature = "NSRange")]
        #[deprecated = "Use -getCString:maxLength:encoding: instead"]
        #[method(getCString:maxLength:range:remainingRange:)]
        pub unsafe fn getCString_maxLength_range_remainingRange(
            &self,
            bytes: NonNull<c_char>,
            max_length: NSUInteger,
            a_range: NSRange,
            leftover_range: NSRangePointer,
        );

        #[deprecated = "Use -writeToFile:atomically:encoding:error: instead"]
        #[method(writeToFile:atomically:)]
        pub unsafe fn writeToFile_atomically(
            &self,
            path: &NSString,
            use_auxiliary_file: bool,
        ) -> bool;

        #[cfg(feature = "NSURL")]
        #[deprecated = "Use -writeToURL:atomically:encoding:error: instead"]
        #[method(writeToURL:atomically:)]
        pub unsafe fn writeToURL_atomically(&self, url: &NSURL, atomically: bool) -> bool;

        #[deprecated = "Use -initWithContentsOfFile:encoding:error: instead"]
        #[method_id(@__retain_semantics Init initWithContentsOfFile:)]
        pub unsafe fn initWithContentsOfFile(
            this: Allocated<Self>,
            path: &NSString,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSURL")]
        #[deprecated = "Use -initWithContentsOfURL:encoding:error: instead"]
        #[method_id(@__retain_semantics Init initWithContentsOfURL:)]
        pub unsafe fn initWithContentsOfURL(
            this: Allocated<Self>,
            url: &NSURL,
        ) -> Option<Retained<Self>>;

        #[deprecated = "Use +stringWithContentsOfFile:encoding:error: instead"]
        #[method_id(@__retain_semantics Other stringWithContentsOfFile:)]
        pub unsafe fn stringWithContentsOfFile(path: &NSString) -> Option<Retained<AnyObject>>;

        #[cfg(feature = "NSURL")]
        #[deprecated = "Use +stringWithContentsOfURL:encoding:error: instead"]
        #[method_id(@__retain_semantics Other stringWithContentsOfURL:)]
        pub unsafe fn stringWithContentsOfURL(url: &NSURL) -> Option<Retained<AnyObject>>;

        #[deprecated = "Use -initWithCString:encoding: instead"]
        #[method_id(@__retain_semantics Init initWithCStringNoCopy:length:freeWhenDone:)]
        pub unsafe fn initWithCStringNoCopy_length_freeWhenDone(
            this: Allocated<Self>,
            bytes: NonNull<c_char>,
            length: NSUInteger,
            free_buffer: bool,
        ) -> Option<Retained<Self>>;

        #[deprecated = "Use -initWithCString:encoding: instead"]
        #[method_id(@__retain_semantics Init initWithCString:length:)]
        pub unsafe fn initWithCString_length(
            this: Allocated<Self>,
            bytes: NonNull<c_char>,
            length: NSUInteger,
        ) -> Option<Retained<Self>>;

        #[deprecated = "Use -initWithCString:encoding: instead"]
        #[method_id(@__retain_semantics Init initWithCString:)]
        pub unsafe fn initWithCString(
            this: Allocated<Self>,
            bytes: NonNull<c_char>,
        ) -> Option<Retained<Self>>;

        #[deprecated = "Use +stringWithCString:encoding:"]
        #[method_id(@__retain_semantics Other stringWithCString:length:)]
        pub unsafe fn stringWithCString_length(
            bytes: NonNull<c_char>,
            length: NSUInteger,
        ) -> Option<Retained<AnyObject>>;

        #[deprecated = "Use +stringWithCString:encoding: instead"]
        #[method_id(@__retain_semantics Other stringWithCString:)]
        pub unsafe fn stringWithCString(bytes: NonNull<c_char>) -> Option<Retained<AnyObject>>;

        #[method(getCharacters:)]
        pub unsafe fn getCharacters(&self, buffer: NonNull<unichar>);
    }
);

extern_methods!(
    /// Methods declared on superclass `NSString`
    ///
    /// NSStringDeprecated
    unsafe impl NSMutableString {
        #[deprecated = "Use -initWithContentsOfFile:encoding:error: instead"]
        #[method_id(@__retain_semantics Init initWithContentsOfFile:)]
        pub unsafe fn initWithContentsOfFile(
            this: Allocated<Self>,
            path: &NSString,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSURL")]
        #[deprecated = "Use -initWithContentsOfURL:encoding:error: instead"]
        #[method_id(@__retain_semantics Init initWithContentsOfURL:)]
        pub unsafe fn initWithContentsOfURL(
            this: Allocated<Self>,
            url: &NSURL,
        ) -> Option<Retained<Self>>;

        #[deprecated = "Use -initWithCString:encoding: instead"]
        #[method_id(@__retain_semantics Init initWithCStringNoCopy:length:freeWhenDone:)]
        pub unsafe fn initWithCStringNoCopy_length_freeWhenDone(
            this: Allocated<Self>,
            bytes: NonNull<c_char>,
            length: NSUInteger,
            free_buffer: bool,
        ) -> Option<Retained<Self>>;

        #[deprecated = "Use -initWithCString:encoding: instead"]
        #[method_id(@__retain_semantics Init initWithCString:length:)]
        pub unsafe fn initWithCString_length(
            this: Allocated<Self>,
            bytes: NonNull<c_char>,
            length: NSUInteger,
        ) -> Option<Retained<Self>>;

        #[deprecated = "Use -initWithCString:encoding: instead"]
        #[method_id(@__retain_semantics Init initWithCString:)]
        pub unsafe fn initWithCString(
            this: Allocated<Self>,
            bytes: NonNull<c_char>,
        ) -> Option<Retained<Self>>;
    }
);

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSSimpleCString;

    unsafe impl ClassType for NSSimpleCString {
        #[inherits(NSObject)]
        type Super = NSString;
        type Mutability = Immutable;
    }
);

#[cfg(feature = "NSObject")]
unsafe impl NSCoding for NSSimpleCString {}

unsafe impl NSObjectProtocol for NSSimpleCString {}

#[cfg(feature = "NSObject")]
unsafe impl NSSecureCoding for NSSimpleCString {}

extern_methods!(
    unsafe impl NSSimpleCString {}
);

extern_methods!(
    /// Methods declared on superclass `NSString`
    unsafe impl NSSimpleCString {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "NSCoder")]
        #[method_id(@__retain_semantics Init initWithCoder:)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl NSSimpleCString {
        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSConstantString;

    unsafe impl ClassType for NSConstantString {
        #[inherits(NSString, NSObject)]
        type Super = NSSimpleCString;
        type Mutability = Immutable;
    }
);

#[cfg(feature = "NSObject")]
unsafe impl NSCoding for NSConstantString {}

unsafe impl NSObjectProtocol for NSConstantString {}

#[cfg(feature = "NSObject")]
unsafe impl NSSecureCoding for NSConstantString {}

extern_methods!(
    unsafe impl NSConstantString {}
);

extern_methods!(
    /// Methods declared on superclass `NSString`
    unsafe impl NSConstantString {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "NSCoder")]
        #[method_id(@__retain_semantics Init initWithCoder:)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl NSConstantString {
        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);
