## RabbitMQ 3.8.23

RabbitMQ `3.8.23` is a maintenance release.
All users are recommended to upgrade to this release.

### Obtaining Packages

RabbitMQ releases are distributed via [GitHub](https://github.com/rabbitmq/rabbitmq-server/releases), [Cloudsmith](https://cloudsmith.io/~rabbitmq/repos/),
and [PackageCloud](https://packagecloud.io/rabbitmq).

### Erlang/OTP Compatibility Notes

This release [requires Erlang 23.2](https://www.rabbitmq.com/which-erlang.html) and [supports Erlang 24](https://blog.rabbitmq.com/posts/2021/03/erlang-24-support-roadmap/).

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision modern Erlang versions.


## Upgrade and Compatibility Notes

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

If upgrading from a`3.7.x` release, see [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0)
upgrade and compatibility notes first.

If upgrading from a `3.6.x` or older [release series](https://www.rabbitmq.com/versions.html), first upgrade
to [`3.7.27`](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.27) and then to this version.


## Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users)
and [RabbitMQ community Slack](https://rabbitmq-slack.herokuapp.com/).


## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.8.x/release-notes).
Contributors are encouraged to update them together with their changes.  This helps with release automation and more
consistent release schedule.


### Core Server

#### Bug Fixes

 * TLS information delivered in [Proxy protocol](https://www.rabbitmq.com/networking.html#proxy-protocol) header is now attached to connection metrics as if it was provided by a non-proxying client.

   GitHub issue: [#3175](https://github.com/rabbitmq/rabbitmq-server/pull/3175) contributed by @prefiks, sponsored by CloudAMQP

 * Classic queue shutdown now uses a much higher timeout (up to 10 minutes instead of 30 seconds).

   In environments with many queues (especially mirrored queues) and many consumers this means that
   the chance of queue indices rebuilding after node restart is now substantially lower.

   GitHub issue: [#3409](https://github.com/rabbitmq/rabbitmq-server/pull/3409)

* Quorum queues no longer leak memory and disk space when a consumer is repeatedly added and cancelled on an empty queue.

   GitHub issue: [#3445](https://github.com/rabbitmq/rabbitmq-server/issues/3445)


## Dependency Upgrades

 * observer_cli has been upgraded from `1.6.2` to `1.7.1`


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.8.23.tar.xz`
instead of the source tarball produced by GitHub.
