// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package recorder

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// GetRecorderIDReader is a Reader for the GetRecorderID structure.
type GetRecorderIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetRecorderIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetRecorderIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewGetRecorderIDNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /recorder/{id}] GetRecorderID", response, response.Code())
	}
}

// NewGetRecorderIDOK creates a GetRecorderIDOK with default headers values
func NewGetRecorderIDOK() *GetRecorderIDOK {
	return &GetRecorderIDOK{}
}

/*
GetRecorderIDOK describes a response with status code 200, with default header values.

Success
*/
type GetRecorderIDOK struct {
	Payload *models.Recorder
}

// IsSuccess returns true when this get recorder Id o k response has a 2xx status code
func (o *GetRecorderIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get recorder Id o k response has a 3xx status code
func (o *GetRecorderIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get recorder Id o k response has a 4xx status code
func (o *GetRecorderIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get recorder Id o k response has a 5xx status code
func (o *GetRecorderIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get recorder Id o k response a status code equal to that given
func (o *GetRecorderIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get recorder Id o k response
func (o *GetRecorderIDOK) Code() int {
	return 200
}

func (o *GetRecorderIDOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /recorder/{id}][%d] getRecorderIdOK %s", 200, payload)
}

func (o *GetRecorderIDOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /recorder/{id}][%d] getRecorderIdOK %s", 200, payload)
}

func (o *GetRecorderIDOK) GetPayload() *models.Recorder {
	return o.Payload
}

func (o *GetRecorderIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Recorder)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetRecorderIDNotFound creates a GetRecorderIDNotFound with default headers values
func NewGetRecorderIDNotFound() *GetRecorderIDNotFound {
	return &GetRecorderIDNotFound{}
}

/*
GetRecorderIDNotFound describes a response with status code 404, with default header values.

Recorder not found
*/
type GetRecorderIDNotFound struct {
}

// IsSuccess returns true when this get recorder Id not found response has a 2xx status code
func (o *GetRecorderIDNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get recorder Id not found response has a 3xx status code
func (o *GetRecorderIDNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get recorder Id not found response has a 4xx status code
func (o *GetRecorderIDNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get recorder Id not found response has a 5xx status code
func (o *GetRecorderIDNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get recorder Id not found response a status code equal to that given
func (o *GetRecorderIDNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get recorder Id not found response
func (o *GetRecorderIDNotFound) Code() int {
	return 404
}

func (o *GetRecorderIDNotFound) Error() string {
	return fmt.Sprintf("[GET /recorder/{id}][%d] getRecorderIdNotFound", 404)
}

func (o *GetRecorderIDNotFound) String() string {
	return fmt.Sprintf("[GET /recorder/{id}][%d] getRecorderIdNotFound", 404)
}

func (o *GetRecorderIDNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}
