// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_error_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllHTTPErrorRuleFrontendOKCode is the HTTP code returned for type GetAllHTTPErrorRuleFrontendOK
const GetAllHTTPErrorRuleFrontendOKCode int = 200

/*
GetAllHTTPErrorRuleFrontendOK Successful operation

swagger:response getAllHttpErrorRuleFrontendOK
*/
type GetAllHTTPErrorRuleFrontendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.HTTPErrorRules `json:"body,omitempty"`
}

// NewGetAllHTTPErrorRuleFrontendOK creates GetAllHTTPErrorRuleFrontendOK with default headers values
func NewGetAllHTTPErrorRuleFrontendOK() *GetAllHTTPErrorRuleFrontendOK {

	return &GetAllHTTPErrorRuleFrontendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all Http error rule frontend o k response
func (o *GetAllHTTPErrorRuleFrontendOK) WithConfigurationVersion(configurationVersion string) *GetAllHTTPErrorRuleFrontendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all Http error rule frontend o k response
func (o *GetAllHTTPErrorRuleFrontendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all Http error rule frontend o k response
func (o *GetAllHTTPErrorRuleFrontendOK) WithPayload(payload models.HTTPErrorRules) *GetAllHTTPErrorRuleFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all Http error rule frontend o k response
func (o *GetAllHTTPErrorRuleFrontendOK) SetPayload(payload models.HTTPErrorRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllHTTPErrorRuleFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPErrorRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllHTTPErrorRuleFrontendDefault General Error

swagger:response getAllHttpErrorRuleFrontendDefault
*/
type GetAllHTTPErrorRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllHTTPErrorRuleFrontendDefault creates GetAllHTTPErrorRuleFrontendDefault with default headers values
func NewGetAllHTTPErrorRuleFrontendDefault(code int) *GetAllHTTPErrorRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllHTTPErrorRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all HTTP error rule frontend default response
func (o *GetAllHTTPErrorRuleFrontendDefault) WithStatusCode(code int) *GetAllHTTPErrorRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all HTTP error rule frontend default response
func (o *GetAllHTTPErrorRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all HTTP error rule frontend default response
func (o *GetAllHTTPErrorRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *GetAllHTTPErrorRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all HTTP error rule frontend default response
func (o *GetAllHTTPErrorRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all HTTP error rule frontend default response
func (o *GetAllHTTPErrorRuleFrontendDefault) WithPayload(payload *models.Error) *GetAllHTTPErrorRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all HTTP error rule frontend default response
func (o *GetAllHTTPErrorRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllHTTPErrorRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
