// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateHTTPResponseRuleFrontendCreatedCode is the HTTP code returned for type CreateHTTPResponseRuleFrontendCreated
const CreateHTTPResponseRuleFrontendCreatedCode int = 201

/*
CreateHTTPResponseRuleFrontendCreated HTTP Response Rule created

swagger:response createHttpResponseRuleFrontendCreated
*/
type CreateHTTPResponseRuleFrontendCreated struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPResponseRule `json:"body,omitempty"`
}

// NewCreateHTTPResponseRuleFrontendCreated creates CreateHTTPResponseRuleFrontendCreated with default headers values
func NewCreateHTTPResponseRuleFrontendCreated() *CreateHTTPResponseRuleFrontendCreated {

	return &CreateHTTPResponseRuleFrontendCreated{}
}

// WithPayload adds the payload to the create Http response rule frontend created response
func (o *CreateHTTPResponseRuleFrontendCreated) WithPayload(payload *models.HTTPResponseRule) *CreateHTTPResponseRuleFrontendCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http response rule frontend created response
func (o *CreateHTTPResponseRuleFrontendCreated) SetPayload(payload *models.HTTPResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPResponseRuleFrontendCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPResponseRuleFrontendAcceptedCode is the HTTP code returned for type CreateHTTPResponseRuleFrontendAccepted
const CreateHTTPResponseRuleFrontendAcceptedCode int = 202

/*
CreateHTTPResponseRuleFrontendAccepted Configuration change accepted and reload requested

swagger:response createHttpResponseRuleFrontendAccepted
*/
type CreateHTTPResponseRuleFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPResponseRule `json:"body,omitempty"`
}

// NewCreateHTTPResponseRuleFrontendAccepted creates CreateHTTPResponseRuleFrontendAccepted with default headers values
func NewCreateHTTPResponseRuleFrontendAccepted() *CreateHTTPResponseRuleFrontendAccepted {

	return &CreateHTTPResponseRuleFrontendAccepted{}
}

// WithReloadID adds the reloadId to the create Http response rule frontend accepted response
func (o *CreateHTTPResponseRuleFrontendAccepted) WithReloadID(reloadID string) *CreateHTTPResponseRuleFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create Http response rule frontend accepted response
func (o *CreateHTTPResponseRuleFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create Http response rule frontend accepted response
func (o *CreateHTTPResponseRuleFrontendAccepted) WithPayload(payload *models.HTTPResponseRule) *CreateHTTPResponseRuleFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http response rule frontend accepted response
func (o *CreateHTTPResponseRuleFrontendAccepted) SetPayload(payload *models.HTTPResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPResponseRuleFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPResponseRuleFrontendBadRequestCode is the HTTP code returned for type CreateHTTPResponseRuleFrontendBadRequest
const CreateHTTPResponseRuleFrontendBadRequestCode int = 400

/*
CreateHTTPResponseRuleFrontendBadRequest Bad request

swagger:response createHttpResponseRuleFrontendBadRequest
*/
type CreateHTTPResponseRuleFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPResponseRuleFrontendBadRequest creates CreateHTTPResponseRuleFrontendBadRequest with default headers values
func NewCreateHTTPResponseRuleFrontendBadRequest() *CreateHTTPResponseRuleFrontendBadRequest {

	return &CreateHTTPResponseRuleFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http response rule frontend bad request response
func (o *CreateHTTPResponseRuleFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *CreateHTTPResponseRuleFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http response rule frontend bad request response
func (o *CreateHTTPResponseRuleFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http response rule frontend bad request response
func (o *CreateHTTPResponseRuleFrontendBadRequest) WithPayload(payload *models.Error) *CreateHTTPResponseRuleFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http response rule frontend bad request response
func (o *CreateHTTPResponseRuleFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPResponseRuleFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPResponseRuleFrontendConflictCode is the HTTP code returned for type CreateHTTPResponseRuleFrontendConflict
const CreateHTTPResponseRuleFrontendConflictCode int = 409

/*
CreateHTTPResponseRuleFrontendConflict The specified resource already exists

swagger:response createHttpResponseRuleFrontendConflict
*/
type CreateHTTPResponseRuleFrontendConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPResponseRuleFrontendConflict creates CreateHTTPResponseRuleFrontendConflict with default headers values
func NewCreateHTTPResponseRuleFrontendConflict() *CreateHTTPResponseRuleFrontendConflict {

	return &CreateHTTPResponseRuleFrontendConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http response rule frontend conflict response
func (o *CreateHTTPResponseRuleFrontendConflict) WithConfigurationVersion(configurationVersion string) *CreateHTTPResponseRuleFrontendConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http response rule frontend conflict response
func (o *CreateHTTPResponseRuleFrontendConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http response rule frontend conflict response
func (o *CreateHTTPResponseRuleFrontendConflict) WithPayload(payload *models.Error) *CreateHTTPResponseRuleFrontendConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http response rule frontend conflict response
func (o *CreateHTTPResponseRuleFrontendConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPResponseRuleFrontendConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateHTTPResponseRuleFrontendDefault General Error

swagger:response createHttpResponseRuleFrontendDefault
*/
type CreateHTTPResponseRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPResponseRuleFrontendDefault creates CreateHTTPResponseRuleFrontendDefault with default headers values
func NewCreateHTTPResponseRuleFrontendDefault(code int) *CreateHTTPResponseRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateHTTPResponseRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create HTTP response rule frontend default response
func (o *CreateHTTPResponseRuleFrontendDefault) WithStatusCode(code int) *CreateHTTPResponseRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create HTTP response rule frontend default response
func (o *CreateHTTPResponseRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create HTTP response rule frontend default response
func (o *CreateHTTPResponseRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *CreateHTTPResponseRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create HTTP response rule frontend default response
func (o *CreateHTTPResponseRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create HTTP response rule frontend default response
func (o *CreateHTTPResponseRuleFrontendDefault) WithPayload(payload *models.Error) *CreateHTTPResponseRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create HTTP response rule frontend default response
func (o *CreateHTTPResponseRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPResponseRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
