# Generated CLib Headers

```{caution}
The YAML configuration for the **sourcegen** utility is an experimental part of Cantera
and may be changed without notice.
```

The folder `interfaces/sourcegen/src/sourcegen/headers` holds YAML configuration files
for code generation. Code generation uses output of the
[Doxygen](https://www.doxygen.org) code documentation tool for information on function
declarations as well as C++ docstrings. The collected information
represents annotated CLib functions that form the basis for specific APIs generated by
[sourcegen](sourcegen).

(sec-sourcegen-specifications)=
## Header Specification Files

Each YAML file contains information for CLib headers that implement functions and
methods built around a specific Cantera class. The following fields are supported:

- `docstring`: Used as part of the docstring of the generated API file.
- `prefix`: Prefix used for CLib functions.
- `base`: Base class of the CLib library; examples: `Solution`, `ThermoPhase`.
    Stand-alone functions defined in the `Cantera` namespace use `""` as a base.
- `parents`: List of class parents; used to locate C++ methods (default: `[]`).
- `derived`: Dictionary of derived classes and alternative prefixes. Used to locate C++
    methods and to better differentiate CLib method names (default: `{}`).
- `recipes`: List of CLib *recipes* (see below).

(sec-sourcegen-function-types)=
## CLib Function Types

The *sourcegen* utility implements logic to automatically detect CLib functions types
based on a recipe, which is subsequently used to scaffold API functions using dedicated
*Jinja* templates. The following recipe/CLib function types are differentiated:

- `function`: Regular function defined in the `Cantera` namespace.
- `constructor`: A CLib constructor adds new C++ objects to CLib storage. Constructor
    names should start with `new`. As all objects are handled via smart `shared_ptr<>`,
    CLib constructors require C++ utility functions that return a pointer to a new
    object. Constructors with the name `new` will use the C++ default constructor.
- `accessor`: A CLib accessor adds existing or spawned C++ objects to CLib storage.
- `destructor`: A CLib destructor removes a C++ object from CLib. Destructor names
    should start with `del`.
- `getter`: Implements a getter method of a C++ class.
- `setter`: Implements a setter method of a C++ class.
- `method`: Generic method of a C++ class.
- `variable-getter`: Implements a getter for a C++ class member variable or a variable
    defined in the `Cantera` namespace. Functionality is inferred automatically.
- `variable-setter`: Implements a getter for a C++ class member variable or a variable
    defined in the `Cantera` namespace. Field disambiguates from a `variable-getter`.
- `reserved`: Reserved (hard-coded) CLib functions which include service functions for
    CLib storage (example: `cabinetSize`) or functions that do not have
    a C++ equivalent (example: `getCanteraError`).

(sec-sourcegen-recipes)=
## Function Recipes

Recipes include all information required for the auto-generation of a corresponding
CLib function. Each YAML recipe uses the following fields:

- `name`: Name of the CLib function to be generated (without prefix).
- `brief`: Optional override for brief description from Doxygen documentation.
- `what`: Optional override for auto-detected recipe/CLib function type.
- `wraps`: Optional name or signature of the implemented C++ function/method or
    variable. If left empty, *sourcegen* searches for Doxygen tags matching the `name`
    field. A name is sufficient if C++ functions/methods are unique, for example
    `Func1::type`. A signature is required whenever shortened signatures with default
    arguments are used and/or multiple C++ function/method variants exist, for example
    `Phase::moleFraction(size_t)`. The scope (part preceding `::`) may be omitted, as
    it can be inferred based on the fields `base`, `parents` or `derived`.
- `uses`: Optional list of auxiliary C++ class methods used by the CLib function. The
    exact usage depends on the type of the implemented CLib function.

For custom code, additional fields are required to replace generated information:

- `declaration`: Full CLib declaration.
- `parameters`: Mapping of parameter doc-strings.
- `returns`: Return doc-string.
- `code`: Custom code to be executed.

(sec-sourcegen-headers)=
## CLib Header Generator

The CLib header generator is located in the `interfaces/sourcegen/src/sourcegen/headers`
folder.

### Configuration

The YAML file `config.yaml` within the `headers` folder contains configuration options
specific to the CLib interface. Configuration options are static unless new CLib
modules need to be implemented (see section [](sec-sourcegen-clib-extend)).

- **Generic Options:** As the CLib interface follows directly from
  [](sec-sourcegen-specifications), override options defined by `ignore_files` and
  `ignore_funcs` are not needed. While the options are available, they should only be
  used for testing purposes and otherwise be left at their default values (empty).

- **Type Crosswalks:** These fields map C++ types to their CLib equivalents.

    - `ret_type_crosswalk`: Specifies the types returned by C++ functions and methods.
    - `par_type_crosswalk`: Specifies the types passed as parameters in C++ functions
      and methods.

(sec-sourcegen-headers-details)=
### Implementation Details

- **Header Specification Files:** Definitions used for the CLib API.

    - `ct*.yaml`: Files specifying CLib interfaces for specific Cantera C++
      classes. See [](sec-sourcegen-specifications).

- **Templates for Scaffolding:** Templates, powered by
  [Jinja](https://jinja.palletsprojects.com), are used to scaffold elements of the CLib
  API. The following files define these templates:

    - `templates.yaml`: Defines code blocks within the header files.

- **Source Code:** The implementation of the CLib header generator is contained in
  `generator.py`.

## Extending the CLib Header API

See [](sec-sourcegen-clib-extend).
