# This file is part of Cantera. See License.txt in the top-level directory or
# at https://cantera.org/license.txt for license and copyright information.

from collections.abc import Sequence
from typing import Literal, overload

from ._types import Array, ArrayLike, EquilibriumSolver, LogLevel, PropertyPair
from .thermo import ThermoPhase

class Mixture:
    def __init__(self, phases: Sequence[tuple[ThermoPhase, float]]) -> None: ...
    def report(self, threshold: float = 1e-14) -> str: ...
    def __call__(self) -> None: ...
    @property
    def n_elements(self) -> int: ...
    def element_index(self, element: str | int) -> int: ...
    @property
    def n_species(self) -> int: ...
    def species_name(self, k: int) -> str: ...
    @property
    def species_names(self) -> list[str]: ...
    def species_index(
        self, phase: ThermoPhase | str | int, species: str | int
    ) -> int: ...
    def n_atoms(self, k: int, m: str | int) -> int: ...
    @property
    def n_phases(self) -> int: ...
    def phase(self, n: int) -> ThermoPhase: ...
    def phase_index(self, p: ThermoPhase | str | int) -> int: ...
    @property
    def phase_names(self) -> list[str]: ...
    @property
    def T(self) -> float: ...
    @T.setter
    def T(self, T: float) -> None: ...
    @property
    def min_temp(self) -> float: ...
    @property
    def max_temp(self) -> float: ...
    @property
    def P(self) -> float: ...
    @P.setter
    def P(self, P: float) -> None: ...
    @property
    def charge(self) -> float: ...
    def phase_charge(self, p: ThermoPhase | str | int) -> float: ...
    @overload
    def phase_moles(self, p: ThermoPhase | str | int) -> float: ...
    @overload
    def phase_moles(self, p: None = None) -> list[float]: ...
    def set_phase_moles(self, p: ThermoPhase | str | int, moles: float) -> None: ...
    @property
    def species_moles(self) -> Array: ...
    @species_moles.setter
    def species_moles(self, moles: str | ArrayLike) -> None: ...
    def element_moles(self, e: str) -> float: ...
    @property
    def chemical_potentials(self) -> Array: ...
    def equilibrate(
        self,
        XY: PropertyPair,
        solver: EquilibriumSolver = "auto",
        rtol: float = 1e-9,
        max_steps: int = 1000,
        max_iter: int = 100,
        estimate_equil: Literal[-1, 0, 1] = 0,
        log_level: LogLevel = 0,
    ) -> None: ...
