/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.trees.m5.M5Base;
import weka.classifiers.trees.m5.Rule;
import weka.core.Drawable;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class M5P
extends M5Base
implements Drawable {
    static final long serialVersionUID = -6118439039768244417L;

    public String globalInfo() {
        return "Implements the M5' model tree algorithm. The original M5 algorithm was developed by R. Quinlan. Yong Wang made improvements leading to M5'.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public M5P() {
        this.setGenerateRules(false);
    }

    @Override
    public int graphType() {
        return 1;
    }

    @Override
    public String graph() throws Exception {
        StringBuffer text = new StringBuffer();
        text.append("digraph M5Tree {\n");
        Rule temp = (Rule)this.m_ruleSet.get(0);
        temp.topOfTree().graph(text);
        text.append("}\n");
        return text.toString();
    }

    public String saveInstancesTipText() {
        return "Whether to save instance data at each node in the tree for visualization purposes.";
    }

    public void setSaveInstances(boolean save) {
        this.m_saveInstances = save;
    }

    public boolean getSaveInstances() {
        return this.m_saveInstances;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Enumeration<Option> superOpts = super.listOptions();
        Vector<Option> newVector = new Vector<Option>();
        while (superOpts.hasMoreElements()) {
            newVector.addElement(superOpts.nextElement());
        }
        newVector.addElement(new Option("\tSave instances at the nodes in\n\tthe tree (for visualization purposes)", "L", 0, "-L"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setSaveInstances(Utils.getFlag('L', options));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOpts = super.getOptions();
        String[] options = new String[superOpts.length + 1];
        int current = superOpts.length;
        for (int i = 0; i < current; ++i) {
            options[i] = superOpts[i];
        }
        if (this.getSaveInstances()) {
            options[current++] = "-L";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14534 $");
    }

    public static void main(String[] args) {
        M5P.runClassifier(new M5P(), args);
    }
}

