// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
pub struct WriteGetObjectResponseInput {
    /// <p>Route prefix to the HTTP URL generated.</p>
    pub request_route: ::std::option::Option<::std::string::String>,
    /// <p>A single use encrypted token that maps <code>WriteGetObjectResponse</code> to the end user <code>GetObject</code> request.</p>
    pub request_token: ::std::option::Option<::std::string::String>,
    /// <p>The object data.</p>
    pub body: ::aws_smithy_types::byte_stream::ByteStream,
    /// <p>The integer status code for an HTTP response of a corresponding <code>GetObject</code> request. The following is a list of status codes.</p>
    /// <ul>
    /// <li>
    /// <p><code>200 - OK</code></p></li>
    /// <li>
    /// <p><code>206 - Partial Content</code></p></li>
    /// <li>
    /// <p><code>304 - Not Modified</code></p></li>
    /// <li>
    /// <p><code>400 - Bad Request</code></p></li>
    /// <li>
    /// <p><code>401 - Unauthorized</code></p></li>
    /// <li>
    /// <p><code>403 - Forbidden</code></p></li>
    /// <li>
    /// <p><code>404 - Not Found</code></p></li>
    /// <li>
    /// <p><code>405 - Method Not Allowed</code></p></li>
    /// <li>
    /// <p><code>409 - Conflict</code></p></li>
    /// <li>
    /// <p><code>411 - Length Required</code></p></li>
    /// <li>
    /// <p><code>412 - Precondition Failed</code></p></li>
    /// <li>
    /// <p><code>416 - Range Not Satisfiable</code></p></li>
    /// <li>
    /// <p><code>500 - Internal Server Error</code></p></li>
    /// <li>
    /// <p><code>503 - Service Unavailable</code></p></li>
    /// </ul>
    pub status_code: ::std::option::Option<i32>,
    /// <p>A string that uniquely identifies an error condition. Returned in the <code> tag of the error XML response for a corresponding <code>GetObject</code> call. Cannot be used with a successful <code>StatusCode</code> header or when the transformed object is provided in the body. All error codes from S3 are sentence-cased. The regular expression (regex) value is <code>"^\[A-Z\]\[a-zA-Z\]+$"</code>.</code></p>
    pub error_code: ::std::option::Option<::std::string::String>,
    /// <p>Contains a generic description of the error condition. Returned in the <message>
    /// tag of the error XML response for a corresponding
    /// <code>GetObject</code> call. Cannot be used with a successful
    /// <code>StatusCode</code> header or when the transformed object is provided in body.
    /// </message></p>
    pub error_message: ::std::option::Option<::std::string::String>,
    /// <p>Indicates that a range of bytes was specified.</p>
    pub accept_ranges: ::std::option::Option<::std::string::String>,
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub cache_control: ::std::option::Option<::std::string::String>,
    /// <p>Specifies presentational information for the object.</p>
    pub content_disposition: ::std::option::Option<::std::string::String>,
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
    pub content_encoding: ::std::option::Option<::std::string::String>,
    /// <p>The language the content is in.</p>
    pub content_language: ::std::option::Option<::std::string::String>,
    /// <p>The size of the content body in bytes.</p>
    pub content_length: ::std::option::Option<i64>,
    /// <p>The portion of the object returned in the response.</p>
    pub content_range: ::std::option::Option<::std::string::String>,
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub content_type: ::std::option::Option<::std::string::String>,
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 32-bit <code>CRC32</code> checksum of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    /// <p></p>
    pub checksum_crc32: ::std::option::Option<::std::string::String>,
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 32-bit <code>CRC32C</code> checksum of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub checksum_crc32_c: ::std::option::Option<::std::string::String>,
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the Base64 encoded, 64-bit <code>CRC64NVME</code> checksum of the part. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub checksum_crc64_nvme: ::std::option::Option<::std::string::String>,
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 160-bit <code>SHA1</code> digest of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub checksum_sha1: ::std::option::Option<::std::string::String>,
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 256-bit <code>SHA256</code> digest of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub checksum_sha256: ::std::option::Option<::std::string::String>,
    /// <p>Specifies whether an object stored in Amazon S3 is (<code>true</code>) or is not (<code>false</code>) a delete marker. To learn more about delete markers, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/DeleteMarker.html">Working with delete markers</a>.</p>
    pub delete_marker: ::std::option::Option<bool>,
    /// <p>An opaque identifier assigned by a web server to a specific version of a resource found at a URL.</p>
    pub e_tag: ::std::option::Option<::std::string::String>,
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub expires: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes this header. It includes the <code>expiry-date</code> and <code>rule-id</code> key-value pairs that provide the object expiration information. The value of the <code>rule-id</code> is URL-encoded.</p>
    pub expiration: ::std::option::Option<::std::string::String>,
    /// <p>The date and time that the object was last modified.</p>
    pub last_modified: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>Set to the number of metadata entries not returned in <code>x-amz-meta</code> headers. This can happen if you create metadata using an API like SOAP that supports more flexible metadata than the REST API. For example, using SOAP, you can create metadata whose values are not legal HTTP headers.</p>
    pub missing_meta: ::std::option::Option<i32>,
    /// <p>A map of metadata to store with the object in S3.</p>
    pub metadata: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>,
    /// <p>Indicates whether an object stored in Amazon S3 has Object Lock enabled. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html">Object Lock</a>.</p>
    pub object_lock_mode: ::std::option::Option<crate::types::ObjectLockMode>,
    /// <p>Indicates whether an object stored in Amazon S3 has an active legal hold.</p>
    pub object_lock_legal_hold_status: ::std::option::Option<crate::types::ObjectLockLegalHoldStatus>,
    /// <p>The date and time when Object Lock is configured to expire.</p>
    pub object_lock_retain_until_date: ::std::option::Option<::aws_smithy_types::DateTime>,
    /// <p>The count of parts this object has.</p>
    pub parts_count: ::std::option::Option<i32>,
    /// <p>Indicates if request involves bucket that is either a source or destination in a Replication rule. For more information about S3 Replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication.html">Replication</a>.</p>
    pub replication_status: ::std::option::Option<crate::types::ReplicationStatus>,
    /// <p>If present, indicates that the requester was successfully charged for the request.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub request_charged: ::std::option::Option<crate::types::RequestCharged>,
    /// <p>Provides information about object restoration operation and expiration time of the restored object copy.</p>
    pub restore: ::std::option::Option<::std::string::String>,
    /// <p>The server-side encryption algorithm used when storing requested object in Amazon S3 (for example, AES256, <code>aws:kms</code>).</p>
    pub server_side_encryption: ::std::option::Option<crate::types::ServerSideEncryption>,
    /// <p>Encryption algorithm used if server-side encryption with a customer-provided encryption key was specified for object stored in Amazon S3.</p>
    pub sse_customer_algorithm: ::std::option::Option<::std::string::String>,
    /// <p>If present, specifies the ID (Key ID, Key ARN, or Key Alias) of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric encryption customer managed key that was used for stored in Amazon S3 object.</p>
    pub ssekms_key_id: ::std::option::Option<::std::string::String>,
    /// <p>128-bit MD5 digest of customer-provided encryption key used in Amazon S3 to encrypt data stored in S3. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html">Protecting data using server-side encryption with customer-provided encryption keys (SSE-C)</a>.</p>
    pub sse_customer_key_md5: ::std::option::Option<::std::string::String>,
    /// <p>Provides storage class information of the object. Amazon S3 returns this header for all objects except for S3 Standard storage class objects.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a>.</p>
    pub storage_class: ::std::option::Option<crate::types::StorageClass>,
    /// <p>The number of tags, if any, on the object.</p>
    pub tag_count: ::std::option::Option<i32>,
    /// <p>An ID used to reference a specific version of the object.</p>
    pub version_id: ::std::option::Option<::std::string::String>,
    /// <p>Indicates whether the object stored in Amazon S3 uses an S3 bucket key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub bucket_key_enabled: ::std::option::Option<bool>,
}
impl WriteGetObjectResponseInput {
    /// <p>Route prefix to the HTTP URL generated.</p>
    pub fn request_route(&self) -> ::std::option::Option<&str> {
        self.request_route.as_deref()
    }
    /// <p>A single use encrypted token that maps <code>WriteGetObjectResponse</code> to the end user <code>GetObject</code> request.</p>
    pub fn request_token(&self) -> ::std::option::Option<&str> {
        self.request_token.as_deref()
    }
    /// <p>The object data.</p>
    pub fn body(&self) -> &::aws_smithy_types::byte_stream::ByteStream {
        &self.body
    }
    /// <p>The integer status code for an HTTP response of a corresponding <code>GetObject</code> request. The following is a list of status codes.</p>
    /// <ul>
    /// <li>
    /// <p><code>200 - OK</code></p></li>
    /// <li>
    /// <p><code>206 - Partial Content</code></p></li>
    /// <li>
    /// <p><code>304 - Not Modified</code></p></li>
    /// <li>
    /// <p><code>400 - Bad Request</code></p></li>
    /// <li>
    /// <p><code>401 - Unauthorized</code></p></li>
    /// <li>
    /// <p><code>403 - Forbidden</code></p></li>
    /// <li>
    /// <p><code>404 - Not Found</code></p></li>
    /// <li>
    /// <p><code>405 - Method Not Allowed</code></p></li>
    /// <li>
    /// <p><code>409 - Conflict</code></p></li>
    /// <li>
    /// <p><code>411 - Length Required</code></p></li>
    /// <li>
    /// <p><code>412 - Precondition Failed</code></p></li>
    /// <li>
    /// <p><code>416 - Range Not Satisfiable</code></p></li>
    /// <li>
    /// <p><code>500 - Internal Server Error</code></p></li>
    /// <li>
    /// <p><code>503 - Service Unavailable</code></p></li>
    /// </ul>
    pub fn status_code(&self) -> ::std::option::Option<i32> {
        self.status_code
    }
    /// <p>A string that uniquely identifies an error condition. Returned in the <code> tag of the error XML response for a corresponding <code>GetObject</code> call. Cannot be used with a successful <code>StatusCode</code> header or when the transformed object is provided in the body. All error codes from S3 are sentence-cased. The regular expression (regex) value is <code>"^\[A-Z\]\[a-zA-Z\]+$"</code>.</code></p>
    pub fn error_code(&self) -> ::std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>Contains a generic description of the error condition. Returned in the <message>
    /// tag of the error XML response for a corresponding
    /// <code>GetObject</code> call. Cannot be used with a successful
    /// <code>StatusCode</code> header or when the transformed object is provided in body.
    /// </message></p>
    pub fn error_message(&self) -> ::std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>Indicates that a range of bytes was specified.</p>
    pub fn accept_ranges(&self) -> ::std::option::Option<&str> {
        self.accept_ranges.as_deref()
    }
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub fn cache_control(&self) -> ::std::option::Option<&str> {
        self.cache_control.as_deref()
    }
    /// <p>Specifies presentational information for the object.</p>
    pub fn content_disposition(&self) -> ::std::option::Option<&str> {
        self.content_disposition.as_deref()
    }
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
    pub fn content_encoding(&self) -> ::std::option::Option<&str> {
        self.content_encoding.as_deref()
    }
    /// <p>The language the content is in.</p>
    pub fn content_language(&self) -> ::std::option::Option<&str> {
        self.content_language.as_deref()
    }
    /// <p>The size of the content body in bytes.</p>
    pub fn content_length(&self) -> ::std::option::Option<i64> {
        self.content_length
    }
    /// <p>The portion of the object returned in the response.</p>
    pub fn content_range(&self) -> ::std::option::Option<&str> {
        self.content_range.as_deref()
    }
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub fn content_type(&self) -> ::std::option::Option<&str> {
        self.content_type.as_deref()
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 32-bit <code>CRC32</code> checksum of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    /// <p></p>
    pub fn checksum_crc32(&self) -> ::std::option::Option<&str> {
        self.checksum_crc32.as_deref()
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 32-bit <code>CRC32C</code> checksum of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn checksum_crc32_c(&self) -> ::std::option::Option<&str> {
        self.checksum_crc32_c.as_deref()
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the Base64 encoded, 64-bit <code>CRC64NVME</code> checksum of the part. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn checksum_crc64_nvme(&self) -> ::std::option::Option<&str> {
        self.checksum_crc64_nvme.as_deref()
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 160-bit <code>SHA1</code> digest of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn checksum_sha1(&self) -> ::std::option::Option<&str> {
        self.checksum_sha1.as_deref()
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 256-bit <code>SHA256</code> digest of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn checksum_sha256(&self) -> ::std::option::Option<&str> {
        self.checksum_sha256.as_deref()
    }
    /// <p>Specifies whether an object stored in Amazon S3 is (<code>true</code>) or is not (<code>false</code>) a delete marker. To learn more about delete markers, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/DeleteMarker.html">Working with delete markers</a>.</p>
    pub fn delete_marker(&self) -> ::std::option::Option<bool> {
        self.delete_marker
    }
    /// <p>An opaque identifier assigned by a web server to a specific version of a resource found at a URL.</p>
    pub fn e_tag(&self) -> ::std::option::Option<&str> {
        self.e_tag.as_deref()
    }
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub fn expires(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.expires.as_ref()
    }
    /// <p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes this header. It includes the <code>expiry-date</code> and <code>rule-id</code> key-value pairs that provide the object expiration information. The value of the <code>rule-id</code> is URL-encoded.</p>
    pub fn expiration(&self) -> ::std::option::Option<&str> {
        self.expiration.as_deref()
    }
    /// <p>The date and time that the object was last modified.</p>
    pub fn last_modified(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
    /// <p>Set to the number of metadata entries not returned in <code>x-amz-meta</code> headers. This can happen if you create metadata using an API like SOAP that supports more flexible metadata than the REST API. For example, using SOAP, you can create metadata whose values are not legal HTTP headers.</p>
    pub fn missing_meta(&self) -> ::std::option::Option<i32> {
        self.missing_meta
    }
    /// <p>A map of metadata to store with the object in S3.</p>
    pub fn metadata(&self) -> ::std::option::Option<&::std::collections::HashMap<::std::string::String, ::std::string::String>> {
        self.metadata.as_ref()
    }
    /// <p>Indicates whether an object stored in Amazon S3 has Object Lock enabled. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html">Object Lock</a>.</p>
    pub fn object_lock_mode(&self) -> ::std::option::Option<&crate::types::ObjectLockMode> {
        self.object_lock_mode.as_ref()
    }
    /// <p>Indicates whether an object stored in Amazon S3 has an active legal hold.</p>
    pub fn object_lock_legal_hold_status(&self) -> ::std::option::Option<&crate::types::ObjectLockLegalHoldStatus> {
        self.object_lock_legal_hold_status.as_ref()
    }
    /// <p>The date and time when Object Lock is configured to expire.</p>
    pub fn object_lock_retain_until_date(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.object_lock_retain_until_date.as_ref()
    }
    /// <p>The count of parts this object has.</p>
    pub fn parts_count(&self) -> ::std::option::Option<i32> {
        self.parts_count
    }
    /// <p>Indicates if request involves bucket that is either a source or destination in a Replication rule. For more information about S3 Replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication.html">Replication</a>.</p>
    pub fn replication_status(&self) -> ::std::option::Option<&crate::types::ReplicationStatus> {
        self.replication_status.as_ref()
    }
    /// <p>If present, indicates that the requester was successfully charged for the request.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn request_charged(&self) -> ::std::option::Option<&crate::types::RequestCharged> {
        self.request_charged.as_ref()
    }
    /// <p>Provides information about object restoration operation and expiration time of the restored object copy.</p>
    pub fn restore(&self) -> ::std::option::Option<&str> {
        self.restore.as_deref()
    }
    /// <p>The server-side encryption algorithm used when storing requested object in Amazon S3 (for example, AES256, <code>aws:kms</code>).</p>
    pub fn server_side_encryption(&self) -> ::std::option::Option<&crate::types::ServerSideEncryption> {
        self.server_side_encryption.as_ref()
    }
    /// <p>Encryption algorithm used if server-side encryption with a customer-provided encryption key was specified for object stored in Amazon S3.</p>
    pub fn sse_customer_algorithm(&self) -> ::std::option::Option<&str> {
        self.sse_customer_algorithm.as_deref()
    }
    /// <p>If present, specifies the ID (Key ID, Key ARN, or Key Alias) of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric encryption customer managed key that was used for stored in Amazon S3 object.</p>
    pub fn ssekms_key_id(&self) -> ::std::option::Option<&str> {
        self.ssekms_key_id.as_deref()
    }
    /// <p>128-bit MD5 digest of customer-provided encryption key used in Amazon S3 to encrypt data stored in S3. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html">Protecting data using server-side encryption with customer-provided encryption keys (SSE-C)</a>.</p>
    pub fn sse_customer_key_md5(&self) -> ::std::option::Option<&str> {
        self.sse_customer_key_md5.as_deref()
    }
    /// <p>Provides storage class information of the object. Amazon S3 returns this header for all objects except for S3 Standard storage class objects.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a>.</p>
    pub fn storage_class(&self) -> ::std::option::Option<&crate::types::StorageClass> {
        self.storage_class.as_ref()
    }
    /// <p>The number of tags, if any, on the object.</p>
    pub fn tag_count(&self) -> ::std::option::Option<i32> {
        self.tag_count
    }
    /// <p>An ID used to reference a specific version of the object.</p>
    pub fn version_id(&self) -> ::std::option::Option<&str> {
        self.version_id.as_deref()
    }
    /// <p>Indicates whether the object stored in Amazon S3 uses an S3 bucket key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub fn bucket_key_enabled(&self) -> ::std::option::Option<bool> {
        self.bucket_key_enabled
    }
}
impl ::std::fmt::Debug for WriteGetObjectResponseInput {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("WriteGetObjectResponseInput");
        formatter.field("request_route", &self.request_route);
        formatter.field("request_token", &self.request_token);
        formatter.field("body", &self.body);
        formatter.field("status_code", &self.status_code);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.field("accept_ranges", &self.accept_ranges);
        formatter.field("cache_control", &self.cache_control);
        formatter.field("content_disposition", &self.content_disposition);
        formatter.field("content_encoding", &self.content_encoding);
        formatter.field("content_language", &self.content_language);
        formatter.field("content_length", &self.content_length);
        formatter.field("content_range", &self.content_range);
        formatter.field("content_type", &self.content_type);
        formatter.field("checksum_crc32", &self.checksum_crc32);
        formatter.field("checksum_crc32_c", &self.checksum_crc32_c);
        formatter.field("checksum_crc64_nvme", &self.checksum_crc64_nvme);
        formatter.field("checksum_sha1", &self.checksum_sha1);
        formatter.field("checksum_sha256", &self.checksum_sha256);
        formatter.field("delete_marker", &self.delete_marker);
        formatter.field("e_tag", &self.e_tag);
        formatter.field("expires", &self.expires);
        formatter.field("expiration", &self.expiration);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("missing_meta", &self.missing_meta);
        formatter.field("metadata", &self.metadata);
        formatter.field("object_lock_mode", &self.object_lock_mode);
        formatter.field("object_lock_legal_hold_status", &self.object_lock_legal_hold_status);
        formatter.field("object_lock_retain_until_date", &self.object_lock_retain_until_date);
        formatter.field("parts_count", &self.parts_count);
        formatter.field("replication_status", &self.replication_status);
        formatter.field("request_charged", &self.request_charged);
        formatter.field("restore", &self.restore);
        formatter.field("server_side_encryption", &self.server_side_encryption);
        formatter.field("sse_customer_algorithm", &self.sse_customer_algorithm);
        formatter.field("ssekms_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("sse_customer_key_md5", &self.sse_customer_key_md5);
        formatter.field("storage_class", &self.storage_class);
        formatter.field("tag_count", &self.tag_count);
        formatter.field("version_id", &self.version_id);
        formatter.field("bucket_key_enabled", &self.bucket_key_enabled);
        formatter.finish()
    }
}
impl WriteGetObjectResponseInput {
    /// Creates a new builder-style object to manufacture [`WriteGetObjectResponseInput`](crate::operation::write_get_object_response::WriteGetObjectResponseInput).
    pub fn builder() -> crate::operation::write_get_object_response::builders::WriteGetObjectResponseInputBuilder {
        crate::operation::write_get_object_response::builders::WriteGetObjectResponseInputBuilder::default()
    }
}

/// A builder for [`WriteGetObjectResponseInput`](crate::operation::write_get_object_response::WriteGetObjectResponseInput).
#[derive(::std::default::Default)]
#[non_exhaustive]
pub struct WriteGetObjectResponseInputBuilder {
    pub(crate) request_route: ::std::option::Option<::std::string::String>,
    pub(crate) request_token: ::std::option::Option<::std::string::String>,
    pub(crate) body: ::std::option::Option<::aws_smithy_types::byte_stream::ByteStream>,
    pub(crate) status_code: ::std::option::Option<i32>,
    pub(crate) error_code: ::std::option::Option<::std::string::String>,
    pub(crate) error_message: ::std::option::Option<::std::string::String>,
    pub(crate) accept_ranges: ::std::option::Option<::std::string::String>,
    pub(crate) cache_control: ::std::option::Option<::std::string::String>,
    pub(crate) content_disposition: ::std::option::Option<::std::string::String>,
    pub(crate) content_encoding: ::std::option::Option<::std::string::String>,
    pub(crate) content_language: ::std::option::Option<::std::string::String>,
    pub(crate) content_length: ::std::option::Option<i64>,
    pub(crate) content_range: ::std::option::Option<::std::string::String>,
    pub(crate) content_type: ::std::option::Option<::std::string::String>,
    pub(crate) checksum_crc32: ::std::option::Option<::std::string::String>,
    pub(crate) checksum_crc32_c: ::std::option::Option<::std::string::String>,
    pub(crate) checksum_crc64_nvme: ::std::option::Option<::std::string::String>,
    pub(crate) checksum_sha1: ::std::option::Option<::std::string::String>,
    pub(crate) checksum_sha256: ::std::option::Option<::std::string::String>,
    pub(crate) delete_marker: ::std::option::Option<bool>,
    pub(crate) e_tag: ::std::option::Option<::std::string::String>,
    pub(crate) expires: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) expiration: ::std::option::Option<::std::string::String>,
    pub(crate) last_modified: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) missing_meta: ::std::option::Option<i32>,
    pub(crate) metadata: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>,
    pub(crate) object_lock_mode: ::std::option::Option<crate::types::ObjectLockMode>,
    pub(crate) object_lock_legal_hold_status: ::std::option::Option<crate::types::ObjectLockLegalHoldStatus>,
    pub(crate) object_lock_retain_until_date: ::std::option::Option<::aws_smithy_types::DateTime>,
    pub(crate) parts_count: ::std::option::Option<i32>,
    pub(crate) replication_status: ::std::option::Option<crate::types::ReplicationStatus>,
    pub(crate) request_charged: ::std::option::Option<crate::types::RequestCharged>,
    pub(crate) restore: ::std::option::Option<::std::string::String>,
    pub(crate) server_side_encryption: ::std::option::Option<crate::types::ServerSideEncryption>,
    pub(crate) sse_customer_algorithm: ::std::option::Option<::std::string::String>,
    pub(crate) ssekms_key_id: ::std::option::Option<::std::string::String>,
    pub(crate) sse_customer_key_md5: ::std::option::Option<::std::string::String>,
    pub(crate) storage_class: ::std::option::Option<crate::types::StorageClass>,
    pub(crate) tag_count: ::std::option::Option<i32>,
    pub(crate) version_id: ::std::option::Option<::std::string::String>,
    pub(crate) bucket_key_enabled: ::std::option::Option<bool>,
}
impl WriteGetObjectResponseInputBuilder {
    /// <p>Route prefix to the HTTP URL generated.</p>
    /// This field is required.
    pub fn request_route(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.request_route = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Route prefix to the HTTP URL generated.</p>
    pub fn set_request_route(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.request_route = input;
        self
    }
    /// <p>Route prefix to the HTTP URL generated.</p>
    pub fn get_request_route(&self) -> &::std::option::Option<::std::string::String> {
        &self.request_route
    }
    /// <p>A single use encrypted token that maps <code>WriteGetObjectResponse</code> to the end user <code>GetObject</code> request.</p>
    /// This field is required.
    pub fn request_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.request_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A single use encrypted token that maps <code>WriteGetObjectResponse</code> to the end user <code>GetObject</code> request.</p>
    pub fn set_request_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.request_token = input;
        self
    }
    /// <p>A single use encrypted token that maps <code>WriteGetObjectResponse</code> to the end user <code>GetObject</code> request.</p>
    pub fn get_request_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.request_token
    }
    /// <p>The object data.</p>
    pub fn body(mut self, input: ::aws_smithy_types::byte_stream::ByteStream) -> Self {
        self.body = ::std::option::Option::Some(input);
        self
    }
    /// <p>The object data.</p>
    pub fn set_body(mut self, input: ::std::option::Option<::aws_smithy_types::byte_stream::ByteStream>) -> Self {
        self.body = input;
        self
    }
    /// <p>The object data.</p>
    pub fn get_body(&self) -> &::std::option::Option<::aws_smithy_types::byte_stream::ByteStream> {
        &self.body
    }
    /// <p>The integer status code for an HTTP response of a corresponding <code>GetObject</code> request. The following is a list of status codes.</p>
    /// <ul>
    /// <li>
    /// <p><code>200 - OK</code></p></li>
    /// <li>
    /// <p><code>206 - Partial Content</code></p></li>
    /// <li>
    /// <p><code>304 - Not Modified</code></p></li>
    /// <li>
    /// <p><code>400 - Bad Request</code></p></li>
    /// <li>
    /// <p><code>401 - Unauthorized</code></p></li>
    /// <li>
    /// <p><code>403 - Forbidden</code></p></li>
    /// <li>
    /// <p><code>404 - Not Found</code></p></li>
    /// <li>
    /// <p><code>405 - Method Not Allowed</code></p></li>
    /// <li>
    /// <p><code>409 - Conflict</code></p></li>
    /// <li>
    /// <p><code>411 - Length Required</code></p></li>
    /// <li>
    /// <p><code>412 - Precondition Failed</code></p></li>
    /// <li>
    /// <p><code>416 - Range Not Satisfiable</code></p></li>
    /// <li>
    /// <p><code>500 - Internal Server Error</code></p></li>
    /// <li>
    /// <p><code>503 - Service Unavailable</code></p></li>
    /// </ul>
    pub fn status_code(mut self, input: i32) -> Self {
        self.status_code = ::std::option::Option::Some(input);
        self
    }
    /// <p>The integer status code for an HTTP response of a corresponding <code>GetObject</code> request. The following is a list of status codes.</p>
    /// <ul>
    /// <li>
    /// <p><code>200 - OK</code></p></li>
    /// <li>
    /// <p><code>206 - Partial Content</code></p></li>
    /// <li>
    /// <p><code>304 - Not Modified</code></p></li>
    /// <li>
    /// <p><code>400 - Bad Request</code></p></li>
    /// <li>
    /// <p><code>401 - Unauthorized</code></p></li>
    /// <li>
    /// <p><code>403 - Forbidden</code></p></li>
    /// <li>
    /// <p><code>404 - Not Found</code></p></li>
    /// <li>
    /// <p><code>405 - Method Not Allowed</code></p></li>
    /// <li>
    /// <p><code>409 - Conflict</code></p></li>
    /// <li>
    /// <p><code>411 - Length Required</code></p></li>
    /// <li>
    /// <p><code>412 - Precondition Failed</code></p></li>
    /// <li>
    /// <p><code>416 - Range Not Satisfiable</code></p></li>
    /// <li>
    /// <p><code>500 - Internal Server Error</code></p></li>
    /// <li>
    /// <p><code>503 - Service Unavailable</code></p></li>
    /// </ul>
    pub fn set_status_code(mut self, input: ::std::option::Option<i32>) -> Self {
        self.status_code = input;
        self
    }
    /// <p>The integer status code for an HTTP response of a corresponding <code>GetObject</code> request. The following is a list of status codes.</p>
    /// <ul>
    /// <li>
    /// <p><code>200 - OK</code></p></li>
    /// <li>
    /// <p><code>206 - Partial Content</code></p></li>
    /// <li>
    /// <p><code>304 - Not Modified</code></p></li>
    /// <li>
    /// <p><code>400 - Bad Request</code></p></li>
    /// <li>
    /// <p><code>401 - Unauthorized</code></p></li>
    /// <li>
    /// <p><code>403 - Forbidden</code></p></li>
    /// <li>
    /// <p><code>404 - Not Found</code></p></li>
    /// <li>
    /// <p><code>405 - Method Not Allowed</code></p></li>
    /// <li>
    /// <p><code>409 - Conflict</code></p></li>
    /// <li>
    /// <p><code>411 - Length Required</code></p></li>
    /// <li>
    /// <p><code>412 - Precondition Failed</code></p></li>
    /// <li>
    /// <p><code>416 - Range Not Satisfiable</code></p></li>
    /// <li>
    /// <p><code>500 - Internal Server Error</code></p></li>
    /// <li>
    /// <p><code>503 - Service Unavailable</code></p></li>
    /// </ul>
    pub fn get_status_code(&self) -> &::std::option::Option<i32> {
        &self.status_code
    }
    /// <p>A string that uniquely identifies an error condition. Returned in the <code> tag of the error XML response for a corresponding <code>GetObject</code> call. Cannot be used with a successful <code>StatusCode</code> header or when the transformed object is provided in the body. All error codes from S3 are sentence-cased. The regular expression (regex) value is <code>"^\[A-Z\]\[a-zA-Z\]+$"</code>.</code></p>
    pub fn error_code(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.error_code = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A string that uniquely identifies an error condition. Returned in the <code> tag of the error XML response for a corresponding <code>GetObject</code> call. Cannot be used with a successful <code>StatusCode</code> header or when the transformed object is provided in the body. All error codes from S3 are sentence-cased. The regular expression (regex) value is <code>"^\[A-Z\]\[a-zA-Z\]+$"</code>.</code></p>
    pub fn set_error_code(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.error_code = input;
        self
    }
    /// <p>A string that uniquely identifies an error condition. Returned in the <code> tag of the error XML response for a corresponding <code>GetObject</code> call. Cannot be used with a successful <code>StatusCode</code> header or when the transformed object is provided in the body. All error codes from S3 are sentence-cased. The regular expression (regex) value is <code>"^\[A-Z\]\[a-zA-Z\]+$"</code>.</code></p>
    pub fn get_error_code(&self) -> &::std::option::Option<::std::string::String> {
        &self.error_code
    }
    /// <p>Contains a generic description of the error condition. Returned in the <message>
    /// tag of the error XML response for a corresponding
    /// <code>GetObject</code> call. Cannot be used with a successful
    /// <code>StatusCode</code> header or when the transformed object is provided in body.
    /// </message></p>
    pub fn error_message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.error_message = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Contains a generic description of the error condition. Returned in the <message>
    /// tag of the error XML response for a corresponding
    /// <code>GetObject</code> call. Cannot be used with a successful
    /// <code>StatusCode</code> header or when the transformed object is provided in body.
    /// </message></p>
    pub fn set_error_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.error_message = input;
        self
    }
    /// <p>Contains a generic description of the error condition. Returned in the <message>
    /// tag of the error XML response for a corresponding
    /// <code>GetObject</code> call. Cannot be used with a successful
    /// <code>StatusCode</code> header or when the transformed object is provided in body.
    /// </message></p>
    pub fn get_error_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.error_message
    }
    /// <p>Indicates that a range of bytes was specified.</p>
    pub fn accept_ranges(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.accept_ranges = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Indicates that a range of bytes was specified.</p>
    pub fn set_accept_ranges(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.accept_ranges = input;
        self
    }
    /// <p>Indicates that a range of bytes was specified.</p>
    pub fn get_accept_ranges(&self) -> &::std::option::Option<::std::string::String> {
        &self.accept_ranges
    }
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub fn cache_control(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.cache_control = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub fn set_cache_control(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.cache_control = input;
        self
    }
    /// <p>Specifies caching behavior along the request/reply chain.</p>
    pub fn get_cache_control(&self) -> &::std::option::Option<::std::string::String> {
        &self.cache_control
    }
    /// <p>Specifies presentational information for the object.</p>
    pub fn content_disposition(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content_disposition = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specifies presentational information for the object.</p>
    pub fn set_content_disposition(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content_disposition = input;
        self
    }
    /// <p>Specifies presentational information for the object.</p>
    pub fn get_content_disposition(&self) -> &::std::option::Option<::std::string::String> {
        &self.content_disposition
    }
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
    pub fn content_encoding(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content_encoding = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
    pub fn set_content_encoding(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content_encoding = input;
        self
    }
    /// <p>Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field.</p>
    pub fn get_content_encoding(&self) -> &::std::option::Option<::std::string::String> {
        &self.content_encoding
    }
    /// <p>The language the content is in.</p>
    pub fn content_language(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content_language = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The language the content is in.</p>
    pub fn set_content_language(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content_language = input;
        self
    }
    /// <p>The language the content is in.</p>
    pub fn get_content_language(&self) -> &::std::option::Option<::std::string::String> {
        &self.content_language
    }
    /// <p>The size of the content body in bytes.</p>
    pub fn content_length(mut self, input: i64) -> Self {
        self.content_length = ::std::option::Option::Some(input);
        self
    }
    /// <p>The size of the content body in bytes.</p>
    pub fn set_content_length(mut self, input: ::std::option::Option<i64>) -> Self {
        self.content_length = input;
        self
    }
    /// <p>The size of the content body in bytes.</p>
    pub fn get_content_length(&self) -> &::std::option::Option<i64> {
        &self.content_length
    }
    /// <p>The portion of the object returned in the response.</p>
    pub fn content_range(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content_range = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The portion of the object returned in the response.</p>
    pub fn set_content_range(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content_range = input;
        self
    }
    /// <p>The portion of the object returned in the response.</p>
    pub fn get_content_range(&self) -> &::std::option::Option<::std::string::String> {
        &self.content_range
    }
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub fn content_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content_type = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub fn set_content_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content_type = input;
        self
    }
    /// <p>A standard MIME type describing the format of the object data.</p>
    pub fn get_content_type(&self) -> &::std::option::Option<::std::string::String> {
        &self.content_type
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 32-bit <code>CRC32</code> checksum of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    /// <p></p>
    pub fn checksum_crc32(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.checksum_crc32 = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 32-bit <code>CRC32</code> checksum of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    /// <p></p>
    pub fn set_checksum_crc32(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.checksum_crc32 = input;
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 32-bit <code>CRC32</code> checksum of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    /// <p></p>
    pub fn get_checksum_crc32(&self) -> &::std::option::Option<::std::string::String> {
        &self.checksum_crc32
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 32-bit <code>CRC32C</code> checksum of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn checksum_crc32_c(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.checksum_crc32_c = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 32-bit <code>CRC32C</code> checksum of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn set_checksum_crc32_c(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.checksum_crc32_c = input;
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 32-bit <code>CRC32C</code> checksum of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn get_checksum_crc32_c(&self) -> &::std::option::Option<::std::string::String> {
        &self.checksum_crc32_c
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the Base64 encoded, 64-bit <code>CRC64NVME</code> checksum of the part. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn checksum_crc64_nvme(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.checksum_crc64_nvme = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the Base64 encoded, 64-bit <code>CRC64NVME</code> checksum of the part. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn set_checksum_crc64_nvme(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.checksum_crc64_nvme = input;
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This header specifies the Base64 encoded, 64-bit <code>CRC64NVME</code> checksum of the part. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    pub fn get_checksum_crc64_nvme(&self) -> &::std::option::Option<::std::string::String> {
        &self.checksum_crc64_nvme
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 160-bit <code>SHA1</code> digest of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn checksum_sha1(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.checksum_sha1 = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 160-bit <code>SHA1</code> digest of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn set_checksum_sha1(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.checksum_sha1 = input;
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 160-bit <code>SHA1</code> digest of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn get_checksum_sha1(&self) -> &::std::option::Option<::std::string::String> {
        &self.checksum_sha1
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 256-bit <code>SHA256</code> digest of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn checksum_sha256(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.checksum_sha256 = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 256-bit <code>SHA256</code> digest of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn set_checksum_sha256(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.checksum_sha256 = input;
        self
    }
    /// <p>This header can be used as a data integrity check to verify that the data received is the same data that was originally sent. This specifies the Base64 encoded, 256-bit <code>SHA256</code> digest of the object returned by the Object Lambda function. This may not match the checksum for the object stored in Amazon S3. Amazon S3 will perform validation of the checksum values only when the original <code>GetObject</code> request required checksum validation. For more information about checksums, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p>
    /// <p>Only one checksum header can be specified at a time. If you supply multiple checksum headers, this request will fail.</p>
    pub fn get_checksum_sha256(&self) -> &::std::option::Option<::std::string::String> {
        &self.checksum_sha256
    }
    /// <p>Specifies whether an object stored in Amazon S3 is (<code>true</code>) or is not (<code>false</code>) a delete marker. To learn more about delete markers, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/DeleteMarker.html">Working with delete markers</a>.</p>
    pub fn delete_marker(mut self, input: bool) -> Self {
        self.delete_marker = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies whether an object stored in Amazon S3 is (<code>true</code>) or is not (<code>false</code>) a delete marker. To learn more about delete markers, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/DeleteMarker.html">Working with delete markers</a>.</p>
    pub fn set_delete_marker(mut self, input: ::std::option::Option<bool>) -> Self {
        self.delete_marker = input;
        self
    }
    /// <p>Specifies whether an object stored in Amazon S3 is (<code>true</code>) or is not (<code>false</code>) a delete marker. To learn more about delete markers, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/DeleteMarker.html">Working with delete markers</a>.</p>
    pub fn get_delete_marker(&self) -> &::std::option::Option<bool> {
        &self.delete_marker
    }
    /// <p>An opaque identifier assigned by a web server to a specific version of a resource found at a URL.</p>
    pub fn e_tag(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.e_tag = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>An opaque identifier assigned by a web server to a specific version of a resource found at a URL.</p>
    pub fn set_e_tag(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.e_tag = input;
        self
    }
    /// <p>An opaque identifier assigned by a web server to a specific version of a resource found at a URL.</p>
    pub fn get_e_tag(&self) -> &::std::option::Option<::std::string::String> {
        &self.e_tag
    }
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub fn expires(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.expires = ::std::option::Option::Some(input);
        self
    }
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub fn set_expires(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.expires = input;
        self
    }
    /// <p>The date and time at which the object is no longer cacheable.</p>
    pub fn get_expires(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.expires
    }
    /// <p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes this header. It includes the <code>expiry-date</code> and <code>rule-id</code> key-value pairs that provide the object expiration information. The value of the <code>rule-id</code> is URL-encoded.</p>
    pub fn expiration(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.expiration = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes this header. It includes the <code>expiry-date</code> and <code>rule-id</code> key-value pairs that provide the object expiration information. The value of the <code>rule-id</code> is URL-encoded.</p>
    pub fn set_expiration(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.expiration = input;
        self
    }
    /// <p>If the object expiration is configured (see PUT Bucket lifecycle), the response includes this header. It includes the <code>expiry-date</code> and <code>rule-id</code> key-value pairs that provide the object expiration information. The value of the <code>rule-id</code> is URL-encoded.</p>
    pub fn get_expiration(&self) -> &::std::option::Option<::std::string::String> {
        &self.expiration
    }
    /// <p>The date and time that the object was last modified.</p>
    pub fn last_modified(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.last_modified = ::std::option::Option::Some(input);
        self
    }
    /// <p>The date and time that the object was last modified.</p>
    pub fn set_last_modified(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.last_modified = input;
        self
    }
    /// <p>The date and time that the object was last modified.</p>
    pub fn get_last_modified(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.last_modified
    }
    /// <p>Set to the number of metadata entries not returned in <code>x-amz-meta</code> headers. This can happen if you create metadata using an API like SOAP that supports more flexible metadata than the REST API. For example, using SOAP, you can create metadata whose values are not legal HTTP headers.</p>
    pub fn missing_meta(mut self, input: i32) -> Self {
        self.missing_meta = ::std::option::Option::Some(input);
        self
    }
    /// <p>Set to the number of metadata entries not returned in <code>x-amz-meta</code> headers. This can happen if you create metadata using an API like SOAP that supports more flexible metadata than the REST API. For example, using SOAP, you can create metadata whose values are not legal HTTP headers.</p>
    pub fn set_missing_meta(mut self, input: ::std::option::Option<i32>) -> Self {
        self.missing_meta = input;
        self
    }
    /// <p>Set to the number of metadata entries not returned in <code>x-amz-meta</code> headers. This can happen if you create metadata using an API like SOAP that supports more flexible metadata than the REST API. For example, using SOAP, you can create metadata whose values are not legal HTTP headers.</p>
    pub fn get_missing_meta(&self) -> &::std::option::Option<i32> {
        &self.missing_meta
    }
    /// Adds a key-value pair to `metadata`.
    ///
    /// To override the contents of this collection use [`set_metadata`](Self::set_metadata).
    ///
    /// <p>A map of metadata to store with the object in S3.</p>
    pub fn metadata(mut self, k: impl ::std::convert::Into<::std::string::String>, v: impl ::std::convert::Into<::std::string::String>) -> Self {
        let mut hash_map = self.metadata.unwrap_or_default();
        hash_map.insert(k.into(), v.into());
        self.metadata = ::std::option::Option::Some(hash_map);
        self
    }
    /// <p>A map of metadata to store with the object in S3.</p>
    pub fn set_metadata(mut self, input: ::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>>) -> Self {
        self.metadata = input;
        self
    }
    /// <p>A map of metadata to store with the object in S3.</p>
    pub fn get_metadata(&self) -> &::std::option::Option<::std::collections::HashMap<::std::string::String, ::std::string::String>> {
        &self.metadata
    }
    /// <p>Indicates whether an object stored in Amazon S3 has Object Lock enabled. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html">Object Lock</a>.</p>
    pub fn object_lock_mode(mut self, input: crate::types::ObjectLockMode) -> Self {
        self.object_lock_mode = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether an object stored in Amazon S3 has Object Lock enabled. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html">Object Lock</a>.</p>
    pub fn set_object_lock_mode(mut self, input: ::std::option::Option<crate::types::ObjectLockMode>) -> Self {
        self.object_lock_mode = input;
        self
    }
    /// <p>Indicates whether an object stored in Amazon S3 has Object Lock enabled. For more information about S3 Object Lock, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html">Object Lock</a>.</p>
    pub fn get_object_lock_mode(&self) -> &::std::option::Option<crate::types::ObjectLockMode> {
        &self.object_lock_mode
    }
    /// <p>Indicates whether an object stored in Amazon S3 has an active legal hold.</p>
    pub fn object_lock_legal_hold_status(mut self, input: crate::types::ObjectLockLegalHoldStatus) -> Self {
        self.object_lock_legal_hold_status = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether an object stored in Amazon S3 has an active legal hold.</p>
    pub fn set_object_lock_legal_hold_status(mut self, input: ::std::option::Option<crate::types::ObjectLockLegalHoldStatus>) -> Self {
        self.object_lock_legal_hold_status = input;
        self
    }
    /// <p>Indicates whether an object stored in Amazon S3 has an active legal hold.</p>
    pub fn get_object_lock_legal_hold_status(&self) -> &::std::option::Option<crate::types::ObjectLockLegalHoldStatus> {
        &self.object_lock_legal_hold_status
    }
    /// <p>The date and time when Object Lock is configured to expire.</p>
    pub fn object_lock_retain_until_date(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.object_lock_retain_until_date = ::std::option::Option::Some(input);
        self
    }
    /// <p>The date and time when Object Lock is configured to expire.</p>
    pub fn set_object_lock_retain_until_date(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.object_lock_retain_until_date = input;
        self
    }
    /// <p>The date and time when Object Lock is configured to expire.</p>
    pub fn get_object_lock_retain_until_date(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.object_lock_retain_until_date
    }
    /// <p>The count of parts this object has.</p>
    pub fn parts_count(mut self, input: i32) -> Self {
        self.parts_count = ::std::option::Option::Some(input);
        self
    }
    /// <p>The count of parts this object has.</p>
    pub fn set_parts_count(mut self, input: ::std::option::Option<i32>) -> Self {
        self.parts_count = input;
        self
    }
    /// <p>The count of parts this object has.</p>
    pub fn get_parts_count(&self) -> &::std::option::Option<i32> {
        &self.parts_count
    }
    /// <p>Indicates if request involves bucket that is either a source or destination in a Replication rule. For more information about S3 Replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication.html">Replication</a>.</p>
    pub fn replication_status(mut self, input: crate::types::ReplicationStatus) -> Self {
        self.replication_status = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates if request involves bucket that is either a source or destination in a Replication rule. For more information about S3 Replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication.html">Replication</a>.</p>
    pub fn set_replication_status(mut self, input: ::std::option::Option<crate::types::ReplicationStatus>) -> Self {
        self.replication_status = input;
        self
    }
    /// <p>Indicates if request involves bucket that is either a source or destination in a Replication rule. For more information about S3 Replication, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication.html">Replication</a>.</p>
    pub fn get_replication_status(&self) -> &::std::option::Option<crate::types::ReplicationStatus> {
        &self.replication_status
    }
    /// <p>If present, indicates that the requester was successfully charged for the request.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn request_charged(mut self, input: crate::types::RequestCharged) -> Self {
        self.request_charged = ::std::option::Option::Some(input);
        self
    }
    /// <p>If present, indicates that the requester was successfully charged for the request.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn set_request_charged(mut self, input: ::std::option::Option<crate::types::RequestCharged>) -> Self {
        self.request_charged = input;
        self
    }
    /// <p>If present, indicates that the requester was successfully charged for the request.</p><note>
    /// <p>This functionality is not supported for directory buckets.</p>
    /// </note>
    pub fn get_request_charged(&self) -> &::std::option::Option<crate::types::RequestCharged> {
        &self.request_charged
    }
    /// <p>Provides information about object restoration operation and expiration time of the restored object copy.</p>
    pub fn restore(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.restore = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Provides information about object restoration operation and expiration time of the restored object copy.</p>
    pub fn set_restore(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.restore = input;
        self
    }
    /// <p>Provides information about object restoration operation and expiration time of the restored object copy.</p>
    pub fn get_restore(&self) -> &::std::option::Option<::std::string::String> {
        &self.restore
    }
    /// <p>The server-side encryption algorithm used when storing requested object in Amazon S3 (for example, AES256, <code>aws:kms</code>).</p>
    pub fn server_side_encryption(mut self, input: crate::types::ServerSideEncryption) -> Self {
        self.server_side_encryption = ::std::option::Option::Some(input);
        self
    }
    /// <p>The server-side encryption algorithm used when storing requested object in Amazon S3 (for example, AES256, <code>aws:kms</code>).</p>
    pub fn set_server_side_encryption(mut self, input: ::std::option::Option<crate::types::ServerSideEncryption>) -> Self {
        self.server_side_encryption = input;
        self
    }
    /// <p>The server-side encryption algorithm used when storing requested object in Amazon S3 (for example, AES256, <code>aws:kms</code>).</p>
    pub fn get_server_side_encryption(&self) -> &::std::option::Option<crate::types::ServerSideEncryption> {
        &self.server_side_encryption
    }
    /// <p>Encryption algorithm used if server-side encryption with a customer-provided encryption key was specified for object stored in Amazon S3.</p>
    pub fn sse_customer_algorithm(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.sse_customer_algorithm = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Encryption algorithm used if server-side encryption with a customer-provided encryption key was specified for object stored in Amazon S3.</p>
    pub fn set_sse_customer_algorithm(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.sse_customer_algorithm = input;
        self
    }
    /// <p>Encryption algorithm used if server-side encryption with a customer-provided encryption key was specified for object stored in Amazon S3.</p>
    pub fn get_sse_customer_algorithm(&self) -> &::std::option::Option<::std::string::String> {
        &self.sse_customer_algorithm
    }
    /// <p>If present, specifies the ID (Key ID, Key ARN, or Key Alias) of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric encryption customer managed key that was used for stored in Amazon S3 object.</p>
    pub fn ssekms_key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.ssekms_key_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>If present, specifies the ID (Key ID, Key ARN, or Key Alias) of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric encryption customer managed key that was used for stored in Amazon S3 object.</p>
    pub fn set_ssekms_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.ssekms_key_id = input;
        self
    }
    /// <p>If present, specifies the ID (Key ID, Key ARN, or Key Alias) of the Amazon Web Services Key Management Service (Amazon Web Services KMS) symmetric encryption customer managed key that was used for stored in Amazon S3 object.</p>
    pub fn get_ssekms_key_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.ssekms_key_id
    }
    /// <p>128-bit MD5 digest of customer-provided encryption key used in Amazon S3 to encrypt data stored in S3. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html">Protecting data using server-side encryption with customer-provided encryption keys (SSE-C)</a>.</p>
    pub fn sse_customer_key_md5(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.sse_customer_key_md5 = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>128-bit MD5 digest of customer-provided encryption key used in Amazon S3 to encrypt data stored in S3. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html">Protecting data using server-side encryption with customer-provided encryption keys (SSE-C)</a>.</p>
    pub fn set_sse_customer_key_md5(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.sse_customer_key_md5 = input;
        self
    }
    /// <p>128-bit MD5 digest of customer-provided encryption key used in Amazon S3 to encrypt data stored in S3. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html">Protecting data using server-side encryption with customer-provided encryption keys (SSE-C)</a>.</p>
    pub fn get_sse_customer_key_md5(&self) -> &::std::option::Option<::std::string::String> {
        &self.sse_customer_key_md5
    }
    /// <p>Provides storage class information of the object. Amazon S3 returns this header for all objects except for S3 Standard storage class objects.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a>.</p>
    pub fn storage_class(mut self, input: crate::types::StorageClass) -> Self {
        self.storage_class = ::std::option::Option::Some(input);
        self
    }
    /// <p>Provides storage class information of the object. Amazon S3 returns this header for all objects except for S3 Standard storage class objects.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a>.</p>
    pub fn set_storage_class(mut self, input: ::std::option::Option<crate::types::StorageClass>) -> Self {
        self.storage_class = input;
        self
    }
    /// <p>Provides storage class information of the object. Amazon S3 returns this header for all objects except for S3 Standard storage class objects.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html">Storage Classes</a>.</p>
    pub fn get_storage_class(&self) -> &::std::option::Option<crate::types::StorageClass> {
        &self.storage_class
    }
    /// <p>The number of tags, if any, on the object.</p>
    pub fn tag_count(mut self, input: i32) -> Self {
        self.tag_count = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of tags, if any, on the object.</p>
    pub fn set_tag_count(mut self, input: ::std::option::Option<i32>) -> Self {
        self.tag_count = input;
        self
    }
    /// <p>The number of tags, if any, on the object.</p>
    pub fn get_tag_count(&self) -> &::std::option::Option<i32> {
        &self.tag_count
    }
    /// <p>An ID used to reference a specific version of the object.</p>
    pub fn version_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.version_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>An ID used to reference a specific version of the object.</p>
    pub fn set_version_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.version_id = input;
        self
    }
    /// <p>An ID used to reference a specific version of the object.</p>
    pub fn get_version_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.version_id
    }
    /// <p>Indicates whether the object stored in Amazon S3 uses an S3 bucket key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub fn bucket_key_enabled(mut self, input: bool) -> Self {
        self.bucket_key_enabled = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether the object stored in Amazon S3 uses an S3 bucket key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub fn set_bucket_key_enabled(mut self, input: ::std::option::Option<bool>) -> Self {
        self.bucket_key_enabled = input;
        self
    }
    /// <p>Indicates whether the object stored in Amazon S3 uses an S3 bucket key for server-side encryption with Amazon Web Services KMS (SSE-KMS).</p>
    pub fn get_bucket_key_enabled(&self) -> &::std::option::Option<bool> {
        &self.bucket_key_enabled
    }
    /// Consumes the builder and constructs a [`WriteGetObjectResponseInput`](crate::operation::write_get_object_response::WriteGetObjectResponseInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<
        crate::operation::write_get_object_response::WriteGetObjectResponseInput,
        ::aws_smithy_types::error::operation::BuildError,
    > {
        ::std::result::Result::Ok(crate::operation::write_get_object_response::WriteGetObjectResponseInput {
            request_route: self.request_route,
            request_token: self.request_token,
            body: self.body.unwrap_or_default(),
            status_code: self.status_code,
            error_code: self.error_code,
            error_message: self.error_message,
            accept_ranges: self.accept_ranges,
            cache_control: self.cache_control,
            content_disposition: self.content_disposition,
            content_encoding: self.content_encoding,
            content_language: self.content_language,
            content_length: self.content_length,
            content_range: self.content_range,
            content_type: self.content_type,
            checksum_crc32: self.checksum_crc32,
            checksum_crc32_c: self.checksum_crc32_c,
            checksum_crc64_nvme: self.checksum_crc64_nvme,
            checksum_sha1: self.checksum_sha1,
            checksum_sha256: self.checksum_sha256,
            delete_marker: self.delete_marker,
            e_tag: self.e_tag,
            expires: self.expires,
            expiration: self.expiration,
            last_modified: self.last_modified,
            missing_meta: self.missing_meta,
            metadata: self.metadata,
            object_lock_mode: self.object_lock_mode,
            object_lock_legal_hold_status: self.object_lock_legal_hold_status,
            object_lock_retain_until_date: self.object_lock_retain_until_date,
            parts_count: self.parts_count,
            replication_status: self.replication_status,
            request_charged: self.request_charged,
            restore: self.restore,
            server_side_encryption: self.server_side_encryption,
            sse_customer_algorithm: self.sse_customer_algorithm,
            ssekms_key_id: self.ssekms_key_id,
            sse_customer_key_md5: self.sse_customer_key_md5,
            storage_class: self.storage_class,
            tag_count: self.tag_count,
            version_id: self.version_id,
            bucket_key_enabled: self.bucket_key_enabled,
        })
    }
}
impl ::std::fmt::Debug for WriteGetObjectResponseInputBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("WriteGetObjectResponseInputBuilder");
        formatter.field("request_route", &self.request_route);
        formatter.field("request_token", &self.request_token);
        formatter.field("body", &self.body);
        formatter.field("status_code", &self.status_code);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.field("accept_ranges", &self.accept_ranges);
        formatter.field("cache_control", &self.cache_control);
        formatter.field("content_disposition", &self.content_disposition);
        formatter.field("content_encoding", &self.content_encoding);
        formatter.field("content_language", &self.content_language);
        formatter.field("content_length", &self.content_length);
        formatter.field("content_range", &self.content_range);
        formatter.field("content_type", &self.content_type);
        formatter.field("checksum_crc32", &self.checksum_crc32);
        formatter.field("checksum_crc32_c", &self.checksum_crc32_c);
        formatter.field("checksum_crc64_nvme", &self.checksum_crc64_nvme);
        formatter.field("checksum_sha1", &self.checksum_sha1);
        formatter.field("checksum_sha256", &self.checksum_sha256);
        formatter.field("delete_marker", &self.delete_marker);
        formatter.field("e_tag", &self.e_tag);
        formatter.field("expires", &self.expires);
        formatter.field("expiration", &self.expiration);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("missing_meta", &self.missing_meta);
        formatter.field("metadata", &self.metadata);
        formatter.field("object_lock_mode", &self.object_lock_mode);
        formatter.field("object_lock_legal_hold_status", &self.object_lock_legal_hold_status);
        formatter.field("object_lock_retain_until_date", &self.object_lock_retain_until_date);
        formatter.field("parts_count", &self.parts_count);
        formatter.field("replication_status", &self.replication_status);
        formatter.field("request_charged", &self.request_charged);
        formatter.field("restore", &self.restore);
        formatter.field("server_side_encryption", &self.server_side_encryption);
        formatter.field("sse_customer_algorithm", &self.sse_customer_algorithm);
        formatter.field("ssekms_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("sse_customer_key_md5", &self.sse_customer_key_md5);
        formatter.field("storage_class", &self.storage_class);
        formatter.field("tag_count", &self.tag_count);
        formatter.field("version_id", &self.version_id);
        formatter.field("bucket_key_enabled", &self.bucket_key_enabled);
        formatter.finish()
    }
}
