/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.diagram;

import java.io.IOException;
import org.asciidoctor.diagram.DiagramGenerator;
import org.asciidoctor.diagram.DiagramGeneratorFunction;
import org.asciidoctor.diagram.Request;
import org.asciidoctor.diagram.ResponseData;

public abstract class LazyDiagramGenerator
implements DiagramGenerator {
    private final String name;
    private DiagramGeneratorFunction diagramGeneratorFunction;
    private IOException loadError;

    public LazyDiagramGenerator(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected abstract DiagramGeneratorFunction createGenerator() throws Exception;

    @Override
    public ResponseData generate(Request request) throws IOException {
        if (this.loadError != null) {
            throw this.loadError;
        }
        if (this.diagramGeneratorFunction == null) {
            try {
                this.diagramGeneratorFunction = this.createGenerator();
            }
            catch (Throwable e) {
                String message = this.getName() + " could not be initialised due to " + e.getClass().getSimpleName();
                if (e.getMessage() != null) {
                    message = message + ": " + e.getMessage();
                }
                this.loadError = new IOException(message);
                this.loadError.setStackTrace(e.getStackTrace());
                throw this.loadError;
            }
        }
        return this.diagramGeneratorFunction.generate(request);
    }
}

