/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ditaa;

import java.awt.Font;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.PSystemBasicFactory;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.ditaa.PSystemDitaa;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.skin.UmlDiagramType;

public class PSystemDitaaFactory
extends PSystemBasicFactory<PSystemDitaa> {
    public PSystemDitaaFactory() {
        super(DiagramType.DITAA);
    }

    @Override
    public PSystemDitaa initDiagram(UmlSource source, String startLine, PreprocessingArtifact preprocessing) {
        boolean performSeparationOfCommonEdges = true;
        if (startLine != null && (startLine.contains("-E") || startLine.contains("--no-separation"))) {
            performSeparationOfCommonEdges = false;
        }
        boolean dropShadows = true;
        if (startLine != null && (startLine.contains("-S") || startLine.contains("--no-shadows"))) {
            dropShadows = false;
        }
        boolean allCornersAreRound = false;
        if (startLine != null && (startLine.contains("-r") || startLine.contains("--round-corners"))) {
            allCornersAreRound = true;
        }
        boolean transparentBackground = false;
        if (startLine != null && (startLine.contains("-T") || startLine.contains("--transparent"))) {
            transparentBackground = true;
        }
        boolean forceFontSize = false;
        if (startLine != null && startLine.contains("--font-size")) {
            forceFontSize = true;
        }
        float scale = this.extractScale(startLine);
        Font font = this.extractFont(startLine);
        return new PSystemDitaa(source, "", performSeparationOfCommonEdges, dropShadows, allCornersAreRound, transparentBackground, scale, font, forceFontSize, preprocessing);
    }

    @Override
    public PSystemDitaa executeLine(UmlSource source, PSystemDitaa system, String line, PreprocessingArtifact preprocessing) {
        if (system == null && (line.equals("ditaa") || line.startsWith("ditaa("))) {
            boolean performSeparationOfCommonEdges = true;
            if (line.contains("-E") || line.contains("--no-separation")) {
                performSeparationOfCommonEdges = false;
            }
            boolean dropShadows = true;
            if (line.contains("-S") || line.contains("--no-shadows")) {
                dropShadows = false;
            }
            boolean allCornersAreRound = false;
            if (line.contains("-r") || line.contains("--round-corners")) {
                allCornersAreRound = true;
            }
            boolean transparentBackground = false;
            if (line.contains("-T") || line.contains("--transparent")) {
                transparentBackground = true;
            }
            boolean forceFontSize = false;
            if (line.contains("--font-size")) {
                forceFontSize = true;
            }
            float scale = this.extractScale(line);
            Font font = this.extractFont(line);
            return new PSystemDitaa(source, "", performSeparationOfCommonEdges, dropShadows, allCornersAreRound, transparentBackground, scale, font, forceFontSize, preprocessing);
        }
        if (system == null) {
            return null;
        }
        return system.add(line, preprocessing);
    }

    private float extractScale(String line) {
        if (line == null) {
            return 1.0f;
        }
        Pattern p = Pattern.compile("scale=([\\d.]+)");
        Matcher m = p.matcher(line);
        if (m.find()) {
            String number = m.group(1);
            return Float.parseFloat(number);
        }
        return 1.0f;
    }

    private Font extractFont(String line) {
        if (line == null) {
            return new Font("Dialog", 1, 12);
        }
        Pattern pName = Pattern.compile("font-family=([a-zA-Z0-0 ]+)");
        Matcher mName = pName.matcher(line);
        String fontName = "Dialog";
        if (mName.find()) {
            fontName = mName.group(1);
        }
        Pattern pVariant = Pattern.compile("font-variant=(BOLD|ITALIC|PLAIN)");
        Matcher mVariant = pVariant.matcher(line);
        int fontVariant = 1;
        if (mVariant.find()) {
            switch (mVariant.group(1)) {
                case "BOLD": {
                    fontVariant = 1;
                    break;
                }
                case "ITALIC": {
                    fontVariant = 2;
                    break;
                }
                case "PLAIN": {
                    fontVariant = 0;
                }
            }
        }
        Pattern pSize = Pattern.compile("font-size=([\\d]+)");
        Matcher mSize = pSize.matcher(line);
        int fontSize = 12;
        if (mSize.find()) {
            fontSize = Integer.parseInt(mSize.group(1));
        }
        return new Font(fontName, fontVariant, fontSize);
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return null;
    }
}

