/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.CucaNote;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.LinkArrow;
import net.sourceforge.plantuml.abel.LinkStrategy;
import net.sourceforge.plantuml.abel.NoteLinkStrategy;
import net.sourceforge.plantuml.cruise.XAbstractEdge;
import net.sourceforge.plantuml.cruise.XEdge;
import net.sourceforge.plantuml.cucadiagram.EntityPort;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.decoration.LinkMiddleDecor;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.decoration.Rainbow;
import net.sourceforge.plantuml.descdiagram.command.StringWithArrow;
import net.sourceforge.plantuml.dot.DotSplines;
import net.sourceforge.plantuml.dot.GraphvizVersion;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.BezierUtils;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.MagneticBorder;
import net.sourceforge.plantuml.klimt.geom.PointAndAngle;
import net.sourceforge.plantuml.klimt.geom.Positionable;
import net.sourceforge.plantuml.klimt.geom.PositionableUtils;
import net.sourceforge.plantuml.klimt.geom.Side;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.DotPath;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.skin.AlignmentParam;
import net.sourceforge.plantuml.skin.ColorParam;
import net.sourceforge.plantuml.skin.LineParam;
import net.sourceforge.plantuml.skin.Pragma;
import net.sourceforge.plantuml.skin.PragmaKey;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.ArithmeticStrategySum;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.Kal;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.Oscillator;
import net.sourceforge.plantuml.svek.PointListIterator;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.svek.SvgResult;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.svek.extremity.ExtremityArrow;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactory;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryExtends;
import net.sourceforge.plantuml.svek.extremity.ExtremityOther;
import net.sourceforge.plantuml.svek.image.EntityImageNoteLink;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.utils.Log;
import net.sourceforge.plantuml.utils.Position;

public class SvekEdge
extends XAbstractEdge
implements XEdge,
UDrawable {
    private static final XDimension2D CONSTRAINT_SPOT = new XDimension2D(10.0, 10.0);
    private final Cluster ltail;
    private final Cluster lhead;
    private final EntityPort startUid;
    private final EntityPort endUid;
    private final TextBlock startTailText;
    private final TextBlock endHeadText;
    private final TextBlock labelText;
    private boolean divideLabelWidthByTwo = false;
    private final int lineColor;
    private final int noteLabelColor;
    private final int startTailColor;
    private final int endHeadColor;
    private final StringBounder stringBounder;
    private DotPath dotPath;
    private DotPath dotPathInit;
    private Positionable startTailLabelXY;
    private Positionable endHeadLabelXY;
    private Positionable labelXY;
    private UDrawable extremity1;
    private UDrawable extremity2;
    private double dx;
    private double dy;
    private boolean opale;
    private Cluster projectionCluster;
    private final Pragma pragma;
    private final HColor backgroundColor;
    private final boolean useRankSame;
    private final UStroke defaultThickness;
    private HColor arrowLollipopColor;
    private final double labelShield;
    private Kal kal1;
    private Kal kal2;
    private Set<String> ids;

    public String toString() {
        return super.toString() + " color=" + this.lineColor;
    }

    private LinkStrategy getLinkStrategy() {
        return this.link.getLinkStrategy();
    }

    @Override
    public Direction getArrowDirection() {
        if (this.getLinkArrow() == LinkArrow.BACKWARD) {
            return this.getArrowDirectionInternal().getInv();
        }
        return this.getArrowDirectionInternal();
    }

    private Direction getArrowDirectionInternal() {
        if (this.isAutolink()) {
            double startAngle = this.dotPath.getStartAngle();
            return Direction.LEFT;
        }
        XPoint2D start = this.dotPath.getStartPoint();
        XPoint2D end = this.dotPath.getEndPoint();
        double ang = Math.atan2(end.getX() - start.getX(), end.getY() - start.getY());
        if (ang > -0.7853981633974483 && ang < 0.7853981633974483) {
            return Direction.DOWN;
        }
        if (ang > 2.356194490192345 || ang < -2.356194490192345) {
            return Direction.UP;
        }
        return end.getX() > start.getX() ? Direction.RIGHT : Direction.LEFT;
    }

    @Override
    public double getArrowDirectionInRadian() {
        if (this.getLinkArrow() == LinkArrow.BACKWARD) {
            return Math.PI + this.getArrowDirectionInRadianInternal();
        }
        return this.getArrowDirectionInRadianInternal();
    }

    private double getArrowDirectionInRadianInternal() {
        if (this.isAutolink()) {
            double startAngle = this.dotPath.getStartAngle();
            return startAngle;
        }
        XPoint2D start = this.dotPath.getStartPoint();
        XPoint2D end = this.dotPath.getEndPoint();
        double ang = Math.atan2(end.getX() - start.getX(), end.getY() - start.getY());
        return ang;
    }

    private Cluster getCluster2(Bibliotekon bibliotekon, Entity entityMutable) {
        for (Cluster cl : bibliotekon.allCluster()) {
            if (!cl.getGroups().contains(entityMutable)) continue;
            return cl;
        }
        throw new IllegalArgumentException();
    }

    public SvekEdge(Link link, ISkinParam skinParam, StringBounder stringBounder, FontConfiguration font, FontConfiguration cardinalityFont, Bibliotekon bibliotekon, Pragma pragma, GraphvizVersion graphvizVersion) {
        super(link, skinParam, bibliotekon);
        CucaNote note;
        TextBlock labelOnly;
        if (graphvizVersion.useShieldForQuantifier() && link.getLinkArg().getQuantifier1() != null) {
            link.getEntity1().ensureMargins(Margins.uniform(16.0));
        }
        if (graphvizVersion.useShieldForQuantifier() && link.getLinkArg().getQuantifier2() != null) {
            link.getEntity2().ensureMargins(Margins.uniform(16.0));
        }
        if (link.getLinkArg().getKal1() != null) {
            this.kal1 = new Kal(this, link.getLinkArg().getKal1(), skinParam, link.getEntity1(), link, stringBounder);
        }
        if (link.getLinkArg().getKal2() != null) {
            this.kal2 = new Kal(this, link.getLinkArg().getKal2(), skinParam, link.getEntity2(), link, stringBounder);
        }
        this.useRankSame = skinParam.useRankSame();
        this.startUid = link.getEntityPort1(bibliotekon);
        this.endUid = link.getEntityPort2(bibliotekon);
        Cluster ltail = null;
        if (this.startUid.startsWith("za")) {
            ltail = this.getCluster2(bibliotekon, link.getEntity1());
        }
        Cluster lhead = null;
        if (this.endUid.startsWith("za")) {
            lhead = this.getCluster2(bibliotekon, link.getEntity2());
        }
        if (link.getColors() != null) {
            skinParam = link.getColors().mute(skinParam);
            font = font.mute(link.getColors());
        }
        this.backgroundColor = skinParam.getBackgroundColor();
        this.defaultThickness = skinParam.getThickness(LineParam.arrow, null);
        this.arrowLollipopColor = skinParam.getHtmlColor(ColorParam.arrowLollipop, null, false);
        if (this.arrowLollipopColor == null) {
            this.arrowLollipopColor = this.backgroundColor;
        }
        this.pragma = pragma;
        this.stringBounder = stringBounder;
        this.ltail = ltail;
        this.lhead = lhead;
        this.lineColor = bibliotekon.getColorSequence().getValue();
        this.noteLabelColor = bibliotekon.getColorSequence().getValue();
        this.startTailColor = bibliotekon.getColorSequence().getValue();
        this.endHeadColor = bibliotekon.getColorSequence().getValue();
        if (Display.isNull(link.getLabel())) {
            labelOnly = TextBlockUtils.EMPTY_TEXT_BLOCK;
            if (this.getLinkArrow() != LinkArrow.NONE_OR_SEVERAL) {
                labelOnly = StringWithArrow.addMagicArrow(labelOnly, this, font);
            }
        } else {
            HorizontalAlignment alignment = this.getMessageTextAlignment(this.diagramType(), skinParam);
            boolean hasSeveralGuideLines = link.getLabel().hasSeveralGuideLines();
            TextBlock block = hasSeveralGuideLines ? StringWithArrow.addSeveralMagicArrows(link.getLabel(), this, font, alignment, skinParam) : link.getLabel().create0(font, alignment, skinParam, skinParam.maxMessageSize(), CreoleMode.SIMPLE_LINE, null, null);
            labelOnly = this.addVisibilityModifier(block, link, skinParam);
            if (this.getLinkArrow() != LinkArrow.NONE_OR_SEVERAL && !hasSeveralGuideLines) {
                labelOnly = StringWithArrow.addMagicArrow(labelOnly, this, font);
            }
        }
        if ((note = link.getNote()) == null) {
            this.labelText = labelOnly;
        } else {
            EntityImageNoteLink noteOnly = new EntityImageNoteLink(note.getDisplay(), note.getColors(), skinParam, link.getStyleBuilder());
            if (note.getStrategy() == NoteLinkStrategy.HALF_NOT_PRINTED || note.getStrategy() == NoteLinkStrategy.HALF_PRINTED_FULL) {
                this.divideLabelWidthByTwo = true;
            }
            this.labelText = note.getPosition() == Position.LEFT ? TextBlockUtils.mergeLR(noteOnly, labelOnly, VerticalAlignment.CENTER) : (note.getPosition() == Position.RIGHT ? TextBlockUtils.mergeLR(labelOnly, noteOnly, VerticalAlignment.CENTER) : (note.getPosition() == Position.TOP ? TextBlockUtils.mergeTB((TextBlock)noteOnly, labelOnly, HorizontalAlignment.CENTER) : TextBlockUtils.mergeTB(labelOnly, noteOnly, HorizontalAlignment.CENTER)));
        }
        this.startTailText = link.getQuantifier1() == null ? null : Display.getWithNewlines(skinParam.getPragma(), link.getQuantifier1()).create(cardinalityFont, HorizontalAlignment.CENTER, skinParam);
        this.endHeadText = link.getQuantifier2() == null ? null : Display.getWithNewlines(skinParam.getPragma(), link.getQuantifier2()).create(cardinalityFont, HorizontalAlignment.CENTER, skinParam);
        this.labelShield = link.getType().getMiddleDecor() == LinkMiddleDecor.NONE ? 0.0 : 7.0;
    }

    private TextBlock addVisibilityModifier(TextBlock block, Link link, ISkinParam skinParam) {
        VisibilityModifier visibilityModifier = link.getVisibilityModifier();
        if (visibilityModifier != null) {
            Rose rose = new Rose();
            HColor fore = rose.getHtmlColor(skinParam, visibilityModifier.getForeground());
            TextBlock visibility = visibilityModifier.getUBlock(skinParam.classAttributeIconSize(), fore, null, false);
            visibility = TextBlockUtils.withMargin(visibility, 0.0, 1.0, 2.0, 0.0);
            block = TextBlockUtils.mergeLR(visibility, block, VerticalAlignment.CENTER);
        }
        double marginLabel = this.startUid.equalsId(this.endUid) ? 6.0 : 1.0;
        return TextBlockUtils.withMargin(block, marginLabel, marginLabel);
    }

    private HorizontalAlignment getMessageTextAlignment(UmlDiagramType umlDiagramType, ISkinParam skinParam) {
        if (umlDiagramType == UmlDiagramType.STATE) {
            return skinParam.getHorizontalAlignment(AlignmentParam.stateMessageAlignment, null, false, null);
        }
        return skinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER);
    }

    public boolean hasNoteLabelText() {
        return this.labelText != null && this.labelText != TextBlockUtils.EMPTY_TEXT_BLOCK;
    }

    private LinkArrow getLinkArrow() {
        return this.link.getLinkArrow();
    }

    public void appendLine(GraphvizVersion graphvizVersion, StringBuilder sb, DotMode dotMode, DotSplines dotSplines) {
        sb.append(this.startUid.getFullString());
        sb.append("->");
        sb.append(this.endUid.getFullString());
        sb.append("[");
        LinkType linkType = this.link.getTypePatchCluster();
        String decoration = linkType.getSpecificDecorationSvek(this.getLinkStrategy());
        if (decoration.length() > 0 && !decoration.endsWith(",")) {
            decoration = decoration + ",";
        }
        sb.append(decoration);
        int length = this.link.getLength();
        if (graphvizVersion.ignoreHorizontalLinks() && length == 1) {
            length = 2;
        }
        if (this.useRankSame) {
            if (this.pragma.isDefine(PragmaKey.HORIZONTAL_LINE_BETWEEN_DIFFERENT_PACKAGE_ALLOWED) || this.link.isInvis() || length != 1) {
                sb.append("minlen=" + (length - 1));
                sb.append(",");
            }
        } else {
            sb.append("minlen=" + (length - 1));
            sb.append(",");
        }
        sb.append("color=\"" + StringUtils.sharp000000(this.lineColor) + "\"");
        if (this.hasNoteLabelText() || this.link.getLinkConstraint() != null) {
            sb.append(",");
            if (graphvizVersion.useXLabelInsteadOfLabel() || dotMode == DotMode.NO_LEFT_RIGHT_AND_XLABEL || dotSplines == DotSplines.ORTHO) {
                sb.append("xlabel=<");
            } else {
                sb.append("label=<");
            }
            XDimension2D dimNote = this.hasNoteLabelText() ? this.labelText.calculateDimension(this.stringBounder) : CONSTRAINT_SPOT;
            dimNote = dimNote.delta(2.0 * this.labelShield);
            SvekEdge.appendTable(sb, this.eventuallyDivideByTwo(dimNote), this.noteLabelColor, graphvizVersion);
            sb.append(">");
        }
        if (this.startTailText != null) {
            sb.append(",");
            sb.append("taillabel=<");
            SvekEdge.appendTable(sb, this.startTailText.calculateDimension(this.stringBounder), this.startTailColor, graphvizVersion);
            sb.append(">");
        }
        if (this.endHeadText != null) {
            sb.append(",");
            sb.append("headlabel=<");
            SvekEdge.appendTable(sb, this.endHeadText.calculateDimension(this.stringBounder), this.endHeadColor, graphvizVersion);
            sb.append(">");
        }
        if (this.link.isInvis()) {
            sb.append(",");
            sb.append("style=invis");
        }
        if (!this.link.isConstraint() || this.link.hasTwoEntryPointsSameContainer()) {
            sb.append(",constraint=false");
        }
        if (this.link.getSametail() != null) {
            sb.append(",sametail=" + this.link.getSametail());
        }
        sb.append("];");
        SvekUtils.println(sb);
    }

    private XDimension2D eventuallyDivideByTwo(XDimension2D dim) {
        if (this.divideLabelWidthByTwo) {
            return new XDimension2D(dim.getWidth() / 2.0, dim.getHeight());
        }
        return dim;
    }

    public String rankSame() {
        if (!this.pragma.isDefine(PragmaKey.HORIZONTAL_LINE_BETWEEN_DIFFERENT_PACKAGE_ALLOWED) && this.link.getLength() == 1) {
            return "{rank=same; " + this.getStartUidPrefix() + "; " + this.getEndUidPrefix() + "}";
        }
        return null;
    }

    public static void appendTable(StringBuilder sb, XDimension2D dim, int col, GraphvizVersion graphvizVersion) {
        int w = (int)dim.getWidth();
        int h = (int)dim.getHeight();
        SvekEdge.appendTable(sb, w, h, col);
    }

    public static void appendTable(StringBuilder sb, int w, int h, int col) {
        sb.append("<TABLE ");
        sb.append("BGCOLOR=\"" + StringUtils.sharp000000(col) + "\" ");
        sb.append("FIXEDSIZE=\"TRUE\" WIDTH=\"" + w + "\" HEIGHT=\"" + h + "\">");
        sb.append("<TR");
        sb.append(">");
        sb.append("<TD");
        sb.append(">");
        sb.append("</TD>");
        sb.append("</TR>");
        sb.append("</TABLE>");
    }

    public final String getStartUidPrefix() {
        return this.startUid.getPrefix();
    }

    public final String getEndUidPrefix() {
        return this.endUid.getPrefix();
    }

    private UDrawable getExtremitySpecial(XPoint2D center, LinkDecor decor, double angle, Cluster cluster, SvekNode nodeContact) {
        ExtremityFactory extremityFactory = decor.getExtremityFactoryLegacy(this.backgroundColor);
        return extremityFactory.createUDrawable(center, angle, null);
    }

    private UDrawable getExtremitySimplier(XPoint2D center, ExtremityFactory extremityFactory, double angle, Cluster cluster, SvekNode nodeContact, boolean isStart, Kal kal) {
        UTranslate translateForKal;
        if (extremityFactory == null) {
            return null;
        }
        Side side = null;
        if (nodeContact != null) {
            side = nodeContact.getRectangleArea().getClosestSide(center);
        }
        if (kal == null) {
            translateForKal = new UTranslate(0.0, 0.0);
        } else {
            translateForKal = kal.getTranslateForDecoration();
            center = translateForKal.getTranslated(center);
        }
        Extremity extremity = (Extremity)extremityFactory.createUDrawable(center, angle, side);
        double decorationLength = extremity.getDecorationLength();
        if (isStart) {
            this.dotPath.moveStartPoint(translateForKal.compose(new UTranslate(decorationLength, 0.0).rotate(angle - Math.PI)));
        } else {
            this.dotPath.moveEndPoint(translateForKal.compose(new UTranslate(decorationLength, 0.0).rotate(angle - Math.PI)));
        }
        return extremity;
    }

    private UDrawable getExtremity(final XPoint2D center, LinkDecor decor, PointListIterator pointListIterator, double angle, Cluster cluster, SvekNode nodeContact) {
        ExtremityFactory extremityFactory = decor.getExtremityFactoryLegacy(this.backgroundColor);
        if (cluster != null) {
            if (extremityFactory != null) {
                return extremityFactory.createUDrawable(center, angle, null);
            }
            if (decor == LinkDecor.EXTENDS) {
                return new ExtremityFactoryExtends(this.backgroundColor).createUDrawable(center, angle, null);
            }
            return null;
        }
        if (extremityFactory != null) {
            List points = (List)pointListIterator.next();
            if (points.size() == 0) {
                return null;
            }
            XPoint2D p0 = (XPoint2D)points.get(0);
            XPoint2D p1 = (XPoint2D)points.get(1);
            XPoint2D p2 = (XPoint2D)points.get(2);
            Side side = null;
            if (nodeContact != null) {
                side = nodeContact.getRectangleArea().getClosestSide(p1);
            }
            return extremityFactory.createTBRDrawableLegacy(p0, p1, p2, side);
        }
        if (decor == LinkDecor.NONE) {
            UPolygon sh = new UPolygon((List)pointListIterator.cloneMe().next());
            final XPoint2D contact = sh.checkMiddleContactForSpecificTriangle(center);
            if (contact != null) {
                return new UDrawable(){

                    @Override
                    public void drawU(UGraphic ug) {
                        ULine line = new ULine(contact.getX() - center.getX(), contact.getY() - center.getY());
                        ug = ug.apply(UTranslate.point(center));
                        ug.draw(line);
                    }
                };
            }
        } else if (decor != LinkDecor.NONE) {
            UPolygon sh = new UPolygon((List)pointListIterator.next());
            return new ExtremityOther(sh);
        }
        return null;
    }

    public void solveLine(SvgResult fullSvg) {
        XPoint2D pos;
        if (this.link.isInvis()) {
            return;
        }
        int idx = fullSvg.getIndexFromColor(this.lineColor);
        if (idx == -1) {
            return;
        }
        if ((idx = fullSvg.indexOf("d=\"", idx)) == -1) {
            throw new IllegalStateException();
        }
        int end = fullSvg.indexOf("\"", idx + 3);
        SvgResult path = fullSvg.substring(idx + 3, end);
        if (!path.isPathConsistent()) {
            return;
        }
        this.dotPath = path.toDotPath();
        XPoint2D tmpStartPoint = this.dotPath.getStartPoint();
        XPoint2D tmpEndPoint = this.dotPath.getEndPoint();
        SvekNode svekNode1 = this.getSvekNode1();
        SvekNode svekNode2 = this.getSvekNode2();
        if (svekNode1 != null && svekNode2 != null) {
            XPoint2D tmpPos1 = svekNode1.getRectangleArea().getPointCenter();
            XPoint2D tmpPos2 = svekNode2.getRectangleArea().getPointCenter();
            double normal = tmpStartPoint.distance(tmpPos1) + tmpEndPoint.distance(tmpPos2);
            double inversed = tmpStartPoint.distance(tmpPos2) + tmpEndPoint.distance(tmpPos1);
            if (inversed < normal) {
                this.dotPath = this.dotPath.reverse();
            }
        }
        this.dotPathInit = this.dotPath.copy();
        if (this.projectionCluster != null) {
            this.projectionCluster.manageEntryExitPoint(this.stringBounder);
        }
        this.dotPath = this.dotPath.simulateCompound(this.lhead == null ? null : this.lhead.getRectangleArea(), this.ltail == null ? null : this.ltail.getRectangleArea());
        SvgResult lineSvg = fullSvg.substring(end);
        PointListIterator pointListIterator = null;
        LinkType linkType = this.link.getType();
        if (this.getLinkStrategy() == LinkStrategy.SIMPLIER) {
            this.extremity1 = this.getExtremitySimplier(this.dotPath.getStartPoint(), linkType.getDecor2().getExtremityFactoryComplete(this.backgroundColor), this.dotPath.getStartAngle() + Math.PI, this.ltail, svekNode1, true, this.kal1);
            this.extremity2 = this.getExtremitySimplier(this.dotPath.getEndPoint(), linkType.getDecor1().getExtremityFactoryComplete(this.backgroundColor), this.dotPath.getEndAngle(), this.lhead, svekNode2, false, this.kal2);
        } else {
            pointListIterator = lineSvg.getPointsWithThisColor(this.lineColor);
            if (this.link.getLength() == 1 && this.isThereTwo(linkType) && this.count(pointListIterator.cloneMe()) == 2) {
                List points = (List)pointListIterator.next();
                XPoint2D p1 = (XPoint2D)points.get(1);
                XPoint2D startPoint = this.dotPath.getStartPoint();
                XPoint2D endPoint = this.dotPath.getEndPoint();
                if (p1.distance(startPoint) < p1.distance(endPoint)) {
                    startPoint = p1;
                } else {
                    endPoint = p1;
                }
                this.extremity1 = this.getExtremitySpecial(startPoint, linkType.getDecor2(), this.dotPath.getStartAngle() + Math.PI, this.ltail, svekNode1);
                this.extremity2 = this.getExtremitySpecial(endPoint, linkType.getDecor1(), this.dotPath.getEndAngle(), this.lhead, svekNode2);
            } else {
                this.extremity1 = this.getExtremity(this.dotPath.getStartPoint(), linkType.getDecor2(), pointListIterator, this.dotPath.getStartAngle() + Math.PI, this.ltail, svekNode1);
                this.extremity2 = this.getExtremity(this.dotPath.getEndPoint(), linkType.getDecor1(), pointListIterator, this.dotPath.getEndAngle(), this.lhead, svekNode2);
            }
        }
        if (this.link.getEntity1().getLeafType() == LeafType.LOLLIPOP_HALF) {
            svekNode1.addImpact(this.dotPath.getStartAngle() + Math.PI);
        }
        if (this.link.getEntity2().getLeafType() == LeafType.LOLLIPOP_HALF) {
            svekNode2.addImpact(this.dotPath.getEndAngle());
        }
        if (this.getLinkStrategy() == LinkStrategy.LEGACY_toberemoved && this.extremity1 instanceof Extremity && this.extremity2 instanceof Extremity) {
            XPoint2D p1 = ((Extremity)this.extremity1).somePoint();
            XPoint2D p2 = ((Extremity)this.extremity2).somePoint();
            if (p1 != null && p2 != null) {
                double dist1start = p1.distance(this.dotPath.getStartPoint());
                double dist1end = p1.distance(this.dotPath.getEndPoint());
                double dist2start = p2.distance(this.dotPath.getStartPoint());
                double dist2end = p2.distance(this.dotPath.getEndPoint());
                if (dist1start > dist1end && dist2end > dist2start) {
                    pointListIterator = lineSvg.getPointsWithThisColor(this.lineColor);
                    this.extremity2 = this.getExtremity(this.dotPath.getEndPoint(), linkType.getDecor1(), pointListIterator, this.dotPath.getEndAngle(), this.lhead, svekNode2);
                    this.extremity1 = this.getExtremity(this.dotPath.getStartPoint(), linkType.getDecor2(), pointListIterator, this.dotPath.getStartAngle() + Math.PI, this.ltail, svekNode1);
                }
            }
        }
        if ((this.hasNoteLabelText() || this.link.getLinkConstraint() != null) && (pos = this.getXY(fullSvg, this.noteLabelColor)) != null) {
            Positionable positionable = this.labelXY = this.hasNoteLabelText() ? TextBlockUtils.asPositionable(this.labelText, this.stringBounder, pos) : TextBlockUtils.asPositionable(CONSTRAINT_SPOT, this.stringBounder, pos);
        }
        if (this.startTailText != null && (pos = this.getXY(fullSvg, this.startTailColor)) != null) {
            this.startTailLabelXY = TextBlockUtils.asPositionable(this.startTailText, this.stringBounder, pos);
        }
        if (this.endHeadText != null && (pos = this.getXY(fullSvg, this.endHeadColor)) != null) {
            this.endHeadLabelXY = TextBlockUtils.asPositionable(this.endHeadText, this.stringBounder, pos);
        }
        if (!this.isOpalisable()) {
            this.setOpale(false);
        }
    }

    private boolean isThereTwo(LinkType linkType) {
        return linkType.getDecor2().getExtremityFactoryLegacy(this.backgroundColor) != null && linkType.getDecor1().getExtremityFactoryLegacy(this.backgroundColor) != null;
    }

    private int count(PointListIterator it) {
        int nb = 0;
        while (it.hasNext()) {
            it.next();
            ++nb;
        }
        return nb;
    }

    private SvekNode getSvekNode2() {
        return this.bibliotekon.getNode(this.link.getEntity2());
    }

    private SvekNode getSvekNode1() {
        return this.bibliotekon.getNode(this.link.getEntity1());
    }

    private Cluster getSvekCluster1() {
        return this.bibliotekon.getCluster(this.link.getEntity1());
    }

    private Cluster getSvekCluster2() {
        return this.bibliotekon.getCluster(this.link.getEntity2());
    }

    private boolean isOpalisable() {
        return this.dotPath.getBeziers().size() <= 1;
    }

    private XPoint2D getXY(SvgResult svgResult, int color) {
        int idx = svgResult.getIndexFromColor(color);
        if (idx == -1) {
            return null;
        }
        return SvekUtils.getMinXY(svgResult.substring(idx).extractList("points=\""));
    }

    private StyleSignature getDefaultStyleDefinition(Stereotype stereotype) {
        StyleSignatureBasic result = StyleSignatureBasic.of(SName.root, SName.element, this.diagramType().getStyleName(), SName.arrow);
        return result.withTOBECHANGED(stereotype);
    }

    public void setSharedIds(Set<String> ids) {
        this.ids = ids;
    }

    @Override
    public void drawU(UGraphic ug) {
        MagneticBorder magneticBorder2;
        MagneticBorder magneticBorder1;
        Cluster cl;
        if (this.opale) {
            return;
        }
        if (this.link.isInvis()) {
            return;
        }
        if (this.dotPath == null) {
            Log.info("DotPath is null for " + this);
            return;
        }
        ug.draw(this.link.commentForSvg());
        EnumMap<UGroupType, String> typeIDent = new EnumMap<UGroupType, String>(UGroupType.class);
        typeIDent.put(UGroupType.DATA_UID, this.link.getUid());
        typeIDent.put(UGroupType.CLASS, "link");
        typeIDent.put(UGroupType.ID, "link_" + this.link.getEntity1().getName() + "_" + this.link.getEntity2().getName());
        typeIDent.put(UGroupType.DATA_ENTITY_1, this.link.getEntity1().getName());
        typeIDent.put(UGroupType.DATA_ENTITY_2, this.link.getEntity2().getName());
        typeIDent.put(UGroupType.DATA_ENTITY_1_UID, this.link.getEntity1().getUid());
        typeIDent.put(UGroupType.DATA_ENTITY_2_UID, this.link.getEntity2().getUid());
        if (this.link.getLocation() != null) {
            typeIDent.put(UGroupType.DATA_SOURCE_LINE, "" + this.link.getLocation().getPosition());
        }
        ug.startGroup(typeIDent);
        double x = 0.0;
        double y = 0.0;
        Url url = this.link.getUrl();
        if (url != null) {
            ug.startUrl(url);
        }
        if (this.link.isAutoLinkOfAGroup() && (cl = this.bibliotekon.getCluster(this.link.getEntity1())) != null) {
            x += cl.getRectangleArea().getWidth();
            x -= this.dotPath.getStartPoint().getX() - cl.getRectangleArea().getMinX();
        }
        x += this.dx;
        y += this.dy;
        StyleBuilder currentStyleBuilder = this.getCurrentStyleBuilder();
        Style styleLine = this.getDefaultStyleDefinition(this.getStereotype()).getMergedStyle(currentStyleBuilder);
        UStroke suggestedStroke = styleLine.getStroke();
        Rainbow rainbow = Rainbow.build(styleLine, this.skinParam.getIHtmlColorSet());
        HColor arrowHeadColor = rainbow.getArrowHeadColor();
        HColor color = rainbow.getColor();
        if (this.link.getColors() != null) {
            HColor newColor = this.link.getColors().getColor(ColorType.ARROW, ColorType.LINE);
            if (newColor != null) {
                arrowHeadColor = color = newColor;
            }
        } else if (this.link.getSpecificColor() != null) {
            arrowHeadColor = color = this.link.getSpecificColor();
        }
        ug = ug.apply(HColors.none().bg()).apply(color);
        LinkType linkType = this.link.getType();
        UStroke stroke = suggestedStroke == null || !linkType.getStyle().isNormal() ? linkType.getStroke3(this.defaultThickness) : linkType.getStroke3(suggestedStroke);
        if (this.link.getColors() != null && this.link.getColors().getSpecificLineStroke() != null) {
            stroke = this.link.getColors().getSpecificLineStroke();
        }
        ug = ug.apply(stroke);
        DotPath todraw = this.dotPath.copy();
        UTranslate magneticForce1 = UTranslate.none();
        if (this.getSvekNode1() != null) {
            magneticBorder1 = this.getSvekNode1().getMagneticBorder();
            magneticForce1 = magneticBorder1.getForceAt(ug.getStringBounder(), todraw.getStartPoint().move(this.dx, this.dy));
            todraw.moveStartPoint(magneticForce1);
        } else if (this.getSvekCluster1() != null) {
            magneticBorder1 = this.getSvekCluster1().getMagneticBorder();
            magneticForce1 = magneticBorder1.getForceAt(ug.getStringBounder(), todraw.getStartPoint().move(this.dx, this.dy));
            todraw.moveStartPoint(magneticForce1);
        }
        UTranslate magneticForce2 = UTranslate.none();
        if (this.getSvekNode2() != null) {
            magneticBorder2 = this.getSvekNode2().getMagneticBorder();
            magneticForce2 = magneticBorder2.getForceAt(ug.getStringBounder(), todraw.getEndPoint().move(this.dx, this.dy));
            todraw.moveEndPoint(magneticForce2);
        } else if (this.getSvekCluster2() != null) {
            magneticBorder2 = this.getSvekCluster2().getMagneticBorder();
            magneticForce2 = magneticBorder2.getForceAt(ug.getStringBounder(), todraw.getEndPoint().move(this.dx, this.dy));
            todraw.moveEndPoint(magneticForce2);
        }
        todraw.setCommentAndCodeLine(this.uniq(this.ids, this.link.idCommentForSvg()), this.link.getCodeLine());
        this.drawRainbow(ug.apply(new UTranslate(x, y)), color, arrowHeadColor, todraw, this.link.getSupplementaryColors(), stroke, magneticForce1, magneticForce2);
        ug = ug.apply(UStroke.simple()).apply(color);
        if (this.hasNoteLabelText() && this.labelXY != null && (this.link.getNote() == null || this.link.getNote().getStrategy() != NoteLinkStrategy.HALF_NOT_PRINTED)) {
            this.labelText.drawU(ug.apply(new UTranslate(x + this.labelXY.getPosition().getX() + this.labelShield, y + this.labelXY.getPosition().getY() + this.labelShield)));
        }
        if (this.startTailText != null && this.startTailLabelXY != null && this.startTailLabelXY.getPosition() != null) {
            this.startTailText.drawU(ug.apply(new UTranslate(x + this.startTailLabelXY.getPosition().getX(), y + this.startTailLabelXY.getPosition().getY())));
        }
        if (this.endHeadText != null && this.endHeadLabelXY != null && this.endHeadLabelXY.getPosition() != null) {
            this.endHeadText.drawU(ug.apply(new UTranslate(x + this.endHeadLabelXY.getPosition().getX(), y + this.endHeadLabelXY.getPosition().getY())));
        }
        if (linkType.getMiddleDecor() != LinkMiddleDecor.NONE) {
            PointAndAngle middle = this.dotPath.getMiddle();
            double angleRad = middle.getAngle();
            double angleDeg = -angleRad * 180.0 / Math.PI;
            UDrawable mi = linkType.getMiddleDecor().getMiddleFactory(this.arrowLollipopColor, this.backgroundColor).createUDrawable(angleDeg - 45.0);
            mi.drawU(ug.apply(new UTranslate(x + middle.getX(), y + middle.getY())));
        }
        if (url != null) {
            ug.closeUrl();
        }
        if (this.link.getLinkConstraint() != null) {
            double xConstraint = x + this.labelXY.getPosition().getX();
            double yConstraint = y + this.labelXY.getPosition().getY();
            List<XPoint2D> square = this.getSquare(xConstraint, yConstraint);
            Set<XPoint2D> bez = todraw.sample();
            XPoint2D minPt = null;
            double minDist = Double.MAX_VALUE;
            for (XPoint2D pt : square) {
                for (XPoint2D pt2 : bez) {
                    double distance = pt2.distance(pt);
                    if (minPt != null && !(distance < minDist)) continue;
                    minPt = pt;
                    minDist = distance;
                }
            }
            this.link.getLinkConstraint().setPosition(this.link, minPt);
            this.link.getLinkConstraint().drawMe(ug, this.skinParam);
        }
        ug.closeGroup();
    }

    public void computeKal() {
        UTranslate tr;
        if (this.kal1 != null) {
            tr = UTranslate.point(this.dotPathInit.getStartPoint()).compose(new UTranslate(this.dx, this.dy));
            this.kal1.setTranslate(tr, this.extremity1);
        }
        if (this.kal2 != null) {
            tr = UTranslate.point(this.dotPathInit.getEndPoint()).compose(new UTranslate(this.dx, this.dy));
            this.kal2.setTranslate(tr, this.extremity2);
        }
    }

    private List<XPoint2D> getSquare(double x, double y) {
        ArrayList<XPoint2D> result = new ArrayList<XPoint2D>();
        result.add(new XPoint2D(x, y));
        result.add(new XPoint2D(x + 5.0, y));
        result.add(new XPoint2D(x + 10.0, y));
        result.add(new XPoint2D(x, y + 5.0));
        result.add(new XPoint2D(x + 10.0, y + 5.0));
        result.add(new XPoint2D(x, y + 10.0));
        result.add(new XPoint2D(x + 5.0, y + 10.0));
        result.add(new XPoint2D(x + 10.0, y + 10.0));
        return result;
    }

    private String uniq(Set<String> ids, String comment) {
        boolean changed = ids.add(comment);
        if (changed) {
            return comment;
        }
        int i = 1;
        String candidate;
        while (!(changed = ids.add(candidate = comment + "-" + i))) {
            ++i;
        }
        return candidate;
    }

    private void drawRainbow(UGraphic ug, HColor color, HColor headColor, DotPath todraw, List<Colors> supplementaryColors, UStroke stroke, UTranslate magneticForce1, UTranslate magneticForce2) {
        UGraphic ugHead;
        ug.draw(todraw);
        LinkType linkType = this.link.getType();
        if (headColor.isTransparent()) {
            if (this.extremity1 instanceof ExtremityArrow) {
                ugHead = ug.apply(color).apply(stroke.onlyThickness());
                ((ExtremityArrow)this.extremity1).drawLineIfTransparent(ugHead.apply(magneticForce1));
            }
        } else if (this.extremity1 != null) {
            ugHead = ug.apply(headColor).apply(stroke.onlyThickness());
            ugHead = linkType.getDecor2().isFill() ? ugHead.apply(color.bg()) : ugHead.apply(HColors.none().bg());
            this.extremity1.drawU(ugHead.apply(magneticForce1));
        }
        if (headColor.isTransparent()) {
            if (this.extremity2 instanceof ExtremityArrow) {
                ugHead = ug.apply(color).apply(stroke.onlyThickness());
                ((ExtremityArrow)this.extremity2).drawLineIfTransparent(ugHead.apply(magneticForce2));
            }
        } else if (this.extremity2 != null) {
            ugHead = ug.apply(headColor).apply(stroke.onlyThickness());
            ugHead = linkType.getDecor1().isFill() ? ugHead.apply(color.bg()) : ugHead.apply(HColors.none().bg());
            this.extremity2.drawU(ugHead.apply(magneticForce2));
        }
        int i = 0;
        for (Colors colors : supplementaryColors) {
            ug.apply(new UTranslate(2 * (i + 1), 2 * (i + 1))).apply(colors.getColor(ColorType.LINE)).draw(todraw);
            ++i;
        }
    }

    public boolean isInverted() {
        return this.link.isInverted();
    }

    private double getDecorDzeta() {
        LinkType linkType = this.link.getType();
        int size1 = linkType.getDecor1().getMargin();
        int size2 = linkType.getDecor2().getMargin();
        return size1 + size2;
    }

    public double getHorizontalDzeta(StringBounder stringBounder) {
        if (this.startUid.equalsId(this.endUid)) {
            return this.getDecorDzeta();
        }
        if (!this.isHorizontal()) {
            return 0.0;
        }
        ArithmeticStrategySum strategy = new ArithmeticStrategySum();
        if (this.hasNoteLabelText()) {
            strategy.eat(this.labelText.calculateDimension(stringBounder).getWidth());
        }
        if (this.startTailText != null) {
            strategy.eat(this.startTailText.calculateDimension(stringBounder).getWidth());
        }
        if (this.endHeadText != null) {
            strategy.eat(this.endHeadText.calculateDimension(stringBounder).getWidth());
        }
        return strategy.getResult() + this.getDecorDzeta();
    }

    private boolean isHorizontal() {
        return this.link.getLength() == 1;
    }

    public double getVerticalDzeta(StringBounder stringBounder) {
        if (this.startUid.equalsId(this.endUid)) {
            return this.getDecorDzeta();
        }
        if (this.isHorizontal()) {
            return 0.0;
        }
        ArithmeticStrategySum strategy = new ArithmeticStrategySum();
        if (this.hasNoteLabelText()) {
            strategy.eat(this.labelText.calculateDimension(stringBounder).getHeight());
        }
        if (this.startTailText != null) {
            strategy.eat(this.startTailText.calculateDimension(stringBounder).getHeight());
        }
        if (this.endHeadText != null) {
            strategy.eat(this.endHeadText.calculateDimension(stringBounder).getHeight());
        }
        return strategy.getResult() + this.getDecorDzeta();
    }

    public void manageCollision(Collection<SvekNode> allNodes) {
        for (SvekNode sh : allNodes) {
            Positionable cl = PositionableUtils.addMargin(sh, 8.0, 8.0);
            if (this.startTailText != null && this.startTailLabelXY != null && PositionableUtils.intersect(cl, this.startTailLabelXY)) {
                this.startTailLabelXY = PositionableUtils.moveAwayFrom(cl, this.startTailLabelXY);
            }
            if (this.endHeadText == null || this.endHeadLabelXY == null || !PositionableUtils.intersect(cl, this.endHeadLabelXY)) continue;
            this.endHeadLabelXY = PositionableUtils.moveAwayFrom(cl, this.endHeadLabelXY);
        }
    }

    private XPoint2D avoid2(XPoint2D move, Positionable pos, SvekNode sh) {
        Oscillator oscillator = new Oscillator();
        XPoint2D orig = new XPoint2D(move.x, move.y);
        while (this.cut(pos, sh)) {
            XPoint2D m = oscillator.nextPosition();
            move = new XPoint2D(orig.x + m.x, orig.y + m.y);
        }
        return move;
    }

    private boolean cut(Positionable pos, SvekNode sh) {
        return BezierUtils.intersect(pos, sh) || this.tooClose(pos);
    }

    private boolean tooClose(Positionable pos) {
        XDimension2D dim;
        double dist = this.dotPath.getMinDist(BezierUtils.getCenter(pos));
        return dist < (dim = pos.getSize()).getWidth() / 2.0 + 2.0 || dist < dim.getHeight() / 2.0 + 2.0;
    }

    @Override
    public void moveDelta(double deltaX, double deltaY) {
        this.dx += deltaX;
        this.dy += deltaY;
    }

    public final DotPath getDotPath() {
        DotPath result = this.dotPath.copy();
        result.moveDelta(this.dx, this.dy);
        return result;
    }

    public int getLength() {
        return this.link.getLength();
    }

    public void setOpale(boolean opale) {
        this.link.setOpale(opale);
        this.opale = opale;
    }

    public boolean isOpale() {
        return this.opale;
    }

    public boolean isHorizontalSolitary() {
        return this.link.isHorizontalSolitary();
    }

    public boolean isLinkFromOrTo(Entity group) {
        return this.link.getEntity1() == group || this.link.getEntity2() == group;
    }

    public boolean hasEntryPoint() {
        return this.link.hasEntryPoint();
    }

    public void setProjectionCluster(Cluster cluster) {
        this.projectionCluster = cluster;
    }

    @Override
    public boolean isHidden() {
        return this.link.isHidden();
    }

    public boolean sameConnections(SvekEdge other) {
        return this.link.sameConnections(other.link);
    }

    private boolean isAutolink() {
        return this.link.getEntity1() == this.link.getEntity2();
    }

    public XPoint2D getMyPoint(Entity entity) {
        if (this.link.getEntity1() == entity) {
            return this.moveDelta(this.dotPath.getStartPoint());
        }
        if (this.link.getEntity2() == entity) {
            return this.moveDelta(this.dotPath.getEndPoint());
        }
        throw new IllegalArgumentException();
    }

    private XPoint2D moveDelta(XPoint2D pt) {
        return new UTranslate(this.dx, this.dy).getTranslated(pt);
    }

    public boolean isLink(Link link) {
        return this.link == link;
    }

    public XPoint2D getStartContactPoint() {
        if (this.dotPath == null) {
            return null;
        }
        XPoint2D start = this.dotPath.getStartPoint();
        if (start == null) {
            return null;
        }
        return new UTranslate(this.dx, this.dy).getTranslated(start);
    }

    public XPoint2D getEndContactPoint() {
        XPoint2D end = this.dotPath.getEndPoint();
        if (end == null) {
            return null;
        }
        return new UTranslate(this.dx, this.dy).getTranslated(end);
    }

    public StyleBuilder getCurrentStyleBuilder() {
        return this.link.getStyleBuilder();
    }

    public Stereotype getStereotype() {
        return this.link.getStereotype();
    }

    public void moveStartPoint(double dx, double dy) {
        this.dotPath.moveStartPoint(dx, dy);
        this.dotPathInit.moveStartPoint(dx, dy);
    }

    public void moveEndPoint(double dx, double dy) {
        this.dotPath.moveEndPoint(dx, dy);
        this.dotPathInit.moveEndPoint(dx, dy);
    }
}

