/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.util.office;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.Helper;
import com.sun.jna.platform.win32.COM.util.Factory;
import com.sun.jna.platform.win32.COM.util.office.word.ComIApplication;
import com.sun.jna.platform.win32.COM.util.office.word.ComWord_Application;
import com.sun.jna.platform.win32.COM.util.office.word.WdOriginalFormat;
import com.sun.jna.platform.win32.COM.util.office.word.WdSaveFormat;
import com.sun.jna.platform.win32.Ole32;
import java.io.File;
import java.io.IOException;

public class MSOfficeWordDemo {
    private static final String currentWorkingDir = new File("").getAbsolutePath() + File.separator;

    public static void main(String[] args) throws IOException {
        Ole32.INSTANCE.CoInitializeEx(Pointer.NULL, 0);
        try {
            MSOfficeWordDemo.testMSWord();
        }
        finally {
            Ole32.INSTANCE.CoUninitialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testMSWord() throws IOException {
        File demoDocument = null;
        ComIApplication msWord = null;
        Factory factory = new Factory();
        try {
            System.out.println("Files in temp dir: " + Helper.tempDir.getAbsolutePath());
            ComWord_Application msWordObject = factory.createObject(ComWord_Application.class);
            msWord = msWordObject.queryInterface(ComIApplication.class);
            System.out.println("MSWord version: " + msWord.getVersion());
            msWord.setVisible(true);
            demoDocument = Helper.createNotExistingFile("jnatest", ".doc");
            Helper.extractClasspathFileToReal("/com/sun/jna/platform/win32/COM/util/office/resources/jnatest.doc", demoDocument);
            msWord.getDocuments().Open(demoDocument.getAbsolutePath());
            Helper.sleep(5);
            msWord.getSelection().TypeText("Hello from JNA! \n\n");
            Helper.sleep(10);
            msWord.getActiveDocument().SaveAs(new File(Helper.tempDir, "jnatestSaveAs.doc").getAbsolutePath(), WdSaveFormat.wdFormatDocument);
            msWord.getActiveDocument().SaveAs(new File(Helper.tempDir, "jnatestSaveAs.pdf").getAbsolutePath(), WdSaveFormat.wdFormatPDF);
            msWord.getActiveDocument().SaveAs(new File(Helper.tempDir, "jnatestSaveAs.rtf").getAbsolutePath(), WdSaveFormat.wdFormatRTF);
            msWord.getActiveDocument().SaveAs(new File(Helper.tempDir, "jnatestSaveAs.html").getAbsolutePath(), WdSaveFormat.wdFormatHTML);
            msWord.getActiveDocument().Close(false);
            msWord.getDocuments().Add();
            msWord.getSelection().TypeText("Hello from JNA! \n Please notice that JNA can control MS Word via the new COM interface! \nHere we are creating a new word document and we save it to the 'TEMP' directory!");
            msWord.getActiveDocument().SaveAs(new File(Helper.tempDir, "jnatestNewDoc1.docx").getAbsolutePath(), WdSaveFormat.wdFormatDocumentDefault);
            msWord.getActiveDocument().SaveAs(new File(Helper.tempDir, "jnatestNewDoc2.docx").getAbsolutePath(), WdSaveFormat.wdFormatDocumentDefault);
            msWord.getActiveDocument().SaveAs(new File(Helper.tempDir, "jnatestNewDoc3.docx").getAbsolutePath(), WdSaveFormat.wdFormatDocumentDefault);
            msWord.getActiveDocument().Close(false);
            msWord.getDocuments().Open(new File(Helper.tempDir, "jnatestNewDoc1.docx").getAbsolutePath());
            msWord.getSelection().TypeText("Hello some changes from JNA!\n");
            msWord.getDocuments().Open(new File(Helper.tempDir, "jnatestNewDoc2.docx").getAbsolutePath());
            msWord.getSelection().TypeText("Hello some changes from JNA!\n");
            msWord.getDocuments().Open(new File(Helper.tempDir, "jnatestNewDoc3.docx").getAbsolutePath());
            msWord.getSelection().TypeText("Hello some changes from JNA!\n");
            msWord.getDocuments().Save(false, WdOriginalFormat.wdPromptUser);
        }
        finally {
            if (msWord != null) {
                msWord.Quit();
            }
            factory.disposeAll();
            if (demoDocument != null && demoDocument.exists()) {
                demoDocument.delete();
            }
        }
    }
}

