/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class RegularSequenceChecker
extends ProxyReceiver {
    private Stack<Integer> stack = new Stack();
    private State state = State.Initial;
    private static Map<State, Map<String, State>> machine = new HashMap<State, Map<String, State>>();

    static void edge(State from, String event, State to) {
        Map edges = machine.computeIfAbsent(from, s2 -> new HashMap());
        edges.put(event, to);
    }

    private void transition(String event) {
        State newState = machine.get((Object)this.state).get(event);
        if (newState == null) {
            throw new IllegalStateException("Event " + event + " is not permitted in state " + (Object)((Object)this.state));
        }
        this.state = newState;
    }

    public RegularSequenceChecker(Receiver nextReceiver) {
        super(nextReceiver);
    }

    @Override
    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        this.transition("append");
        this.nextReceiver.append(item, locationId, copyNamespaces);
    }

    @Override
    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        this.transition("attribute");
        this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.transition("text");
        if (chars.length() == 0 && !this.stack.isEmpty()) {
            throw new IllegalStateException("Zero-length text nodes not allowed within document/element content");
        }
        this.nextReceiver.characters(chars, locationId, properties);
    }

    @Override
    public void close() throws XPathException {
        if (this.state != State.Final) {
            this.nextReceiver.close();
            this.state = State.Final;
        }
    }

    @Override
    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.transition("comment");
        this.nextReceiver.comment(chars, locationId, properties);
    }

    @Override
    public void endDocument() throws XPathException {
        this.transition("endDocument");
        if (this.stack.isEmpty() || this.stack.pop() != 0) {
            throw new IllegalStateException("Unmatched endDocument() call");
        }
        this.nextReceiver.endDocument();
    }

    @Override
    public void endElement() throws XPathException {
        this.transition("endElement");
        if (this.stack.isEmpty() || this.stack.pop() != 1) {
            throw new IllegalStateException("Unmatched endElement() call");
        }
        if (this.stack.isEmpty()) {
            this.state = State.Open;
        }
        this.nextReceiver.endElement();
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        this.transition("namespace");
        this.nextReceiver.namespace(namespaceBindings, properties);
    }

    @Override
    public void open() throws XPathException {
        this.transition("open");
        this.nextReceiver.open();
    }

    @Override
    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
        this.transition("pi");
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
    }

    @Override
    public void startContent() throws XPathException {
        this.transition("startContent");
        this.nextReceiver.startContent();
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        this.transition("startDocument");
        this.stack.push(0);
        this.nextReceiver.startDocument(properties);
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.transition("startElement");
        this.stack.push(1);
        this.nextReceiver.startElement(nameCode, typeCode, location, properties);
    }

    static {
        RegularSequenceChecker.edge(State.Initial, "open", State.Open);
        RegularSequenceChecker.edge(State.Open, "append", State.Open);
        RegularSequenceChecker.edge(State.Open, "text", State.Open);
        RegularSequenceChecker.edge(State.Open, "comment", State.Open);
        RegularSequenceChecker.edge(State.Open, "pi", State.Open);
        RegularSequenceChecker.edge(State.Open, "attribute", State.Open);
        RegularSequenceChecker.edge(State.Open, "namespace", State.Open);
        RegularSequenceChecker.edge(State.Open, "startDocument", State.Content);
        RegularSequenceChecker.edge(State.Open, "startElement", State.StartTag);
        RegularSequenceChecker.edge(State.StartTag, "attribute", State.StartTag);
        RegularSequenceChecker.edge(State.StartTag, "namespace", State.StartTag);
        RegularSequenceChecker.edge(State.StartTag, "startContent", State.Content);
        RegularSequenceChecker.edge(State.Content, "text", State.Content);
        RegularSequenceChecker.edge(State.Content, "comment", State.Content);
        RegularSequenceChecker.edge(State.Content, "pi", State.Content);
        RegularSequenceChecker.edge(State.Content, "startElement", State.StartTag);
        RegularSequenceChecker.edge(State.Content, "endElement", State.Content);
        RegularSequenceChecker.edge(State.Content, "endDocument", State.Open);
        RegularSequenceChecker.edge(State.Open, "close", State.Final);
    }

    public static enum State {
        Initial,
        Open,
        StartTag,
        Content,
        Final;

    }
}

