/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jxmpp.jid.BareJid;

public final class RosterPacket
extends IQ {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "jabber:iq:roster";
    private final List<Item> rosterItems = new ArrayList<Item>();
    private String rosterVersion;

    public RosterPacket() {
        super(ELEMENT, NAMESPACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRosterItem(Item item) {
        List<Item> list2 = this.rosterItems;
        synchronized (list2) {
            this.rosterItems.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRosterItemCount() {
        List<Item> list2 = this.rosterItems;
        synchronized (list2) {
            return this.rosterItems.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Item> getRosterItems() {
        List<Item> list2 = this.rosterItems;
        synchronized (list2) {
            return new ArrayList<Item>(this.rosterItems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.optAttribute("ver", this.rosterVersion);
        buf.rightAngleBracket();
        List<Item> list2 = this.rosterItems;
        synchronized (list2) {
            for (Item entry : this.rosterItems) {
                buf.append(entry.toXML());
            }
        }
        return buf;
    }

    public String getVersion() {
        return this.rosterVersion;
    }

    public void setVersion(String version) {
        this.rosterVersion = version;
    }

    public static final class Item
    implements ExtensionElement {
        public static final String ELEMENT = "item";
        public static final QName QNAME = new QName("jabber:iq:roster", "item");
        public static final String GROUP = "group";
        private final BareJid jid;
        private boolean subscriptionPending;
        private String name;
        private ItemType itemType = ItemType.none;
        private boolean approved;
        private final Set<String> groupNames;

        public Item(BareJid jid, String name) {
            this(jid, name, false);
        }

        public Item(BareJid jid, String name, boolean subscriptionPending) {
            this.jid = Objects.requireNonNull(jid);
            this.name = name;
            this.subscriptionPending = subscriptionPending;
            this.groupNames = new CopyOnWriteArraySet<String>();
        }

        @Override
        public String getElementName() {
            return QNAME.getLocalPart();
        }

        @Override
        public String getNamespace() {
            return QNAME.getNamespaceURI();
        }

        @Deprecated
        public String getUser() {
            return this.jid.toString();
        }

        public BareJid getJid() {
            return this.jid;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public ItemType getItemType() {
            return this.itemType;
        }

        public void setItemType(ItemType itemType) {
            this.itemType = Objects.requireNonNull(itemType, "itemType must not be null");
        }

        public void setSubscriptionPending(boolean subscriptionPending) {
            this.subscriptionPending = subscriptionPending;
        }

        public boolean isSubscriptionPending() {
            return this.subscriptionPending;
        }

        public boolean isApproved() {
            return this.approved;
        }

        public void setApproved(boolean approved) {
            this.approved = approved;
        }

        public Set<String> getGroupNames() {
            return Collections.unmodifiableSet(this.groupNames);
        }

        public void addGroupName(String groupName) {
            this.groupNames.add(groupName);
        }

        public void removeGroupName(String groupName) {
            this.groupNames.remove(groupName);
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder(this, enclosingNamespace);
            xml.attribute("jid", this.jid);
            xml.optAttribute("name", this.name);
            xml.optAttribute("subscription", this.itemType);
            if (this.subscriptionPending) {
                xml.append(" ask='subscribe'");
            }
            xml.optBooleanAttribute("approved", this.approved);
            xml.rightAngleBracket();
            for (String groupName : this.groupNames) {
                xml.openElement(GROUP).escape(groupName).closeElement(GROUP);
            }
            xml.closeElement(this);
            return xml;
        }

        public int hashCode() {
            return HashCode.builder().append(this.groupNames).append(this.subscriptionPending).append((Object)this.itemType).append(this.name).append(this.jid).append(this.approved).build();
        }

        public boolean equals(Object obj) {
            return EqualsUtil.equals(this, obj, (e, o) -> e.append(this.groupNames, o.groupNames).append(this.subscriptionPending, o.subscriptionPending).append(this.itemType, o.itemType).append(this.name, o.name).append(this.jid, o.jid).append(this.approved, o.approved));
        }
    }

    public static enum ItemType {
        none('\u22a5'),
        to('\u2190'),
        from('\u2192'),
        both('\u2194'),
        remove('\u26a1');

        private static final char ME = '\u25cf';
        private final String symbol;

        private ItemType(char secondSymbolChar) {
            StringBuilder sb = new StringBuilder(2);
            sb.append('\u25cf').append(secondSymbolChar);
            this.symbol = sb.toString();
        }

        public static ItemType fromString(String string2) {
            if (StringUtils.isNullOrEmpty((CharSequence)string2)) {
                return none;
            }
            return ItemType.valueOf(string2.toLowerCase(Locale.US));
        }

        public String asSymbol() {
            return this.symbol;
        }
    }
}

