/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jxmpp.JxmppContext;

public class DiscoverInfoProvider
extends IqProvider<DiscoverInfo> {
    @Override
    public DiscoverInfo parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException, SmackParsingException {
        DiscoverInfoBuilder discoverInfoBuilder = DiscoverInfo.builder(iqData);
        String node = parser.getAttributeValue("node");
        discoverInfoBuilder.setNode(node);
        while (true) {
            XmlPullParser.Event eventType;
            if ((eventType = parser.next()) == XmlPullParser.Event.START_ELEMENT) {
                String name = parser.getName();
                String namespace = parser.getNamespace();
                if (namespace.equals("http://jabber.org/protocol/disco#info")) {
                    switch (name) {
                        case "identity": {
                            String category = parser.getAttributeValue("category");
                            String identityName = parser.getAttributeValue("name");
                            String type = parser.getAttributeValue("type");
                            String lang = ParserUtils.getXmlLang(parser);
                            DiscoverInfo.Identity identity = new DiscoverInfo.Identity(category, type, identityName, lang);
                            discoverInfoBuilder.addIdentity(identity);
                            break;
                        }
                        case "feature": {
                            String feature = parser.getAttributeValue("var");
                            discoverInfoBuilder.addFeature(feature);
                        }
                    }
                    continue;
                }
                PacketParserUtils.addExtensionElement(discoverInfoBuilder, parser, xmlEnvironment, jxmppContext);
                continue;
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT && parser.getDepth() == initialDepth) break;
        }
        DiscoverInfo discoverInfo = discoverInfoBuilder.buildWithoutValidiation();
        return discoverInfo;
    }
}

