/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.fallback_indication;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.AsyncButOrdered;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.fallback_indication.FallbackIndicationListener;
import org.jivesoftware.smackx.fallback_indication.element.FallbackIndicationElement;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityBareJid;

public final class FallbackIndicationManager
extends Manager {
    private static final Map<XMPPConnection, FallbackIndicationManager> INSTANCES = new WeakHashMap<XMPPConnection, FallbackIndicationManager>();
    private final Set<FallbackIndicationListener> listeners = new CopyOnWriteArraySet<FallbackIndicationListener>();
    private final AsyncButOrdered<BareJid> asyncButOrdered = new AsyncButOrdered();
    private final StanzaFilter fallbackIndicationElementFilter = new AndFilter(StanzaTypeFilter.MESSAGE, new StanzaExtensionFilter("fallback", "urn:xmpp:fallback:0"));

    private void fallbackIndicationElementListener(Stanza packet) {
        Message message = (Message)packet;
        FallbackIndicationElement indicator = FallbackIndicationElement.fromMessage(message);
        String body = message.getBody();
        this.asyncButOrdered.performAsyncButOrdered(message.getFrom().asBareJid(), () -> {
            for (FallbackIndicationListener l : this.listeners) {
                l.onFallbackIndicationReceived(message, indicator, body);
            }
        });
    }

    private FallbackIndicationManager(XMPPConnection connection) {
        super(connection);
        connection.addAsyncStanzaListener(this::fallbackIndicationElementListener, this.fallbackIndicationElementFilter);
        ServiceDiscoveryManager.getInstanceFor(connection).addFeature("urn:xmpp:fallback:0");
    }

    public static synchronized FallbackIndicationManager getInstanceFor(XMPPConnection connection) {
        FallbackIndicationManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new FallbackIndicationManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    public boolean userSupportsFallbackIndications(EntityBareJid jid) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(jid, "urn:xmpp:fallback:0");
    }

    public boolean serverSupportsFallbackIndications() throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).serverSupportsFeature("urn:xmpp:fallback:0");
    }

    public static MessageBuilder addFallbackIndicationWithBody(MessageBuilder messageBuilder, String fallbackMessageBody) {
        return FallbackIndicationManager.addFallbackIndication(messageBuilder).setBody(fallbackMessageBody);
    }

    public static MessageBuilder addFallbackIndication(MessageBuilder messageBuilder) {
        return (MessageBuilder)messageBuilder.addExtension(new FallbackIndicationElement());
    }

    public synchronized void addFallbackIndicationListener(FallbackIndicationListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeFallbackIndicationListener(FallbackIndicationListener listener) {
        this.listeners.remove(listener);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection connection) {
                FallbackIndicationManager.getInstanceFor(connection);
            }
        });
    }
}

