/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muclight.element;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.muclight.MUCLightAffiliation;
import org.jivesoftware.smackx.muclight.MUCLightRoomConfiguration;
import org.jivesoftware.smackx.muclight.element.MUCLightElements;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;

public class MUCLightCreateIQ
extends IQ {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "urn:xmpp:muclight:0#create";
    private MUCLightRoomConfiguration configuration;
    private final Map<Jid, MUCLightAffiliation> occupants;

    public MUCLightCreateIQ(EntityJid room, String roomName, String subject, Map<String, String> customConfigs, List<Jid> occupants) {
        super(ELEMENT, NAMESPACE);
        this.configuration = new MUCLightRoomConfiguration(roomName, subject, customConfigs);
        this.occupants = new HashMap<Jid, MUCLightAffiliation>();
        for (Jid occupant : occupants) {
            this.occupants.put(occupant, MUCLightAffiliation.member);
        }
        this.setType(IQ.Type.set);
        this.setTo(room);
    }

    public MUCLightCreateIQ(EntityJid room, String roomName, List<Jid> occupants) {
        this(room, roomName, null, null, occupants);
    }

    public MUCLightRoomConfiguration getConfiguration() {
        return this.configuration;
    }

    public Map<Jid, MUCLightAffiliation> getOccupants() {
        return this.occupants;
    }

    @Override
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        xml.rightAngleBracket();
        xml.append(new MUCLightElements.ConfigurationElement(this.configuration));
        if (!this.occupants.isEmpty()) {
            xml.append(new MUCLightElements.OccupantsElement(this.occupants));
        }
        return xml;
    }
}

