/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muclight.provider;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.muclight.element.MUCLightBlockingIQ;
import org.jxmpp.JxmppContext;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class MUCLightBlockingIQProvider
extends IqProvider<MUCLightBlockingIQ> {
    @Override
    public MUCLightBlockingIQ parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
        Map<Jid, Boolean> rooms = null;
        Map<Jid, Boolean> users = null;
        while (true) {
            XmlPullParser.Event eventType;
            if ((eventType = parser.next()) == XmlPullParser.Event.START_ELEMENT) {
                if (parser.getName().equals("room")) {
                    rooms = MUCLightBlockingIQProvider.parseBlocking(parser, rooms);
                }
                if (!parser.getName().equals("user")) continue;
                users = MUCLightBlockingIQProvider.parseBlocking(parser, users);
                continue;
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT && parser.getDepth() == initialDepth) break;
        }
        MUCLightBlockingIQ mucLightBlockingIQ = new MUCLightBlockingIQ(rooms, users);
        mucLightBlockingIQ.setType(IQ.Type.result);
        return mucLightBlockingIQ;
    }

    private static Map<Jid, Boolean> parseBlocking(XmlPullParser parser, Map<Jid, Boolean> map) throws XmppStringprepException, XmlPullParserException, IOException {
        String action;
        if (map == null) {
            map = new HashMap<Jid, Boolean>();
        }
        if ((action = parser.getAttributeValue("", "action")).equals("deny")) {
            map.put(JidCreate.from(parser.nextText()), false);
        } else if (action.equals("allow")) {
            map.put(JidCreate.from(parser.nextText()), true);
        }
        return map;
    }
}

