/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.hla;

import java.util.Collections;
import java.util.Set;
import org.minidns.MiniDnsException;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsqueryresult.DnsQueryResult;
import org.minidns.dnssec.DnssecResultNotAuthenticException;
import org.minidns.dnssec.DnssecUnverifiedReason;
import org.minidns.hla.ResolutionUnsuccessfulException;
import org.minidns.record.Data;

public class ResolverResult<D extends Data> {
    protected final Question question;
    private final DnsMessage.RESPONSE_CODE responseCode;
    private final Set<D> data;
    private final boolean isAuthenticData;
    protected final Set<DnssecUnverifiedReason> unverifiedReasons;
    protected final DnsMessage answer;
    protected final DnsQueryResult result;
    private ResolutionUnsuccessfulException resolutionUnsuccessfulException;
    private DnssecResultNotAuthenticException dnssecResultNotAuthenticException;

    ResolverResult(Question question, DnsQueryResult result, Set<DnssecUnverifiedReason> unverifiedReasons) throws MiniDnsException.NullResultException {
        if (result == null) {
            throw new MiniDnsException.NullResultException(question.asMessageBuilder().build());
        }
        this.result = result;
        DnsMessage answer = result.response;
        this.question = question;
        this.responseCode = answer.responseCode;
        this.answer = answer;
        Set r = answer.getAnswersFor(question);
        this.data = r == null ? Collections.emptySet() : Collections.unmodifiableSet(r);
        if (unverifiedReasons == null) {
            this.unverifiedReasons = null;
            this.isAuthenticData = false;
        } else {
            this.unverifiedReasons = Collections.unmodifiableSet(unverifiedReasons);
            this.isAuthenticData = this.unverifiedReasons.isEmpty();
        }
    }

    public boolean wasSuccessful() {
        return this.responseCode == DnsMessage.RESPONSE_CODE.NO_ERROR;
    }

    public Set<D> getAnswers() {
        this.throwIseIfErrorResponse();
        return this.data;
    }

    public Set<D> getAnswersOrEmptySet() {
        return this.data;
    }

    public DnsMessage.RESPONSE_CODE getResponseCode() {
        return this.responseCode;
    }

    public boolean isAuthenticData() {
        this.throwIseIfErrorResponse();
        return this.isAuthenticData;
    }

    public Set<DnssecUnverifiedReason> getUnverifiedReasons() {
        this.throwIseIfErrorResponse();
        return this.unverifiedReasons;
    }

    public Question getQuestion() {
        return this.question;
    }

    public void throwIfErrorResponse() throws ResolutionUnsuccessfulException {
        ResolutionUnsuccessfulException resolutionUnsuccessfulException = this.getResolutionUnsuccessfulException();
        if (resolutionUnsuccessfulException != null) {
            throw resolutionUnsuccessfulException;
        }
    }

    public ResolutionUnsuccessfulException getResolutionUnsuccessfulException() {
        if (this.wasSuccessful()) {
            return null;
        }
        if (this.resolutionUnsuccessfulException == null) {
            this.resolutionUnsuccessfulException = new ResolutionUnsuccessfulException(this.question, this.responseCode);
        }
        return this.resolutionUnsuccessfulException;
    }

    public DnssecResultNotAuthenticException getDnssecResultNotAuthenticException() {
        if (!this.wasSuccessful()) {
            return null;
        }
        if (this.isAuthenticData) {
            return null;
        }
        if (this.dnssecResultNotAuthenticException == null) {
            this.dnssecResultNotAuthenticException = DnssecResultNotAuthenticException.from(this.getUnverifiedReasons());
        }
        return this.dnssecResultNotAuthenticException;
    }

    public DnsMessage getRawAnswer() {
        return this.answer;
    }

    public DnsQueryResult getDnsQueryResult() {
        return this.result;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append('\n').append("Question: ").append(this.question).append('\n').append("Response Code: ").append((Object)this.responseCode).append('\n');
        if (this.responseCode == DnsMessage.RESPONSE_CODE.NO_ERROR) {
            if (this.isAuthenticData) {
                sb.append("Results verified via DNSSEC\n");
            }
            if (this.hasUnverifiedReasons()) {
                sb.append(this.unverifiedReasons).append('\n');
            }
            sb.append(this.answer.answerSection);
        }
        return sb.toString();
    }

    boolean hasUnverifiedReasons() {
        return this.unverifiedReasons != null && !this.unverifiedReasons.isEmpty();
    }

    protected void throwIseIfErrorResponse() {
        ResolutionUnsuccessfulException resolutionUnsuccessfulException = this.getResolutionUnsuccessfulException();
        if (resolutionUnsuccessfulException != null) {
            throw new IllegalStateException("Can not perform operation because the DNS resolution was unsuccessful", resolutionUnsuccessfulException);
        }
    }
}

