/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification.syntax_check;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.pgpainless.decryption_verification.syntax_check.InputSymbol;
import org.pgpainless.decryption_verification.syntax_check.OpenPgpMessageSyntax;
import org.pgpainless.decryption_verification.syntax_check.StackSymbol;
import org.pgpainless.decryption_verification.syntax_check.State;
import org.pgpainless.decryption_verification.syntax_check.Syntax;
import org.pgpainless.decryption_verification.syntax_check.Transition;
import org.pgpainless.exception.MalformedOpenPgpMessageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDA {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDA.class);
    private final Syntax syntax;
    private final Stack<StackSymbol> stack = new Stack();
    private final List<InputSymbol> inputs = new ArrayList<InputSymbol>();
    private State state;

    public PDA() {
        this(new OpenPgpMessageSyntax(), State.OpenPgpMessage, StackSymbol.terminus, StackSymbol.msg);
    }

    public PDA(@Nonnull Syntax syntax, @Nonnull State initialState, StackSymbol ... initialStack) {
        this.syntax = syntax;
        this.state = initialState;
        for (StackSymbol symbol : initialStack) {
            this.pushStack(symbol);
        }
    }

    public void next(@Nonnull InputSymbol input) throws MalformedOpenPgpMessageException {
        StackSymbol stackSymbol = this.popStack();
        try {
            Transition transition = this.syntax.transition(this.state, input, stackSymbol);
            this.state = transition.getNewState();
            for (StackSymbol item : transition.getPushedItems()) {
                this.pushStack(item);
            }
            this.inputs.add(input);
        }
        catch (MalformedOpenPgpMessageException e) {
            MalformedOpenPgpMessageException wrapped = new MalformedOpenPgpMessageException("Malformed message: After reading packet sequence " + Arrays.toString(this.inputs.toArray()) + ", token '" + (Object)((Object)input) + "' is not allowed.\nNo transition from state '" + (Object)((Object)this.state) + "' with stack " + Arrays.toString(this.stack.toArray()) + (stackSymbol != null ? "||'" + (Object)((Object)stackSymbol) + "'." : "."), e);
            LOGGER.debug("Invalid input '" + (Object)((Object)input) + "'", wrapped);
            throw wrapped;
        }
    }

    @Nonnull
    public State getState() {
        return this.state;
    }

    @Nullable
    public StackSymbol peekStack() {
        if (this.stack.isEmpty()) {
            return null;
        }
        return this.stack.peek();
    }

    public boolean isValid() {
        return this.getState() == State.Valid && this.stack.isEmpty();
    }

    public void assertValid() throws MalformedOpenPgpMessageException {
        if (!this.isValid()) {
            throw new MalformedOpenPgpMessageException("Pushdown Automaton is not in an acceptable state: " + this.toString());
        }
    }

    private StackSymbol popStack() {
        if (this.stack.isEmpty()) {
            return null;
        }
        return this.stack.pop();
    }

    private void pushStack(StackSymbol item) {
        this.stack.push(item);
    }

    public String toString() {
        return "State: " + (Object)((Object)this.state) + " Stack: " + this.stack;
    }
}

