/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.pgpainless.key.OpenPgpFingerprint;

public class SubkeyIdentifier {
    private final OpenPgpFingerprint primaryKeyFingerprint;
    private final OpenPgpFingerprint subkeyFingerprint;

    public SubkeyIdentifier(PGPKeyRing keyRing) {
        this(keyRing, keyRing.getPublicKey().getKeyID());
    }

    public SubkeyIdentifier(@Nonnull PGPKeyRing keyRing, long keyId) {
        PGPPublicKey subkey = keyRing.getPublicKey(keyId);
        if (subkey == null) {
            throw new NoSuchElementException("Key ring does not contain subkey with id " + Long.toHexString(keyId));
        }
        this.primaryKeyFingerprint = OpenPgpFingerprint.of(keyRing);
        this.subkeyFingerprint = OpenPgpFingerprint.of(subkey);
    }

    public SubkeyIdentifier(@Nonnull PGPKeyRing keyRing, @Nonnull OpenPgpFingerprint subkeyFingerprint) {
        this(OpenPgpFingerprint.of(keyRing), subkeyFingerprint);
    }

    public SubkeyIdentifier(@Nonnull OpenPgpFingerprint primaryKeyFingerprint) {
        this(primaryKeyFingerprint, primaryKeyFingerprint);
    }

    public SubkeyIdentifier(@Nonnull OpenPgpFingerprint primaryKeyFingerprint, @Nonnull OpenPgpFingerprint subkeyFingerprint) {
        this.primaryKeyFingerprint = primaryKeyFingerprint;
        this.subkeyFingerprint = subkeyFingerprint;
    }

    @Nonnull
    public OpenPgpFingerprint getFingerprint() {
        return this.getSubkeyFingerprint();
    }

    public long getKeyId() {
        return this.getSubkeyId();
    }

    @Nonnull
    public OpenPgpFingerprint getPrimaryKeyFingerprint() {
        return this.primaryKeyFingerprint;
    }

    public long getPrimaryKeyId() {
        return this.getPrimaryKeyFingerprint().getKeyId();
    }

    @Nonnull
    public OpenPgpFingerprint getSubkeyFingerprint() {
        return this.subkeyFingerprint;
    }

    public long getSubkeyId() {
        return this.getSubkeyFingerprint().getKeyId();
    }

    public int hashCode() {
        return this.primaryKeyFingerprint.hashCode() * 31 + this.subkeyFingerprint.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SubkeyIdentifier)) {
            return false;
        }
        SubkeyIdentifier other = (SubkeyIdentifier)obj;
        return this.getPrimaryKeyFingerprint().equals(other.getPrimaryKeyFingerprint()) && this.getSubkeyFingerprint().equals(other.getSubkeyFingerprint());
    }

    public String toString() {
        return this.getSubkeyFingerprint() + " " + this.getPrimaryKeyFingerprint();
    }
}

