/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.functors;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.BiPredicate;

@FunctionalInterface
public interface UnaryEquator<T>
extends BiPredicate<T, T> {
    default public UnaryEquator<T> and(UnaryEquator<? super T> other) {
        Objects.requireNonNull(other, "No other equator to compose");
        return (t1, t2) -> this.test(t1, t2) && other.test(t1, t2);
    }

    default public UnaryEquator<T> or(UnaryEquator<? super T> other) {
        Objects.requireNonNull(other, "No other equator to compose");
        return (t1, t2) -> this.test(t1, t2) || other.test(t1, t2);
    }

    default public UnaryEquator<T> negate() {
        return (t1, t2) -> !this.test(t1, t2);
    }

    public static <T> boolean isSameReference(T o1, T o2) {
        return o1 == o2;
    }

    public static <T> UnaryEquator<T> defaultEquality() {
        return Objects::equals;
    }

    public static <T> UnaryEquator<T> referenceEquality() {
        return UnaryEquator::isSameReference;
    }

    public static <T> UnaryEquator<T> comparing(Comparator<? super T> c) {
        Objects.requireNonNull(c, "No comparator");
        return (o1, o2) -> c.compare(o1, o2) == 0;
    }

    public static <T> UnaryEquator<T> verum() {
        return (o1, o2) -> true;
    }

    public static <T> UnaryEquator<T> falsum() {
        return (o1, o2) -> false;
    }
}

