// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// Billing20201105StatementState StatementState represents the current state of this statement.
//
//   - STATEMENT_STATE_UNSET: STATEMENT_STATE_UNSET means the current state of the statement is not set or not specified.
//   - STATEMENT_STATE_RUNNING: STATEMENT_STATE_RUNNING is for the latest current billing period statement.
//
// Only one running statement per billing period per billing account at a time.
//   - STATEMENT_STATE_PAID: STATEMENT_STATE_PAID for FCP is when a statement is recognized.
//
// Paid for PAYG is when stripe invoice is paid.
//   - STATEMENT_STATE_SUBMITTED: STATEMENT_STATE_SUBMITTED means the statement was sent for collection and can no longer
//
// be changed. It's yet to be paid.
//   - STATEMENT_STATE_WONTPAY: STATEMENT_STATE_WONTPAY means that attempts to collect money for the payment were exhausted.
//
// This also means the account could enter the delinquency flow because of this.
//   - STATEMENT_STATE_VOID: STATEMENT_STATE_VOID means that this statement must be ignored as it is not valid anymore.
//
// swagger:model billing_20201105StatementState
type Billing20201105StatementState string

func NewBilling20201105StatementState(value Billing20201105StatementState) *Billing20201105StatementState {
	return &value
}

// Pointer returns a pointer to a freshly-allocated Billing20201105StatementState.
func (m Billing20201105StatementState) Pointer() *Billing20201105StatementState {
	return &m
}

const (

	// Billing20201105StatementStateSTATEMENTSTATEUNSET captures enum value "STATEMENT_STATE_UNSET"
	Billing20201105StatementStateSTATEMENTSTATEUNSET Billing20201105StatementState = "STATEMENT_STATE_UNSET"

	// Billing20201105StatementStateSTATEMENTSTATERUNNING captures enum value "STATEMENT_STATE_RUNNING"
	Billing20201105StatementStateSTATEMENTSTATERUNNING Billing20201105StatementState = "STATEMENT_STATE_RUNNING"

	// Billing20201105StatementStateSTATEMENTSTATEPAID captures enum value "STATEMENT_STATE_PAID"
	Billing20201105StatementStateSTATEMENTSTATEPAID Billing20201105StatementState = "STATEMENT_STATE_PAID"

	// Billing20201105StatementStateSTATEMENTSTATESUBMITTED captures enum value "STATEMENT_STATE_SUBMITTED"
	Billing20201105StatementStateSTATEMENTSTATESUBMITTED Billing20201105StatementState = "STATEMENT_STATE_SUBMITTED"

	// Billing20201105StatementStateSTATEMENTSTATEWONTPAY captures enum value "STATEMENT_STATE_WONTPAY"
	Billing20201105StatementStateSTATEMENTSTATEWONTPAY Billing20201105StatementState = "STATEMENT_STATE_WONTPAY"

	// Billing20201105StatementStateSTATEMENTSTATEVOID captures enum value "STATEMENT_STATE_VOID"
	Billing20201105StatementStateSTATEMENTSTATEVOID Billing20201105StatementState = "STATEMENT_STATE_VOID"
)

// for schema
var billing20201105StatementStateEnum []interface{}

func init() {
	var res []Billing20201105StatementState
	if err := json.Unmarshal([]byte(`["STATEMENT_STATE_UNSET","STATEMENT_STATE_RUNNING","STATEMENT_STATE_PAID","STATEMENT_STATE_SUBMITTED","STATEMENT_STATE_WONTPAY","STATEMENT_STATE_VOID"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		billing20201105StatementStateEnum = append(billing20201105StatementStateEnum, v)
	}
}

func (m Billing20201105StatementState) validateBilling20201105StatementStateEnum(path, location string, value Billing20201105StatementState) error {
	if err := validate.EnumCase(path, location, value, billing20201105StatementStateEnum, true); err != nil {
		return err
	}
	return nil
}

// Validate validates this billing 20201105 statement state
func (m Billing20201105StatementState) Validate(formats strfmt.Registry) error {
	var res []error

	// value enum
	if err := m.validateBilling20201105StatementStateEnum("", "body", m); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validates this billing 20201105 statement state based on context it is used
func (m Billing20201105StatementState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}
