// Code generated by go-swagger; DO NOT EDIT.

package groups_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGroupsServiceCountGroupsForPrincipalsParams creates a new GroupsServiceCountGroupsForPrincipalsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGroupsServiceCountGroupsForPrincipalsParams() *GroupsServiceCountGroupsForPrincipalsParams {
	return &GroupsServiceCountGroupsForPrincipalsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGroupsServiceCountGroupsForPrincipalsParamsWithTimeout creates a new GroupsServiceCountGroupsForPrincipalsParams object
// with the ability to set a timeout on a request.
func NewGroupsServiceCountGroupsForPrincipalsParamsWithTimeout(timeout time.Duration) *GroupsServiceCountGroupsForPrincipalsParams {
	return &GroupsServiceCountGroupsForPrincipalsParams{
		timeout: timeout,
	}
}

// NewGroupsServiceCountGroupsForPrincipalsParamsWithContext creates a new GroupsServiceCountGroupsForPrincipalsParams object
// with the ability to set a context for a request.
func NewGroupsServiceCountGroupsForPrincipalsParamsWithContext(ctx context.Context) *GroupsServiceCountGroupsForPrincipalsParams {
	return &GroupsServiceCountGroupsForPrincipalsParams{
		Context: ctx,
	}
}

// NewGroupsServiceCountGroupsForPrincipalsParamsWithHTTPClient creates a new GroupsServiceCountGroupsForPrincipalsParams object
// with the ability to set a custom HTTPClient for a request.
func NewGroupsServiceCountGroupsForPrincipalsParamsWithHTTPClient(client *http.Client) *GroupsServiceCountGroupsForPrincipalsParams {
	return &GroupsServiceCountGroupsForPrincipalsParams{
		HTTPClient: client,
	}
}

/*
GroupsServiceCountGroupsForPrincipalsParams contains all the parameters to send to the API endpoint

	for the groups service count groups for principals operation.

	Typically these are written to a http.Request.
*/
type GroupsServiceCountGroupsForPrincipalsParams struct {

	/* ParentResourceName.

	     parent_resource is the parent resource of the groups that should be counted per principal
	organization/<org_id>
	*/
	ParentResourceName string

	/* PrincipalIds.

	   principal_ids is a list of the ids for which to count groups.
	*/
	PrincipalIds []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the groups service count groups for principals params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupsServiceCountGroupsForPrincipalsParams) WithDefaults() *GroupsServiceCountGroupsForPrincipalsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the groups service count groups for principals params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupsServiceCountGroupsForPrincipalsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the groups service count groups for principals params
func (o *GroupsServiceCountGroupsForPrincipalsParams) WithTimeout(timeout time.Duration) *GroupsServiceCountGroupsForPrincipalsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the groups service count groups for principals params
func (o *GroupsServiceCountGroupsForPrincipalsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the groups service count groups for principals params
func (o *GroupsServiceCountGroupsForPrincipalsParams) WithContext(ctx context.Context) *GroupsServiceCountGroupsForPrincipalsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the groups service count groups for principals params
func (o *GroupsServiceCountGroupsForPrincipalsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the groups service count groups for principals params
func (o *GroupsServiceCountGroupsForPrincipalsParams) WithHTTPClient(client *http.Client) *GroupsServiceCountGroupsForPrincipalsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the groups service count groups for principals params
func (o *GroupsServiceCountGroupsForPrincipalsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithParentResourceName adds the parentResourceName to the groups service count groups for principals params
func (o *GroupsServiceCountGroupsForPrincipalsParams) WithParentResourceName(parentResourceName string) *GroupsServiceCountGroupsForPrincipalsParams {
	o.SetParentResourceName(parentResourceName)
	return o
}

// SetParentResourceName adds the parentResourceName to the groups service count groups for principals params
func (o *GroupsServiceCountGroupsForPrincipalsParams) SetParentResourceName(parentResourceName string) {
	o.ParentResourceName = parentResourceName
}

// WithPrincipalIds adds the principalIds to the groups service count groups for principals params
func (o *GroupsServiceCountGroupsForPrincipalsParams) WithPrincipalIds(principalIds []string) *GroupsServiceCountGroupsForPrincipalsParams {
	o.SetPrincipalIds(principalIds)
	return o
}

// SetPrincipalIds adds the principalIds to the groups service count groups for principals params
func (o *GroupsServiceCountGroupsForPrincipalsParams) SetPrincipalIds(principalIds []string) {
	o.PrincipalIds = principalIds
}

// WriteToRequest writes these params to a swagger request
func (o *GroupsServiceCountGroupsForPrincipalsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param parent_resource_name
	if err := r.SetPathParam("parent_resource_name", o.ParentResourceName); err != nil {
		return err
	}

	if o.PrincipalIds != nil {

		// binding items for principal_ids
		joinedPrincipalIds := o.bindParamPrincipalIds(reg)

		// query array param principal_ids
		if err := r.SetQueryParam("principal_ids", joinedPrincipalIds...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamGroupsServiceCountGroupsForPrincipals binds the parameter principal_ids
func (o *GroupsServiceCountGroupsForPrincipalsParams) bindParamPrincipalIds(formats strfmt.Registry) []string {
	principalIdsIR := o.PrincipalIds

	var principalIdsIC []string
	for _, principalIdsIIR := range principalIdsIR { // explode []string

		principalIdsIIV := principalIdsIIR // string as string
		principalIdsIC = append(principalIdsIC, principalIdsIIV)
	}

	// items.CollectionFormat: "multi"
	principalIdsIS := swag.JoinByFormat(principalIdsIC, "multi")

	return principalIdsIS
}
