// Code generated by go-swagger; DO NOT EDIT.

package log_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-log-service/preview/2021-03-30/models"
)

// LogServiceSearchReader is a Reader for the LogServiceSearch structure.
type LogServiceSearchReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LogServiceSearchReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLogServiceSearchOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLogServiceSearchDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLogServiceSearchOK creates a LogServiceSearchOK with default headers values
func NewLogServiceSearchOK() *LogServiceSearchOK {
	return &LogServiceSearchOK{}
}

/*
LogServiceSearchOK describes a response with status code 200, with default header values.

A successful response.
*/
type LogServiceSearchOK struct {
	Payload *models.LogService20210330SearchResponse
}

// IsSuccess returns true when this log service search o k response has a 2xx status code
func (o *LogServiceSearchOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this log service search o k response has a 3xx status code
func (o *LogServiceSearchOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this log service search o k response has a 4xx status code
func (o *LogServiceSearchOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this log service search o k response has a 5xx status code
func (o *LogServiceSearchOK) IsServerError() bool {
	return false
}

// IsCode returns true when this log service search o k response a status code equal to that given
func (o *LogServiceSearchOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the log service search o k response
func (o *LogServiceSearchOK) Code() int {
	return 200
}

func (o *LogServiceSearchOK) Error() string {
	return fmt.Sprintf("[POST /logs/2022-06-06/organizations/{organization_id}/entries/preview/search][%d] logServiceSearchOK  %+v", 200, o.Payload)
}

func (o *LogServiceSearchOK) String() string {
	return fmt.Sprintf("[POST /logs/2022-06-06/organizations/{organization_id}/entries/preview/search][%d] logServiceSearchOK  %+v", 200, o.Payload)
}

func (o *LogServiceSearchOK) GetPayload() *models.LogService20210330SearchResponse {
	return o.Payload
}

func (o *LogServiceSearchOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LogService20210330SearchResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLogServiceSearchDefault creates a LogServiceSearchDefault with default headers values
func NewLogServiceSearchDefault(code int) *LogServiceSearchDefault {
	return &LogServiceSearchDefault{
		_statusCode: code,
	}
}

/*
LogServiceSearchDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type LogServiceSearchDefault struct {
	_statusCode int

	Payload *models.RuntimeError
}

// IsSuccess returns true when this log service search default response has a 2xx status code
func (o *LogServiceSearchDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this log service search default response has a 3xx status code
func (o *LogServiceSearchDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this log service search default response has a 4xx status code
func (o *LogServiceSearchDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this log service search default response has a 5xx status code
func (o *LogServiceSearchDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this log service search default response a status code equal to that given
func (o *LogServiceSearchDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the log service search default response
func (o *LogServiceSearchDefault) Code() int {
	return o._statusCode
}

func (o *LogServiceSearchDefault) Error() string {
	return fmt.Sprintf("[POST /logs/2022-06-06/organizations/{organization_id}/entries/preview/search][%d] LogService_Search default  %+v", o._statusCode, o.Payload)
}

func (o *LogServiceSearchDefault) String() string {
	return fmt.Sprintf("[POST /logs/2022-06-06/organizations/{organization_id}/entries/preview/search][%d] LogService_Search default  %+v", o._statusCode, o.Payload)
}

func (o *LogServiceSearchDefault) GetPayload() *models.RuntimeError {
	return o.Payload
}

func (o *LogServiceSearchDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
