// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudVagrant20220930Architecture hashicorp cloud vagrant 20220930 architecture
//
// swagger:model hashicorp.cloud.vagrant_20220930.Architecture
type HashicorpCloudVagrant20220930Architecture struct {

	// The architecture type that is supported.
	ArchitectureType string `json:"architecture_type,omitempty"`

	// Data for the box, including the download_url and checksum information
	BoxData *HashicorpCloudVagrant20220930BoxData `json:"box_data,omitempty"`

	// The date the record was created.
	// Read Only: true
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// Whether or not this is the default Architecture for the Provider
	Default bool `json:"default,omitempty"`

	// The date that the record was last updated.
	// Read Only: true
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updated_at,omitempty"`
}

// Validate validates this hashicorp cloud vagrant 20220930 architecture
func (m *HashicorpCloudVagrant20220930Architecture) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBoxData(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudVagrant20220930Architecture) validateBoxData(formats strfmt.Registry) error {
	if swag.IsZero(m.BoxData) { // not required
		return nil
	}

	if m.BoxData != nil {
		if err := m.BoxData.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("box_data")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("box_data")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Architecture) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Architecture) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this hashicorp cloud vagrant 20220930 architecture based on the context it is used
func (m *HashicorpCloudVagrant20220930Architecture) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBoxData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreatedAt(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdatedAt(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudVagrant20220930Architecture) contextValidateBoxData(ctx context.Context, formats strfmt.Registry) error {

	if m.BoxData != nil {

		if swag.IsZero(m.BoxData) { // not required
			return nil
		}

		if err := m.BoxData.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("box_data")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("box_data")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Architecture) contextValidateCreatedAt(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "created_at", "body", strfmt.DateTime(m.CreatedAt)); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Architecture) contextValidateUpdatedAt(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "updated_at", "body", strfmt.DateTime(m.UpdatedAt)); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudVagrant20220930Architecture) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudVagrant20220930Architecture) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudVagrant20220930Architecture
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
