// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// IsVaultPluginRegisteredReader is a Reader for the IsVaultPluginRegistered structure.
type IsVaultPluginRegisteredReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IsVaultPluginRegisteredReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIsVaultPluginRegisteredOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIsVaultPluginRegisteredDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIsVaultPluginRegisteredOK creates a IsVaultPluginRegisteredOK with default headers values
func NewIsVaultPluginRegisteredOK() *IsVaultPluginRegisteredOK {
	return &IsVaultPluginRegisteredOK{}
}

/*
IsVaultPluginRegisteredOK describes a response with status code 200, with default header values.

A successful response.
*/
type IsVaultPluginRegisteredOK struct {
	Payload *models.HashicorpCloudVault20201125IsVaultPluginRegisteredResponse
}

// IsSuccess returns true when this is vault plugin registered o k response has a 2xx status code
func (o *IsVaultPluginRegisteredOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this is vault plugin registered o k response has a 3xx status code
func (o *IsVaultPluginRegisteredOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this is vault plugin registered o k response has a 4xx status code
func (o *IsVaultPluginRegisteredOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this is vault plugin registered o k response has a 5xx status code
func (o *IsVaultPluginRegisteredOK) IsServerError() bool {
	return false
}

// IsCode returns true when this is vault plugin registered o k response a status code equal to that given
func (o *IsVaultPluginRegisteredOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the is vault plugin registered o k response
func (o *IsVaultPluginRegisteredOK) Code() int {
	return 200
}

func (o *IsVaultPluginRegisteredOK) Error() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/plugin/is-registered][%d] isVaultPluginRegisteredOK  %+v", 200, o.Payload)
}

func (o *IsVaultPluginRegisteredOK) String() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/plugin/is-registered][%d] isVaultPluginRegisteredOK  %+v", 200, o.Payload)
}

func (o *IsVaultPluginRegisteredOK) GetPayload() *models.HashicorpCloudVault20201125IsVaultPluginRegisteredResponse {
	return o.Payload
}

func (o *IsVaultPluginRegisteredOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVault20201125IsVaultPluginRegisteredResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewIsVaultPluginRegisteredDefault creates a IsVaultPluginRegisteredDefault with default headers values
func NewIsVaultPluginRegisteredDefault(code int) *IsVaultPluginRegisteredDefault {
	return &IsVaultPluginRegisteredDefault{
		_statusCode: code,
	}
}

/*
IsVaultPluginRegisteredDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type IsVaultPluginRegisteredDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this is vault plugin registered default response has a 2xx status code
func (o *IsVaultPluginRegisteredDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this is vault plugin registered default response has a 3xx status code
func (o *IsVaultPluginRegisteredDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this is vault plugin registered default response has a 4xx status code
func (o *IsVaultPluginRegisteredDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this is vault plugin registered default response has a 5xx status code
func (o *IsVaultPluginRegisteredDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this is vault plugin registered default response a status code equal to that given
func (o *IsVaultPluginRegisteredDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the is vault plugin registered default response
func (o *IsVaultPluginRegisteredDefault) Code() int {
	return o._statusCode
}

func (o *IsVaultPluginRegisteredDefault) Error() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/plugin/is-registered][%d] IsVaultPluginRegistered default  %+v", o._statusCode, o.Payload)
}

func (o *IsVaultPluginRegisteredDefault) String() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/plugin/is-registered][%d] IsVaultPluginRegistered default  %+v", o._statusCode, o.Payload)
}

func (o *IsVaultPluginRegisteredDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *IsVaultPluginRegisteredDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
