// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-06-13/models"
)

// CompleteVercelInstallationReader is a Reader for the CompleteVercelInstallation structure.
type CompleteVercelInstallationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CompleteVercelInstallationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCompleteVercelInstallationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCompleteVercelInstallationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCompleteVercelInstallationOK creates a CompleteVercelInstallationOK with default headers values
func NewCompleteVercelInstallationOK() *CompleteVercelInstallationOK {
	return &CompleteVercelInstallationOK{}
}

/*
CompleteVercelInstallationOK describes a response with status code 200, with default header values.

A successful response.
*/
type CompleteVercelInstallationOK struct {
	Payload *models.APIHTTPBody
}

// IsSuccess returns true when this complete vercel installation o k response has a 2xx status code
func (o *CompleteVercelInstallationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this complete vercel installation o k response has a 3xx status code
func (o *CompleteVercelInstallationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this complete vercel installation o k response has a 4xx status code
func (o *CompleteVercelInstallationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this complete vercel installation o k response has a 5xx status code
func (o *CompleteVercelInstallationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this complete vercel installation o k response a status code equal to that given
func (o *CompleteVercelInstallationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the complete vercel installation o k response
func (o *CompleteVercelInstallationOK) Code() int {
	return 200
}

func (o *CompleteVercelInstallationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/sync/vercel/callback][%d] completeVercelInstallationOK %s", 200, payload)
}

func (o *CompleteVercelInstallationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/sync/vercel/callback][%d] completeVercelInstallationOK %s", 200, payload)
}

func (o *CompleteVercelInstallationOK) GetPayload() *models.APIHTTPBody {
	return o.Payload
}

func (o *CompleteVercelInstallationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.APIHTTPBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCompleteVercelInstallationDefault creates a CompleteVercelInstallationDefault with default headers values
func NewCompleteVercelInstallationDefault(code int) *CompleteVercelInstallationDefault {
	return &CompleteVercelInstallationDefault{
		_statusCode: code,
	}
}

/*
CompleteVercelInstallationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CompleteVercelInstallationDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this complete vercel installation default response has a 2xx status code
func (o *CompleteVercelInstallationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this complete vercel installation default response has a 3xx status code
func (o *CompleteVercelInstallationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this complete vercel installation default response has a 4xx status code
func (o *CompleteVercelInstallationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this complete vercel installation default response has a 5xx status code
func (o *CompleteVercelInstallationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this complete vercel installation default response a status code equal to that given
func (o *CompleteVercelInstallationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the complete vercel installation default response
func (o *CompleteVercelInstallationDefault) Code() int {
	return o._statusCode
}

func (o *CompleteVercelInstallationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/sync/vercel/callback][%d] CompleteVercelInstallation default %s", o._statusCode, payload)
}

func (o *CompleteVercelInstallationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/sync/vercel/callback][%d] CompleteVercelInstallation default %s", o._statusCode, payload)
}

func (o *CompleteVercelInstallationDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *CompleteVercelInstallationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
