// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// WaypointServiceUpgradeApplicationTFWorkspaceReader is a Reader for the WaypointServiceUpgradeApplicationTFWorkspace structure.
type WaypointServiceUpgradeApplicationTFWorkspaceReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceUpgradeApplicationTFWorkspaceReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceUpgradeApplicationTFWorkspaceOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceUpgradeApplicationTFWorkspaceDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceUpgradeApplicationTFWorkspaceOK creates a WaypointServiceUpgradeApplicationTFWorkspaceOK with default headers values
func NewWaypointServiceUpgradeApplicationTFWorkspaceOK() *WaypointServiceUpgradeApplicationTFWorkspaceOK {
	return &WaypointServiceUpgradeApplicationTFWorkspaceOK{}
}

/*
WaypointServiceUpgradeApplicationTFWorkspaceOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceUpgradeApplicationTFWorkspaceOK struct {
	Payload *models.HashicorpCloudWaypointUpgradeApplicationTFWorkspaceResponse
}

// IsSuccess returns true when this waypoint service upgrade application t f workspace o k response has a 2xx status code
func (o *WaypointServiceUpgradeApplicationTFWorkspaceOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service upgrade application t f workspace o k response has a 3xx status code
func (o *WaypointServiceUpgradeApplicationTFWorkspaceOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service upgrade application t f workspace o k response has a 4xx status code
func (o *WaypointServiceUpgradeApplicationTFWorkspaceOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service upgrade application t f workspace o k response has a 5xx status code
func (o *WaypointServiceUpgradeApplicationTFWorkspaceOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service upgrade application t f workspace o k response a status code equal to that given
func (o *WaypointServiceUpgradeApplicationTFWorkspaceOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service upgrade application t f workspace o k response
func (o *WaypointServiceUpgradeApplicationTFWorkspaceOK) Code() int {
	return 200
}

func (o *WaypointServiceUpgradeApplicationTFWorkspaceOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/applications/{application.name}/upgrade-tf-workspace][%d] waypointServiceUpgradeApplicationTFWorkspaceOK %s", 200, payload)
}

func (o *WaypointServiceUpgradeApplicationTFWorkspaceOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/applications/{application.name}/upgrade-tf-workspace][%d] waypointServiceUpgradeApplicationTFWorkspaceOK %s", 200, payload)
}

func (o *WaypointServiceUpgradeApplicationTFWorkspaceOK) GetPayload() *models.HashicorpCloudWaypointUpgradeApplicationTFWorkspaceResponse {
	return o.Payload
}

func (o *WaypointServiceUpgradeApplicationTFWorkspaceOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointUpgradeApplicationTFWorkspaceResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceUpgradeApplicationTFWorkspaceDefault creates a WaypointServiceUpgradeApplicationTFWorkspaceDefault with default headers values
func NewWaypointServiceUpgradeApplicationTFWorkspaceDefault(code int) *WaypointServiceUpgradeApplicationTFWorkspaceDefault {
	return &WaypointServiceUpgradeApplicationTFWorkspaceDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceUpgradeApplicationTFWorkspaceDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceUpgradeApplicationTFWorkspaceDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service upgrade application t f workspace default response has a 2xx status code
func (o *WaypointServiceUpgradeApplicationTFWorkspaceDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service upgrade application t f workspace default response has a 3xx status code
func (o *WaypointServiceUpgradeApplicationTFWorkspaceDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service upgrade application t f workspace default response has a 4xx status code
func (o *WaypointServiceUpgradeApplicationTFWorkspaceDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service upgrade application t f workspace default response has a 5xx status code
func (o *WaypointServiceUpgradeApplicationTFWorkspaceDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service upgrade application t f workspace default response a status code equal to that given
func (o *WaypointServiceUpgradeApplicationTFWorkspaceDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service upgrade application t f workspace default response
func (o *WaypointServiceUpgradeApplicationTFWorkspaceDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceUpgradeApplicationTFWorkspaceDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/applications/{application.name}/upgrade-tf-workspace][%d] WaypointService_UpgradeApplicationTFWorkspace default %s", o._statusCode, payload)
}

func (o *WaypointServiceUpgradeApplicationTFWorkspaceDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/applications/{application.name}/upgrade-tf-workspace][%d] WaypointService_UpgradeApplicationTFWorkspace default %s", o._statusCode, payload)
}

func (o *WaypointServiceUpgradeApplicationTFWorkspaceDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceUpgradeApplicationTFWorkspaceDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
