'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var cx = require('clsx');
var core = require('@mantine/core');
var CopyIcon = require('./CopyIcon.cjs');
var useHighlight = require('./use-highlight.cjs');
var CodeHighlight_module = require('./CodeHighlight.module.css.cjs');
var CodeHighlight_theme_module = require('./CodeHighlight.theme.module.css.cjs');

function _interopDefault (e) { return e && e.__esModule ? e : { default: e }; }

var cx__default = /*#__PURE__*/_interopDefault(cx);

const classes = { ...CodeHighlight_module, root: cx__default.default(CodeHighlight_module.root, CodeHighlight_theme_module.theme) };
const defaultProps = {
  copyLabel: "Copy code",
  copiedLabel: "Copied",
  language: "tsx",
  withCopyButton: true
};
const CodeHighlight = core.factory((_props, ref) => {
  const props = core.useProps("CodeHighlight", defaultProps, _props);
  const {
    classNames,
    className,
    style,
    styles,
    unstyled,
    vars,
    children,
    code,
    copiedLabel,
    copyLabel,
    language,
    withCopyButton,
    highlightOnClient,
    ...others
  } = props;
  const getStyles = core.useStyles({
    name: "CodeHighlight",
    props,
    classes,
    className,
    style,
    classNames,
    styles,
    unstyled
  });
  const getCodeProps = useHighlight.useHighlight({
    code,
    language,
    highlightOnClient
  });
  return /* @__PURE__ */ jsxRuntime.jsxs(core.Box, { ...getStyles("root"), ref, ...others, dir: "ltr", children: [
    withCopyButton && /* @__PURE__ */ jsxRuntime.jsx(core.CopyButton, { value: code.trim(), children: ({ copied, copy }) => /* @__PURE__ */ jsxRuntime.jsx(core.Tooltip, { label: copied ? copiedLabel : copyLabel, fz: "sm", position: "left", children: /* @__PURE__ */ jsxRuntime.jsx(core.ActionIcon, { onClick: copy, variant: "none", ...getStyles("copy"), children: /* @__PURE__ */ jsxRuntime.jsx(CopyIcon.CopyIcon, { copied }) }) }) }),
    /* @__PURE__ */ jsxRuntime.jsx(core.ScrollArea, { type: "hover", dir: "ltr", offsetScrollbars: false, children: /* @__PURE__ */ jsxRuntime.jsx("pre", { ...getStyles("pre"), children: /* @__PURE__ */ jsxRuntime.jsx("code", { ...getStyles("code"), ...getCodeProps() }) }) })
  ] });
});
CodeHighlight.displayName = "@mantine/core/CodeHighlight";
CodeHighlight.classes = classes;

exports.CodeHighlight = CodeHighlight;
//# sourceMappingURL=CodeHighlight.cjs.map
