declare type EncodedValue = string | (string | null)[] | null | undefined;
/**
 * simple cache that keeps values around so long as something
 * has registered interest in it (typically via calling useQueryParams).
 * Caches based on the stringified value as the key and the
 * last passed in decode function.
 */
export declare class DecodedParamCache {
    private paramsMap;
    private registeredParams;
    constructor();
    set(param: string, stringifiedValue: EncodedValue, decodedValue: any, decode: Function): void;
    /**
     * A param has been cached if the stringified value and decode function matches
     */
    has(param: string, stringifiedValue: EncodedValue, decode?: Function): boolean;
    get(param: string): any;
    /**
     * Register interest in a set of param names. When these go to 0 they are cleaned out.
     */
    registerParams(paramNames: string[]): void;
    /**
     * Unregister interest in a set of param names. If there is no remaining interest,
     * remove the decoded value from the cache to prevent memory leaks.
     */
    unregisterParams(paramNames: string[]): void;
    clear(): void;
}
export declare const decodedParamCache: DecodedParamCache;
export {};
