/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.net.URI;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.MessageBean;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.util.AttributeStack;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.DitaClass;
import org.dita.dost.util.DitaUtils;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class GenListModuleReader
extends AbstractXMLFilter {
    public static final URI ROOT_URI = URLUtils.toURI("ROOT");
    private Job job;
    private URI currentDir = null;
    private boolean hasConRef = false;
    private boolean hasHref = false;
    private boolean hasKeyRef = false;
    private boolean hasCodeRef = false;
    private final Set<Reference> nonConrefCopytoTargets = new LinkedHashSet<Reference>(64);
    private final Set<URI> conrefTargets = new HashSet<URI>(32);
    private final Set<URI> hrefTargets = new HashSet<URI>(32);
    private final Set<URI> schemeSet = new HashSet<URI>(32);
    private final Set<URI> coderefTargetSet = new HashSet<URI>(16);
    private final Set<URI> ignoredCopytoSourceSet = new HashSet<URI>(16);
    private final Map<URI, URI> copytoMap = new HashMap<URI, URI>(16);
    private boolean hasconaction = false;
    private final Deque<DitaClass> classes = new LinkedList<DitaClass>();
    private boolean isValidInput = false;
    private final Set<URI> outDitaFilesSet = new HashSet<URI>(64);
    private URI rootDir = null;
    private final AttributeStack attributeStack = new AttributeStack();
    private final Set<URI> resourceOnlySet = new HashSet<URI>(32);
    private final Set<URI> normalProcessingRoleSet = new HashSet<URI>(32);
    private final Set<URI> nonTopicrefReferenceSet = new HashSet<URI>(32);
    private final Set<URI> schemeRefSet = new HashSet<URI>(32);
    private final Map<URI, Set<URI>> schemeRelationGraph = new LinkedHashMap<URI, Set<URI>>();
    private boolean isRootElement = true;
    private DitaClass rootClass = null;
    private Predicate<String> formatFilter;
    private DitaClass forceType;
    public static final String[] KEYREF_ATTRS = new String[]{"keyref", "conkeyref", "archivekeyrefs", "classidkeyref", "codebasekeyref", "datakeyref"};

    @Override
    public void setJob(Job job) {
        this.job = job;
    }

    public void setForceType(DitaClass cls) {
        this.forceType = cls;
    }

    public Set<URI> getOutDitaFilesSet() {
        return this.outDitaFilesSet;
    }

    public Set<URI> getSchemeSet() {
        return this.schemeSet;
    }

    public Set<URI> getSchemeRefSet() {
        return this.schemeRefSet;
    }

    public boolean isDitaTopic() {
        if (this.isRootElement) {
            throw new IllegalStateException();
        }
        return this.rootClass == null || Constants.TOPIC_TOPIC.matches(this.rootClass);
    }

    public String currentFileFormat() {
        if (this.rootClass == null || Constants.TOPIC_TOPIC.matches(this.rootClass)) {
            return "dita";
        }
        if (Constants.MAP_MAP.matches(this.rootClass)) {
            return "ditamap";
        }
        return null;
    }

    public boolean isDitaMap() {
        if (this.isRootElement) {
            throw new IllegalStateException();
        }
        return this.rootClass != null && Constants.MAP_MAP.matches(this.rootClass);
    }

    public Map<URI, Set<URI>> getRelationshipGrap() {
        return this.schemeRelationGraph;
    }

    public void setPrimaryDitamap(URI primaryDitamap) {
        assert (primaryDitamap.isAbsolute());
        this.rootDir = primaryDitamap.resolve(".");
    }

    public boolean hasConRef() {
        return this.hasConRef;
    }

    public boolean hasKeyRef() {
        return this.hasKeyRef;
    }

    public boolean hasCodeRef() {
        return this.hasCodeRef;
    }

    public boolean hasHref() {
        return this.hasHref;
    }

    public Map<URI, URI> getCopytoMap() {
        return this.copytoMap;
    }

    public Set<URI> getHrefTargets() {
        return this.hrefTargets;
    }

    public Set<URI> getConrefTargets() {
        return this.conrefTargets;
    }

    public Set<URI> getCoderefTargets() {
        return this.coderefTargetSet;
    }

    @Override
    public void setCurrentFile(URI currentFile) {
        assert (currentFile.isAbsolute());
        super.setCurrentFile(currentFile);
        this.currentDir = currentFile.resolve(".");
    }

    public boolean isValidInput() {
        return this.isValidInput;
    }

    public boolean hasConaction() {
        return this.hasconaction;
    }

    public Set<Reference> getNonConrefCopytoTargets() {
        return this.nonConrefCopytoTargets;
    }

    public Set<URI> getCoderefTargetSet() {
        return this.coderefTargetSet;
    }

    public Set<URI> getIgnoredCopytoSourceSet() {
        return this.ignoredCopytoSourceSet;
    }

    public Set<URI> getResourceOnlySet() {
        return this.resourceOnlySet;
    }

    public Set<URI> getNormalProcessingRoleSet() {
        return this.normalProcessingRoleSet;
    }

    public Set<URI> getNonTopicrefReferenceSet() {
        return this.nonTopicrefReferenceSet;
    }

    public void reset() {
        this.hasKeyRef = false;
        this.hasConRef = false;
        this.hasHref = false;
        this.hasCodeRef = false;
        this.currentDir = null;
        this.classes.clear();
        this.isValidInput = false;
        this.hasconaction = false;
        this.coderefTargetSet.clear();
        this.nonConrefCopytoTargets.clear();
        this.hrefTargets.clear();
        this.conrefTargets.clear();
        this.copytoMap.clear();
        this.ignoredCopytoSourceSet.clear();
        this.outDitaFilesSet.clear();
        this.schemeSet.clear();
        this.schemeRefSet.clear();
        this.attributeStack.clear();
        this.isRootElement = true;
        this.rootClass = null;
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.currentDir == null) {
            throw new IllegalStateException();
        }
        this.attributeStack.push(new XMLUtils.AttributesBuilder().add("processing-role", "normal").build());
        this.getContentHandler().startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String format;
        this.attributeStack.push(atts);
        this.handleRootElement(atts);
        this.handleSubjectScheme(atts);
        DitaClass cls = DitaClass.getInstance(atts);
        if (this.forceType != null && cls != null && (Constants.MAP_MAP.matches(cls) || Constants.TOPIC_TOPIC.matches(cls)) && !this.forceType.matches(cls)) {
            this.isValidInput = true;
            throw new EarlyExitException();
        }
        URI href = URLUtils.toURI(atts.getValue("href"));
        String scope = this.attributeStack.peek("scope");
        if (scope == null && href != null && href.isAbsolute()) {
            switch (href.getScheme()) {
                case "http": 
                case "https": 
                case "ftp": 
                case "ftps": 
                case "sftp": 
                case "mailto": {
                    scope = "external";
                }
            }
        }
        if (!(href == null || href.getPath() == null || href.getPath().isEmpty() || "external".equals(scope) || "peer".equals(scope) || GenListModuleReader.isFormatDita(format = this.attributeStack.peek("format")) && !this.isDitaMap() && !this.job.crawlTopics())) {
            if (!Constants.MAP_TOPICREF.matches(cls)) {
                this.nonTopicrefReferenceSet.add(URLUtils.stripFragment(this.currentDir.resolve(href)));
            } else if (DitaUtils.isResourceOnly(this.attributeStack.peek("processing-role"))) {
                this.resourceOnlySet.add(URLUtils.stripFragment(this.currentDir.resolve(href)));
            } else {
                this.normalProcessingRoleSet.add(URLUtils.stripFragment(this.currentDir.resolve(href)));
            }
        }
        if (cls != null && cls.isValid()) {
            this.classes.addFirst(cls);
        } else {
            this.classes.addFirst(null);
        }
        if (!(cls != null && cls.isValid() || "dita".equals(localName))) {
            if (!XMLUtils.nonDitaContext(this.classes)) {
                if (atts.getValue("class") == null) {
                    this.logger.info(MessageUtils.getMessage("DOTJ030I", localName).setLocation(atts).toString());
                } else {
                    this.logger.info(MessageUtils.getMessage("DOTJ070I", atts.getValue("class"), localName).setLocation(atts).toString());
                }
            }
        } else {
            if (Constants.MAP_MAP.matches(cls) || Constants.TOPIC_TITLE.matches(cls)) {
                this.isValidInput = true;
            }
            this.parseConrefAttr(atts);
            if (Constants.PR_D_CODEREF.matches(cls)) {
                this.parseCoderef(atts, scope);
            } else if (Constants.TOPIC_OBJECT.matches(cls)) {
                this.parseObject(atts);
            } else if (Constants.MAP_TOPICREF.matches(cls)) {
                this.parseAttribute(atts, "href", scope);
                this.parseAttribute(atts, "copy-to", scope);
            } else {
                this.parseAttribute(atts, "href", scope);
            }
            this.parseConactionAttr(atts);
            this.parseConkeyrefAttr(atts);
            this.parseKeyrefAttr(atts);
        }
        this.getContentHandler().startElement(uri, localName, qName, atts);
    }

    private void parseCoderef(Attributes atts, String attrScope) {
        URI href = URLUtils.toURI(atts.getValue("href"));
        if (href == null) {
            return;
        }
        if ("external".equals(attrScope) || "peer".equals(attrScope) || href.toString().startsWith("#")) {
            return;
        }
        this.hasCodeRef = true;
        URI filename = URLUtils.stripFragment(href.isAbsolute() ? href : this.currentDir.resolve(href));
        assert (filename.isAbsolute());
        this.coderefTargetSet.add(filename);
    }

    private void parseObject(Attributes atts) {
        URI attrValue = URLUtils.toURI(atts.getValue("data"));
        if (attrValue == null || attrValue.isAbsolute()) {
            return;
        }
        URI codebase = URLUtils.toURI(atts.getValue("codebase"));
        URI filename = codebase != null ? (codebase.isAbsolute() ? codebase.resolve(attrValue) : this.currentDir.resolve(codebase).resolve(attrValue)) : this.currentDir.resolve(attrValue);
        filename = URLUtils.stripFragment(filename);
        assert (filename.isAbsolute());
        this.nonConrefCopytoTargets.add(new Reference(filename, "nondita"));
    }

    private void handleSubjectScheme(Attributes atts) {
        URI href;
        String classValue = atts.getValue("class");
        if (Constants.SUBJECTSCHEME_SUBJECTSCHEME.matches(classValue)) {
            Set children = this.schemeRelationGraph.getOrDefault(ROOT_URI, new LinkedHashSet());
            children.add(this.currentFile);
            this.schemeRelationGraph.put(ROOT_URI, children);
            this.schemeRefSet.add(this.currentFile);
        } else if (Constants.SUBJECTSCHEME_SCHEMEREF.matches(classValue) && (href = URLUtils.toURI(atts.getValue("href"))) != null) {
            Set children = this.schemeRelationGraph.getOrDefault(this.currentFile, new LinkedHashSet());
            URI child = this.currentFile.resolve(href);
            children.add(child);
            this.schemeRelationGraph.put(this.currentFile, children);
        }
    }

    private void handleRootElement(Attributes atts) {
        if (this.isRootElement) {
            this.isRootElement = false;
            String classValue = atts.getValue("class");
            if (classValue != null) {
                this.rootClass = DitaClass.getInstance(atts.getValue("class"));
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.attributeStack.pop();
        this.classes.pop();
        this.getContentHandler().endElement(uri, localName, qName);
    }

    @Override
    public void endDocument() throws SAXException {
        this.getContentHandler().endDocument();
    }

    private void parseAttribute(Attributes atts, String attrName, String scope) throws SAXException {
        URI attrValue = URLUtils.toURI(atts.getValue(attrName));
        if (attrValue == null) {
            return;
        }
        String attrConref = atts.getValue("conref");
        if (attrConref != null && !attrConref.isEmpty() && "-dita-use-conref-target".equals(attrValue.toString())) {
            return;
        }
        String attrClass = atts.getValue("class");
        String attrScope = scope;
        if (attrScope == null && "href".equals(attrName) && attrValue.isAbsolute()) {
            switch (attrValue.getScheme()) {
                case "http": 
                case "https": 
                case "ftp": 
                case "ftps": 
                case "sftp": 
                case "mailto": {
                    attrScope = "external";
                }
            }
        }
        if (!DitaUtils.isLocalScope(attrScope) || attrValue.toString().startsWith("#")) {
            return;
        }
        URI filename = URLUtils.stripFragment(attrValue.isAbsolute() ? attrValue : this.currentDir.resolve(attrValue));
        assert (filename.isAbsolute());
        String attrType = this.attributeStack.peek("type");
        if (Constants.MAP_TOPICREF.matches(attrClass) && "subjectScheme".equalsIgnoreCase(attrType)) {
            this.schemeSet.add(filename);
        }
        String attrFormat = this.getFormat(atts);
        if ("href".equals(attrName)) {
            this.hasHref = true;
            if ((!GenListModuleReader.isFormatDita(attrFormat) || this.isDitaMap() || this.job.crawlTopics()) && (this.followLinks() && GenListModuleReader.canFollow(attrValue) || Constants.TOPIC_IMAGE.matches(attrClass) || Constants.SVG_D_SVGREF.matches(attrClass) || Constants.DITAVAREF_D_DITAVALREF.matches(attrClass))) {
                this.nonConrefCopytoTargets.add(new Reference(filename, attrFormat));
            }
        }
        if (GenListModuleReader.isFormatDita(attrFormat)) {
            URI copyTo;
            if ("href".equals(attrName) && GenListModuleReader.canFollow(attrValue)) {
                if (this.followLinks()) {
                    this.hrefTargets.add(filename);
                    this.toOutFile(filename, atts, false);
                }
            } else if ("copy-to".equals(attrName) && (copyTo = URLUtils.toURI(atts.getValue("href"))) != null) {
                if (copyTo.toString().isEmpty()) {
                    this.logger.warn("Copy-to task [href=\"\" copy-to=\"" + String.valueOf(filename) + "\"] was ignored.");
                } else {
                    URI value = URLUtils.stripFragment(this.currentDir.resolve(copyTo));
                    if (this.copytoMap.get(filename) != null) {
                        if (!value.equals(this.copytoMap.get(filename))) {
                            this.logger.warn(MessageUtils.getMessage("DOTX065W", copyTo.toString(), filename.toString()).setLocation(atts).toString());
                        }
                        this.ignoredCopytoSourceSet.add(value);
                    } else {
                        this.copytoMap.put(filename, value);
                    }
                }
            }
        }
    }

    public static boolean canFollow(URI href) {
        return href == null || href.getScheme() == null || !href.getScheme().equals("mailto");
    }

    private String getFormat(Attributes atts) {
        String attrClass = atts.getValue("class");
        if (Constants.TOPIC_IMAGE.matches(attrClass)) {
            return "image";
        }
        if (Constants.TOPIC_OBJECT.matches(attrClass)) {
            throw new IllegalArgumentException();
        }
        String format = atts.getValue("format");
        if (format != null && FileUtils.isSupportedImageFile("." + format)) {
            format = "image";
        }
        return format;
    }

    private void parseConrefAttr(Attributes atts) throws SAXException {
        String attrValue = atts.getValue("conref");
        if (attrValue != null) {
            if (attrValue.isEmpty()) {
                this.logger.warn(MessageUtils.getMessage("DOTJ081W", new String[0]).setLocation(atts).toString());
            } else {
                this.hasConRef = true;
                URI target = URLUtils.toURI(attrValue);
                URI filename = URLUtils.isAbsolute(target) ? target : (attrValue.startsWith("#") ? this.currentFile : this.currentDir.resolve(target));
                filename = URLUtils.stripFragment(filename);
                this.conrefTargets.add(filename);
                this.toOutFile(filename, atts, true);
            }
        }
    }

    private void parseConkeyrefAttr(Attributes atts) {
        String conkeyref = atts.getValue("conkeyref");
        if (conkeyref != null) {
            this.hasConRef = true;
        }
    }

    private void parseKeyrefAttr(Attributes atts) {
        for (String attr : KEYREF_ATTRS) {
            if (atts.getValue(attr) == null) continue;
            this.hasKeyRef = true;
            break;
        }
    }

    private void parseConactionAttr(Attributes atts) {
        String conaction = atts.getValue("conaction");
        if (conaction != null && (conaction.equals("mark") || conaction.equals("pushreplace"))) {
            this.hasconaction = true;
        }
    }

    public static boolean isFormatDita(String attrFormat) {
        if (attrFormat == null || attrFormat.equals("dita")) {
            return true;
        }
        for (String f : Configuration.ditaFormat) {
            if (!f.equals(attrFormat)) continue;
            return true;
        }
        return false;
    }

    private boolean isOutFile(URI toCheckPath) {
        String path = toCheckPath.getPath();
        return path == null || !path.startsWith(this.rootDir.getPath());
    }

    private boolean followLinks() {
        if (!this.job.crawlTopics() && !this.isDitaMap()) {
            return false;
        }
        return !this.job.getOnlyTopicInMap() || this.isDitaMap();
    }

    private void addToOutFilesSet(URI hrefedFile) {
        if (this.followLinks()) {
            this.outDitaFilesSet.add(hrefedFile);
        }
    }

    private void toOutFile(URI filename, Attributes atts, boolean isResourceOnly) throws SAXException {
        assert (filename.isAbsolute());
        String[] prop = new String[]{filename.toString(), this.currentFile.toString()};
        if (this.job.getGeneratecopyouter() == Job.Generate.NOT_GENERATEOUTTER && this.isOutFile(filename)) {
            if (this.job.getOutterControl() == Job.OutterControl.FAIL) {
                MessageBean msgBean = MessageUtils.getMessage("DOTJ035F", prop).setLocation(atts);
                throw new SAXParseException(null, null, new DITAOTException(msgBean, null, msgBean.toString()));
            }
            if (this.job.getOutterControl() == Job.OutterControl.WARN && !isResourceOnly) {
                MessageBean msgBean = MessageUtils.getMessage("DOTJ036W", prop).setLocation(atts);
                this.logger.warn(msgBean.toString());
            }
            this.addToOutFilesSet(filename);
        }
    }

    public void setFormatFilter(Predicate<String> formatFilter) {
        this.formatFilter = formatFilter;
    }

    public static class EarlyExitException
    extends RuntimeException {
    }

    public static class Reference {
        public final URI filename;
        public final String format;

        public Reference(URI filename, String format) {
            assert (filename.isAbsolute() && filename.getFragment() == null);
            this.filename = filename;
            this.format = format;
        }

        public Reference(URI filename) {
            this(filename, null);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Reference)) {
                return false;
            }
            Reference other = (Reference)obj;
            return !(this.filename == null ? other.filename != null : !this.filename.equals(other.filename));
        }
    }
}

