#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 679
#define LARGE_STATE_COUNT 74
#define SYMBOL_COUNT 171
#define ALIAS_COUNT 0
#define TOKEN_COUNT 81
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 6
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 11

enum ts_symbol_identifiers {
  anon_sym_SEMI = 1,
  anon_sym_AT = 2,
  anon_sym_LPAREN = 3,
  anon_sym_RPAREN = 4,
  anon_sym_import = 5,
  anon_sym_using = 6,
  anon_sym_namespace = 7,
  anon_sym_LBRACE = 8,
  anon_sym_RBRACE = 9,
  anon_sym_model = 10,
  anon_sym_is = 11,
  anon_sym_extends = 12,
  anon_sym_COMMA = 13,
  anon_sym_PIPE = 14,
  anon_sym_AMP = 15,
  anon_sym_valueof = 16,
  anon_sym_LBRACK = 17,
  anon_sym_RBRACK = 18,
  anon_sym_QMARK = 19,
  anon_sym_COLON = 20,
  anon_sym_DOT_DOT_DOT = 21,
  anon_sym_union = 22,
  anon_sym_scalar = 23,
  anon_sym_interface = 24,
  anon_sym_op = 25,
  anon_sym_enum = 26,
  anon_sym_alias = 27,
  anon_sym_EQ = 28,
  anon_sym_AT_AT = 29,
  anon_sym_dec = 30,
  anon_sym_extern = 31,
  anon_sym_fn = 32,
  anon_sym_LT = 33,
  anon_sym_GT = 34,
  anon_sym_numeric = 35,
  anon_sym_integer = 36,
  anon_sym_float = 37,
  anon_sym_int64 = 38,
  anon_sym_int32 = 39,
  anon_sym_int16 = 40,
  anon_sym_int = 41,
  anon_sym_safeint = 42,
  anon_sym_uint6 = 43,
  anon_sym_uint32 = 44,
  anon_sym_uint16 = 45,
  anon_sym_uint8 = 46,
  anon_sym_float32 = 47,
  anon_sym_float64 = 48,
  anon_sym_decimal = 49,
  anon_sym_decimal128 = 50,
  anon_sym_plainDate = 51,
  anon_sym_plainTime = 52,
  anon_sym_utcDateTime = 53,
  anon_sym_offsetDateTime = 54,
  anon_sym_duration = 55,
  anon_sym_bytes = 56,
  anon_sym_string = 57,
  anon_sym_boolean = 58,
  anon_sym_null = 59,
  anon_sym_Array = 60,
  anon_sym_Record = 61,
  anon_sym_unknown = 62,
  anon_sym_void = 63,
  anon_sym_never = 64,
  sym_plain_identifier = 65,
  anon_sym_BQUOTE = 66,
  sym_backticked_identifier_fragment = 67,
  anon_sym_DOT = 68,
  anon_sym_true = 69,
  anon_sym_false = 70,
  sym_decimal_literal = 71,
  sym_hex_integer_literal = 72,
  sym_binary_integer_literal = 73,
  anon_sym_DQUOTE = 74,
  anon_sym_DQUOTE_DQUOTE_DQUOTE = 75,
  sym_escape_sequence = 76,
  sym_quoted_string_fragment = 77,
  sym_triple_quoted_string_fragment = 78,
  sym_single_line_comment = 79,
  sym_multi_line_comment = 80,
  sym_source_file = 81,
  sym__item = 82,
  sym__statement = 83,
  sym_decorator_list = 84,
  sym_decorator = 85,
  sym_decorator_arguments = 86,
  sym_import_statement = 87,
  sym_using_statement = 88,
  sym_namespace_statement = 89,
  sym_namespace_body = 90,
  sym_model_statement = 91,
  sym__model_heritage = 92,
  sym_model_is_heritage = 93,
  sym_model_extends_heritage = 94,
  sym_expression_list = 95,
  sym__expression = 96,
  sym_union_expression = 97,
  sym_intersection_expression = 98,
  sym_value_of_expression = 99,
  sym_array_expression = 100,
  sym__primary_expression = 101,
  sym_tuple_expression = 102,
  sym_model_expression = 103,
  sym_model_body = 104,
  sym_model_property = 105,
  sym_model_spread_property = 106,
  sym_union_statement = 107,
  sym_union_body = 108,
  sym_union_variant = 109,
  sym_scalar_statement = 110,
  sym_scalar_extends = 111,
  sym_interface_statement = 112,
  sym_interface_heritage = 113,
  sym_interface_body = 114,
  sym_interface_member = 115,
  sym_enum_statement = 116,
  sym_enum_body = 117,
  sym_enum_spread_member = 118,
  sym_enum_member = 119,
  sym_enum_member_value = 120,
  sym_alias_statement = 121,
  sym_augment_decorator_statement = 122,
  sym_operation_statement = 123,
  sym__operation_signature = 124,
  sym_operation_signature_declaration = 125,
  sym_operation_arguments = 126,
  sym_operation_signature_reference = 127,
  sym_decorator_declaration_statement = 128,
  sym_decorator_modifiers = 129,
  sym_function_parameter_list = 130,
  sym_function_parameter = 131,
  sym_type_annotation = 132,
  sym_function_declaration_statement = 133,
  sym_function_modifiers = 134,
  sym_reference_expression_list = 135,
  sym_reference_expression = 136,
  sym_parenthesized_expression = 137,
  sym_template_arguments = 138,
  sym_template_parameters = 139,
  sym_template_parameter_list = 140,
  sym_template_parameter = 141,
  sym_template_constraint = 142,
  sym_template_default = 143,
  sym_identifier_or_member_expression = 144,
  sym_identifier = 145,
  sym_builtin_type = 146,
  sym_backticked_identifier = 147,
  sym_member_expression = 148,
  sym__literal = 149,
  sym_boolean_literal = 150,
  sym__numeric_literal = 151,
  sym__string_literal = 152,
  sym_quoted_string_literal = 153,
  sym_triple_quoted_string_literal = 154,
  sym__comment = 155,
  aux_sym_source_file_repeat1 = 156,
  aux_sym_decorator_list_repeat1 = 157,
  aux_sym_namespace_body_repeat1 = 158,
  aux_sym_expression_list_repeat1 = 159,
  aux_sym_model_body_repeat1 = 160,
  aux_sym_union_body_repeat1 = 161,
  aux_sym_interface_body_repeat1 = 162,
  aux_sym_enum_body_repeat1 = 163,
  aux_sym_function_parameter_list_repeat1 = 164,
  aux_sym_reference_expression_list_repeat1 = 165,
  aux_sym_template_parameter_list_repeat1 = 166,
  aux_sym_backticked_identifier_repeat1 = 167,
  aux_sym_member_expression_repeat1 = 168,
  aux_sym_quoted_string_literal_repeat1 = 169,
  aux_sym_triple_quoted_string_literal_repeat1 = 170,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_SEMI] = ";",
  [anon_sym_AT] = "@",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_import] = "import",
  [anon_sym_using] = "using",
  [anon_sym_namespace] = "namespace",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_model] = "model",
  [anon_sym_is] = "is",
  [anon_sym_extends] = "extends",
  [anon_sym_COMMA] = ",",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [anon_sym_valueof] = "valueof",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_QMARK] = "\?",
  [anon_sym_COLON] = ":",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_union] = "union",
  [anon_sym_scalar] = "scalar",
  [anon_sym_interface] = "interface",
  [anon_sym_op] = "op",
  [anon_sym_enum] = "enum",
  [anon_sym_alias] = "alias",
  [anon_sym_EQ] = "=",
  [anon_sym_AT_AT] = "@@",
  [anon_sym_dec] = "dec",
  [anon_sym_extern] = "extern",
  [anon_sym_fn] = "fn",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_numeric] = "numeric",
  [anon_sym_integer] = "integer",
  [anon_sym_float] = "float",
  [anon_sym_int64] = "int64",
  [anon_sym_int32] = "int32",
  [anon_sym_int16] = "int16",
  [anon_sym_int] = "int",
  [anon_sym_safeint] = "safeint",
  [anon_sym_uint6] = "uint6",
  [anon_sym_uint32] = "uint32",
  [anon_sym_uint16] = "uint16",
  [anon_sym_uint8] = "uint8",
  [anon_sym_float32] = "float32",
  [anon_sym_float64] = "float64",
  [anon_sym_decimal] = "decimal",
  [anon_sym_decimal128] = "decimal128",
  [anon_sym_plainDate] = "plainDate",
  [anon_sym_plainTime] = "plainTime",
  [anon_sym_utcDateTime] = "utcDateTime",
  [anon_sym_offsetDateTime] = "offsetDateTime",
  [anon_sym_duration] = "duration",
  [anon_sym_bytes] = "bytes",
  [anon_sym_string] = "string",
  [anon_sym_boolean] = "boolean",
  [anon_sym_null] = "null",
  [anon_sym_Array] = "Array",
  [anon_sym_Record] = "Record",
  [anon_sym_unknown] = "unknown",
  [anon_sym_void] = "void",
  [anon_sym_never] = "never",
  [sym_plain_identifier] = "plain_identifier",
  [anon_sym_BQUOTE] = "`",
  [sym_backticked_identifier_fragment] = "backticked_identifier_fragment",
  [anon_sym_DOT] = ".",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_decimal_literal] = "decimal_literal",
  [sym_hex_integer_literal] = "hex_integer_literal",
  [sym_binary_integer_literal] = "binary_integer_literal",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = "\"\"\"",
  [sym_escape_sequence] = "escape_sequence",
  [sym_quoted_string_fragment] = "quoted_string_fragment",
  [sym_triple_quoted_string_fragment] = "triple_quoted_string_fragment",
  [sym_single_line_comment] = "single_line_comment",
  [sym_multi_line_comment] = "multi_line_comment",
  [sym_source_file] = "source_file",
  [sym__item] = "_item",
  [sym__statement] = "_statement",
  [sym_decorator_list] = "decorator_list",
  [sym_decorator] = "decorator",
  [sym_decorator_arguments] = "decorator_arguments",
  [sym_import_statement] = "import_statement",
  [sym_using_statement] = "using_statement",
  [sym_namespace_statement] = "namespace_statement",
  [sym_namespace_body] = "namespace_body",
  [sym_model_statement] = "model_statement",
  [sym__model_heritage] = "_model_heritage",
  [sym_model_is_heritage] = "model_is_heritage",
  [sym_model_extends_heritage] = "model_extends_heritage",
  [sym_expression_list] = "expression_list",
  [sym__expression] = "_expression",
  [sym_union_expression] = "union_expression",
  [sym_intersection_expression] = "intersection_expression",
  [sym_value_of_expression] = "value_of_expression",
  [sym_array_expression] = "array_expression",
  [sym__primary_expression] = "_primary_expression",
  [sym_tuple_expression] = "tuple_expression",
  [sym_model_expression] = "model_expression",
  [sym_model_body] = "model_body",
  [sym_model_property] = "model_property",
  [sym_model_spread_property] = "model_spread_property",
  [sym_union_statement] = "union_statement",
  [sym_union_body] = "union_body",
  [sym_union_variant] = "union_variant",
  [sym_scalar_statement] = "scalar_statement",
  [sym_scalar_extends] = "scalar_extends",
  [sym_interface_statement] = "interface_statement",
  [sym_interface_heritage] = "interface_heritage",
  [sym_interface_body] = "interface_body",
  [sym_interface_member] = "interface_member",
  [sym_enum_statement] = "enum_statement",
  [sym_enum_body] = "enum_body",
  [sym_enum_spread_member] = "enum_spread_member",
  [sym_enum_member] = "enum_member",
  [sym_enum_member_value] = "enum_member_value",
  [sym_alias_statement] = "alias_statement",
  [sym_augment_decorator_statement] = "augment_decorator_statement",
  [sym_operation_statement] = "operation_statement",
  [sym__operation_signature] = "_operation_signature",
  [sym_operation_signature_declaration] = "operation_signature_declaration",
  [sym_operation_arguments] = "operation_arguments",
  [sym_operation_signature_reference] = "operation_signature_reference",
  [sym_decorator_declaration_statement] = "decorator_declaration_statement",
  [sym_decorator_modifiers] = "decorator_modifiers",
  [sym_function_parameter_list] = "function_parameter_list",
  [sym_function_parameter] = "function_parameter",
  [sym_type_annotation] = "type_annotation",
  [sym_function_declaration_statement] = "function_declaration_statement",
  [sym_function_modifiers] = "function_modifiers",
  [sym_reference_expression_list] = "reference_expression_list",
  [sym_reference_expression] = "reference_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_template_arguments] = "template_arguments",
  [sym_template_parameters] = "template_parameters",
  [sym_template_parameter_list] = "template_parameter_list",
  [sym_template_parameter] = "template_parameter",
  [sym_template_constraint] = "template_constraint",
  [sym_template_default] = "template_default",
  [sym_identifier_or_member_expression] = "identifier_or_member_expression",
  [sym_identifier] = "identifier",
  [sym_builtin_type] = "builtin_type",
  [sym_backticked_identifier] = "backticked_identifier",
  [sym_member_expression] = "member_expression",
  [sym__literal] = "_literal",
  [sym_boolean_literal] = "boolean_literal",
  [sym__numeric_literal] = "_numeric_literal",
  [sym__string_literal] = "_string_literal",
  [sym_quoted_string_literal] = "quoted_string_literal",
  [sym_triple_quoted_string_literal] = "triple_quoted_string_literal",
  [sym__comment] = "_comment",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_decorator_list_repeat1] = "decorator_list_repeat1",
  [aux_sym_namespace_body_repeat1] = "namespace_body_repeat1",
  [aux_sym_expression_list_repeat1] = "expression_list_repeat1",
  [aux_sym_model_body_repeat1] = "model_body_repeat1",
  [aux_sym_union_body_repeat1] = "union_body_repeat1",
  [aux_sym_interface_body_repeat1] = "interface_body_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_function_parameter_list_repeat1] = "function_parameter_list_repeat1",
  [aux_sym_reference_expression_list_repeat1] = "reference_expression_list_repeat1",
  [aux_sym_template_parameter_list_repeat1] = "template_parameter_list_repeat1",
  [aux_sym_backticked_identifier_repeat1] = "backticked_identifier_repeat1",
  [aux_sym_member_expression_repeat1] = "member_expression_repeat1",
  [aux_sym_quoted_string_literal_repeat1] = "quoted_string_literal_repeat1",
  [aux_sym_triple_quoted_string_literal_repeat1] = "triple_quoted_string_literal_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_model] = anon_sym_model,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_valueof] = anon_sym_valueof,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_scalar] = anon_sym_scalar,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_op] = anon_sym_op,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_alias] = anon_sym_alias,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_AT_AT] = anon_sym_AT_AT,
  [anon_sym_dec] = anon_sym_dec,
  [anon_sym_extern] = anon_sym_extern,
  [anon_sym_fn] = anon_sym_fn,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_numeric] = anon_sym_numeric,
  [anon_sym_integer] = anon_sym_integer,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_int64] = anon_sym_int64,
  [anon_sym_int32] = anon_sym_int32,
  [anon_sym_int16] = anon_sym_int16,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_safeint] = anon_sym_safeint,
  [anon_sym_uint6] = anon_sym_uint6,
  [anon_sym_uint32] = anon_sym_uint32,
  [anon_sym_uint16] = anon_sym_uint16,
  [anon_sym_uint8] = anon_sym_uint8,
  [anon_sym_float32] = anon_sym_float32,
  [anon_sym_float64] = anon_sym_float64,
  [anon_sym_decimal] = anon_sym_decimal,
  [anon_sym_decimal128] = anon_sym_decimal128,
  [anon_sym_plainDate] = anon_sym_plainDate,
  [anon_sym_plainTime] = anon_sym_plainTime,
  [anon_sym_utcDateTime] = anon_sym_utcDateTime,
  [anon_sym_offsetDateTime] = anon_sym_offsetDateTime,
  [anon_sym_duration] = anon_sym_duration,
  [anon_sym_bytes] = anon_sym_bytes,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_boolean] = anon_sym_boolean,
  [anon_sym_null] = anon_sym_null,
  [anon_sym_Array] = anon_sym_Array,
  [anon_sym_Record] = anon_sym_Record,
  [anon_sym_unknown] = anon_sym_unknown,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_never] = anon_sym_never,
  [sym_plain_identifier] = sym_plain_identifier,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [sym_backticked_identifier_fragment] = sym_backticked_identifier_fragment,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_decimal_literal] = sym_decimal_literal,
  [sym_hex_integer_literal] = sym_hex_integer_literal,
  [sym_binary_integer_literal] = sym_binary_integer_literal,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = anon_sym_DQUOTE_DQUOTE_DQUOTE,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_quoted_string_fragment] = sym_quoted_string_fragment,
  [sym_triple_quoted_string_fragment] = sym_triple_quoted_string_fragment,
  [sym_single_line_comment] = sym_single_line_comment,
  [sym_multi_line_comment] = sym_multi_line_comment,
  [sym_source_file] = sym_source_file,
  [sym__item] = sym__item,
  [sym__statement] = sym__statement,
  [sym_decorator_list] = sym_decorator_list,
  [sym_decorator] = sym_decorator,
  [sym_decorator_arguments] = sym_decorator_arguments,
  [sym_import_statement] = sym_import_statement,
  [sym_using_statement] = sym_using_statement,
  [sym_namespace_statement] = sym_namespace_statement,
  [sym_namespace_body] = sym_namespace_body,
  [sym_model_statement] = sym_model_statement,
  [sym__model_heritage] = sym__model_heritage,
  [sym_model_is_heritage] = sym_model_is_heritage,
  [sym_model_extends_heritage] = sym_model_extends_heritage,
  [sym_expression_list] = sym_expression_list,
  [sym__expression] = sym__expression,
  [sym_union_expression] = sym_union_expression,
  [sym_intersection_expression] = sym_intersection_expression,
  [sym_value_of_expression] = sym_value_of_expression,
  [sym_array_expression] = sym_array_expression,
  [sym__primary_expression] = sym__primary_expression,
  [sym_tuple_expression] = sym_tuple_expression,
  [sym_model_expression] = sym_model_expression,
  [sym_model_body] = sym_model_body,
  [sym_model_property] = sym_model_property,
  [sym_model_spread_property] = sym_model_spread_property,
  [sym_union_statement] = sym_union_statement,
  [sym_union_body] = sym_union_body,
  [sym_union_variant] = sym_union_variant,
  [sym_scalar_statement] = sym_scalar_statement,
  [sym_scalar_extends] = sym_scalar_extends,
  [sym_interface_statement] = sym_interface_statement,
  [sym_interface_heritage] = sym_interface_heritage,
  [sym_interface_body] = sym_interface_body,
  [sym_interface_member] = sym_interface_member,
  [sym_enum_statement] = sym_enum_statement,
  [sym_enum_body] = sym_enum_body,
  [sym_enum_spread_member] = sym_enum_spread_member,
  [sym_enum_member] = sym_enum_member,
  [sym_enum_member_value] = sym_enum_member_value,
  [sym_alias_statement] = sym_alias_statement,
  [sym_augment_decorator_statement] = sym_augment_decorator_statement,
  [sym_operation_statement] = sym_operation_statement,
  [sym__operation_signature] = sym__operation_signature,
  [sym_operation_signature_declaration] = sym_operation_signature_declaration,
  [sym_operation_arguments] = sym_operation_arguments,
  [sym_operation_signature_reference] = sym_operation_signature_reference,
  [sym_decorator_declaration_statement] = sym_decorator_declaration_statement,
  [sym_decorator_modifiers] = sym_decorator_modifiers,
  [sym_function_parameter_list] = sym_function_parameter_list,
  [sym_function_parameter] = sym_function_parameter,
  [sym_type_annotation] = sym_type_annotation,
  [sym_function_declaration_statement] = sym_function_declaration_statement,
  [sym_function_modifiers] = sym_function_modifiers,
  [sym_reference_expression_list] = sym_reference_expression_list,
  [sym_reference_expression] = sym_reference_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_template_arguments] = sym_template_arguments,
  [sym_template_parameters] = sym_template_parameters,
  [sym_template_parameter_list] = sym_template_parameter_list,
  [sym_template_parameter] = sym_template_parameter,
  [sym_template_constraint] = sym_template_constraint,
  [sym_template_default] = sym_template_default,
  [sym_identifier_or_member_expression] = sym_identifier_or_member_expression,
  [sym_identifier] = sym_identifier,
  [sym_builtin_type] = sym_builtin_type,
  [sym_backticked_identifier] = sym_backticked_identifier,
  [sym_member_expression] = sym_member_expression,
  [sym__literal] = sym__literal,
  [sym_boolean_literal] = sym_boolean_literal,
  [sym__numeric_literal] = sym__numeric_literal,
  [sym__string_literal] = sym__string_literal,
  [sym_quoted_string_literal] = sym_quoted_string_literal,
  [sym_triple_quoted_string_literal] = sym_triple_quoted_string_literal,
  [sym__comment] = sym__comment,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_decorator_list_repeat1] = aux_sym_decorator_list_repeat1,
  [aux_sym_namespace_body_repeat1] = aux_sym_namespace_body_repeat1,
  [aux_sym_expression_list_repeat1] = aux_sym_expression_list_repeat1,
  [aux_sym_model_body_repeat1] = aux_sym_model_body_repeat1,
  [aux_sym_union_body_repeat1] = aux_sym_union_body_repeat1,
  [aux_sym_interface_body_repeat1] = aux_sym_interface_body_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_function_parameter_list_repeat1] = aux_sym_function_parameter_list_repeat1,
  [aux_sym_reference_expression_list_repeat1] = aux_sym_reference_expression_list_repeat1,
  [aux_sym_template_parameter_list_repeat1] = aux_sym_template_parameter_list_repeat1,
  [aux_sym_backticked_identifier_repeat1] = aux_sym_backticked_identifier_repeat1,
  [aux_sym_member_expression_repeat1] = aux_sym_member_expression_repeat1,
  [aux_sym_quoted_string_literal_repeat1] = aux_sym_quoted_string_literal_repeat1,
  [aux_sym_triple_quoted_string_literal_repeat1] = aux_sym_triple_quoted_string_literal_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_model] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_valueof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_scalar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_op] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alias] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extern] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_numeric] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_integer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_safeint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint6] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_decimal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_decimal128] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_plainDate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_plainTime] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_utcDateTime] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_offsetDateTime] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_duration] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_boolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_null] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Array] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Record] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unknown] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_never] = {
    .visible = true,
    .named = false,
  },
  [sym_plain_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_backticked_identifier_fragment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_decimal_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_integer_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE_DQUOTE_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_triple_quoted_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_single_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_multi_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__item] = {
    .visible = false,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_decorator_list] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_using_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_body] = {
    .visible = true,
    .named = true,
  },
  [sym_model_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__model_heritage] = {
    .visible = false,
    .named = true,
  },
  [sym_model_is_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_model_extends_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_union_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_value_of_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_array_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__primary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_model_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_model_body] = {
    .visible = true,
    .named = true,
  },
  [sym_model_property] = {
    .visible = true,
    .named = true,
  },
  [sym_model_spread_property] = {
    .visible = true,
    .named = true,
  },
  [sym_union_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_union_body] = {
    .visible = true,
    .named = true,
  },
  [sym_union_variant] = {
    .visible = true,
    .named = true,
  },
  [sym_scalar_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_scalar_extends] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_body] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_member] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_spread_member] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_member] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_member_value] = {
    .visible = true,
    .named = true,
  },
  [sym_alias_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_augment_decorator_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_operation_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__operation_signature] = {
    .visible = false,
    .named = true,
  },
  [sym_operation_signature_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_operation_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_operation_signature_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_declaration_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_function_modifiers] = {
    .visible = true,
    .named = true,
  },
  [sym_reference_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_reference_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_template_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_template_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_template_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_template_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_template_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_template_default] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier_or_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_builtin_type] = {
    .visible = true,
    .named = true,
  },
  [sym_backticked_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym_boolean_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__numeric_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_quoted_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_triple_quoted_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__comment] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_decorator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_namespace_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_model_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_reference_expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_backticked_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_member_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_quoted_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_triple_quoted_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_base = 1,
  field_constraint = 2,
  field_default = 3,
  field_member = 4,
  field_module = 5,
  field_name = 6,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_base] = "base",
  [field_constraint] = "constraint",
  [field_default] = "default",
  [field_member] = "member",
  [field_module] = "module",
  [field_name] = "name",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 2},
  [6] = {.index = 7, .length = 1},
  [7] = {.index = 8, .length = 1},
  [8] = {.index = 9, .length = 2},
  [9] = {.index = 11, .length = 2},
  [10] = {.index = 13, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1},
  [1] =
    {field_base, 0},
    {field_member, 1, .inherited = true},
  [3] =
    {field_module, 1},
  [4] =
    {field_member, 1},
  [5] =
    {field_member, 0, .inherited = true},
    {field_member, 1, .inherited = true},
  [7] =
    {field_name, 0},
  [8] =
    {field_name, 2},
  [9] =
    {field_constraint, 1},
    {field_name, 0},
  [11] =
    {field_default, 1},
    {field_name, 0},
  [13] =
    {field_constraint, 1},
    {field_default, 2},
    {field_name, 0},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 2,
  [5] = 5,
  [6] = 3,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 9,
  [11] = 11,
  [12] = 9,
  [13] = 11,
  [14] = 11,
  [15] = 9,
  [16] = 11,
  [17] = 11,
  [18] = 18,
  [19] = 18,
  [20] = 18,
  [21] = 18,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 23,
  [31] = 31,
  [32] = 22,
  [33] = 33,
  [34] = 22,
  [35] = 31,
  [36] = 36,
  [37] = 25,
  [38] = 38,
  [39] = 25,
  [40] = 22,
  [41] = 31,
  [42] = 23,
  [43] = 43,
  [44] = 36,
  [45] = 45,
  [46] = 31,
  [47] = 47,
  [48] = 48,
  [49] = 23,
  [50] = 50,
  [51] = 33,
  [52] = 38,
  [53] = 38,
  [54] = 54,
  [55] = 55,
  [56] = 33,
  [57] = 57,
  [58] = 25,
  [59] = 33,
  [60] = 38,
  [61] = 24,
  [62] = 36,
  [63] = 26,
  [64] = 33,
  [65] = 38,
  [66] = 66,
  [67] = 67,
  [68] = 23,
  [69] = 69,
  [70] = 70,
  [71] = 31,
  [72] = 72,
  [73] = 22,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 102,
  [104] = 104,
  [105] = 105,
  [106] = 102,
  [107] = 107,
  [108] = 102,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 110,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 114,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 96,
  [128] = 98,
  [129] = 100,
  [130] = 130,
  [131] = 99,
  [132] = 132,
  [133] = 133,
  [134] = 97,
  [135] = 135,
  [136] = 94,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 95,
  [142] = 142,
  [143] = 101,
  [144] = 144,
  [145] = 145,
  [146] = 77,
  [147] = 104,
  [148] = 78,
  [149] = 76,
  [150] = 74,
  [151] = 75,
  [152] = 90,
  [153] = 153,
  [154] = 88,
  [155] = 82,
  [156] = 156,
  [157] = 156,
  [158] = 91,
  [159] = 159,
  [160] = 84,
  [161] = 159,
  [162] = 92,
  [163] = 86,
  [164] = 93,
  [165] = 79,
  [166] = 166,
  [167] = 81,
  [168] = 121,
  [169] = 169,
  [170] = 170,
  [171] = 116,
  [172] = 85,
  [173] = 83,
  [174] = 174,
  [175] = 80,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 181,
  [189] = 180,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 97,
  [211] = 211,
  [212] = 94,
  [213] = 213,
  [214] = 214,
  [215] = 130,
  [216] = 216,
  [217] = 135,
  [218] = 95,
  [219] = 207,
  [220] = 220,
  [221] = 221,
  [222] = 206,
  [223] = 223,
  [224] = 214,
  [225] = 225,
  [226] = 226,
  [227] = 225,
  [228] = 126,
  [229] = 229,
  [230] = 207,
  [231] = 207,
  [232] = 232,
  [233] = 209,
  [234] = 229,
  [235] = 223,
  [236] = 236,
  [237] = 126,
  [238] = 135,
  [239] = 130,
  [240] = 240,
  [241] = 101,
  [242] = 99,
  [243] = 243,
  [244] = 100,
  [245] = 96,
  [246] = 98,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 251,
  [256] = 256,
  [257] = 257,
  [258] = 256,
  [259] = 257,
  [260] = 260,
  [261] = 261,
  [262] = 252,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 104,
  [267] = 265,
  [268] = 268,
  [269] = 248,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 265,
  [275] = 275,
  [276] = 142,
  [277] = 261,
  [278] = 278,
  [279] = 250,
  [280] = 253,
  [281] = 281,
  [282] = 282,
  [283] = 264,
  [284] = 145,
  [285] = 265,
  [286] = 144,
  [287] = 263,
  [288] = 271,
  [289] = 281,
  [290] = 290,
  [291] = 282,
  [292] = 272,
  [293] = 265,
  [294] = 249,
  [295] = 278,
  [296] = 296,
  [297] = 297,
  [298] = 142,
  [299] = 299,
  [300] = 144,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 145,
  [307] = 96,
  [308] = 99,
  [309] = 98,
  [310] = 100,
  [311] = 95,
  [312] = 97,
  [313] = 94,
  [314] = 101,
  [315] = 104,
  [316] = 95,
  [317] = 94,
  [318] = 97,
  [319] = 101,
  [320] = 96,
  [321] = 98,
  [322] = 99,
  [323] = 100,
  [324] = 104,
  [325] = 77,
  [326] = 77,
  [327] = 91,
  [328] = 84,
  [329] = 74,
  [330] = 78,
  [331] = 91,
  [332] = 92,
  [333] = 84,
  [334] = 88,
  [335] = 79,
  [336] = 90,
  [337] = 86,
  [338] = 93,
  [339] = 79,
  [340] = 82,
  [341] = 90,
  [342] = 76,
  [343] = 75,
  [344] = 74,
  [345] = 78,
  [346] = 92,
  [347] = 76,
  [348] = 75,
  [349] = 86,
  [350] = 93,
  [351] = 82,
  [352] = 88,
  [353] = 81,
  [354] = 116,
  [355] = 355,
  [356] = 216,
  [357] = 355,
  [358] = 121,
  [359] = 359,
  [360] = 116,
  [361] = 361,
  [362] = 80,
  [363] = 361,
  [364] = 121,
  [365] = 80,
  [366] = 81,
  [367] = 83,
  [368] = 216,
  [369] = 85,
  [370] = 83,
  [371] = 359,
  [372] = 85,
  [373] = 373,
  [374] = 374,
  [375] = 373,
  [376] = 374,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 145,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 378,
  [397] = 397,
  [398] = 392,
  [399] = 379,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 142,
  [409] = 385,
  [410] = 405,
  [411] = 411,
  [412] = 397,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 401,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 404,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 383,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 384,
  [433] = 386,
  [434] = 395,
  [435] = 394,
  [436] = 426,
  [437] = 418,
  [438] = 393,
  [439] = 406,
  [440] = 400,
  [441] = 387,
  [442] = 419,
  [443] = 420,
  [444] = 407,
  [445] = 422,
  [446] = 388,
  [447] = 423,
  [448] = 411,
  [449] = 391,
  [450] = 424,
  [451] = 425,
  [452] = 413,
  [453] = 142,
  [454] = 389,
  [455] = 403,
  [456] = 145,
  [457] = 428,
  [458] = 380,
  [459] = 414,
  [460] = 429,
  [461] = 416,
  [462] = 415,
  [463] = 381,
  [464] = 431,
  [465] = 382,
  [466] = 402,
  [467] = 377,
  [468] = 430,
  [469] = 469,
  [470] = 116,
  [471] = 130,
  [472] = 472,
  [473] = 473,
  [474] = 126,
  [475] = 135,
  [476] = 121,
  [477] = 469,
  [478] = 473,
  [479] = 479,
  [480] = 480,
  [481] = 480,
  [482] = 479,
  [483] = 483,
  [484] = 144,
  [485] = 485,
  [486] = 485,
  [487] = 487,
  [488] = 487,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 490,
  [497] = 489,
  [498] = 492,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 495,
  [503] = 503,
  [504] = 504,
  [505] = 503,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 506,
  [510] = 510,
  [511] = 504,
  [512] = 512,
  [513] = 513,
  [514] = 512,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 518,
  [519] = 515,
  [520] = 520,
  [521] = 521,
  [522] = 522,
  [523] = 512,
  [524] = 524,
  [525] = 513,
  [526] = 513,
  [527] = 524,
  [528] = 517,
  [529] = 529,
  [530] = 530,
  [531] = 524,
  [532] = 515,
  [533] = 515,
  [534] = 513,
  [535] = 512,
  [536] = 515,
  [537] = 537,
  [538] = 538,
  [539] = 529,
  [540] = 538,
  [541] = 541,
  [542] = 517,
  [543] = 520,
  [544] = 541,
  [545] = 524,
  [546] = 520,
  [547] = 517,
  [548] = 520,
  [549] = 524,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 551,
  [557] = 557,
  [558] = 553,
  [559] = 559,
  [560] = 560,
  [561] = 561,
  [562] = 552,
  [563] = 563,
  [564] = 564,
  [565] = 561,
  [566] = 566,
  [567] = 567,
  [568] = 555,
  [569] = 569,
  [570] = 559,
  [571] = 553,
  [572] = 572,
  [573] = 564,
  [574] = 574,
  [575] = 566,
  [576] = 553,
  [577] = 577,
  [578] = 578,
  [579] = 579,
  [580] = 580,
  [581] = 581,
  [582] = 582,
  [583] = 583,
  [584] = 584,
  [585] = 585,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 577,
  [592] = 592,
  [593] = 593,
  [594] = 594,
  [595] = 595,
  [596] = 596,
  [597] = 597,
  [598] = 592,
  [599] = 590,
  [600] = 578,
  [601] = 581,
  [602] = 582,
  [603] = 603,
  [604] = 589,
  [605] = 605,
  [606] = 606,
  [607] = 583,
  [608] = 579,
  [609] = 603,
  [610] = 610,
  [611] = 611,
  [612] = 611,
  [613] = 596,
  [614] = 606,
  [615] = 594,
  [616] = 588,
  [617] = 587,
  [618] = 586,
  [619] = 580,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 625,
  [626] = 621,
  [627] = 627,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 633,
  [634] = 634,
  [635] = 623,
  [636] = 624,
  [637] = 625,
  [638] = 632,
  [639] = 632,
  [640] = 640,
  [641] = 632,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 633,
  [646] = 634,
  [647] = 633,
  [648] = 648,
  [649] = 633,
  [650] = 650,
  [651] = 651,
  [652] = 652,
  [653] = 632,
  [654] = 625,
  [655] = 655,
  [656] = 656,
  [657] = 624,
  [658] = 658,
  [659] = 659,
  [660] = 623,
  [661] = 624,
  [662] = 623,
  [663] = 663,
  [664] = 627,
  [665] = 665,
  [666] = 659,
  [667] = 658,
  [668] = 644,
  [669] = 669,
  [670] = 625,
  [671] = 655,
  [672] = 620,
  [673] = 631,
  [674] = 630,
  [675] = 652,
  [676] = 640,
  [677] = 629,
  [678] = 678,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(193);
      ADVANCE_MAP(
        '"', 438,
        '&', 209,
        '(', 197,
        ')', 198,
        ',', 207,
        '.', 425,
        '/', 9,
        '0', 430,
        ':', 215,
        ';', 194,
        '<', 229,
        '=', 224,
        '>', 230,
        '?', 214,
        '@', 196,
        'A', 152,
        'R', 57,
        '[', 212,
        '\\', 187,
        ']', 213,
        '`', 417,
        'a', 104,
        'b', 137,
        'd', 69,
        'e', 120,
        'f', 33,
        'i', 113,
        'm', 135,
        'n', 29,
        'o', 82,
        'p', 105,
        's', 31,
        't', 151,
        'u', 90,
        'v', 34,
        '{', 202,
        '|', 208,
        '}', 203,
        '+', 14,
        '-', 14,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(191);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(432);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '"', 438,
        '&', 209,
        '(', 197,
        ')', 198,
        ',', 207,
        '.', 425,
        '/', 9,
        ':', 215,
        ';', 194,
        '<', 229,
        '?', 214,
        '@', 195,
        'A', 394,
        'R', 322,
        '[', 212,
        '`', 417,
        'b', 381,
        'd', 331,
        'f', 364,
        'i', 376,
        'n', 323,
        'o', 343,
        'p', 360,
        's', 306,
        'u', 355,
        'v', 382,
        '{', 202,
        '|', 208,
        '}', 203,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '"', 438,
        '&', 209,
        '(', 197,
        ')', 198,
        ',', 207,
        '.', 424,
        '/', 9,
        '0', 430,
        ':', 215,
        ';', 194,
        '<', 229,
        '=', 224,
        '>', 230,
        '?', 214,
        '@', 195,
        'A', 394,
        'R', 322,
        '[', 212,
        ']', 213,
        '`', 417,
        'b', 381,
        'd', 331,
        'f', 305,
        'i', 376,
        'n', 323,
        'o', 343,
        'p', 360,
        's', 306,
        't', 389,
        'u', 355,
        'v', 307,
        '{', 202,
        '|', 208,
        '}', 203,
        '+', 14,
        '-', 14,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(432);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(4);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(439);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(437);
      if (lookahead == '/') ADVANCE(9);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(437);
      if (lookahead == '/') ADVANCE(441);
      if (lookahead == '\\') ADVANCE(187);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(5);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(444);
      if (lookahead != 0) ADVANCE(446);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(3);
      if (lookahead == '/') ADVANCE(447);
      if (lookahead == '\\') ADVANCE(187);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(450);
      if (lookahead != 0) ADVANCE(452);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '(', 197,
        '.', 424,
        '/', 9,
        '@', 195,
        'A', 394,
        'R', 322,
        '`', 417,
        'b', 381,
        'd', 331,
        'f', 364,
        'i', 376,
        'n', 323,
        'o', 342,
        'p', 360,
        's', 306,
        'u', 355,
        'v', 382,
        '}', 203,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8);
      if (('B' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 9:
      if (lookahead == '*') ADVANCE(11);
      if (lookahead == '/') ADVANCE(453);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(10);
      if (lookahead == '/') ADVANCE(454);
      if (lookahead != 0) ADVANCE(11);
      END_STATE();
    case 11:
      if (lookahead == '*') ADVANCE(10);
      if (lookahead != 0) ADVANCE(11);
      END_STATE();
    case 12:
      if (lookahead == '.') ADVANCE(216);
      END_STATE();
    case 13:
      if (lookahead == '/') ADVANCE(418);
      if (lookahead == '\\') ADVANCE(187);
      if (lookahead == '`') ADVANCE(417);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(421);
      if (lookahead != 0) ADVANCE(423);
      END_STATE();
    case 14:
      if (lookahead == '0') ADVANCE(431);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(432);
      END_STATE();
    case 15:
      if (lookahead == '1') ADVANCE(22);
      if (lookahead == '3') ADVANCE(17);
      if (lookahead == '6') ADVANCE(247);
      if (lookahead == '8') ADVANCE(253);
      END_STATE();
    case 16:
      if (lookahead == '2') ADVANCE(239);
      END_STATE();
    case 17:
      if (lookahead == '2') ADVANCE(249);
      END_STATE();
    case 18:
      if (lookahead == '2') ADVANCE(255);
      END_STATE();
    case 19:
      if (lookahead == '4') ADVANCE(237);
      END_STATE();
    case 20:
      if (lookahead == '4') ADVANCE(257);
      END_STATE();
    case 21:
      if (lookahead == '6') ADVANCE(241);
      END_STATE();
    case 22:
      if (lookahead == '6') ADVANCE(251);
      END_STATE();
    case 23:
      if (lookahead == 'D') ADVANCE(43);
      END_STATE();
    case 24:
      if (lookahead == 'D') ADVANCE(44);
      if (lookahead == 'T') ADVANCE(99);
      END_STATE();
    case 25:
      if (lookahead == 'D') ADVANCE(45);
      END_STATE();
    case 26:
      if (lookahead == 'T') ADVANCE(102);
      END_STATE();
    case 27:
      if (lookahead == 'T') ADVANCE(103);
      END_STATE();
    case 28:
      if (lookahead == 'a') ADVANCE(119);
      END_STATE();
    case 29:
      if (lookahead == 'a') ADVANCE(119);
      if (lookahead == 'e') ADVANCE(182);
      if (lookahead == 'u') ADVANCE(109);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(184);
      END_STATE();
    case 31:
      if (lookahead == 'a') ADVANCE(84);
      if (lookahead == 'c') ADVANCE(38);
      if (lookahead == 't') ADVANCE(159);
      END_STATE();
    case 32:
      if (lookahead == 'a') ADVANCE(160);
      END_STATE();
    case 33:
      if (lookahead == 'a') ADVANCE(106);
      if (lookahead == 'l') ADVANCE(142);
      if (lookahead == 'n') ADVANCE(228);
      END_STATE();
    case 34:
      if (lookahead == 'a') ADVANCE(112);
      if (lookahead == 'o') ADVANCE(91);
      END_STATE();
    case 35:
      if (lookahead == 'a') ADVANCE(173);
      END_STATE();
    case 36:
      if (lookahead == 'a') ADVANCE(51);
      END_STATE();
    case 37:
      if (lookahead == 'a') ADVANCE(168);
      END_STATE();
    case 38:
      if (lookahead == 'a') ADVANCE(110);
      END_STATE();
    case 39:
      if (lookahead == 'a') ADVANCE(125);
      END_STATE();
    case 40:
      if (lookahead == 'a') ADVANCE(149);
      END_STATE();
    case 41:
      if (lookahead == 'a') ADVANCE(95);
      END_STATE();
    case 42:
      if (lookahead == 'a') ADVANCE(52);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(174);
      END_STATE();
    case 44:
      if (lookahead == 'a') ADVANCE(175);
      END_STATE();
    case 45:
      if (lookahead == 'a') ADVANCE(177);
      END_STATE();
    case 46:
      if (lookahead == 'c') ADVANCE(226);
      END_STATE();
    case 47:
      if (lookahead == 'c') ADVANCE(23);
      END_STATE();
    case 48:
      if (lookahead == 'c') ADVANCE(231);
      END_STATE();
    case 49:
      if (lookahead == 'c') ADVANCE(38);
      END_STATE();
    case 50:
      if (lookahead == 'c') ADVANCE(139);
      END_STATE();
    case 51:
      if (lookahead == 'c') ADVANCE(62);
      END_STATE();
    case 52:
      if (lookahead == 'c') ADVANCE(67);
      END_STATE();
    case 53:
      if (lookahead == 'd') ADVANCE(285);
      END_STATE();
    case 54:
      if (lookahead == 'd') ADVANCE(281);
      END_STATE();
    case 55:
      if (lookahead == 'd') ADVANCE(77);
      END_STATE();
    case 56:
      if (lookahead == 'd') ADVANCE(162);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(50);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(131);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(426);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(428);
      END_STATE();
    case 61:
      if (lookahead == 'e') ADVANCE(26);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(201);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(261);
      END_STATE();
    case 64:
      if (lookahead == 'e') ADVANCE(263);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(265);
      END_STATE();
    case 66:
      if (lookahead == 'e') ADVANCE(267);
      END_STATE();
    case 67:
      if (lookahead == 'e') ADVANCE(219);
      END_STATE();
    case 68:
      if (lookahead == 'e') ADVANCE(46);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(46);
      if (lookahead == 'u') ADVANCE(156);
      END_STATE();
    case 70:
      if (lookahead == 'e') ADVANCE(161);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(163);
      END_STATE();
    case 73:
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 74:
      if (lookahead == 'e') ADVANCE(138);
      END_STATE();
    case 75:
      if (lookahead == 'e') ADVANCE(178);
      END_STATE();
    case 76:
      if (lookahead == 'e') ADVANCE(157);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 78:
      if (lookahead == 'e') ADVANCE(39);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(150);
      END_STATE();
    case 80:
      if (lookahead == 'e') ADVANCE(155);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(27);
      END_STATE();
    case 82:
      if (lookahead == 'f') ADVANCE(85);
      if (lookahead == 'p') ADVANCE(220);
      END_STATE();
    case 83:
      if (lookahead == 'f') ADVANCE(210);
      END_STATE();
    case 84:
      if (lookahead == 'f') ADVANCE(71);
      END_STATE();
    case 85:
      if (lookahead == 'f') ADVANCE(165);
      END_STATE();
    case 86:
      if (lookahead == 'f') ADVANCE(42);
      END_STATE();
    case 87:
      if (lookahead == 'g') ADVANCE(200);
      END_STATE();
    case 88:
      if (lookahead == 'g') ADVANCE(273);
      END_STATE();
    case 89:
      if (lookahead == 'g') ADVANCE(79);
      END_STATE();
    case 90:
      if (lookahead == 'i') ADVANCE(129);
      if (lookahead == 'n') ADVANCE(97);
      if (lookahead == 's') ADVANCE(92);
      if (lookahead == 't') ADVANCE(47);
      END_STATE();
    case 91:
      if (lookahead == 'i') ADVANCE(53);
      END_STATE();
    case 92:
      if (lookahead == 'i') ADVANCE(128);
      END_STATE();
    case 93:
      if (lookahead == 'i') ADVANCE(48);
      END_STATE();
    case 94:
      if (lookahead == 'i') ADVANCE(32);
      END_STATE();
    case 95:
      if (lookahead == 'i') ADVANCE(122);
      END_STATE();
    case 96:
      if (lookahead == 'i') ADVANCE(143);
      END_STATE();
    case 97:
      if (lookahead == 'i') ADVANCE(143);
      if (lookahead == 'k') ADVANCE(132);
      END_STATE();
    case 98:
      if (lookahead == 'i') ADVANCE(130);
      END_STATE();
    case 99:
      if (lookahead == 'i') ADVANCE(116);
      END_STATE();
    case 100:
      if (lookahead == 'i') ADVANCE(133);
      END_STATE();
    case 101:
      if (lookahead == 'i') ADVANCE(144);
      END_STATE();
    case 102:
      if (lookahead == 'i') ADVANCE(117);
      END_STATE();
    case 103:
      if (lookahead == 'i') ADVANCE(118);
      END_STATE();
    case 104:
      if (lookahead == 'l') ADVANCE(94);
      END_STATE();
    case 105:
      if (lookahead == 'l') ADVANCE(41);
      END_STATE();
    case 106:
      if (lookahead == 'l') ADVANCE(164);
      END_STATE();
    case 107:
      if (lookahead == 'l') ADVANCE(277);
      END_STATE();
    case 108:
      if (lookahead == 'l') ADVANCE(204);
      END_STATE();
    case 109:
      if (lookahead == 'l') ADVANCE(107);
      if (lookahead == 'm') ADVANCE(76);
      END_STATE();
    case 110:
      if (lookahead == 'l') ADVANCE(40);
      END_STATE();
    case 111:
      if (lookahead == 'l') ADVANCE(78);
      END_STATE();
    case 112:
      if (lookahead == 'l') ADVANCE(181);
      END_STATE();
    case 113:
      if (lookahead == 'm') ADVANCE(147);
      if (lookahead == 'n') ADVANCE(166);
      if (lookahead == 's') ADVANCE(205);
      END_STATE();
    case 114:
      if (lookahead == 'm') ADVANCE(147);
      if (lookahead == 'n') ADVANCE(176);
      if (lookahead == 's') ADVANCE(205);
      END_STATE();
    case 115:
      if (lookahead == 'm') ADVANCE(222);
      END_STATE();
    case 116:
      if (lookahead == 'm') ADVANCE(64);
      END_STATE();
    case 117:
      if (lookahead == 'm') ADVANCE(65);
      END_STATE();
    case 118:
      if (lookahead == 'm') ADVANCE(66);
      END_STATE();
    case 119:
      if (lookahead == 'm') ADVANCE(72);
      END_STATE();
    case 120:
      if (lookahead == 'n') ADVANCE(179);
      if (lookahead == 'x') ADVANCE(172);
      END_STATE();
    case 121:
      if (lookahead == 'n') ADVANCE(228);
      END_STATE();
    case 122:
      if (lookahead == 'n') ADVANCE(24);
      END_STATE();
    case 123:
      if (lookahead == 'n') ADVANCE(217);
      END_STATE();
    case 124:
      if (lookahead == 'n') ADVANCE(227);
      END_STATE();
    case 125:
      if (lookahead == 'n') ADVANCE(275);
      END_STATE();
    case 126:
      if (lookahead == 'n') ADVANCE(283);
      END_STATE();
    case 127:
      if (lookahead == 'n') ADVANCE(269);
      END_STATE();
    case 128:
      if (lookahead == 'n') ADVANCE(87);
      END_STATE();
    case 129:
      if (lookahead == 'n') ADVANCE(167);
      END_STATE();
    case 130:
      if (lookahead == 'n') ADVANCE(88);
      END_STATE();
    case 131:
      if (lookahead == 'n') ADVANCE(56);
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 132:
      if (lookahead == 'n') ADVANCE(136);
      END_STATE();
    case 133:
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 134:
      if (lookahead == 'n') ADVANCE(96);
      if (lookahead == 's') ADVANCE(92);
      END_STATE();
    case 135:
      if (lookahead == 'o') ADVANCE(55);
      END_STATE();
    case 136:
      if (lookahead == 'o') ADVANCE(183);
      END_STATE();
    case 137:
      if (lookahead == 'o') ADVANCE(140);
      if (lookahead == 'y') ADVANCE(171);
      END_STATE();
    case 138:
      if (lookahead == 'o') ADVANCE(83);
      END_STATE();
    case 139:
      if (lookahead == 'o') ADVANCE(153);
      END_STATE();
    case 140:
      if (lookahead == 'o') ADVANCE(111);
      END_STATE();
    case 141:
      if (lookahead == 'o') ADVANCE(158);
      END_STATE();
    case 142:
      if (lookahead == 'o') ADVANCE(37);
      END_STATE();
    case 143:
      if (lookahead == 'o') ADVANCE(123);
      END_STATE();
    case 144:
      if (lookahead == 'o') ADVANCE(127);
      END_STATE();
    case 145:
      if (lookahead == 'p') ADVANCE(220);
      END_STATE();
    case 146:
      if (lookahead == 'p') ADVANCE(36);
      END_STATE();
    case 147:
      if (lookahead == 'p') ADVANCE(141);
      END_STATE();
    case 148:
      if (lookahead == 'r') ADVANCE(287);
      END_STATE();
    case 149:
      if (lookahead == 'r') ADVANCE(218);
      END_STATE();
    case 150:
      if (lookahead == 'r') ADVANCE(233);
      END_STATE();
    case 151:
      if (lookahead == 'r') ADVANCE(180);
      END_STATE();
    case 152:
      if (lookahead == 'r') ADVANCE(154);
      END_STATE();
    case 153:
      if (lookahead == 'r') ADVANCE(54);
      END_STATE();
    case 154:
      if (lookahead == 'r') ADVANCE(30);
      END_STATE();
    case 155:
      if (lookahead == 'r') ADVANCE(86);
      END_STATE();
    case 156:
      if (lookahead == 'r') ADVANCE(35);
      END_STATE();
    case 157:
      if (lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 158:
      if (lookahead == 'r') ADVANCE(169);
      END_STATE();
    case 159:
      if (lookahead == 'r') ADVANCE(98);
      END_STATE();
    case 160:
      if (lookahead == 's') ADVANCE(223);
      END_STATE();
    case 161:
      if (lookahead == 's') ADVANCE(271);
      END_STATE();
    case 162:
      if (lookahead == 's') ADVANCE(206);
      END_STATE();
    case 163:
      if (lookahead == 's') ADVANCE(146);
      END_STATE();
    case 164:
      if (lookahead == 's') ADVANCE(60);
      END_STATE();
    case 165:
      if (lookahead == 's') ADVANCE(75);
      END_STATE();
    case 166:
      if (lookahead == 't') ADVANCE(243);
      END_STATE();
    case 167:
      if (lookahead == 't') ADVANCE(15);
      END_STATE();
    case 168:
      if (lookahead == 't') ADVANCE(235);
      END_STATE();
    case 169:
      if (lookahead == 't') ADVANCE(199);
      END_STATE();
    case 170:
      if (lookahead == 't') ADVANCE(245);
      END_STATE();
    case 171:
      if (lookahead == 't') ADVANCE(70);
      END_STATE();
    case 172:
      if (lookahead == 't') ADVANCE(58);
      END_STATE();
    case 173:
      if (lookahead == 't') ADVANCE(101);
      END_STATE();
    case 174:
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 175:
      if (lookahead == 't') ADVANCE(63);
      END_STATE();
    case 176:
      if (lookahead == 't') ADVANCE(80);
      END_STATE();
    case 177:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 178:
      if (lookahead == 't') ADVANCE(25);
      END_STATE();
    case 179:
      if (lookahead == 'u') ADVANCE(115);
      END_STATE();
    case 180:
      if (lookahead == 'u') ADVANCE(59);
      END_STATE();
    case 181:
      if (lookahead == 'u') ADVANCE(74);
      END_STATE();
    case 182:
      if (lookahead == 'v') ADVANCE(73);
      END_STATE();
    case 183:
      if (lookahead == 'w') ADVANCE(126);
      END_STATE();
    case 184:
      if (lookahead == 'y') ADVANCE(279);
      END_STATE();
    case 185:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(189);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(434);
      END_STATE();
    case 186:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(436);
      END_STATE();
    case 187:
      if (lookahead == '"' ||
          lookahead == '\\' ||
          lookahead == '`' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(440);
      END_STATE();
    case 188:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(433);
      END_STATE();
    case 189:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(434);
      END_STATE();
    case 190:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(435);
      END_STATE();
    case 191:
      if (eof) ADVANCE(193);
      ADVANCE_MAP(
        '"', 438,
        '&', 209,
        '(', 197,
        ')', 198,
        ',', 207,
        '.', 425,
        '/', 9,
        '0', 430,
        ':', 215,
        ';', 194,
        '<', 229,
        '=', 224,
        '>', 230,
        '?', 214,
        '@', 196,
        'A', 152,
        'R', 57,
        '[', 212,
        ']', 213,
        '`', 417,
        'a', 104,
        'b', 137,
        'd', 69,
        'e', 120,
        'f', 33,
        'i', 113,
        'm', 135,
        'n', 29,
        'o', 82,
        'p', 105,
        's', 31,
        't', 151,
        'u', 90,
        'v', 34,
        '{', 202,
        '|', 208,
        '}', 203,
        '+', 14,
        '-', 14,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(191);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(432);
      END_STATE();
    case 192:
      if (eof) ADVANCE(193);
      ADVANCE_MAP(
        '&', 209,
        '(', 197,
        ')', 198,
        ',', 207,
        '.', 424,
        '/', 9,
        ':', 215,
        ';', 194,
        '<', 229,
        '=', 224,
        '>', 230,
        '?', 214,
        '@', 196,
        '[', 212,
        ']', 213,
        'a', 104,
        'd', 68,
        'e', 120,
        'f', 121,
        'i', 114,
        'm', 135,
        'n', 28,
        'o', 145,
        's', 49,
        'u', 134,
        '{', 202,
        '|', 208,
        '}', 203,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(192);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '@') ADVANCE(225);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_model);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_valueof);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_valueof);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_union);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_scalar);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_op);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_op);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_alias);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_AT_AT);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_dec);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_extern);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_numeric);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_numeric);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_integer);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_integer);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_float);
      if (lookahead == '3') ADVANCE(18);
      if (lookahead == '6') ADVANCE(20);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_float);
      if (lookahead == '3') ADVANCE(292);
      if (lookahead == '6') ADVANCE(295);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_int64);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_int64);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_int32);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_int32);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_int16);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_int16);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_int);
      if (lookahead == '1') ADVANCE(21);
      if (lookahead == '3') ADVANCE(16);
      if (lookahead == '6') ADVANCE(19);
      if (lookahead == 'e') ADVANCE(89);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_int);
      if (lookahead == '1') ADVANCE(296);
      if (lookahead == '3') ADVANCE(290);
      if (lookahead == '6') ADVANCE(294);
      if (lookahead == 'e') ADVANCE(347);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_safeint);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_safeint);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_uint6);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_uint6);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_uint32);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_uint32);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_uint16);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_uint16);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_uint8);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_uint8);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_float32);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_float32);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_float64);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_float64);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_decimal);
      if (lookahead == '1') ADVANCE(293);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_decimal128);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_plainDate);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_plainDate);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_plainTime);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_plainTime);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_utcDateTime);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_utcDateTime);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_offsetDateTime);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_offsetDateTime);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_duration);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_duration);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(anon_sym_bytes);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(anon_sym_bytes);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(anon_sym_string);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_boolean);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(anon_sym_boolean);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_null);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_null);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_Array);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_Array);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_Record);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(anon_sym_Record);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(anon_sym_unknown);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(anon_sym_unknown);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(anon_sym_void);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(anon_sym_never);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(anon_sym_never);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == '1') ADVANCE(297);
      if (lookahead == '3') ADVANCE(291);
      if (lookahead == '6') ADVANCE(248);
      if (lookahead == '8') ADVANCE(254);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == '2') ADVANCE(240);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == '2') ADVANCE(250);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == '2') ADVANCE(256);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == '2') ADVANCE(298);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == '4') ADVANCE(238);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == '4') ADVANCE(258);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == '6') ADVANCE(242);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == '6') ADVANCE(252);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == '8') ADVANCE(260);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'D') ADVANCE(313);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'D') ADVANCE(314);
      if (lookahead == 'T') ADVANCE(350);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'D') ADVANCE(315);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'T') ADVANCE(356);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'T') ADVANCE(358);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'a') ADVANCE(415);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'a') ADVANCE(361);
      if (lookahead == 'l') ADVANCE(388);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'a') ADVANCE(344);
      if (lookahead == 't') ADVANCE(396);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'a') ADVANCE(367);
      if (lookahead == 'o') ADVANCE(348);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'a') ADVANCE(351);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'a') ADVANCE(406);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'a') ADVANCE(373);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'a') ADVANCE(403);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'a') ADVANCE(363);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'a') ADVANCE(407);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'a') ADVANCE(408);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'a') ADVANCE(409);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'c') ADVANCE(299);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'c') ADVANCE(232);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'c') ADVANCE(349);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'c') ADVANCE(386);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'd') ADVANCE(286);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'd') ADVANCE(282);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'e') ADVANCE(319);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'e') ADVANCE(413);
      if (lookahead == 'u') ADVANCE(365);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'e') ADVANCE(427);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'e') ADVANCE(429);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'e') ADVANCE(302);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'e') ADVANCE(262);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'e') ADVANCE(264);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'e') ADVANCE(266);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'e') ADVANCE(268);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'e') ADVANCE(318);
      if (lookahead == 'u') ADVANCE(395);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'e') ADVANCE(398);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'e') ADVANCE(384);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'e') ADVANCE(310);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'e') ADVANCE(357);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'e') ADVANCE(410);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'e') ADVANCE(390);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'e') ADVANCE(397);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'e') ADVANCE(391);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'e') ADVANCE(303);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'f') ADVANCE(211);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'f') ADVANCE(345);
      if (lookahead == 'p') ADVANCE(221);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'f') ADVANCE(345);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'f') ADVANCE(335);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'f') ADVANCE(400);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'g') ADVANCE(274);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'g') ADVANCE(339);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'i') ADVANCE(320);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'i') ADVANCE(368);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'i') ADVANCE(369);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'i') ADVANCE(372);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'i') ADVANCE(377);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'i') ADVANCE(317);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'i') ADVANCE(387);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'i') ADVANCE(378);
      if (lookahead == 'n') ADVANCE(359);
      if (lookahead == 't') ADVANCE(316);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'i') ADVANCE(370);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'i') ADVANCE(380);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'i') ADVANCE(371);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'k') ADVANCE(379);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'l') ADVANCE(308);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'l') ADVANCE(399);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'l') ADVANCE(278);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'l') ADVANCE(259);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'l') ADVANCE(388);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'l') ADVANCE(362);
      if (lookahead == 'm') ADVANCE(338);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'l') ADVANCE(334);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'l') ADVANCE(412);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'm') ADVANCE(312);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'm') ADVANCE(328);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'm') ADVANCE(329);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'm') ADVANCE(330);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'n') ADVANCE(300);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'n') ADVANCE(276);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'n') ADVANCE(284);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'n') ADVANCE(270);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'n') ADVANCE(401);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'n') ADVANCE(346);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'n') ADVANCE(402);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'n') ADVANCE(383);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'n') ADVANCE(404);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'o') ADVANCE(385);
      if (lookahead == 'y') ADVANCE(405);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'o') ADVANCE(348);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'o') ADVANCE(414);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'o') ADVANCE(341);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'o') ADVANCE(366);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'o') ADVANCE(393);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'o') ADVANCE(375);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'o') ADVANCE(311);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'r') ADVANCE(411);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'r') ADVANCE(288);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'r') ADVANCE(234);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'r') ADVANCE(304);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'r') ADVANCE(321);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'r') ADVANCE(392);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'r') ADVANCE(309);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'r') ADVANCE(352);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'r') ADVANCE(353);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 's') ADVANCE(272);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 's') ADVANCE(325);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 's') ADVANCE(336);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 't') ADVANCE(244);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 't') ADVANCE(289);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 't') ADVANCE(236);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 't') ADVANCE(246);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 't') ADVANCE(332);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 't') ADVANCE(354);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 't') ADVANCE(326);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 't') ADVANCE(327);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 't') ADVANCE(340);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 't') ADVANCE(301);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'u') ADVANCE(324);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'u') ADVANCE(333);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'v') ADVANCE(337);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'w') ADVANCE(374);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == 'y') ADVANCE(280);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym_plain_identifier);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym_backticked_identifier_fragment);
      if (lookahead == '*') ADVANCE(420);
      if (lookahead == '/') ADVANCE(422);
      if (lookahead != 0 &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(423);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym_backticked_identifier_fragment);
      if (lookahead == '*') ADVANCE(419);
      if (lookahead == '/') ADVANCE(423);
      if (lookahead == '\\' ||
          lookahead == '`') ADVANCE(11);
      if (lookahead != 0) ADVANCE(420);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(sym_backticked_identifier_fragment);
      if (lookahead == '*') ADVANCE(419);
      if (lookahead == '\\' ||
          lookahead == '`') ADVANCE(11);
      if (lookahead != 0) ADVANCE(420);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(sym_backticked_identifier_fragment);
      if (lookahead == '/') ADVANCE(418);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(421);
      if (lookahead != 0 &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(423);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(sym_backticked_identifier_fragment);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(423);
      if (lookahead == '\\' ||
          lookahead == '`') ADVANCE(453);
      if (lookahead != 0) ADVANCE(422);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(sym_backticked_identifier_fragment);
      if (lookahead != 0 &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(423);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(12);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(anon_sym_true);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym_false);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(416);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(sym_decimal_literal);
      if (lookahead == '.') ADVANCE(188);
      if (lookahead == 'b') ADVANCE(186);
      if (lookahead == 'e') ADVANCE(185);
      if (lookahead == 'x') ADVANCE(190);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(sym_decimal_literal);
      if (lookahead == '.') ADVANCE(188);
      if (lookahead == 'e') ADVANCE(185);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(sym_decimal_literal);
      if (lookahead == '.') ADVANCE(188);
      if (lookahead == 'e') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(432);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(sym_decimal_literal);
      if (lookahead == 'e') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(433);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(sym_decimal_literal);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(434);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(sym_hex_integer_literal);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(435);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(sym_binary_integer_literal);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(436);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead == '"') ADVANCE(4);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(anon_sym_DQUOTE_DQUOTE_DQUOTE);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(sym_quoted_string_fragment);
      if (lookahead == '*') ADVANCE(443);
      if (lookahead == '/') ADVANCE(445);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(446);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(sym_quoted_string_fragment);
      if (lookahead == '*') ADVANCE(442);
      if (lookahead == '/') ADVANCE(446);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == '"' ||
          lookahead == '\\') ADVANCE(11);
      if (lookahead != 0) ADVANCE(443);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(sym_quoted_string_fragment);
      if (lookahead == '*') ADVANCE(442);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == '"' ||
          lookahead == '\\') ADVANCE(11);
      if (lookahead != 0) ADVANCE(443);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(sym_quoted_string_fragment);
      if (lookahead == '/') ADVANCE(441);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') ADVANCE(444);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(446);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(sym_quoted_string_fragment);
      if (lookahead == '"' ||
          lookahead == '\\') ADVANCE(453);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(445);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(sym_quoted_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(446);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(sym_triple_quoted_string_fragment);
      if (lookahead == '*') ADVANCE(449);
      if (lookahead == '/') ADVANCE(451);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(452);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(sym_triple_quoted_string_fragment);
      if (lookahead == '*') ADVANCE(448);
      if (lookahead == '/') ADVANCE(452);
      if (lookahead == '"' ||
          lookahead == '\\') ADVANCE(11);
      if (lookahead != 0) ADVANCE(449);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(sym_triple_quoted_string_fragment);
      if (lookahead == '*') ADVANCE(448);
      if (lookahead == '"' ||
          lookahead == '\\') ADVANCE(11);
      if (lookahead != 0) ADVANCE(449);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(sym_triple_quoted_string_fragment);
      if (lookahead == '/') ADVANCE(447);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(450);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(452);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(sym_triple_quoted_string_fragment);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(452);
      if (lookahead == '"' ||
          lookahead == '\\') ADVANCE(453);
      if (lookahead != 0) ADVANCE(451);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(sym_triple_quoted_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(452);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(sym_single_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(453);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(sym_multi_line_comment);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 192},
  [2] = {.lex_state = 2},
  [3] = {.lex_state = 2},
  [4] = {.lex_state = 2},
  [5] = {.lex_state = 2},
  [6] = {.lex_state = 2},
  [7] = {.lex_state = 2},
  [8] = {.lex_state = 2},
  [9] = {.lex_state = 2},
  [10] = {.lex_state = 2},
  [11] = {.lex_state = 2},
  [12] = {.lex_state = 2},
  [13] = {.lex_state = 2},
  [14] = {.lex_state = 2},
  [15] = {.lex_state = 2},
  [16] = {.lex_state = 2},
  [17] = {.lex_state = 2},
  [18] = {.lex_state = 2},
  [19] = {.lex_state = 2},
  [20] = {.lex_state = 2},
  [21] = {.lex_state = 2},
  [22] = {.lex_state = 2},
  [23] = {.lex_state = 2},
  [24] = {.lex_state = 2},
  [25] = {.lex_state = 2},
  [26] = {.lex_state = 2},
  [27] = {.lex_state = 2},
  [28] = {.lex_state = 2},
  [29] = {.lex_state = 2},
  [30] = {.lex_state = 2},
  [31] = {.lex_state = 2},
  [32] = {.lex_state = 2},
  [33] = {.lex_state = 2},
  [34] = {.lex_state = 2},
  [35] = {.lex_state = 2},
  [36] = {.lex_state = 2},
  [37] = {.lex_state = 2},
  [38] = {.lex_state = 2},
  [39] = {.lex_state = 2},
  [40] = {.lex_state = 2},
  [41] = {.lex_state = 2},
  [42] = {.lex_state = 2},
  [43] = {.lex_state = 2},
  [44] = {.lex_state = 2},
  [45] = {.lex_state = 2},
  [46] = {.lex_state = 2},
  [47] = {.lex_state = 2},
  [48] = {.lex_state = 2},
  [49] = {.lex_state = 2},
  [50] = {.lex_state = 2},
  [51] = {.lex_state = 2},
  [52] = {.lex_state = 2},
  [53] = {.lex_state = 2},
  [54] = {.lex_state = 2},
  [55] = {.lex_state = 2},
  [56] = {.lex_state = 2},
  [57] = {.lex_state = 2},
  [58] = {.lex_state = 2},
  [59] = {.lex_state = 2},
  [60] = {.lex_state = 2},
  [61] = {.lex_state = 2},
  [62] = {.lex_state = 2},
  [63] = {.lex_state = 2},
  [64] = {.lex_state = 2},
  [65] = {.lex_state = 2},
  [66] = {.lex_state = 2},
  [67] = {.lex_state = 2},
  [68] = {.lex_state = 2},
  [69] = {.lex_state = 2},
  [70] = {.lex_state = 2},
  [71] = {.lex_state = 2},
  [72] = {.lex_state = 2},
  [73] = {.lex_state = 2},
  [74] = {.lex_state = 2},
  [75] = {.lex_state = 2},
  [76] = {.lex_state = 2},
  [77] = {.lex_state = 2},
  [78] = {.lex_state = 2},
  [79] = {.lex_state = 2},
  [80] = {.lex_state = 2},
  [81] = {.lex_state = 2},
  [82] = {.lex_state = 2},
  [83] = {.lex_state = 2},
  [84] = {.lex_state = 2},
  [85] = {.lex_state = 2},
  [86] = {.lex_state = 2},
  [87] = {.lex_state = 2},
  [88] = {.lex_state = 2},
  [89] = {.lex_state = 2},
  [90] = {.lex_state = 2},
  [91] = {.lex_state = 2},
  [92] = {.lex_state = 2},
  [93] = {.lex_state = 2},
  [94] = {.lex_state = 2},
  [95] = {.lex_state = 2},
  [96] = {.lex_state = 2},
  [97] = {.lex_state = 2},
  [98] = {.lex_state = 2},
  [99] = {.lex_state = 2},
  [100] = {.lex_state = 2},
  [101] = {.lex_state = 2},
  [102] = {.lex_state = 1},
  [103] = {.lex_state = 1},
  [104] = {.lex_state = 2},
  [105] = {.lex_state = 2},
  [106] = {.lex_state = 1},
  [107] = {.lex_state = 1},
  [108] = {.lex_state = 1},
  [109] = {.lex_state = 2},
  [110] = {.lex_state = 1},
  [111] = {.lex_state = 2},
  [112] = {.lex_state = 2},
  [113] = {.lex_state = 1},
  [114] = {.lex_state = 1},
  [115] = {.lex_state = 2},
  [116] = {.lex_state = 2},
  [117] = {.lex_state = 2},
  [118] = {.lex_state = 1},
  [119] = {.lex_state = 1},
  [120] = {.lex_state = 2},
  [121] = {.lex_state = 2},
  [122] = {.lex_state = 1},
  [123] = {.lex_state = 1},
  [124] = {.lex_state = 1},
  [125] = {.lex_state = 2},
  [126] = {.lex_state = 2},
  [127] = {.lex_state = 1},
  [128] = {.lex_state = 1},
  [129] = {.lex_state = 1},
  [130] = {.lex_state = 2},
  [131] = {.lex_state = 1},
  [132] = {.lex_state = 2},
  [133] = {.lex_state = 2},
  [134] = {.lex_state = 1},
  [135] = {.lex_state = 2},
  [136] = {.lex_state = 1},
  [137] = {.lex_state = 2},
  [138] = {.lex_state = 2},
  [139] = {.lex_state = 2},
  [140] = {.lex_state = 2},
  [141] = {.lex_state = 1},
  [142] = {.lex_state = 2},
  [143] = {.lex_state = 1},
  [144] = {.lex_state = 2},
  [145] = {.lex_state = 2},
  [146] = {.lex_state = 1},
  [147] = {.lex_state = 1},
  [148] = {.lex_state = 1},
  [149] = {.lex_state = 1},
  [150] = {.lex_state = 1},
  [151] = {.lex_state = 1},
  [152] = {.lex_state = 1},
  [153] = {.lex_state = 8},
  [154] = {.lex_state = 1},
  [155] = {.lex_state = 1},
  [156] = {.lex_state = 8},
  [157] = {.lex_state = 8},
  [158] = {.lex_state = 1},
  [159] = {.lex_state = 8},
  [160] = {.lex_state = 1},
  [161] = {.lex_state = 8},
  [162] = {.lex_state = 1},
  [163] = {.lex_state = 1},
  [164] = {.lex_state = 1},
  [165] = {.lex_state = 1},
  [166] = {.lex_state = 1},
  [167] = {.lex_state = 1},
  [168] = {.lex_state = 1},
  [169] = {.lex_state = 1},
  [170] = {.lex_state = 1},
  [171] = {.lex_state = 1},
  [172] = {.lex_state = 1},
  [173] = {.lex_state = 1},
  [174] = {.lex_state = 1},
  [175] = {.lex_state = 1},
  [176] = {.lex_state = 1},
  [177] = {.lex_state = 1},
  [178] = {.lex_state = 1},
  [179] = {.lex_state = 1},
  [180] = {.lex_state = 1},
  [181] = {.lex_state = 1},
  [182] = {.lex_state = 1},
  [183] = {.lex_state = 1},
  [184] = {.lex_state = 192},
  [185] = {.lex_state = 1},
  [186] = {.lex_state = 1},
  [187] = {.lex_state = 192},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 1},
  [190] = {.lex_state = 1},
  [191] = {.lex_state = 1},
  [192] = {.lex_state = 1},
  [193] = {.lex_state = 1},
  [194] = {.lex_state = 1},
  [195] = {.lex_state = 1},
  [196] = {.lex_state = 1},
  [197] = {.lex_state = 1},
  [198] = {.lex_state = 1},
  [199] = {.lex_state = 1},
  [200] = {.lex_state = 1},
  [201] = {.lex_state = 1},
  [202] = {.lex_state = 1},
  [203] = {.lex_state = 1},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 1},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 1},
  [208] = {.lex_state = 1},
  [209] = {.lex_state = 1},
  [210] = {.lex_state = 8},
  [211] = {.lex_state = 1},
  [212] = {.lex_state = 8},
  [213] = {.lex_state = 192},
  [214] = {.lex_state = 192},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 1},
  [217] = {.lex_state = 1},
  [218] = {.lex_state = 8},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 192},
  [225] = {.lex_state = 192},
  [226] = {.lex_state = 1},
  [227] = {.lex_state = 192},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 1},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 1},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 1},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 8},
  [238] = {.lex_state = 8},
  [239] = {.lex_state = 8},
  [240] = {.lex_state = 1},
  [241] = {.lex_state = 8},
  [242] = {.lex_state = 8},
  [243] = {.lex_state = 8},
  [244] = {.lex_state = 8},
  [245] = {.lex_state = 8},
  [246] = {.lex_state = 8},
  [247] = {.lex_state = 8},
  [248] = {.lex_state = 1},
  [249] = {.lex_state = 1},
  [250] = {.lex_state = 1},
  [251] = {.lex_state = 1},
  [252] = {.lex_state = 1},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 8},
  [255] = {.lex_state = 1},
  [256] = {.lex_state = 1},
  [257] = {.lex_state = 1},
  [258] = {.lex_state = 1},
  [259] = {.lex_state = 1},
  [260] = {.lex_state = 1},
  [261] = {.lex_state = 1},
  [262] = {.lex_state = 1},
  [263] = {.lex_state = 1},
  [264] = {.lex_state = 1},
  [265] = {.lex_state = 1},
  [266] = {.lex_state = 8},
  [267] = {.lex_state = 1},
  [268] = {.lex_state = 1},
  [269] = {.lex_state = 1},
  [270] = {.lex_state = 1},
  [271] = {.lex_state = 1},
  [272] = {.lex_state = 1},
  [273] = {.lex_state = 1},
  [274] = {.lex_state = 1},
  [275] = {.lex_state = 1},
  [276] = {.lex_state = 1},
  [277] = {.lex_state = 1},
  [278] = {.lex_state = 1},
  [279] = {.lex_state = 1},
  [280] = {.lex_state = 1},
  [281] = {.lex_state = 1},
  [282] = {.lex_state = 1},
  [283] = {.lex_state = 1},
  [284] = {.lex_state = 1},
  [285] = {.lex_state = 1},
  [286] = {.lex_state = 1},
  [287] = {.lex_state = 1},
  [288] = {.lex_state = 1},
  [289] = {.lex_state = 1},
  [290] = {.lex_state = 1},
  [291] = {.lex_state = 1},
  [292] = {.lex_state = 1},
  [293] = {.lex_state = 1},
  [294] = {.lex_state = 1},
  [295] = {.lex_state = 1},
  [296] = {.lex_state = 1},
  [297] = {.lex_state = 8},
  [298] = {.lex_state = 8},
  [299] = {.lex_state = 1},
  [300] = {.lex_state = 8},
  [301] = {.lex_state = 1},
  [302] = {.lex_state = 1},
  [303] = {.lex_state = 1},
  [304] = {.lex_state = 1},
  [305] = {.lex_state = 1},
  [306] = {.lex_state = 8},
  [307] = {.lex_state = 192},
  [308] = {.lex_state = 192},
  [309] = {.lex_state = 192},
  [310] = {.lex_state = 192},
  [311] = {.lex_state = 192},
  [312] = {.lex_state = 192},
  [313] = {.lex_state = 192},
  [314] = {.lex_state = 192},
  [315] = {.lex_state = 192},
  [316] = {.lex_state = 192},
  [317] = {.lex_state = 192},
  [318] = {.lex_state = 192},
  [319] = {.lex_state = 192},
  [320] = {.lex_state = 192},
  [321] = {.lex_state = 192},
  [322] = {.lex_state = 192},
  [323] = {.lex_state = 192},
  [324] = {.lex_state = 192},
  [325] = {.lex_state = 192},
  [326] = {.lex_state = 192},
  [327] = {.lex_state = 192},
  [328] = {.lex_state = 192},
  [329] = {.lex_state = 192},
  [330] = {.lex_state = 192},
  [331] = {.lex_state = 192},
  [332] = {.lex_state = 192},
  [333] = {.lex_state = 192},
  [334] = {.lex_state = 192},
  [335] = {.lex_state = 192},
  [336] = {.lex_state = 192},
  [337] = {.lex_state = 192},
  [338] = {.lex_state = 192},
  [339] = {.lex_state = 192},
  [340] = {.lex_state = 192},
  [341] = {.lex_state = 192},
  [342] = {.lex_state = 192},
  [343] = {.lex_state = 192},
  [344] = {.lex_state = 192},
  [345] = {.lex_state = 192},
  [346] = {.lex_state = 192},
  [347] = {.lex_state = 192},
  [348] = {.lex_state = 192},
  [349] = {.lex_state = 192},
  [350] = {.lex_state = 192},
  [351] = {.lex_state = 192},
  [352] = {.lex_state = 192},
  [353] = {.lex_state = 192},
  [354] = {.lex_state = 192},
  [355] = {.lex_state = 192},
  [356] = {.lex_state = 192},
  [357] = {.lex_state = 192},
  [358] = {.lex_state = 192},
  [359] = {.lex_state = 192},
  [360] = {.lex_state = 192},
  [361] = {.lex_state = 192},
  [362] = {.lex_state = 192},
  [363] = {.lex_state = 192},
  [364] = {.lex_state = 192},
  [365] = {.lex_state = 192},
  [366] = {.lex_state = 192},
  [367] = {.lex_state = 192},
  [368] = {.lex_state = 192},
  [369] = {.lex_state = 192},
  [370] = {.lex_state = 192},
  [371] = {.lex_state = 192},
  [372] = {.lex_state = 192},
  [373] = {.lex_state = 192},
  [374] = {.lex_state = 192},
  [375] = {.lex_state = 192},
  [376] = {.lex_state = 192},
  [377] = {.lex_state = 192},
  [378] = {.lex_state = 192},
  [379] = {.lex_state = 192},
  [380] = {.lex_state = 192},
  [381] = {.lex_state = 192},
  [382] = {.lex_state = 192},
  [383] = {.lex_state = 192},
  [384] = {.lex_state = 192},
  [385] = {.lex_state = 192},
  [386] = {.lex_state = 192},
  [387] = {.lex_state = 192},
  [388] = {.lex_state = 192},
  [389] = {.lex_state = 192},
  [390] = {.lex_state = 192},
  [391] = {.lex_state = 192},
  [392] = {.lex_state = 192},
  [393] = {.lex_state = 192},
  [394] = {.lex_state = 192},
  [395] = {.lex_state = 192},
  [396] = {.lex_state = 192},
  [397] = {.lex_state = 192},
  [398] = {.lex_state = 192},
  [399] = {.lex_state = 192},
  [400] = {.lex_state = 192},
  [401] = {.lex_state = 192},
  [402] = {.lex_state = 192},
  [403] = {.lex_state = 192},
  [404] = {.lex_state = 192},
  [405] = {.lex_state = 192},
  [406] = {.lex_state = 192},
  [407] = {.lex_state = 192},
  [408] = {.lex_state = 192},
  [409] = {.lex_state = 192},
  [410] = {.lex_state = 192},
  [411] = {.lex_state = 192},
  [412] = {.lex_state = 192},
  [413] = {.lex_state = 192},
  [414] = {.lex_state = 192},
  [415] = {.lex_state = 192},
  [416] = {.lex_state = 192},
  [417] = {.lex_state = 192},
  [418] = {.lex_state = 192},
  [419] = {.lex_state = 192},
  [420] = {.lex_state = 192},
  [421] = {.lex_state = 192},
  [422] = {.lex_state = 192},
  [423] = {.lex_state = 192},
  [424] = {.lex_state = 192},
  [425] = {.lex_state = 192},
  [426] = {.lex_state = 192},
  [427] = {.lex_state = 192},
  [428] = {.lex_state = 192},
  [429] = {.lex_state = 192},
  [430] = {.lex_state = 192},
  [431] = {.lex_state = 192},
  [432] = {.lex_state = 192},
  [433] = {.lex_state = 192},
  [434] = {.lex_state = 192},
  [435] = {.lex_state = 192},
  [436] = {.lex_state = 192},
  [437] = {.lex_state = 192},
  [438] = {.lex_state = 192},
  [439] = {.lex_state = 192},
  [440] = {.lex_state = 192},
  [441] = {.lex_state = 192},
  [442] = {.lex_state = 192},
  [443] = {.lex_state = 192},
  [444] = {.lex_state = 192},
  [445] = {.lex_state = 192},
  [446] = {.lex_state = 192},
  [447] = {.lex_state = 192},
  [448] = {.lex_state = 192},
  [449] = {.lex_state = 192},
  [450] = {.lex_state = 192},
  [451] = {.lex_state = 192},
  [452] = {.lex_state = 192},
  [453] = {.lex_state = 192},
  [454] = {.lex_state = 192},
  [455] = {.lex_state = 192},
  [456] = {.lex_state = 192},
  [457] = {.lex_state = 192},
  [458] = {.lex_state = 192},
  [459] = {.lex_state = 192},
  [460] = {.lex_state = 192},
  [461] = {.lex_state = 192},
  [462] = {.lex_state = 192},
  [463] = {.lex_state = 192},
  [464] = {.lex_state = 192},
  [465] = {.lex_state = 192},
  [466] = {.lex_state = 192},
  [467] = {.lex_state = 192},
  [468] = {.lex_state = 192},
  [469] = {.lex_state = 0},
  [470] = {.lex_state = 0},
  [471] = {.lex_state = 0},
  [472] = {.lex_state = 0},
  [473] = {.lex_state = 0},
  [474] = {.lex_state = 0},
  [475] = {.lex_state = 0},
  [476] = {.lex_state = 0},
  [477] = {.lex_state = 0},
  [478] = {.lex_state = 0},
  [479] = {.lex_state = 0},
  [480] = {.lex_state = 0},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 0},
  [483] = {.lex_state = 0},
  [484] = {.lex_state = 0},
  [485] = {.lex_state = 0},
  [486] = {.lex_state = 0},
  [487] = {.lex_state = 0},
  [488] = {.lex_state = 0},
  [489] = {.lex_state = 0},
  [490] = {.lex_state = 0},
  [491] = {.lex_state = 0},
  [492] = {.lex_state = 0},
  [493] = {.lex_state = 0},
  [494] = {.lex_state = 0},
  [495] = {.lex_state = 0},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 0},
  [498] = {.lex_state = 0},
  [499] = {.lex_state = 0},
  [500] = {.lex_state = 0},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 0},
  [503] = {.lex_state = 0},
  [504] = {.lex_state = 0},
  [505] = {.lex_state = 0},
  [506] = {.lex_state = 0},
  [507] = {.lex_state = 0},
  [508] = {.lex_state = 0},
  [509] = {.lex_state = 0},
  [510] = {.lex_state = 0},
  [511] = {.lex_state = 0},
  [512] = {.lex_state = 6},
  [513] = {.lex_state = 7},
  [514] = {.lex_state = 6},
  [515] = {.lex_state = 13},
  [516] = {.lex_state = 13},
  [517] = {.lex_state = 7},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 13},
  [520] = {.lex_state = 6},
  [521] = {.lex_state = 6},
  [522] = {.lex_state = 7},
  [523] = {.lex_state = 6},
  [524] = {.lex_state = 13},
  [525] = {.lex_state = 7},
  [526] = {.lex_state = 7},
  [527] = {.lex_state = 13},
  [528] = {.lex_state = 7},
  [529] = {.lex_state = 0},
  [530] = {.lex_state = 0},
  [531] = {.lex_state = 13},
  [532] = {.lex_state = 13},
  [533] = {.lex_state = 13},
  [534] = {.lex_state = 7},
  [535] = {.lex_state = 6},
  [536] = {.lex_state = 13},
  [537] = {.lex_state = 0},
  [538] = {.lex_state = 0},
  [539] = {.lex_state = 0},
  [540] = {.lex_state = 0},
  [541] = {.lex_state = 0},
  [542] = {.lex_state = 7},
  [543] = {.lex_state = 6},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 13},
  [546] = {.lex_state = 6},
  [547] = {.lex_state = 7},
  [548] = {.lex_state = 6},
  [549] = {.lex_state = 13},
  [550] = {.lex_state = 0},
  [551] = {.lex_state = 0},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 0},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 0},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 0},
  [574] = {.lex_state = 0},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 0},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 0},
  [587] = {.lex_state = 0},
  [588] = {.lex_state = 0},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 0},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 0},
  [593] = {.lex_state = 0},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 0},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 0},
  [603] = {.lex_state = 0},
  [604] = {.lex_state = 0},
  [605] = {.lex_state = 0},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 0},
  [608] = {.lex_state = 0},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 0},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 0},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 0},
  [617] = {.lex_state = 0},
  [618] = {.lex_state = 0},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 0},
  [621] = {.lex_state = 0},
  [622] = {.lex_state = 0},
  [623] = {.lex_state = 0},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 0},
  [627] = {.lex_state = 0},
  [628] = {.lex_state = 0},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 0},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 0},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_using] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_model] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_valueof] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_union] = ACTIONS(1),
    [anon_sym_scalar] = ACTIONS(1),
    [anon_sym_op] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_alias] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_AT_AT] = ACTIONS(1),
    [anon_sym_dec] = ACTIONS(1),
    [anon_sym_extern] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_numeric] = ACTIONS(1),
    [anon_sym_integer] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_int64] = ACTIONS(1),
    [anon_sym_int32] = ACTIONS(1),
    [anon_sym_int16] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_safeint] = ACTIONS(1),
    [anon_sym_uint6] = ACTIONS(1),
    [anon_sym_uint32] = ACTIONS(1),
    [anon_sym_uint16] = ACTIONS(1),
    [anon_sym_uint8] = ACTIONS(1),
    [anon_sym_float32] = ACTIONS(1),
    [anon_sym_float64] = ACTIONS(1),
    [anon_sym_plainDate] = ACTIONS(1),
    [anon_sym_plainTime] = ACTIONS(1),
    [anon_sym_utcDateTime] = ACTIONS(1),
    [anon_sym_offsetDateTime] = ACTIONS(1),
    [anon_sym_duration] = ACTIONS(1),
    [anon_sym_bytes] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_boolean] = ACTIONS(1),
    [anon_sym_null] = ACTIONS(1),
    [anon_sym_Array] = ACTIONS(1),
    [anon_sym_Record] = ACTIONS(1),
    [anon_sym_unknown] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_never] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_decimal_literal] = ACTIONS(1),
    [sym_hex_integer_literal] = ACTIONS(1),
    [sym_binary_integer_literal] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(643),
    [sym__item] = STATE(184),
    [sym__statement] = STATE(184),
    [sym_decorator_list] = STATE(490),
    [sym_decorator] = STATE(474),
    [sym_import_statement] = STATE(184),
    [sym_using_statement] = STATE(184),
    [sym_namespace_statement] = STATE(184),
    [sym_model_statement] = STATE(184),
    [sym_union_statement] = STATE(184),
    [sym_scalar_statement] = STATE(184),
    [sym_interface_statement] = STATE(184),
    [sym_enum_statement] = STATE(184),
    [sym_alias_statement] = STATE(184),
    [sym_augment_decorator_statement] = STATE(184),
    [sym_operation_statement] = STATE(184),
    [sym_decorator_declaration_statement] = STATE(184),
    [sym_decorator_modifiers] = STATE(631),
    [sym_function_declaration_statement] = STATE(184),
    [sym_function_modifiers] = STATE(630),
    [sym__comment] = STATE(184),
    [aux_sym_source_file_repeat1] = STATE(184),
    [aux_sym_decorator_list_repeat1] = STATE(474),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_SEMI] = ACTIONS(7),
    [anon_sym_AT] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_using] = ACTIONS(13),
    [anon_sym_namespace] = ACTIONS(15),
    [anon_sym_model] = ACTIONS(17),
    [anon_sym_union] = ACTIONS(19),
    [anon_sym_scalar] = ACTIONS(21),
    [anon_sym_interface] = ACTIONS(23),
    [anon_sym_op] = ACTIONS(25),
    [anon_sym_enum] = ACTIONS(27),
    [anon_sym_alias] = ACTIONS(29),
    [anon_sym_AT_AT] = ACTIONS(31),
    [anon_sym_dec] = ACTIONS(33),
    [anon_sym_extern] = ACTIONS(35),
    [anon_sym_fn] = ACTIONS(37),
    [sym_single_line_comment] = ACTIONS(7),
    [sym_multi_line_comment] = ACTIONS(7),
  },
  [2] = {
    [sym_decorator_list] = STATE(27),
    [sym_decorator] = STATE(126),
    [sym__expression] = STATE(111),
    [sym_union_expression] = STATE(111),
    [sym_intersection_expression] = STATE(111),
    [sym_value_of_expression] = STATE(111),
    [sym_array_expression] = STATE(111),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_union_variant] = STATE(6),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(89),
    [sym_builtin_type] = STATE(96),
    [sym_backticked_identifier] = STATE(96),
    [sym_member_expression] = STATE(104),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(109),
    [sym_quoted_string_literal] = STATE(109),
    [sym_triple_quoted_string_literal] = STATE(109),
    [aux_sym_decorator_list_repeat1] = STATE(126),
    [aux_sym_union_body_repeat1] = STATE(6),
    [anon_sym_AT] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_RBRACE] = ACTIONS(45),
    [anon_sym_PIPE] = ACTIONS(47),
    [anon_sym_AMP] = ACTIONS(49),
    [anon_sym_valueof] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(55),
    [anon_sym_integer] = ACTIONS(55),
    [anon_sym_float] = ACTIONS(55),
    [anon_sym_int64] = ACTIONS(55),
    [anon_sym_int32] = ACTIONS(55),
    [anon_sym_int16] = ACTIONS(55),
    [anon_sym_int] = ACTIONS(55),
    [anon_sym_safeint] = ACTIONS(55),
    [anon_sym_uint6] = ACTIONS(55),
    [anon_sym_uint32] = ACTIONS(55),
    [anon_sym_uint16] = ACTIONS(55),
    [anon_sym_uint8] = ACTIONS(55),
    [anon_sym_float32] = ACTIONS(55),
    [anon_sym_float64] = ACTIONS(55),
    [anon_sym_decimal] = ACTIONS(55),
    [anon_sym_decimal128] = ACTIONS(55),
    [anon_sym_plainDate] = ACTIONS(55),
    [anon_sym_plainTime] = ACTIONS(55),
    [anon_sym_utcDateTime] = ACTIONS(55),
    [anon_sym_offsetDateTime] = ACTIONS(55),
    [anon_sym_duration] = ACTIONS(55),
    [anon_sym_bytes] = ACTIONS(55),
    [anon_sym_string] = ACTIONS(55),
    [anon_sym_boolean] = ACTIONS(55),
    [anon_sym_null] = ACTIONS(55),
    [anon_sym_Array] = ACTIONS(55),
    [anon_sym_Record] = ACTIONS(55),
    [anon_sym_unknown] = ACTIONS(55),
    [anon_sym_void] = ACTIONS(55),
    [anon_sym_never] = ACTIONS(55),
    [sym_plain_identifier] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [3] = {
    [sym_decorator_list] = STATE(27),
    [sym_decorator] = STATE(126),
    [sym__expression] = STATE(111),
    [sym_union_expression] = STATE(111),
    [sym_intersection_expression] = STATE(111),
    [sym_value_of_expression] = STATE(111),
    [sym_array_expression] = STATE(111),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_union_variant] = STATE(5),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(89),
    [sym_builtin_type] = STATE(96),
    [sym_backticked_identifier] = STATE(96),
    [sym_member_expression] = STATE(104),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(109),
    [sym_quoted_string_literal] = STATE(109),
    [sym_triple_quoted_string_literal] = STATE(109),
    [aux_sym_decorator_list_repeat1] = STATE(126),
    [aux_sym_union_body_repeat1] = STATE(5),
    [anon_sym_AT] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_RBRACE] = ACTIONS(71),
    [anon_sym_PIPE] = ACTIONS(47),
    [anon_sym_AMP] = ACTIONS(49),
    [anon_sym_valueof] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(55),
    [anon_sym_integer] = ACTIONS(55),
    [anon_sym_float] = ACTIONS(55),
    [anon_sym_int64] = ACTIONS(55),
    [anon_sym_int32] = ACTIONS(55),
    [anon_sym_int16] = ACTIONS(55),
    [anon_sym_int] = ACTIONS(55),
    [anon_sym_safeint] = ACTIONS(55),
    [anon_sym_uint6] = ACTIONS(55),
    [anon_sym_uint32] = ACTIONS(55),
    [anon_sym_uint16] = ACTIONS(55),
    [anon_sym_uint8] = ACTIONS(55),
    [anon_sym_float32] = ACTIONS(55),
    [anon_sym_float64] = ACTIONS(55),
    [anon_sym_decimal] = ACTIONS(55),
    [anon_sym_decimal128] = ACTIONS(55),
    [anon_sym_plainDate] = ACTIONS(55),
    [anon_sym_plainTime] = ACTIONS(55),
    [anon_sym_utcDateTime] = ACTIONS(55),
    [anon_sym_offsetDateTime] = ACTIONS(55),
    [anon_sym_duration] = ACTIONS(55),
    [anon_sym_bytes] = ACTIONS(55),
    [anon_sym_string] = ACTIONS(55),
    [anon_sym_boolean] = ACTIONS(55),
    [anon_sym_null] = ACTIONS(55),
    [anon_sym_Array] = ACTIONS(55),
    [anon_sym_Record] = ACTIONS(55),
    [anon_sym_unknown] = ACTIONS(55),
    [anon_sym_void] = ACTIONS(55),
    [anon_sym_never] = ACTIONS(55),
    [sym_plain_identifier] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [4] = {
    [sym_decorator_list] = STATE(27),
    [sym_decorator] = STATE(126),
    [sym__expression] = STATE(111),
    [sym_union_expression] = STATE(111),
    [sym_intersection_expression] = STATE(111),
    [sym_value_of_expression] = STATE(111),
    [sym_array_expression] = STATE(111),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_union_variant] = STATE(3),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(89),
    [sym_builtin_type] = STATE(96),
    [sym_backticked_identifier] = STATE(96),
    [sym_member_expression] = STATE(104),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(109),
    [sym_quoted_string_literal] = STATE(109),
    [sym_triple_quoted_string_literal] = STATE(109),
    [aux_sym_decorator_list_repeat1] = STATE(126),
    [aux_sym_union_body_repeat1] = STATE(3),
    [anon_sym_AT] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_RBRACE] = ACTIONS(73),
    [anon_sym_PIPE] = ACTIONS(47),
    [anon_sym_AMP] = ACTIONS(49),
    [anon_sym_valueof] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(55),
    [anon_sym_integer] = ACTIONS(55),
    [anon_sym_float] = ACTIONS(55),
    [anon_sym_int64] = ACTIONS(55),
    [anon_sym_int32] = ACTIONS(55),
    [anon_sym_int16] = ACTIONS(55),
    [anon_sym_int] = ACTIONS(55),
    [anon_sym_safeint] = ACTIONS(55),
    [anon_sym_uint6] = ACTIONS(55),
    [anon_sym_uint32] = ACTIONS(55),
    [anon_sym_uint16] = ACTIONS(55),
    [anon_sym_uint8] = ACTIONS(55),
    [anon_sym_float32] = ACTIONS(55),
    [anon_sym_float64] = ACTIONS(55),
    [anon_sym_decimal] = ACTIONS(55),
    [anon_sym_decimal128] = ACTIONS(55),
    [anon_sym_plainDate] = ACTIONS(55),
    [anon_sym_plainTime] = ACTIONS(55),
    [anon_sym_utcDateTime] = ACTIONS(55),
    [anon_sym_offsetDateTime] = ACTIONS(55),
    [anon_sym_duration] = ACTIONS(55),
    [anon_sym_bytes] = ACTIONS(55),
    [anon_sym_string] = ACTIONS(55),
    [anon_sym_boolean] = ACTIONS(55),
    [anon_sym_null] = ACTIONS(55),
    [anon_sym_Array] = ACTIONS(55),
    [anon_sym_Record] = ACTIONS(55),
    [anon_sym_unknown] = ACTIONS(55),
    [anon_sym_void] = ACTIONS(55),
    [anon_sym_never] = ACTIONS(55),
    [sym_plain_identifier] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [5] = {
    [sym_decorator_list] = STATE(27),
    [sym_decorator] = STATE(126),
    [sym__expression] = STATE(111),
    [sym_union_expression] = STATE(111),
    [sym_intersection_expression] = STATE(111),
    [sym_value_of_expression] = STATE(111),
    [sym_array_expression] = STATE(111),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_union_variant] = STATE(5),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(89),
    [sym_builtin_type] = STATE(96),
    [sym_backticked_identifier] = STATE(96),
    [sym_member_expression] = STATE(104),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(109),
    [sym_quoted_string_literal] = STATE(109),
    [sym_triple_quoted_string_literal] = STATE(109),
    [aux_sym_decorator_list_repeat1] = STATE(126),
    [aux_sym_union_body_repeat1] = STATE(5),
    [anon_sym_AT] = ACTIONS(75),
    [anon_sym_LPAREN] = ACTIONS(78),
    [anon_sym_LBRACE] = ACTIONS(81),
    [anon_sym_RBRACE] = ACTIONS(84),
    [anon_sym_PIPE] = ACTIONS(86),
    [anon_sym_AMP] = ACTIONS(89),
    [anon_sym_valueof] = ACTIONS(92),
    [anon_sym_LBRACK] = ACTIONS(95),
    [anon_sym_numeric] = ACTIONS(98),
    [anon_sym_integer] = ACTIONS(98),
    [anon_sym_float] = ACTIONS(98),
    [anon_sym_int64] = ACTIONS(98),
    [anon_sym_int32] = ACTIONS(98),
    [anon_sym_int16] = ACTIONS(98),
    [anon_sym_int] = ACTIONS(98),
    [anon_sym_safeint] = ACTIONS(98),
    [anon_sym_uint6] = ACTIONS(98),
    [anon_sym_uint32] = ACTIONS(98),
    [anon_sym_uint16] = ACTIONS(98),
    [anon_sym_uint8] = ACTIONS(98),
    [anon_sym_float32] = ACTIONS(98),
    [anon_sym_float64] = ACTIONS(98),
    [anon_sym_decimal] = ACTIONS(98),
    [anon_sym_decimal128] = ACTIONS(98),
    [anon_sym_plainDate] = ACTIONS(98),
    [anon_sym_plainTime] = ACTIONS(98),
    [anon_sym_utcDateTime] = ACTIONS(98),
    [anon_sym_offsetDateTime] = ACTIONS(98),
    [anon_sym_duration] = ACTIONS(98),
    [anon_sym_bytes] = ACTIONS(98),
    [anon_sym_string] = ACTIONS(98),
    [anon_sym_boolean] = ACTIONS(98),
    [anon_sym_null] = ACTIONS(98),
    [anon_sym_Array] = ACTIONS(98),
    [anon_sym_Record] = ACTIONS(98),
    [anon_sym_unknown] = ACTIONS(98),
    [anon_sym_void] = ACTIONS(98),
    [anon_sym_never] = ACTIONS(98),
    [sym_plain_identifier] = ACTIONS(101),
    [anon_sym_BQUOTE] = ACTIONS(104),
    [anon_sym_true] = ACTIONS(107),
    [anon_sym_false] = ACTIONS(107),
    [sym_decimal_literal] = ACTIONS(110),
    [sym_hex_integer_literal] = ACTIONS(113),
    [sym_binary_integer_literal] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(116),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(119),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [6] = {
    [sym_decorator_list] = STATE(27),
    [sym_decorator] = STATE(126),
    [sym__expression] = STATE(111),
    [sym_union_expression] = STATE(111),
    [sym_intersection_expression] = STATE(111),
    [sym_value_of_expression] = STATE(111),
    [sym_array_expression] = STATE(111),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_union_variant] = STATE(5),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(89),
    [sym_builtin_type] = STATE(96),
    [sym_backticked_identifier] = STATE(96),
    [sym_member_expression] = STATE(104),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(109),
    [sym_quoted_string_literal] = STATE(109),
    [sym_triple_quoted_string_literal] = STATE(109),
    [aux_sym_decorator_list_repeat1] = STATE(126),
    [aux_sym_union_body_repeat1] = STATE(5),
    [anon_sym_AT] = ACTIONS(39),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_RBRACE] = ACTIONS(122),
    [anon_sym_PIPE] = ACTIONS(47),
    [anon_sym_AMP] = ACTIONS(49),
    [anon_sym_valueof] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(55),
    [anon_sym_integer] = ACTIONS(55),
    [anon_sym_float] = ACTIONS(55),
    [anon_sym_int64] = ACTIONS(55),
    [anon_sym_int32] = ACTIONS(55),
    [anon_sym_int16] = ACTIONS(55),
    [anon_sym_int] = ACTIONS(55),
    [anon_sym_safeint] = ACTIONS(55),
    [anon_sym_uint6] = ACTIONS(55),
    [anon_sym_uint32] = ACTIONS(55),
    [anon_sym_uint16] = ACTIONS(55),
    [anon_sym_uint8] = ACTIONS(55),
    [anon_sym_float32] = ACTIONS(55),
    [anon_sym_float64] = ACTIONS(55),
    [anon_sym_decimal] = ACTIONS(55),
    [anon_sym_decimal128] = ACTIONS(55),
    [anon_sym_plainDate] = ACTIONS(55),
    [anon_sym_plainTime] = ACTIONS(55),
    [anon_sym_utcDateTime] = ACTIONS(55),
    [anon_sym_offsetDateTime] = ACTIONS(55),
    [anon_sym_duration] = ACTIONS(55),
    [anon_sym_bytes] = ACTIONS(55),
    [anon_sym_string] = ACTIONS(55),
    [anon_sym_boolean] = ACTIONS(55),
    [anon_sym_null] = ACTIONS(55),
    [anon_sym_Array] = ACTIONS(55),
    [anon_sym_Record] = ACTIONS(55),
    [anon_sym_unknown] = ACTIONS(55),
    [anon_sym_void] = ACTIONS(55),
    [anon_sym_never] = ACTIONS(55),
    [sym_plain_identifier] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__expression] = STATE(499),
    [sym_union_expression] = STATE(499),
    [sym_intersection_expression] = STATE(499),
    [sym_value_of_expression] = STATE(499),
    [sym_array_expression] = STATE(499),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(124),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(124),
    [anon_sym_GT] = ACTIONS(124),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__expression] = STATE(499),
    [sym_union_expression] = STATE(499),
    [sym_intersection_expression] = STATE(499),
    [sym_value_of_expression] = STATE(499),
    [sym_array_expression] = STATE(499),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(138),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(138),
    [anon_sym_GT] = ACTIONS(138),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [9] = {
    [sym_expression_list] = STATE(660),
    [sym__expression] = STATE(483),
    [sym_union_expression] = STATE(483),
    [sym_intersection_expression] = STATE(483),
    [sym_value_of_expression] = STATE(483),
    [sym_array_expression] = STATE(483),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(140),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [10] = {
    [sym_expression_list] = STATE(623),
    [sym__expression] = STATE(483),
    [sym_union_expression] = STATE(483),
    [sym_intersection_expression] = STATE(483),
    [sym_value_of_expression] = STATE(483),
    [sym_array_expression] = STATE(483),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(142),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [11] = {
    [sym_expression_list] = STATE(638),
    [sym__expression] = STATE(483),
    [sym_union_expression] = STATE(483),
    [sym_intersection_expression] = STATE(483),
    [sym_value_of_expression] = STATE(483),
    [sym_array_expression] = STATE(483),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(144),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [12] = {
    [sym_expression_list] = STATE(662),
    [sym__expression] = STATE(483),
    [sym_union_expression] = STATE(483),
    [sym_intersection_expression] = STATE(483),
    [sym_value_of_expression] = STATE(483),
    [sym_array_expression] = STATE(483),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(146),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [13] = {
    [sym_expression_list] = STATE(653),
    [sym__expression] = STATE(483),
    [sym_union_expression] = STATE(483),
    [sym_intersection_expression] = STATE(483),
    [sym_value_of_expression] = STATE(483),
    [sym_array_expression] = STATE(483),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(148),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [14] = {
    [sym_expression_list] = STATE(641),
    [sym__expression] = STATE(483),
    [sym_union_expression] = STATE(483),
    [sym_intersection_expression] = STATE(483),
    [sym_value_of_expression] = STATE(483),
    [sym_array_expression] = STATE(483),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(150),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [15] = {
    [sym_expression_list] = STATE(635),
    [sym__expression] = STATE(483),
    [sym_union_expression] = STATE(483),
    [sym_intersection_expression] = STATE(483),
    [sym_value_of_expression] = STATE(483),
    [sym_array_expression] = STATE(483),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_RBRACK] = ACTIONS(152),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [16] = {
    [sym_expression_list] = STATE(639),
    [sym__expression] = STATE(483),
    [sym_union_expression] = STATE(483),
    [sym_intersection_expression] = STATE(483),
    [sym_value_of_expression] = STATE(483),
    [sym_array_expression] = STATE(483),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(154),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [17] = {
    [sym_expression_list] = STATE(632),
    [sym__expression] = STATE(483),
    [sym_union_expression] = STATE(483),
    [sym_intersection_expression] = STATE(483),
    [sym_value_of_expression] = STATE(483),
    [sym_array_expression] = STATE(483),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(156),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [18] = {
    [sym_expression_list] = STATE(637),
    [sym__expression] = STATE(483),
    [sym_union_expression] = STATE(483),
    [sym_intersection_expression] = STATE(483),
    [sym_value_of_expression] = STATE(483),
    [sym_array_expression] = STATE(483),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [19] = {
    [sym_expression_list] = STATE(625),
    [sym__expression] = STATE(483),
    [sym_union_expression] = STATE(483),
    [sym_intersection_expression] = STATE(483),
    [sym_value_of_expression] = STATE(483),
    [sym_array_expression] = STATE(483),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [20] = {
    [sym_expression_list] = STATE(654),
    [sym__expression] = STATE(483),
    [sym_union_expression] = STATE(483),
    [sym_intersection_expression] = STATE(483),
    [sym_value_of_expression] = STATE(483),
    [sym_array_expression] = STATE(483),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [21] = {
    [sym_expression_list] = STATE(670),
    [sym__expression] = STATE(483),
    [sym_union_expression] = STATE(483),
    [sym_intersection_expression] = STATE(483),
    [sym_value_of_expression] = STATE(483),
    [sym_array_expression] = STATE(483),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [22] = {
    [sym__expression] = STATE(81),
    [sym_union_expression] = STATE(81),
    [sym_intersection_expression] = STATE(81),
    [sym_value_of_expression] = STATE(81),
    [sym_array_expression] = STATE(81),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(97),
    [sym_builtin_type] = STATE(96),
    [sym_backticked_identifier] = STATE(96),
    [sym_member_expression] = STATE(104),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(47),
    [anon_sym_AMP] = ACTIONS(49),
    [anon_sym_valueof] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(55),
    [anon_sym_integer] = ACTIONS(55),
    [anon_sym_float] = ACTIONS(55),
    [anon_sym_int64] = ACTIONS(55),
    [anon_sym_int32] = ACTIONS(55),
    [anon_sym_int16] = ACTIONS(55),
    [anon_sym_int] = ACTIONS(55),
    [anon_sym_safeint] = ACTIONS(55),
    [anon_sym_uint6] = ACTIONS(55),
    [anon_sym_uint32] = ACTIONS(55),
    [anon_sym_uint16] = ACTIONS(55),
    [anon_sym_uint8] = ACTIONS(55),
    [anon_sym_float32] = ACTIONS(55),
    [anon_sym_float64] = ACTIONS(55),
    [anon_sym_decimal] = ACTIONS(55),
    [anon_sym_decimal128] = ACTIONS(55),
    [anon_sym_plainDate] = ACTIONS(55),
    [anon_sym_plainTime] = ACTIONS(55),
    [anon_sym_utcDateTime] = ACTIONS(55),
    [anon_sym_offsetDateTime] = ACTIONS(55),
    [anon_sym_duration] = ACTIONS(55),
    [anon_sym_bytes] = ACTIONS(55),
    [anon_sym_string] = ACTIONS(55),
    [anon_sym_boolean] = ACTIONS(55),
    [anon_sym_null] = ACTIONS(55),
    [anon_sym_Array] = ACTIONS(55),
    [anon_sym_Record] = ACTIONS(55),
    [anon_sym_unknown] = ACTIONS(55),
    [anon_sym_void] = ACTIONS(55),
    [anon_sym_never] = ACTIONS(55),
    [sym_plain_identifier] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [23] = {
    [sym__expression] = STATE(470),
    [sym_union_expression] = STATE(470),
    [sym_intersection_expression] = STATE(470),
    [sym_value_of_expression] = STATE(470),
    [sym_array_expression] = STATE(470),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [24] = {
    [sym__expression] = STATE(573),
    [sym_union_expression] = STATE(573),
    [sym_intersection_expression] = STATE(573),
    [sym_value_of_expression] = STATE(573),
    [sym_array_expression] = STATE(573),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [25] = {
    [sym__expression] = STATE(571),
    [sym_union_expression] = STATE(571),
    [sym_intersection_expression] = STATE(571),
    [sym_value_of_expression] = STATE(571),
    [sym_array_expression] = STATE(571),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [26] = {
    [sym__expression] = STATE(566),
    [sym_union_expression] = STATE(566),
    [sym_intersection_expression] = STATE(566),
    [sym_value_of_expression] = STATE(566),
    [sym_array_expression] = STATE(566),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [27] = {
    [sym__expression] = STATE(115),
    [sym_union_expression] = STATE(115),
    [sym_intersection_expression] = STATE(115),
    [sym_value_of_expression] = STATE(115),
    [sym_array_expression] = STATE(115),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(87),
    [sym_builtin_type] = STATE(96),
    [sym_backticked_identifier] = STATE(96),
    [sym_member_expression] = STATE(104),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(105),
    [sym_quoted_string_literal] = STATE(105),
    [sym_triple_quoted_string_literal] = STATE(105),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(47),
    [anon_sym_AMP] = ACTIONS(49),
    [anon_sym_valueof] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(55),
    [anon_sym_integer] = ACTIONS(55),
    [anon_sym_float] = ACTIONS(55),
    [anon_sym_int64] = ACTIONS(55),
    [anon_sym_int32] = ACTIONS(55),
    [anon_sym_int16] = ACTIONS(55),
    [anon_sym_int] = ACTIONS(55),
    [anon_sym_safeint] = ACTIONS(55),
    [anon_sym_uint6] = ACTIONS(55),
    [anon_sym_uint32] = ACTIONS(55),
    [anon_sym_uint16] = ACTIONS(55),
    [anon_sym_uint8] = ACTIONS(55),
    [anon_sym_float32] = ACTIONS(55),
    [anon_sym_float64] = ACTIONS(55),
    [anon_sym_decimal] = ACTIONS(55),
    [anon_sym_decimal128] = ACTIONS(55),
    [anon_sym_plainDate] = ACTIONS(55),
    [anon_sym_plainTime] = ACTIONS(55),
    [anon_sym_utcDateTime] = ACTIONS(55),
    [anon_sym_offsetDateTime] = ACTIONS(55),
    [anon_sym_duration] = ACTIONS(55),
    [anon_sym_bytes] = ACTIONS(55),
    [anon_sym_string] = ACTIONS(55),
    [anon_sym_boolean] = ACTIONS(55),
    [anon_sym_null] = ACTIONS(55),
    [anon_sym_Array] = ACTIONS(55),
    [anon_sym_Record] = ACTIONS(55),
    [anon_sym_unknown] = ACTIONS(55),
    [anon_sym_void] = ACTIONS(55),
    [anon_sym_never] = ACTIONS(55),
    [sym_plain_identifier] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [28] = {
    [sym__expression] = STATE(117),
    [sym_union_expression] = STATE(117),
    [sym_intersection_expression] = STATE(117),
    [sym_value_of_expression] = STATE(117),
    [sym_array_expression] = STATE(117),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(97),
    [sym_builtin_type] = STATE(96),
    [sym_backticked_identifier] = STATE(96),
    [sym_member_expression] = STATE(104),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(47),
    [anon_sym_AMP] = ACTIONS(49),
    [anon_sym_valueof] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(55),
    [anon_sym_integer] = ACTIONS(55),
    [anon_sym_float] = ACTIONS(55),
    [anon_sym_int64] = ACTIONS(55),
    [anon_sym_int32] = ACTIONS(55),
    [anon_sym_int16] = ACTIONS(55),
    [anon_sym_int] = ACTIONS(55),
    [anon_sym_safeint] = ACTIONS(55),
    [anon_sym_uint6] = ACTIONS(55),
    [anon_sym_uint32] = ACTIONS(55),
    [anon_sym_uint16] = ACTIONS(55),
    [anon_sym_uint8] = ACTIONS(55),
    [anon_sym_float32] = ACTIONS(55),
    [anon_sym_float64] = ACTIONS(55),
    [anon_sym_decimal] = ACTIONS(55),
    [anon_sym_decimal128] = ACTIONS(55),
    [anon_sym_plainDate] = ACTIONS(55),
    [anon_sym_plainTime] = ACTIONS(55),
    [anon_sym_utcDateTime] = ACTIONS(55),
    [anon_sym_offsetDateTime] = ACTIONS(55),
    [anon_sym_duration] = ACTIONS(55),
    [anon_sym_bytes] = ACTIONS(55),
    [anon_sym_string] = ACTIONS(55),
    [anon_sym_boolean] = ACTIONS(55),
    [anon_sym_null] = ACTIONS(55),
    [anon_sym_Array] = ACTIONS(55),
    [anon_sym_Record] = ACTIONS(55),
    [anon_sym_unknown] = ACTIONS(55),
    [anon_sym_void] = ACTIONS(55),
    [anon_sym_never] = ACTIONS(55),
    [sym_plain_identifier] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [29] = {
    [sym__expression] = STATE(112),
    [sym_union_expression] = STATE(112),
    [sym_intersection_expression] = STATE(112),
    [sym_value_of_expression] = STATE(112),
    [sym_array_expression] = STATE(112),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(97),
    [sym_builtin_type] = STATE(96),
    [sym_backticked_identifier] = STATE(96),
    [sym_member_expression] = STATE(104),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(47),
    [anon_sym_AMP] = ACTIONS(49),
    [anon_sym_valueof] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(55),
    [anon_sym_integer] = ACTIONS(55),
    [anon_sym_float] = ACTIONS(55),
    [anon_sym_int64] = ACTIONS(55),
    [anon_sym_int32] = ACTIONS(55),
    [anon_sym_int16] = ACTIONS(55),
    [anon_sym_int] = ACTIONS(55),
    [anon_sym_safeint] = ACTIONS(55),
    [anon_sym_uint6] = ACTIONS(55),
    [anon_sym_uint32] = ACTIONS(55),
    [anon_sym_uint16] = ACTIONS(55),
    [anon_sym_uint8] = ACTIONS(55),
    [anon_sym_float32] = ACTIONS(55),
    [anon_sym_float64] = ACTIONS(55),
    [anon_sym_decimal] = ACTIONS(55),
    [anon_sym_decimal128] = ACTIONS(55),
    [anon_sym_plainDate] = ACTIONS(55),
    [anon_sym_plainTime] = ACTIONS(55),
    [anon_sym_utcDateTime] = ACTIONS(55),
    [anon_sym_offsetDateTime] = ACTIONS(55),
    [anon_sym_duration] = ACTIONS(55),
    [anon_sym_bytes] = ACTIONS(55),
    [anon_sym_string] = ACTIONS(55),
    [anon_sym_boolean] = ACTIONS(55),
    [anon_sym_null] = ACTIONS(55),
    [anon_sym_Array] = ACTIONS(55),
    [anon_sym_Record] = ACTIONS(55),
    [anon_sym_unknown] = ACTIONS(55),
    [anon_sym_void] = ACTIONS(55),
    [anon_sym_never] = ACTIONS(55),
    [sym_plain_identifier] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [30] = {
    [sym__expression] = STATE(354),
    [sym_union_expression] = STATE(354),
    [sym_intersection_expression] = STATE(354),
    [sym_value_of_expression] = STATE(354),
    [sym_array_expression] = STATE(354),
    [sym__primary_expression] = STATE(331),
    [sym_tuple_expression] = STATE(331),
    [sym_model_expression] = STATE(331),
    [sym_reference_expression] = STATE(331),
    [sym_parenthesized_expression] = STATE(331),
    [sym_identifier_or_member_expression] = STATE(326),
    [sym_identifier] = STATE(318),
    [sym_builtin_type] = STATE(320),
    [sym_backticked_identifier] = STATE(320),
    [sym_member_expression] = STATE(324),
    [sym__literal] = STATE(331),
    [sym_boolean_literal] = STATE(331),
    [sym__numeric_literal] = STATE(331),
    [sym__string_literal] = STATE(331),
    [sym_quoted_string_literal] = STATE(331),
    [sym_triple_quoted_string_literal] = STATE(331),
    [anon_sym_LPAREN] = ACTIONS(158),
    [anon_sym_LBRACE] = ACTIONS(160),
    [anon_sym_PIPE] = ACTIONS(162),
    [anon_sym_AMP] = ACTIONS(164),
    [anon_sym_valueof] = ACTIONS(166),
    [anon_sym_LBRACK] = ACTIONS(168),
    [anon_sym_numeric] = ACTIONS(170),
    [anon_sym_integer] = ACTIONS(170),
    [anon_sym_float] = ACTIONS(170),
    [anon_sym_int64] = ACTIONS(170),
    [anon_sym_int32] = ACTIONS(170),
    [anon_sym_int16] = ACTIONS(170),
    [anon_sym_int] = ACTIONS(170),
    [anon_sym_safeint] = ACTIONS(170),
    [anon_sym_uint6] = ACTIONS(170),
    [anon_sym_uint32] = ACTIONS(170),
    [anon_sym_uint16] = ACTIONS(170),
    [anon_sym_uint8] = ACTIONS(170),
    [anon_sym_float32] = ACTIONS(170),
    [anon_sym_float64] = ACTIONS(170),
    [anon_sym_decimal] = ACTIONS(170),
    [anon_sym_decimal128] = ACTIONS(170),
    [anon_sym_plainDate] = ACTIONS(170),
    [anon_sym_plainTime] = ACTIONS(170),
    [anon_sym_utcDateTime] = ACTIONS(170),
    [anon_sym_offsetDateTime] = ACTIONS(170),
    [anon_sym_duration] = ACTIONS(170),
    [anon_sym_bytes] = ACTIONS(170),
    [anon_sym_string] = ACTIONS(170),
    [anon_sym_boolean] = ACTIONS(170),
    [anon_sym_null] = ACTIONS(170),
    [anon_sym_Array] = ACTIONS(170),
    [anon_sym_Record] = ACTIONS(170),
    [anon_sym_unknown] = ACTIONS(170),
    [anon_sym_void] = ACTIONS(170),
    [anon_sym_never] = ACTIONS(170),
    [sym_plain_identifier] = ACTIONS(172),
    [anon_sym_BQUOTE] = ACTIONS(174),
    [anon_sym_true] = ACTIONS(176),
    [anon_sym_false] = ACTIONS(176),
    [sym_decimal_literal] = ACTIONS(178),
    [sym_hex_integer_literal] = ACTIONS(180),
    [sym_binary_integer_literal] = ACTIONS(180),
    [anon_sym_DQUOTE] = ACTIONS(182),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(184),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [31] = {
    [sym__expression] = STATE(365),
    [sym_union_expression] = STATE(365),
    [sym_intersection_expression] = STATE(365),
    [sym_value_of_expression] = STATE(365),
    [sym_array_expression] = STATE(365),
    [sym__primary_expression] = STATE(331),
    [sym_tuple_expression] = STATE(331),
    [sym_model_expression] = STATE(331),
    [sym_reference_expression] = STATE(331),
    [sym_parenthesized_expression] = STATE(331),
    [sym_identifier_or_member_expression] = STATE(326),
    [sym_identifier] = STATE(318),
    [sym_builtin_type] = STATE(320),
    [sym_backticked_identifier] = STATE(320),
    [sym_member_expression] = STATE(324),
    [sym__literal] = STATE(331),
    [sym_boolean_literal] = STATE(331),
    [sym__numeric_literal] = STATE(331),
    [sym__string_literal] = STATE(331),
    [sym_quoted_string_literal] = STATE(331),
    [sym_triple_quoted_string_literal] = STATE(331),
    [anon_sym_LPAREN] = ACTIONS(158),
    [anon_sym_LBRACE] = ACTIONS(160),
    [anon_sym_PIPE] = ACTIONS(162),
    [anon_sym_AMP] = ACTIONS(164),
    [anon_sym_valueof] = ACTIONS(166),
    [anon_sym_LBRACK] = ACTIONS(168),
    [anon_sym_numeric] = ACTIONS(170),
    [anon_sym_integer] = ACTIONS(170),
    [anon_sym_float] = ACTIONS(170),
    [anon_sym_int64] = ACTIONS(170),
    [anon_sym_int32] = ACTIONS(170),
    [anon_sym_int16] = ACTIONS(170),
    [anon_sym_int] = ACTIONS(170),
    [anon_sym_safeint] = ACTIONS(170),
    [anon_sym_uint6] = ACTIONS(170),
    [anon_sym_uint32] = ACTIONS(170),
    [anon_sym_uint16] = ACTIONS(170),
    [anon_sym_uint8] = ACTIONS(170),
    [anon_sym_float32] = ACTIONS(170),
    [anon_sym_float64] = ACTIONS(170),
    [anon_sym_decimal] = ACTIONS(170),
    [anon_sym_decimal128] = ACTIONS(170),
    [anon_sym_plainDate] = ACTIONS(170),
    [anon_sym_plainTime] = ACTIONS(170),
    [anon_sym_utcDateTime] = ACTIONS(170),
    [anon_sym_offsetDateTime] = ACTIONS(170),
    [anon_sym_duration] = ACTIONS(170),
    [anon_sym_bytes] = ACTIONS(170),
    [anon_sym_string] = ACTIONS(170),
    [anon_sym_boolean] = ACTIONS(170),
    [anon_sym_null] = ACTIONS(170),
    [anon_sym_Array] = ACTIONS(170),
    [anon_sym_Record] = ACTIONS(170),
    [anon_sym_unknown] = ACTIONS(170),
    [anon_sym_void] = ACTIONS(170),
    [anon_sym_never] = ACTIONS(170),
    [sym_plain_identifier] = ACTIONS(172),
    [anon_sym_BQUOTE] = ACTIONS(174),
    [anon_sym_true] = ACTIONS(176),
    [anon_sym_false] = ACTIONS(176),
    [sym_decimal_literal] = ACTIONS(178),
    [sym_hex_integer_literal] = ACTIONS(180),
    [sym_binary_integer_literal] = ACTIONS(180),
    [anon_sym_DQUOTE] = ACTIONS(182),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(184),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [32] = {
    [sym__expression] = STATE(366),
    [sym_union_expression] = STATE(366),
    [sym_intersection_expression] = STATE(366),
    [sym_value_of_expression] = STATE(366),
    [sym_array_expression] = STATE(366),
    [sym__primary_expression] = STATE(331),
    [sym_tuple_expression] = STATE(331),
    [sym_model_expression] = STATE(331),
    [sym_reference_expression] = STATE(331),
    [sym_parenthesized_expression] = STATE(331),
    [sym_identifier_or_member_expression] = STATE(326),
    [sym_identifier] = STATE(318),
    [sym_builtin_type] = STATE(320),
    [sym_backticked_identifier] = STATE(320),
    [sym_member_expression] = STATE(324),
    [sym__literal] = STATE(331),
    [sym_boolean_literal] = STATE(331),
    [sym__numeric_literal] = STATE(331),
    [sym__string_literal] = STATE(331),
    [sym_quoted_string_literal] = STATE(331),
    [sym_triple_quoted_string_literal] = STATE(331),
    [anon_sym_LPAREN] = ACTIONS(158),
    [anon_sym_LBRACE] = ACTIONS(160),
    [anon_sym_PIPE] = ACTIONS(162),
    [anon_sym_AMP] = ACTIONS(164),
    [anon_sym_valueof] = ACTIONS(166),
    [anon_sym_LBRACK] = ACTIONS(168),
    [anon_sym_numeric] = ACTIONS(170),
    [anon_sym_integer] = ACTIONS(170),
    [anon_sym_float] = ACTIONS(170),
    [anon_sym_int64] = ACTIONS(170),
    [anon_sym_int32] = ACTIONS(170),
    [anon_sym_int16] = ACTIONS(170),
    [anon_sym_int] = ACTIONS(170),
    [anon_sym_safeint] = ACTIONS(170),
    [anon_sym_uint6] = ACTIONS(170),
    [anon_sym_uint32] = ACTIONS(170),
    [anon_sym_uint16] = ACTIONS(170),
    [anon_sym_uint8] = ACTIONS(170),
    [anon_sym_float32] = ACTIONS(170),
    [anon_sym_float64] = ACTIONS(170),
    [anon_sym_decimal] = ACTIONS(170),
    [anon_sym_decimal128] = ACTIONS(170),
    [anon_sym_plainDate] = ACTIONS(170),
    [anon_sym_plainTime] = ACTIONS(170),
    [anon_sym_utcDateTime] = ACTIONS(170),
    [anon_sym_offsetDateTime] = ACTIONS(170),
    [anon_sym_duration] = ACTIONS(170),
    [anon_sym_bytes] = ACTIONS(170),
    [anon_sym_string] = ACTIONS(170),
    [anon_sym_boolean] = ACTIONS(170),
    [anon_sym_null] = ACTIONS(170),
    [anon_sym_Array] = ACTIONS(170),
    [anon_sym_Record] = ACTIONS(170),
    [anon_sym_unknown] = ACTIONS(170),
    [anon_sym_void] = ACTIONS(170),
    [anon_sym_never] = ACTIONS(170),
    [sym_plain_identifier] = ACTIONS(172),
    [anon_sym_BQUOTE] = ACTIONS(174),
    [anon_sym_true] = ACTIONS(176),
    [anon_sym_false] = ACTIONS(176),
    [sym_decimal_literal] = ACTIONS(178),
    [sym_hex_integer_literal] = ACTIONS(180),
    [sym_binary_integer_literal] = ACTIONS(180),
    [anon_sym_DQUOTE] = ACTIONS(182),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(184),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [33] = {
    [sym__expression] = STATE(85),
    [sym_union_expression] = STATE(85),
    [sym_intersection_expression] = STATE(85),
    [sym_value_of_expression] = STATE(85),
    [sym_array_expression] = STATE(85),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(97),
    [sym_builtin_type] = STATE(96),
    [sym_backticked_identifier] = STATE(96),
    [sym_member_expression] = STATE(104),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(47),
    [anon_sym_AMP] = ACTIONS(49),
    [anon_sym_valueof] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(55),
    [anon_sym_integer] = ACTIONS(55),
    [anon_sym_float] = ACTIONS(55),
    [anon_sym_int64] = ACTIONS(55),
    [anon_sym_int32] = ACTIONS(55),
    [anon_sym_int16] = ACTIONS(55),
    [anon_sym_int] = ACTIONS(55),
    [anon_sym_safeint] = ACTIONS(55),
    [anon_sym_uint6] = ACTIONS(55),
    [anon_sym_uint32] = ACTIONS(55),
    [anon_sym_uint16] = ACTIONS(55),
    [anon_sym_uint8] = ACTIONS(55),
    [anon_sym_float32] = ACTIONS(55),
    [anon_sym_float64] = ACTIONS(55),
    [anon_sym_decimal] = ACTIONS(55),
    [anon_sym_decimal128] = ACTIONS(55),
    [anon_sym_plainDate] = ACTIONS(55),
    [anon_sym_plainTime] = ACTIONS(55),
    [anon_sym_utcDateTime] = ACTIONS(55),
    [anon_sym_offsetDateTime] = ACTIONS(55),
    [anon_sym_duration] = ACTIONS(55),
    [anon_sym_bytes] = ACTIONS(55),
    [anon_sym_string] = ACTIONS(55),
    [anon_sym_boolean] = ACTIONS(55),
    [anon_sym_null] = ACTIONS(55),
    [anon_sym_Array] = ACTIONS(55),
    [anon_sym_Record] = ACTIONS(55),
    [anon_sym_unknown] = ACTIONS(55),
    [anon_sym_void] = ACTIONS(55),
    [anon_sym_never] = ACTIONS(55),
    [sym_plain_identifier] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [34] = {
    [sym__expression] = STATE(81),
    [sym_union_expression] = STATE(81),
    [sym_intersection_expression] = STATE(81),
    [sym_value_of_expression] = STATE(81),
    [sym_array_expression] = STATE(81),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [35] = {
    [sym__expression] = STATE(80),
    [sym_union_expression] = STATE(80),
    [sym_intersection_expression] = STATE(80),
    [sym_value_of_expression] = STATE(80),
    [sym_array_expression] = STATE(80),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [36] = {
    [sym__expression] = STATE(216),
    [sym_union_expression] = STATE(216),
    [sym_intersection_expression] = STATE(216),
    [sym_value_of_expression] = STATE(216),
    [sym_array_expression] = STATE(216),
    [sym__primary_expression] = STATE(158),
    [sym_tuple_expression] = STATE(158),
    [sym_model_expression] = STATE(158),
    [sym_reference_expression] = STATE(158),
    [sym_parenthesized_expression] = STATE(158),
    [sym_identifier_or_member_expression] = STATE(146),
    [sym_identifier] = STATE(134),
    [sym_builtin_type] = STATE(127),
    [sym_backticked_identifier] = STATE(127),
    [sym_member_expression] = STATE(147),
    [sym__literal] = STATE(158),
    [sym_boolean_literal] = STATE(158),
    [sym__numeric_literal] = STATE(158),
    [sym__string_literal] = STATE(158),
    [sym_quoted_string_literal] = STATE(158),
    [sym_triple_quoted_string_literal] = STATE(158),
    [anon_sym_LPAREN] = ACTIONS(186),
    [anon_sym_LBRACE] = ACTIONS(188),
    [anon_sym_PIPE] = ACTIONS(190),
    [anon_sym_AMP] = ACTIONS(192),
    [anon_sym_valueof] = ACTIONS(194),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_numeric] = ACTIONS(198),
    [anon_sym_integer] = ACTIONS(198),
    [anon_sym_float] = ACTIONS(198),
    [anon_sym_int64] = ACTIONS(198),
    [anon_sym_int32] = ACTIONS(198),
    [anon_sym_int16] = ACTIONS(198),
    [anon_sym_int] = ACTIONS(198),
    [anon_sym_safeint] = ACTIONS(198),
    [anon_sym_uint6] = ACTIONS(198),
    [anon_sym_uint32] = ACTIONS(198),
    [anon_sym_uint16] = ACTIONS(198),
    [anon_sym_uint8] = ACTIONS(198),
    [anon_sym_float32] = ACTIONS(198),
    [anon_sym_float64] = ACTIONS(198),
    [anon_sym_decimal] = ACTIONS(198),
    [anon_sym_decimal128] = ACTIONS(198),
    [anon_sym_plainDate] = ACTIONS(198),
    [anon_sym_plainTime] = ACTIONS(198),
    [anon_sym_utcDateTime] = ACTIONS(198),
    [anon_sym_offsetDateTime] = ACTIONS(198),
    [anon_sym_duration] = ACTIONS(198),
    [anon_sym_bytes] = ACTIONS(198),
    [anon_sym_string] = ACTIONS(198),
    [anon_sym_boolean] = ACTIONS(198),
    [anon_sym_null] = ACTIONS(198),
    [anon_sym_Array] = ACTIONS(198),
    [anon_sym_Record] = ACTIONS(198),
    [anon_sym_unknown] = ACTIONS(198),
    [anon_sym_void] = ACTIONS(198),
    [anon_sym_never] = ACTIONS(198),
    [sym_plain_identifier] = ACTIONS(200),
    [anon_sym_BQUOTE] = ACTIONS(202),
    [anon_sym_true] = ACTIONS(204),
    [anon_sym_false] = ACTIONS(204),
    [sym_decimal_literal] = ACTIONS(206),
    [sym_hex_integer_literal] = ACTIONS(208),
    [sym_binary_integer_literal] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(212),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [37] = {
    [sym__expression] = STATE(558),
    [sym_union_expression] = STATE(558),
    [sym_intersection_expression] = STATE(558),
    [sym_value_of_expression] = STATE(558),
    [sym_array_expression] = STATE(558),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [38] = {
    [sym__expression] = STATE(121),
    [sym_union_expression] = STATE(121),
    [sym_intersection_expression] = STATE(121),
    [sym_value_of_expression] = STATE(121),
    [sym_array_expression] = STATE(121),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(97),
    [sym_builtin_type] = STATE(96),
    [sym_backticked_identifier] = STATE(96),
    [sym_member_expression] = STATE(104),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(47),
    [anon_sym_AMP] = ACTIONS(49),
    [anon_sym_valueof] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(55),
    [anon_sym_integer] = ACTIONS(55),
    [anon_sym_float] = ACTIONS(55),
    [anon_sym_int64] = ACTIONS(55),
    [anon_sym_int32] = ACTIONS(55),
    [anon_sym_int16] = ACTIONS(55),
    [anon_sym_int] = ACTIONS(55),
    [anon_sym_safeint] = ACTIONS(55),
    [anon_sym_uint6] = ACTIONS(55),
    [anon_sym_uint32] = ACTIONS(55),
    [anon_sym_uint16] = ACTIONS(55),
    [anon_sym_uint8] = ACTIONS(55),
    [anon_sym_float32] = ACTIONS(55),
    [anon_sym_float64] = ACTIONS(55),
    [anon_sym_decimal] = ACTIONS(55),
    [anon_sym_decimal128] = ACTIONS(55),
    [anon_sym_plainDate] = ACTIONS(55),
    [anon_sym_plainTime] = ACTIONS(55),
    [anon_sym_utcDateTime] = ACTIONS(55),
    [anon_sym_offsetDateTime] = ACTIONS(55),
    [anon_sym_duration] = ACTIONS(55),
    [anon_sym_bytes] = ACTIONS(55),
    [anon_sym_string] = ACTIONS(55),
    [anon_sym_boolean] = ACTIONS(55),
    [anon_sym_null] = ACTIONS(55),
    [anon_sym_Array] = ACTIONS(55),
    [anon_sym_Record] = ACTIONS(55),
    [anon_sym_unknown] = ACTIONS(55),
    [anon_sym_void] = ACTIONS(55),
    [anon_sym_never] = ACTIONS(55),
    [sym_plain_identifier] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [39] = {
    [sym__expression] = STATE(576),
    [sym_union_expression] = STATE(576),
    [sym_intersection_expression] = STATE(576),
    [sym_value_of_expression] = STATE(576),
    [sym_array_expression] = STATE(576),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [40] = {
    [sym__expression] = STATE(353),
    [sym_union_expression] = STATE(353),
    [sym_intersection_expression] = STATE(353),
    [sym_value_of_expression] = STATE(353),
    [sym_array_expression] = STATE(353),
    [sym__primary_expression] = STATE(327),
    [sym_tuple_expression] = STATE(327),
    [sym_model_expression] = STATE(327),
    [sym_reference_expression] = STATE(327),
    [sym_parenthesized_expression] = STATE(327),
    [sym_identifier_or_member_expression] = STATE(325),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(327),
    [sym_boolean_literal] = STATE(327),
    [sym__numeric_literal] = STATE(327),
    [sym__string_literal] = STATE(327),
    [sym_quoted_string_literal] = STATE(327),
    [sym_triple_quoted_string_literal] = STATE(327),
    [anon_sym_LPAREN] = ACTIONS(214),
    [anon_sym_LBRACE] = ACTIONS(216),
    [anon_sym_PIPE] = ACTIONS(218),
    [anon_sym_AMP] = ACTIONS(220),
    [anon_sym_valueof] = ACTIONS(222),
    [anon_sym_LBRACK] = ACTIONS(224),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(226),
    [anon_sym_false] = ACTIONS(226),
    [sym_decimal_literal] = ACTIONS(228),
    [sym_hex_integer_literal] = ACTIONS(230),
    [sym_binary_integer_literal] = ACTIONS(230),
    [anon_sym_DQUOTE] = ACTIONS(232),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(234),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [41] = {
    [sym__expression] = STATE(362),
    [sym_union_expression] = STATE(362),
    [sym_intersection_expression] = STATE(362),
    [sym_value_of_expression] = STATE(362),
    [sym_array_expression] = STATE(362),
    [sym__primary_expression] = STATE(327),
    [sym_tuple_expression] = STATE(327),
    [sym_model_expression] = STATE(327),
    [sym_reference_expression] = STATE(327),
    [sym_parenthesized_expression] = STATE(327),
    [sym_identifier_or_member_expression] = STATE(325),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(327),
    [sym_boolean_literal] = STATE(327),
    [sym__numeric_literal] = STATE(327),
    [sym__string_literal] = STATE(327),
    [sym_quoted_string_literal] = STATE(327),
    [sym_triple_quoted_string_literal] = STATE(327),
    [anon_sym_LPAREN] = ACTIONS(214),
    [anon_sym_LBRACE] = ACTIONS(216),
    [anon_sym_PIPE] = ACTIONS(218),
    [anon_sym_AMP] = ACTIONS(220),
    [anon_sym_valueof] = ACTIONS(222),
    [anon_sym_LBRACK] = ACTIONS(224),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(226),
    [anon_sym_false] = ACTIONS(226),
    [sym_decimal_literal] = ACTIONS(228),
    [sym_hex_integer_literal] = ACTIONS(230),
    [sym_binary_integer_literal] = ACTIONS(230),
    [anon_sym_DQUOTE] = ACTIONS(232),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(234),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [42] = {
    [sym__expression] = STATE(360),
    [sym_union_expression] = STATE(360),
    [sym_intersection_expression] = STATE(360),
    [sym_value_of_expression] = STATE(360),
    [sym_array_expression] = STATE(360),
    [sym__primary_expression] = STATE(327),
    [sym_tuple_expression] = STATE(327),
    [sym_model_expression] = STATE(327),
    [sym_reference_expression] = STATE(327),
    [sym_parenthesized_expression] = STATE(327),
    [sym_identifier_or_member_expression] = STATE(325),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(327),
    [sym_boolean_literal] = STATE(327),
    [sym__numeric_literal] = STATE(327),
    [sym__string_literal] = STATE(327),
    [sym_quoted_string_literal] = STATE(327),
    [sym_triple_quoted_string_literal] = STATE(327),
    [anon_sym_LPAREN] = ACTIONS(214),
    [anon_sym_LBRACE] = ACTIONS(216),
    [anon_sym_PIPE] = ACTIONS(218),
    [anon_sym_AMP] = ACTIONS(220),
    [anon_sym_valueof] = ACTIONS(222),
    [anon_sym_LBRACK] = ACTIONS(224),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(226),
    [anon_sym_false] = ACTIONS(226),
    [sym_decimal_literal] = ACTIONS(228),
    [sym_hex_integer_literal] = ACTIONS(230),
    [sym_binary_integer_literal] = ACTIONS(230),
    [anon_sym_DQUOTE] = ACTIONS(232),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(234),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [43] = {
    [sym__expression] = STATE(166),
    [sym_union_expression] = STATE(166),
    [sym_intersection_expression] = STATE(166),
    [sym_value_of_expression] = STATE(166),
    [sym_array_expression] = STATE(166),
    [sym__primary_expression] = STATE(158),
    [sym_tuple_expression] = STATE(158),
    [sym_model_expression] = STATE(158),
    [sym_reference_expression] = STATE(158),
    [sym_parenthesized_expression] = STATE(158),
    [sym_identifier_or_member_expression] = STATE(146),
    [sym_identifier] = STATE(134),
    [sym_builtin_type] = STATE(127),
    [sym_backticked_identifier] = STATE(127),
    [sym_member_expression] = STATE(147),
    [sym__literal] = STATE(158),
    [sym_boolean_literal] = STATE(158),
    [sym__numeric_literal] = STATE(158),
    [sym__string_literal] = STATE(158),
    [sym_quoted_string_literal] = STATE(158),
    [sym_triple_quoted_string_literal] = STATE(158),
    [anon_sym_LPAREN] = ACTIONS(186),
    [anon_sym_LBRACE] = ACTIONS(188),
    [anon_sym_PIPE] = ACTIONS(190),
    [anon_sym_AMP] = ACTIONS(192),
    [anon_sym_valueof] = ACTIONS(194),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_numeric] = ACTIONS(198),
    [anon_sym_integer] = ACTIONS(198),
    [anon_sym_float] = ACTIONS(198),
    [anon_sym_int64] = ACTIONS(198),
    [anon_sym_int32] = ACTIONS(198),
    [anon_sym_int16] = ACTIONS(198),
    [anon_sym_int] = ACTIONS(198),
    [anon_sym_safeint] = ACTIONS(198),
    [anon_sym_uint6] = ACTIONS(198),
    [anon_sym_uint32] = ACTIONS(198),
    [anon_sym_uint16] = ACTIONS(198),
    [anon_sym_uint8] = ACTIONS(198),
    [anon_sym_float32] = ACTIONS(198),
    [anon_sym_float64] = ACTIONS(198),
    [anon_sym_decimal] = ACTIONS(198),
    [anon_sym_decimal128] = ACTIONS(198),
    [anon_sym_plainDate] = ACTIONS(198),
    [anon_sym_plainTime] = ACTIONS(198),
    [anon_sym_utcDateTime] = ACTIONS(198),
    [anon_sym_offsetDateTime] = ACTIONS(198),
    [anon_sym_duration] = ACTIONS(198),
    [anon_sym_bytes] = ACTIONS(198),
    [anon_sym_string] = ACTIONS(198),
    [anon_sym_boolean] = ACTIONS(198),
    [anon_sym_null] = ACTIONS(198),
    [anon_sym_Array] = ACTIONS(198),
    [anon_sym_Record] = ACTIONS(198),
    [anon_sym_unknown] = ACTIONS(198),
    [anon_sym_void] = ACTIONS(198),
    [anon_sym_never] = ACTIONS(198),
    [sym_plain_identifier] = ACTIONS(200),
    [anon_sym_BQUOTE] = ACTIONS(202),
    [anon_sym_true] = ACTIONS(204),
    [anon_sym_false] = ACTIONS(204),
    [sym_decimal_literal] = ACTIONS(206),
    [sym_hex_integer_literal] = ACTIONS(208),
    [sym_binary_integer_literal] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(212),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [44] = {
    [sym__expression] = STATE(356),
    [sym_union_expression] = STATE(356),
    [sym_intersection_expression] = STATE(356),
    [sym_value_of_expression] = STATE(356),
    [sym_array_expression] = STATE(356),
    [sym__primary_expression] = STATE(327),
    [sym_tuple_expression] = STATE(327),
    [sym_model_expression] = STATE(327),
    [sym_reference_expression] = STATE(327),
    [sym_parenthesized_expression] = STATE(327),
    [sym_identifier_or_member_expression] = STATE(325),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(327),
    [sym_boolean_literal] = STATE(327),
    [sym__numeric_literal] = STATE(327),
    [sym__string_literal] = STATE(327),
    [sym_quoted_string_literal] = STATE(327),
    [sym_triple_quoted_string_literal] = STATE(327),
    [anon_sym_LPAREN] = ACTIONS(214),
    [anon_sym_LBRACE] = ACTIONS(216),
    [anon_sym_PIPE] = ACTIONS(218),
    [anon_sym_AMP] = ACTIONS(220),
    [anon_sym_valueof] = ACTIONS(222),
    [anon_sym_LBRACK] = ACTIONS(224),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(226),
    [anon_sym_false] = ACTIONS(226),
    [sym_decimal_literal] = ACTIONS(228),
    [sym_hex_integer_literal] = ACTIONS(230),
    [sym_binary_integer_literal] = ACTIONS(230),
    [anon_sym_DQUOTE] = ACTIONS(232),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(234),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [45] = {
    [sym__expression] = STATE(537),
    [sym_union_expression] = STATE(537),
    [sym_intersection_expression] = STATE(537),
    [sym_value_of_expression] = STATE(537),
    [sym_array_expression] = STATE(537),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [46] = {
    [sym__expression] = STATE(80),
    [sym_union_expression] = STATE(80),
    [sym_intersection_expression] = STATE(80),
    [sym_value_of_expression] = STATE(80),
    [sym_array_expression] = STATE(80),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(97),
    [sym_builtin_type] = STATE(96),
    [sym_backticked_identifier] = STATE(96),
    [sym_member_expression] = STATE(104),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(47),
    [anon_sym_AMP] = ACTIONS(49),
    [anon_sym_valueof] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(55),
    [anon_sym_integer] = ACTIONS(55),
    [anon_sym_float] = ACTIONS(55),
    [anon_sym_int64] = ACTIONS(55),
    [anon_sym_int32] = ACTIONS(55),
    [anon_sym_int16] = ACTIONS(55),
    [anon_sym_int] = ACTIONS(55),
    [anon_sym_safeint] = ACTIONS(55),
    [anon_sym_uint6] = ACTIONS(55),
    [anon_sym_uint32] = ACTIONS(55),
    [anon_sym_uint16] = ACTIONS(55),
    [anon_sym_uint8] = ACTIONS(55),
    [anon_sym_float32] = ACTIONS(55),
    [anon_sym_float64] = ACTIONS(55),
    [anon_sym_decimal] = ACTIONS(55),
    [anon_sym_decimal128] = ACTIONS(55),
    [anon_sym_plainDate] = ACTIONS(55),
    [anon_sym_plainTime] = ACTIONS(55),
    [anon_sym_utcDateTime] = ACTIONS(55),
    [anon_sym_offsetDateTime] = ACTIONS(55),
    [anon_sym_duration] = ACTIONS(55),
    [anon_sym_bytes] = ACTIONS(55),
    [anon_sym_string] = ACTIONS(55),
    [anon_sym_boolean] = ACTIONS(55),
    [anon_sym_null] = ACTIONS(55),
    [anon_sym_Array] = ACTIONS(55),
    [anon_sym_Record] = ACTIONS(55),
    [anon_sym_unknown] = ACTIONS(55),
    [anon_sym_void] = ACTIONS(55),
    [anon_sym_never] = ACTIONS(55),
    [sym_plain_identifier] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [47] = {
    [sym__expression] = STATE(507),
    [sym_union_expression] = STATE(507),
    [sym_intersection_expression] = STATE(507),
    [sym_value_of_expression] = STATE(507),
    [sym_array_expression] = STATE(507),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [48] = {
    [sym__expression] = STATE(170),
    [sym_union_expression] = STATE(170),
    [sym_intersection_expression] = STATE(170),
    [sym_value_of_expression] = STATE(170),
    [sym_array_expression] = STATE(170),
    [sym__primary_expression] = STATE(158),
    [sym_tuple_expression] = STATE(158),
    [sym_model_expression] = STATE(158),
    [sym_reference_expression] = STATE(158),
    [sym_parenthesized_expression] = STATE(158),
    [sym_identifier_or_member_expression] = STATE(146),
    [sym_identifier] = STATE(134),
    [sym_builtin_type] = STATE(127),
    [sym_backticked_identifier] = STATE(127),
    [sym_member_expression] = STATE(147),
    [sym__literal] = STATE(158),
    [sym_boolean_literal] = STATE(158),
    [sym__numeric_literal] = STATE(158),
    [sym__string_literal] = STATE(158),
    [sym_quoted_string_literal] = STATE(158),
    [sym_triple_quoted_string_literal] = STATE(158),
    [anon_sym_LPAREN] = ACTIONS(186),
    [anon_sym_LBRACE] = ACTIONS(188),
    [anon_sym_PIPE] = ACTIONS(190),
    [anon_sym_AMP] = ACTIONS(192),
    [anon_sym_valueof] = ACTIONS(194),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_numeric] = ACTIONS(198),
    [anon_sym_integer] = ACTIONS(198),
    [anon_sym_float] = ACTIONS(198),
    [anon_sym_int64] = ACTIONS(198),
    [anon_sym_int32] = ACTIONS(198),
    [anon_sym_int16] = ACTIONS(198),
    [anon_sym_int] = ACTIONS(198),
    [anon_sym_safeint] = ACTIONS(198),
    [anon_sym_uint6] = ACTIONS(198),
    [anon_sym_uint32] = ACTIONS(198),
    [anon_sym_uint16] = ACTIONS(198),
    [anon_sym_uint8] = ACTIONS(198),
    [anon_sym_float32] = ACTIONS(198),
    [anon_sym_float64] = ACTIONS(198),
    [anon_sym_decimal] = ACTIONS(198),
    [anon_sym_decimal128] = ACTIONS(198),
    [anon_sym_plainDate] = ACTIONS(198),
    [anon_sym_plainTime] = ACTIONS(198),
    [anon_sym_utcDateTime] = ACTIONS(198),
    [anon_sym_offsetDateTime] = ACTIONS(198),
    [anon_sym_duration] = ACTIONS(198),
    [anon_sym_bytes] = ACTIONS(198),
    [anon_sym_string] = ACTIONS(198),
    [anon_sym_boolean] = ACTIONS(198),
    [anon_sym_null] = ACTIONS(198),
    [anon_sym_Array] = ACTIONS(198),
    [anon_sym_Record] = ACTIONS(198),
    [anon_sym_unknown] = ACTIONS(198),
    [anon_sym_void] = ACTIONS(198),
    [anon_sym_never] = ACTIONS(198),
    [sym_plain_identifier] = ACTIONS(200),
    [anon_sym_BQUOTE] = ACTIONS(202),
    [anon_sym_true] = ACTIONS(204),
    [anon_sym_false] = ACTIONS(204),
    [sym_decimal_literal] = ACTIONS(206),
    [sym_hex_integer_literal] = ACTIONS(208),
    [sym_binary_integer_literal] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(212),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [49] = {
    [sym__expression] = STATE(116),
    [sym_union_expression] = STATE(116),
    [sym_intersection_expression] = STATE(116),
    [sym_value_of_expression] = STATE(116),
    [sym_array_expression] = STATE(116),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(97),
    [sym_builtin_type] = STATE(96),
    [sym_backticked_identifier] = STATE(96),
    [sym_member_expression] = STATE(104),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(47),
    [anon_sym_AMP] = ACTIONS(49),
    [anon_sym_valueof] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(55),
    [anon_sym_integer] = ACTIONS(55),
    [anon_sym_float] = ACTIONS(55),
    [anon_sym_int64] = ACTIONS(55),
    [anon_sym_int32] = ACTIONS(55),
    [anon_sym_int16] = ACTIONS(55),
    [anon_sym_int] = ACTIONS(55),
    [anon_sym_safeint] = ACTIONS(55),
    [anon_sym_uint6] = ACTIONS(55),
    [anon_sym_uint32] = ACTIONS(55),
    [anon_sym_uint16] = ACTIONS(55),
    [anon_sym_uint8] = ACTIONS(55),
    [anon_sym_float32] = ACTIONS(55),
    [anon_sym_float64] = ACTIONS(55),
    [anon_sym_decimal] = ACTIONS(55),
    [anon_sym_decimal128] = ACTIONS(55),
    [anon_sym_plainDate] = ACTIONS(55),
    [anon_sym_plainTime] = ACTIONS(55),
    [anon_sym_utcDateTime] = ACTIONS(55),
    [anon_sym_offsetDateTime] = ACTIONS(55),
    [anon_sym_duration] = ACTIONS(55),
    [anon_sym_bytes] = ACTIONS(55),
    [anon_sym_string] = ACTIONS(55),
    [anon_sym_boolean] = ACTIONS(55),
    [anon_sym_null] = ACTIONS(55),
    [anon_sym_Array] = ACTIONS(55),
    [anon_sym_Record] = ACTIONS(55),
    [anon_sym_unknown] = ACTIONS(55),
    [anon_sym_void] = ACTIONS(55),
    [anon_sym_never] = ACTIONS(55),
    [sym_plain_identifier] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [50] = {
    [sym__expression] = STATE(169),
    [sym_union_expression] = STATE(169),
    [sym_intersection_expression] = STATE(169),
    [sym_value_of_expression] = STATE(169),
    [sym_array_expression] = STATE(169),
    [sym__primary_expression] = STATE(158),
    [sym_tuple_expression] = STATE(158),
    [sym_model_expression] = STATE(158),
    [sym_reference_expression] = STATE(158),
    [sym_parenthesized_expression] = STATE(158),
    [sym_identifier_or_member_expression] = STATE(146),
    [sym_identifier] = STATE(134),
    [sym_builtin_type] = STATE(127),
    [sym_backticked_identifier] = STATE(127),
    [sym_member_expression] = STATE(147),
    [sym__literal] = STATE(158),
    [sym_boolean_literal] = STATE(158),
    [sym__numeric_literal] = STATE(158),
    [sym__string_literal] = STATE(158),
    [sym_quoted_string_literal] = STATE(158),
    [sym_triple_quoted_string_literal] = STATE(158),
    [anon_sym_LPAREN] = ACTIONS(186),
    [anon_sym_LBRACE] = ACTIONS(188),
    [anon_sym_PIPE] = ACTIONS(190),
    [anon_sym_AMP] = ACTIONS(192),
    [anon_sym_valueof] = ACTIONS(194),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_numeric] = ACTIONS(198),
    [anon_sym_integer] = ACTIONS(198),
    [anon_sym_float] = ACTIONS(198),
    [anon_sym_int64] = ACTIONS(198),
    [anon_sym_int32] = ACTIONS(198),
    [anon_sym_int16] = ACTIONS(198),
    [anon_sym_int] = ACTIONS(198),
    [anon_sym_safeint] = ACTIONS(198),
    [anon_sym_uint6] = ACTIONS(198),
    [anon_sym_uint32] = ACTIONS(198),
    [anon_sym_uint16] = ACTIONS(198),
    [anon_sym_uint8] = ACTIONS(198),
    [anon_sym_float32] = ACTIONS(198),
    [anon_sym_float64] = ACTIONS(198),
    [anon_sym_decimal] = ACTIONS(198),
    [anon_sym_decimal128] = ACTIONS(198),
    [anon_sym_plainDate] = ACTIONS(198),
    [anon_sym_plainTime] = ACTIONS(198),
    [anon_sym_utcDateTime] = ACTIONS(198),
    [anon_sym_offsetDateTime] = ACTIONS(198),
    [anon_sym_duration] = ACTIONS(198),
    [anon_sym_bytes] = ACTIONS(198),
    [anon_sym_string] = ACTIONS(198),
    [anon_sym_boolean] = ACTIONS(198),
    [anon_sym_null] = ACTIONS(198),
    [anon_sym_Array] = ACTIONS(198),
    [anon_sym_Record] = ACTIONS(198),
    [anon_sym_unknown] = ACTIONS(198),
    [anon_sym_void] = ACTIONS(198),
    [anon_sym_never] = ACTIONS(198),
    [sym_plain_identifier] = ACTIONS(200),
    [anon_sym_BQUOTE] = ACTIONS(202),
    [anon_sym_true] = ACTIONS(204),
    [anon_sym_false] = ACTIONS(204),
    [sym_decimal_literal] = ACTIONS(206),
    [sym_hex_integer_literal] = ACTIONS(208),
    [sym_binary_integer_literal] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(212),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [51] = {
    [sym__expression] = STATE(372),
    [sym_union_expression] = STATE(372),
    [sym_intersection_expression] = STATE(372),
    [sym_value_of_expression] = STATE(372),
    [sym_array_expression] = STATE(372),
    [sym__primary_expression] = STATE(327),
    [sym_tuple_expression] = STATE(327),
    [sym_model_expression] = STATE(327),
    [sym_reference_expression] = STATE(327),
    [sym_parenthesized_expression] = STATE(327),
    [sym_identifier_or_member_expression] = STATE(325),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(327),
    [sym_boolean_literal] = STATE(327),
    [sym__numeric_literal] = STATE(327),
    [sym__string_literal] = STATE(327),
    [sym_quoted_string_literal] = STATE(327),
    [sym_triple_quoted_string_literal] = STATE(327),
    [anon_sym_LPAREN] = ACTIONS(214),
    [anon_sym_LBRACE] = ACTIONS(216),
    [anon_sym_PIPE] = ACTIONS(218),
    [anon_sym_AMP] = ACTIONS(220),
    [anon_sym_valueof] = ACTIONS(222),
    [anon_sym_LBRACK] = ACTIONS(224),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(226),
    [anon_sym_false] = ACTIONS(226),
    [sym_decimal_literal] = ACTIONS(228),
    [sym_hex_integer_literal] = ACTIONS(230),
    [sym_binary_integer_literal] = ACTIONS(230),
    [anon_sym_DQUOTE] = ACTIONS(232),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(234),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [52] = {
    [sym__expression] = STATE(364),
    [sym_union_expression] = STATE(364),
    [sym_intersection_expression] = STATE(364),
    [sym_value_of_expression] = STATE(364),
    [sym_array_expression] = STATE(364),
    [sym__primary_expression] = STATE(327),
    [sym_tuple_expression] = STATE(327),
    [sym_model_expression] = STATE(327),
    [sym_reference_expression] = STATE(327),
    [sym_parenthesized_expression] = STATE(327),
    [sym_identifier_or_member_expression] = STATE(325),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(327),
    [sym_boolean_literal] = STATE(327),
    [sym__numeric_literal] = STATE(327),
    [sym__string_literal] = STATE(327),
    [sym_quoted_string_literal] = STATE(327),
    [sym_triple_quoted_string_literal] = STATE(327),
    [anon_sym_LPAREN] = ACTIONS(214),
    [anon_sym_LBRACE] = ACTIONS(216),
    [anon_sym_PIPE] = ACTIONS(218),
    [anon_sym_AMP] = ACTIONS(220),
    [anon_sym_valueof] = ACTIONS(222),
    [anon_sym_LBRACK] = ACTIONS(224),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(226),
    [anon_sym_false] = ACTIONS(226),
    [sym_decimal_literal] = ACTIONS(228),
    [sym_hex_integer_literal] = ACTIONS(230),
    [sym_binary_integer_literal] = ACTIONS(230),
    [anon_sym_DQUOTE] = ACTIONS(232),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(234),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [53] = {
    [sym__expression] = STATE(358),
    [sym_union_expression] = STATE(358),
    [sym_intersection_expression] = STATE(358),
    [sym_value_of_expression] = STATE(358),
    [sym_array_expression] = STATE(358),
    [sym__primary_expression] = STATE(331),
    [sym_tuple_expression] = STATE(331),
    [sym_model_expression] = STATE(331),
    [sym_reference_expression] = STATE(331),
    [sym_parenthesized_expression] = STATE(331),
    [sym_identifier_or_member_expression] = STATE(326),
    [sym_identifier] = STATE(318),
    [sym_builtin_type] = STATE(320),
    [sym_backticked_identifier] = STATE(320),
    [sym_member_expression] = STATE(324),
    [sym__literal] = STATE(331),
    [sym_boolean_literal] = STATE(331),
    [sym__numeric_literal] = STATE(331),
    [sym__string_literal] = STATE(331),
    [sym_quoted_string_literal] = STATE(331),
    [sym_triple_quoted_string_literal] = STATE(331),
    [anon_sym_LPAREN] = ACTIONS(158),
    [anon_sym_LBRACE] = ACTIONS(160),
    [anon_sym_PIPE] = ACTIONS(162),
    [anon_sym_AMP] = ACTIONS(164),
    [anon_sym_valueof] = ACTIONS(166),
    [anon_sym_LBRACK] = ACTIONS(168),
    [anon_sym_numeric] = ACTIONS(170),
    [anon_sym_integer] = ACTIONS(170),
    [anon_sym_float] = ACTIONS(170),
    [anon_sym_int64] = ACTIONS(170),
    [anon_sym_int32] = ACTIONS(170),
    [anon_sym_int16] = ACTIONS(170),
    [anon_sym_int] = ACTIONS(170),
    [anon_sym_safeint] = ACTIONS(170),
    [anon_sym_uint6] = ACTIONS(170),
    [anon_sym_uint32] = ACTIONS(170),
    [anon_sym_uint16] = ACTIONS(170),
    [anon_sym_uint8] = ACTIONS(170),
    [anon_sym_float32] = ACTIONS(170),
    [anon_sym_float64] = ACTIONS(170),
    [anon_sym_decimal] = ACTIONS(170),
    [anon_sym_decimal128] = ACTIONS(170),
    [anon_sym_plainDate] = ACTIONS(170),
    [anon_sym_plainTime] = ACTIONS(170),
    [anon_sym_utcDateTime] = ACTIONS(170),
    [anon_sym_offsetDateTime] = ACTIONS(170),
    [anon_sym_duration] = ACTIONS(170),
    [anon_sym_bytes] = ACTIONS(170),
    [anon_sym_string] = ACTIONS(170),
    [anon_sym_boolean] = ACTIONS(170),
    [anon_sym_null] = ACTIONS(170),
    [anon_sym_Array] = ACTIONS(170),
    [anon_sym_Record] = ACTIONS(170),
    [anon_sym_unknown] = ACTIONS(170),
    [anon_sym_void] = ACTIONS(170),
    [anon_sym_never] = ACTIONS(170),
    [sym_plain_identifier] = ACTIONS(172),
    [anon_sym_BQUOTE] = ACTIONS(174),
    [anon_sym_true] = ACTIONS(176),
    [anon_sym_false] = ACTIONS(176),
    [sym_decimal_literal] = ACTIONS(178),
    [sym_hex_integer_literal] = ACTIONS(180),
    [sym_binary_integer_literal] = ACTIONS(180),
    [anon_sym_DQUOTE] = ACTIONS(182),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(184),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [54] = {
    [sym__expression] = STATE(120),
    [sym_union_expression] = STATE(120),
    [sym_intersection_expression] = STATE(120),
    [sym_value_of_expression] = STATE(120),
    [sym_array_expression] = STATE(120),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(97),
    [sym_builtin_type] = STATE(96),
    [sym_backticked_identifier] = STATE(96),
    [sym_member_expression] = STATE(104),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(47),
    [anon_sym_AMP] = ACTIONS(49),
    [anon_sym_valueof] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(55),
    [anon_sym_integer] = ACTIONS(55),
    [anon_sym_float] = ACTIONS(55),
    [anon_sym_int64] = ACTIONS(55),
    [anon_sym_int32] = ACTIONS(55),
    [anon_sym_int16] = ACTIONS(55),
    [anon_sym_int] = ACTIONS(55),
    [anon_sym_safeint] = ACTIONS(55),
    [anon_sym_uint6] = ACTIONS(55),
    [anon_sym_uint32] = ACTIONS(55),
    [anon_sym_uint16] = ACTIONS(55),
    [anon_sym_uint8] = ACTIONS(55),
    [anon_sym_float32] = ACTIONS(55),
    [anon_sym_float64] = ACTIONS(55),
    [anon_sym_decimal] = ACTIONS(55),
    [anon_sym_decimal128] = ACTIONS(55),
    [anon_sym_plainDate] = ACTIONS(55),
    [anon_sym_plainTime] = ACTIONS(55),
    [anon_sym_utcDateTime] = ACTIONS(55),
    [anon_sym_offsetDateTime] = ACTIONS(55),
    [anon_sym_duration] = ACTIONS(55),
    [anon_sym_bytes] = ACTIONS(55),
    [anon_sym_string] = ACTIONS(55),
    [anon_sym_boolean] = ACTIONS(55),
    [anon_sym_null] = ACTIONS(55),
    [anon_sym_Array] = ACTIONS(55),
    [anon_sym_Record] = ACTIONS(55),
    [anon_sym_unknown] = ACTIONS(55),
    [anon_sym_void] = ACTIONS(55),
    [anon_sym_never] = ACTIONS(55),
    [sym_plain_identifier] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [55] = {
    [sym__expression] = STATE(125),
    [sym_union_expression] = STATE(125),
    [sym_intersection_expression] = STATE(125),
    [sym_value_of_expression] = STATE(125),
    [sym_array_expression] = STATE(125),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(97),
    [sym_builtin_type] = STATE(96),
    [sym_backticked_identifier] = STATE(96),
    [sym_member_expression] = STATE(104),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(47),
    [anon_sym_AMP] = ACTIONS(49),
    [anon_sym_valueof] = ACTIONS(51),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(55),
    [anon_sym_integer] = ACTIONS(55),
    [anon_sym_float] = ACTIONS(55),
    [anon_sym_int64] = ACTIONS(55),
    [anon_sym_int32] = ACTIONS(55),
    [anon_sym_int16] = ACTIONS(55),
    [anon_sym_int] = ACTIONS(55),
    [anon_sym_safeint] = ACTIONS(55),
    [anon_sym_uint6] = ACTIONS(55),
    [anon_sym_uint32] = ACTIONS(55),
    [anon_sym_uint16] = ACTIONS(55),
    [anon_sym_uint8] = ACTIONS(55),
    [anon_sym_float32] = ACTIONS(55),
    [anon_sym_float64] = ACTIONS(55),
    [anon_sym_decimal] = ACTIONS(55),
    [anon_sym_decimal128] = ACTIONS(55),
    [anon_sym_plainDate] = ACTIONS(55),
    [anon_sym_plainTime] = ACTIONS(55),
    [anon_sym_utcDateTime] = ACTIONS(55),
    [anon_sym_offsetDateTime] = ACTIONS(55),
    [anon_sym_duration] = ACTIONS(55),
    [anon_sym_bytes] = ACTIONS(55),
    [anon_sym_string] = ACTIONS(55),
    [anon_sym_boolean] = ACTIONS(55),
    [anon_sym_null] = ACTIONS(55),
    [anon_sym_Array] = ACTIONS(55),
    [anon_sym_Record] = ACTIONS(55),
    [anon_sym_unknown] = ACTIONS(55),
    [anon_sym_void] = ACTIONS(55),
    [anon_sym_never] = ACTIONS(55),
    [sym_plain_identifier] = ACTIONS(57),
    [anon_sym_BQUOTE] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [56] = {
    [sym__expression] = STATE(369),
    [sym_union_expression] = STATE(369),
    [sym_intersection_expression] = STATE(369),
    [sym_value_of_expression] = STATE(369),
    [sym_array_expression] = STATE(369),
    [sym__primary_expression] = STATE(331),
    [sym_tuple_expression] = STATE(331),
    [sym_model_expression] = STATE(331),
    [sym_reference_expression] = STATE(331),
    [sym_parenthesized_expression] = STATE(331),
    [sym_identifier_or_member_expression] = STATE(326),
    [sym_identifier] = STATE(318),
    [sym_builtin_type] = STATE(320),
    [sym_backticked_identifier] = STATE(320),
    [sym_member_expression] = STATE(324),
    [sym__literal] = STATE(331),
    [sym_boolean_literal] = STATE(331),
    [sym__numeric_literal] = STATE(331),
    [sym__string_literal] = STATE(331),
    [sym_quoted_string_literal] = STATE(331),
    [sym_triple_quoted_string_literal] = STATE(331),
    [anon_sym_LPAREN] = ACTIONS(158),
    [anon_sym_LBRACE] = ACTIONS(160),
    [anon_sym_PIPE] = ACTIONS(162),
    [anon_sym_AMP] = ACTIONS(164),
    [anon_sym_valueof] = ACTIONS(166),
    [anon_sym_LBRACK] = ACTIONS(168),
    [anon_sym_numeric] = ACTIONS(170),
    [anon_sym_integer] = ACTIONS(170),
    [anon_sym_float] = ACTIONS(170),
    [anon_sym_int64] = ACTIONS(170),
    [anon_sym_int32] = ACTIONS(170),
    [anon_sym_int16] = ACTIONS(170),
    [anon_sym_int] = ACTIONS(170),
    [anon_sym_safeint] = ACTIONS(170),
    [anon_sym_uint6] = ACTIONS(170),
    [anon_sym_uint32] = ACTIONS(170),
    [anon_sym_uint16] = ACTIONS(170),
    [anon_sym_uint8] = ACTIONS(170),
    [anon_sym_float32] = ACTIONS(170),
    [anon_sym_float64] = ACTIONS(170),
    [anon_sym_decimal] = ACTIONS(170),
    [anon_sym_decimal128] = ACTIONS(170),
    [anon_sym_plainDate] = ACTIONS(170),
    [anon_sym_plainTime] = ACTIONS(170),
    [anon_sym_utcDateTime] = ACTIONS(170),
    [anon_sym_offsetDateTime] = ACTIONS(170),
    [anon_sym_duration] = ACTIONS(170),
    [anon_sym_bytes] = ACTIONS(170),
    [anon_sym_string] = ACTIONS(170),
    [anon_sym_boolean] = ACTIONS(170),
    [anon_sym_null] = ACTIONS(170),
    [anon_sym_Array] = ACTIONS(170),
    [anon_sym_Record] = ACTIONS(170),
    [anon_sym_unknown] = ACTIONS(170),
    [anon_sym_void] = ACTIONS(170),
    [anon_sym_never] = ACTIONS(170),
    [sym_plain_identifier] = ACTIONS(172),
    [anon_sym_BQUOTE] = ACTIONS(174),
    [anon_sym_true] = ACTIONS(176),
    [anon_sym_false] = ACTIONS(176),
    [sym_decimal_literal] = ACTIONS(178),
    [sym_hex_integer_literal] = ACTIONS(180),
    [sym_binary_integer_literal] = ACTIONS(180),
    [anon_sym_DQUOTE] = ACTIONS(182),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(184),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [57] = {
    [sym__expression] = STATE(572),
    [sym_union_expression] = STATE(572),
    [sym_intersection_expression] = STATE(572),
    [sym_value_of_expression] = STATE(572),
    [sym_array_expression] = STATE(572),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [58] = {
    [sym__expression] = STATE(553),
    [sym_union_expression] = STATE(553),
    [sym_intersection_expression] = STATE(553),
    [sym_value_of_expression] = STATE(553),
    [sym_array_expression] = STATE(553),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [59] = {
    [sym__expression] = STATE(85),
    [sym_union_expression] = STATE(85),
    [sym_intersection_expression] = STATE(85),
    [sym_value_of_expression] = STATE(85),
    [sym_array_expression] = STATE(85),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [60] = {
    [sym__expression] = STATE(476),
    [sym_union_expression] = STATE(476),
    [sym_intersection_expression] = STATE(476),
    [sym_value_of_expression] = STATE(476),
    [sym_array_expression] = STATE(476),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [61] = {
    [sym__expression] = STATE(564),
    [sym_union_expression] = STATE(564),
    [sym_intersection_expression] = STATE(564),
    [sym_value_of_expression] = STATE(564),
    [sym_array_expression] = STATE(564),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [62] = {
    [sym__expression] = STATE(368),
    [sym_union_expression] = STATE(368),
    [sym_intersection_expression] = STATE(368),
    [sym_value_of_expression] = STATE(368),
    [sym_array_expression] = STATE(368),
    [sym__primary_expression] = STATE(331),
    [sym_tuple_expression] = STATE(331),
    [sym_model_expression] = STATE(331),
    [sym_reference_expression] = STATE(331),
    [sym_parenthesized_expression] = STATE(331),
    [sym_identifier_or_member_expression] = STATE(326),
    [sym_identifier] = STATE(318),
    [sym_builtin_type] = STATE(320),
    [sym_backticked_identifier] = STATE(320),
    [sym_member_expression] = STATE(324),
    [sym__literal] = STATE(331),
    [sym_boolean_literal] = STATE(331),
    [sym__numeric_literal] = STATE(331),
    [sym__string_literal] = STATE(331),
    [sym_quoted_string_literal] = STATE(331),
    [sym_triple_quoted_string_literal] = STATE(331),
    [anon_sym_LPAREN] = ACTIONS(158),
    [anon_sym_LBRACE] = ACTIONS(160),
    [anon_sym_PIPE] = ACTIONS(162),
    [anon_sym_AMP] = ACTIONS(164),
    [anon_sym_valueof] = ACTIONS(166),
    [anon_sym_LBRACK] = ACTIONS(168),
    [anon_sym_numeric] = ACTIONS(170),
    [anon_sym_integer] = ACTIONS(170),
    [anon_sym_float] = ACTIONS(170),
    [anon_sym_int64] = ACTIONS(170),
    [anon_sym_int32] = ACTIONS(170),
    [anon_sym_int16] = ACTIONS(170),
    [anon_sym_int] = ACTIONS(170),
    [anon_sym_safeint] = ACTIONS(170),
    [anon_sym_uint6] = ACTIONS(170),
    [anon_sym_uint32] = ACTIONS(170),
    [anon_sym_uint16] = ACTIONS(170),
    [anon_sym_uint8] = ACTIONS(170),
    [anon_sym_float32] = ACTIONS(170),
    [anon_sym_float64] = ACTIONS(170),
    [anon_sym_decimal] = ACTIONS(170),
    [anon_sym_decimal128] = ACTIONS(170),
    [anon_sym_plainDate] = ACTIONS(170),
    [anon_sym_plainTime] = ACTIONS(170),
    [anon_sym_utcDateTime] = ACTIONS(170),
    [anon_sym_offsetDateTime] = ACTIONS(170),
    [anon_sym_duration] = ACTIONS(170),
    [anon_sym_bytes] = ACTIONS(170),
    [anon_sym_string] = ACTIONS(170),
    [anon_sym_boolean] = ACTIONS(170),
    [anon_sym_null] = ACTIONS(170),
    [anon_sym_Array] = ACTIONS(170),
    [anon_sym_Record] = ACTIONS(170),
    [anon_sym_unknown] = ACTIONS(170),
    [anon_sym_void] = ACTIONS(170),
    [anon_sym_never] = ACTIONS(170),
    [sym_plain_identifier] = ACTIONS(172),
    [anon_sym_BQUOTE] = ACTIONS(174),
    [anon_sym_true] = ACTIONS(176),
    [anon_sym_false] = ACTIONS(176),
    [sym_decimal_literal] = ACTIONS(178),
    [sym_hex_integer_literal] = ACTIONS(180),
    [sym_binary_integer_literal] = ACTIONS(180),
    [anon_sym_DQUOTE] = ACTIONS(182),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(184),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [63] = {
    [sym__expression] = STATE(575),
    [sym_union_expression] = STATE(575),
    [sym_intersection_expression] = STATE(575),
    [sym_value_of_expression] = STATE(575),
    [sym_array_expression] = STATE(575),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [64] = {
    [sym__expression] = STATE(172),
    [sym_union_expression] = STATE(172),
    [sym_intersection_expression] = STATE(172),
    [sym_value_of_expression] = STATE(172),
    [sym_array_expression] = STATE(172),
    [sym__primary_expression] = STATE(158),
    [sym_tuple_expression] = STATE(158),
    [sym_model_expression] = STATE(158),
    [sym_reference_expression] = STATE(158),
    [sym_parenthesized_expression] = STATE(158),
    [sym_identifier_or_member_expression] = STATE(146),
    [sym_identifier] = STATE(134),
    [sym_builtin_type] = STATE(127),
    [sym_backticked_identifier] = STATE(127),
    [sym_member_expression] = STATE(147),
    [sym__literal] = STATE(158),
    [sym_boolean_literal] = STATE(158),
    [sym__numeric_literal] = STATE(158),
    [sym__string_literal] = STATE(158),
    [sym_quoted_string_literal] = STATE(158),
    [sym_triple_quoted_string_literal] = STATE(158),
    [anon_sym_LPAREN] = ACTIONS(186),
    [anon_sym_LBRACE] = ACTIONS(188),
    [anon_sym_PIPE] = ACTIONS(190),
    [anon_sym_AMP] = ACTIONS(192),
    [anon_sym_valueof] = ACTIONS(194),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_numeric] = ACTIONS(198),
    [anon_sym_integer] = ACTIONS(198),
    [anon_sym_float] = ACTIONS(198),
    [anon_sym_int64] = ACTIONS(198),
    [anon_sym_int32] = ACTIONS(198),
    [anon_sym_int16] = ACTIONS(198),
    [anon_sym_int] = ACTIONS(198),
    [anon_sym_safeint] = ACTIONS(198),
    [anon_sym_uint6] = ACTIONS(198),
    [anon_sym_uint32] = ACTIONS(198),
    [anon_sym_uint16] = ACTIONS(198),
    [anon_sym_uint8] = ACTIONS(198),
    [anon_sym_float32] = ACTIONS(198),
    [anon_sym_float64] = ACTIONS(198),
    [anon_sym_decimal] = ACTIONS(198),
    [anon_sym_decimal128] = ACTIONS(198),
    [anon_sym_plainDate] = ACTIONS(198),
    [anon_sym_plainTime] = ACTIONS(198),
    [anon_sym_utcDateTime] = ACTIONS(198),
    [anon_sym_offsetDateTime] = ACTIONS(198),
    [anon_sym_duration] = ACTIONS(198),
    [anon_sym_bytes] = ACTIONS(198),
    [anon_sym_string] = ACTIONS(198),
    [anon_sym_boolean] = ACTIONS(198),
    [anon_sym_null] = ACTIONS(198),
    [anon_sym_Array] = ACTIONS(198),
    [anon_sym_Record] = ACTIONS(198),
    [anon_sym_unknown] = ACTIONS(198),
    [anon_sym_void] = ACTIONS(198),
    [anon_sym_never] = ACTIONS(198),
    [sym_plain_identifier] = ACTIONS(200),
    [anon_sym_BQUOTE] = ACTIONS(202),
    [anon_sym_true] = ACTIONS(204),
    [anon_sym_false] = ACTIONS(204),
    [sym_decimal_literal] = ACTIONS(206),
    [sym_hex_integer_literal] = ACTIONS(208),
    [sym_binary_integer_literal] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(212),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [65] = {
    [sym__expression] = STATE(168),
    [sym_union_expression] = STATE(168),
    [sym_intersection_expression] = STATE(168),
    [sym_value_of_expression] = STATE(168),
    [sym_array_expression] = STATE(168),
    [sym__primary_expression] = STATE(158),
    [sym_tuple_expression] = STATE(158),
    [sym_model_expression] = STATE(158),
    [sym_reference_expression] = STATE(158),
    [sym_parenthesized_expression] = STATE(158),
    [sym_identifier_or_member_expression] = STATE(146),
    [sym_identifier] = STATE(134),
    [sym_builtin_type] = STATE(127),
    [sym_backticked_identifier] = STATE(127),
    [sym_member_expression] = STATE(147),
    [sym__literal] = STATE(158),
    [sym_boolean_literal] = STATE(158),
    [sym__numeric_literal] = STATE(158),
    [sym__string_literal] = STATE(158),
    [sym_quoted_string_literal] = STATE(158),
    [sym_triple_quoted_string_literal] = STATE(158),
    [anon_sym_LPAREN] = ACTIONS(186),
    [anon_sym_LBRACE] = ACTIONS(188),
    [anon_sym_PIPE] = ACTIONS(190),
    [anon_sym_AMP] = ACTIONS(192),
    [anon_sym_valueof] = ACTIONS(194),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_numeric] = ACTIONS(198),
    [anon_sym_integer] = ACTIONS(198),
    [anon_sym_float] = ACTIONS(198),
    [anon_sym_int64] = ACTIONS(198),
    [anon_sym_int32] = ACTIONS(198),
    [anon_sym_int16] = ACTIONS(198),
    [anon_sym_int] = ACTIONS(198),
    [anon_sym_safeint] = ACTIONS(198),
    [anon_sym_uint6] = ACTIONS(198),
    [anon_sym_uint32] = ACTIONS(198),
    [anon_sym_uint16] = ACTIONS(198),
    [anon_sym_uint8] = ACTIONS(198),
    [anon_sym_float32] = ACTIONS(198),
    [anon_sym_float64] = ACTIONS(198),
    [anon_sym_decimal] = ACTIONS(198),
    [anon_sym_decimal128] = ACTIONS(198),
    [anon_sym_plainDate] = ACTIONS(198),
    [anon_sym_plainTime] = ACTIONS(198),
    [anon_sym_utcDateTime] = ACTIONS(198),
    [anon_sym_offsetDateTime] = ACTIONS(198),
    [anon_sym_duration] = ACTIONS(198),
    [anon_sym_bytes] = ACTIONS(198),
    [anon_sym_string] = ACTIONS(198),
    [anon_sym_boolean] = ACTIONS(198),
    [anon_sym_null] = ACTIONS(198),
    [anon_sym_Array] = ACTIONS(198),
    [anon_sym_Record] = ACTIONS(198),
    [anon_sym_unknown] = ACTIONS(198),
    [anon_sym_void] = ACTIONS(198),
    [anon_sym_never] = ACTIONS(198),
    [sym_plain_identifier] = ACTIONS(200),
    [anon_sym_BQUOTE] = ACTIONS(202),
    [anon_sym_true] = ACTIONS(204),
    [anon_sym_false] = ACTIONS(204),
    [sym_decimal_literal] = ACTIONS(206),
    [sym_hex_integer_literal] = ACTIONS(208),
    [sym_binary_integer_literal] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(212),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [66] = {
    [sym__expression] = STATE(174),
    [sym_union_expression] = STATE(174),
    [sym_intersection_expression] = STATE(174),
    [sym_value_of_expression] = STATE(174),
    [sym_array_expression] = STATE(174),
    [sym__primary_expression] = STATE(158),
    [sym_tuple_expression] = STATE(158),
    [sym_model_expression] = STATE(158),
    [sym_reference_expression] = STATE(158),
    [sym_parenthesized_expression] = STATE(158),
    [sym_identifier_or_member_expression] = STATE(146),
    [sym_identifier] = STATE(134),
    [sym_builtin_type] = STATE(127),
    [sym_backticked_identifier] = STATE(127),
    [sym_member_expression] = STATE(147),
    [sym__literal] = STATE(158),
    [sym_boolean_literal] = STATE(158),
    [sym__numeric_literal] = STATE(158),
    [sym__string_literal] = STATE(158),
    [sym_quoted_string_literal] = STATE(158),
    [sym_triple_quoted_string_literal] = STATE(158),
    [anon_sym_LPAREN] = ACTIONS(186),
    [anon_sym_LBRACE] = ACTIONS(188),
    [anon_sym_PIPE] = ACTIONS(190),
    [anon_sym_AMP] = ACTIONS(192),
    [anon_sym_valueof] = ACTIONS(194),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_numeric] = ACTIONS(198),
    [anon_sym_integer] = ACTIONS(198),
    [anon_sym_float] = ACTIONS(198),
    [anon_sym_int64] = ACTIONS(198),
    [anon_sym_int32] = ACTIONS(198),
    [anon_sym_int16] = ACTIONS(198),
    [anon_sym_int] = ACTIONS(198),
    [anon_sym_safeint] = ACTIONS(198),
    [anon_sym_uint6] = ACTIONS(198),
    [anon_sym_uint32] = ACTIONS(198),
    [anon_sym_uint16] = ACTIONS(198),
    [anon_sym_uint8] = ACTIONS(198),
    [anon_sym_float32] = ACTIONS(198),
    [anon_sym_float64] = ACTIONS(198),
    [anon_sym_decimal] = ACTIONS(198),
    [anon_sym_decimal128] = ACTIONS(198),
    [anon_sym_plainDate] = ACTIONS(198),
    [anon_sym_plainTime] = ACTIONS(198),
    [anon_sym_utcDateTime] = ACTIONS(198),
    [anon_sym_offsetDateTime] = ACTIONS(198),
    [anon_sym_duration] = ACTIONS(198),
    [anon_sym_bytes] = ACTIONS(198),
    [anon_sym_string] = ACTIONS(198),
    [anon_sym_boolean] = ACTIONS(198),
    [anon_sym_null] = ACTIONS(198),
    [anon_sym_Array] = ACTIONS(198),
    [anon_sym_Record] = ACTIONS(198),
    [anon_sym_unknown] = ACTIONS(198),
    [anon_sym_void] = ACTIONS(198),
    [anon_sym_never] = ACTIONS(198),
    [sym_plain_identifier] = ACTIONS(200),
    [anon_sym_BQUOTE] = ACTIONS(202),
    [anon_sym_true] = ACTIONS(204),
    [anon_sym_false] = ACTIONS(204),
    [sym_decimal_literal] = ACTIONS(206),
    [sym_hex_integer_literal] = ACTIONS(208),
    [sym_binary_integer_literal] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(212),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [67] = {
    [sym__expression] = STATE(557),
    [sym_union_expression] = STATE(557),
    [sym_intersection_expression] = STATE(557),
    [sym_value_of_expression] = STATE(557),
    [sym_array_expression] = STATE(557),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [68] = {
    [sym__expression] = STATE(171),
    [sym_union_expression] = STATE(171),
    [sym_intersection_expression] = STATE(171),
    [sym_value_of_expression] = STATE(171),
    [sym_array_expression] = STATE(171),
    [sym__primary_expression] = STATE(158),
    [sym_tuple_expression] = STATE(158),
    [sym_model_expression] = STATE(158),
    [sym_reference_expression] = STATE(158),
    [sym_parenthesized_expression] = STATE(158),
    [sym_identifier_or_member_expression] = STATE(146),
    [sym_identifier] = STATE(134),
    [sym_builtin_type] = STATE(127),
    [sym_backticked_identifier] = STATE(127),
    [sym_member_expression] = STATE(147),
    [sym__literal] = STATE(158),
    [sym_boolean_literal] = STATE(158),
    [sym__numeric_literal] = STATE(158),
    [sym__string_literal] = STATE(158),
    [sym_quoted_string_literal] = STATE(158),
    [sym_triple_quoted_string_literal] = STATE(158),
    [anon_sym_LPAREN] = ACTIONS(186),
    [anon_sym_LBRACE] = ACTIONS(188),
    [anon_sym_PIPE] = ACTIONS(190),
    [anon_sym_AMP] = ACTIONS(192),
    [anon_sym_valueof] = ACTIONS(194),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_numeric] = ACTIONS(198),
    [anon_sym_integer] = ACTIONS(198),
    [anon_sym_float] = ACTIONS(198),
    [anon_sym_int64] = ACTIONS(198),
    [anon_sym_int32] = ACTIONS(198),
    [anon_sym_int16] = ACTIONS(198),
    [anon_sym_int] = ACTIONS(198),
    [anon_sym_safeint] = ACTIONS(198),
    [anon_sym_uint6] = ACTIONS(198),
    [anon_sym_uint32] = ACTIONS(198),
    [anon_sym_uint16] = ACTIONS(198),
    [anon_sym_uint8] = ACTIONS(198),
    [anon_sym_float32] = ACTIONS(198),
    [anon_sym_float64] = ACTIONS(198),
    [anon_sym_decimal] = ACTIONS(198),
    [anon_sym_decimal128] = ACTIONS(198),
    [anon_sym_plainDate] = ACTIONS(198),
    [anon_sym_plainTime] = ACTIONS(198),
    [anon_sym_utcDateTime] = ACTIONS(198),
    [anon_sym_offsetDateTime] = ACTIONS(198),
    [anon_sym_duration] = ACTIONS(198),
    [anon_sym_bytes] = ACTIONS(198),
    [anon_sym_string] = ACTIONS(198),
    [anon_sym_boolean] = ACTIONS(198),
    [anon_sym_null] = ACTIONS(198),
    [anon_sym_Array] = ACTIONS(198),
    [anon_sym_Record] = ACTIONS(198),
    [anon_sym_unknown] = ACTIONS(198),
    [anon_sym_void] = ACTIONS(198),
    [anon_sym_never] = ACTIONS(198),
    [sym_plain_identifier] = ACTIONS(200),
    [anon_sym_BQUOTE] = ACTIONS(202),
    [anon_sym_true] = ACTIONS(204),
    [anon_sym_false] = ACTIONS(204),
    [sym_decimal_literal] = ACTIONS(206),
    [sym_hex_integer_literal] = ACTIONS(208),
    [sym_binary_integer_literal] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(212),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [69] = {
    [sym__expression] = STATE(530),
    [sym_union_expression] = STATE(530),
    [sym_intersection_expression] = STATE(530),
    [sym_value_of_expression] = STATE(530),
    [sym_array_expression] = STATE(530),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [70] = {
    [sym__expression] = STATE(563),
    [sym_union_expression] = STATE(563),
    [sym_intersection_expression] = STATE(563),
    [sym_value_of_expression] = STATE(563),
    [sym_array_expression] = STATE(563),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [71] = {
    [sym__expression] = STATE(175),
    [sym_union_expression] = STATE(175),
    [sym_intersection_expression] = STATE(175),
    [sym_value_of_expression] = STATE(175),
    [sym_array_expression] = STATE(175),
    [sym__primary_expression] = STATE(158),
    [sym_tuple_expression] = STATE(158),
    [sym_model_expression] = STATE(158),
    [sym_reference_expression] = STATE(158),
    [sym_parenthesized_expression] = STATE(158),
    [sym_identifier_or_member_expression] = STATE(146),
    [sym_identifier] = STATE(134),
    [sym_builtin_type] = STATE(127),
    [sym_backticked_identifier] = STATE(127),
    [sym_member_expression] = STATE(147),
    [sym__literal] = STATE(158),
    [sym_boolean_literal] = STATE(158),
    [sym__numeric_literal] = STATE(158),
    [sym__string_literal] = STATE(158),
    [sym_quoted_string_literal] = STATE(158),
    [sym_triple_quoted_string_literal] = STATE(158),
    [anon_sym_LPAREN] = ACTIONS(186),
    [anon_sym_LBRACE] = ACTIONS(188),
    [anon_sym_PIPE] = ACTIONS(190),
    [anon_sym_AMP] = ACTIONS(192),
    [anon_sym_valueof] = ACTIONS(194),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_numeric] = ACTIONS(198),
    [anon_sym_integer] = ACTIONS(198),
    [anon_sym_float] = ACTIONS(198),
    [anon_sym_int64] = ACTIONS(198),
    [anon_sym_int32] = ACTIONS(198),
    [anon_sym_int16] = ACTIONS(198),
    [anon_sym_int] = ACTIONS(198),
    [anon_sym_safeint] = ACTIONS(198),
    [anon_sym_uint6] = ACTIONS(198),
    [anon_sym_uint32] = ACTIONS(198),
    [anon_sym_uint16] = ACTIONS(198),
    [anon_sym_uint8] = ACTIONS(198),
    [anon_sym_float32] = ACTIONS(198),
    [anon_sym_float64] = ACTIONS(198),
    [anon_sym_decimal] = ACTIONS(198),
    [anon_sym_decimal128] = ACTIONS(198),
    [anon_sym_plainDate] = ACTIONS(198),
    [anon_sym_plainTime] = ACTIONS(198),
    [anon_sym_utcDateTime] = ACTIONS(198),
    [anon_sym_offsetDateTime] = ACTIONS(198),
    [anon_sym_duration] = ACTIONS(198),
    [anon_sym_bytes] = ACTIONS(198),
    [anon_sym_string] = ACTIONS(198),
    [anon_sym_boolean] = ACTIONS(198),
    [anon_sym_null] = ACTIONS(198),
    [anon_sym_Array] = ACTIONS(198),
    [anon_sym_Record] = ACTIONS(198),
    [anon_sym_unknown] = ACTIONS(198),
    [anon_sym_void] = ACTIONS(198),
    [anon_sym_never] = ACTIONS(198),
    [sym_plain_identifier] = ACTIONS(200),
    [anon_sym_BQUOTE] = ACTIONS(202),
    [anon_sym_true] = ACTIONS(204),
    [anon_sym_false] = ACTIONS(204),
    [sym_decimal_literal] = ACTIONS(206),
    [sym_hex_integer_literal] = ACTIONS(208),
    [sym_binary_integer_literal] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(212),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [72] = {
    [sym__expression] = STATE(499),
    [sym_union_expression] = STATE(499),
    [sym_intersection_expression] = STATE(499),
    [sym_value_of_expression] = STATE(499),
    [sym_array_expression] = STATE(499),
    [sym__primary_expression] = STATE(91),
    [sym_tuple_expression] = STATE(91),
    [sym_model_expression] = STATE(91),
    [sym_reference_expression] = STATE(91),
    [sym_parenthesized_expression] = STATE(91),
    [sym_identifier_or_member_expression] = STATE(77),
    [sym_identifier] = STATE(312),
    [sym_builtin_type] = STATE(307),
    [sym_backticked_identifier] = STATE(307),
    [sym_member_expression] = STATE(315),
    [sym__literal] = STATE(91),
    [sym_boolean_literal] = STATE(91),
    [sym__numeric_literal] = STATE(91),
    [sym__string_literal] = STATE(91),
    [sym_quoted_string_literal] = STATE(91),
    [sym_triple_quoted_string_literal] = STATE(91),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_LBRACE] = ACTIONS(43),
    [anon_sym_PIPE] = ACTIONS(126),
    [anon_sym_AMP] = ACTIONS(128),
    [anon_sym_valueof] = ACTIONS(130),
    [anon_sym_LBRACK] = ACTIONS(53),
    [anon_sym_numeric] = ACTIONS(132),
    [anon_sym_integer] = ACTIONS(132),
    [anon_sym_float] = ACTIONS(132),
    [anon_sym_int64] = ACTIONS(132),
    [anon_sym_int32] = ACTIONS(132),
    [anon_sym_int16] = ACTIONS(132),
    [anon_sym_int] = ACTIONS(132),
    [anon_sym_safeint] = ACTIONS(132),
    [anon_sym_uint6] = ACTIONS(132),
    [anon_sym_uint32] = ACTIONS(132),
    [anon_sym_uint16] = ACTIONS(132),
    [anon_sym_uint8] = ACTIONS(132),
    [anon_sym_float32] = ACTIONS(132),
    [anon_sym_float64] = ACTIONS(132),
    [anon_sym_decimal] = ACTIONS(132),
    [anon_sym_decimal128] = ACTIONS(132),
    [anon_sym_plainDate] = ACTIONS(132),
    [anon_sym_plainTime] = ACTIONS(132),
    [anon_sym_utcDateTime] = ACTIONS(132),
    [anon_sym_offsetDateTime] = ACTIONS(132),
    [anon_sym_duration] = ACTIONS(132),
    [anon_sym_bytes] = ACTIONS(132),
    [anon_sym_string] = ACTIONS(132),
    [anon_sym_boolean] = ACTIONS(132),
    [anon_sym_null] = ACTIONS(132),
    [anon_sym_Array] = ACTIONS(132),
    [anon_sym_Record] = ACTIONS(132),
    [anon_sym_unknown] = ACTIONS(132),
    [anon_sym_void] = ACTIONS(132),
    [anon_sym_never] = ACTIONS(132),
    [sym_plain_identifier] = ACTIONS(134),
    [anon_sym_BQUOTE] = ACTIONS(136),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(61),
    [sym_decimal_literal] = ACTIONS(63),
    [sym_hex_integer_literal] = ACTIONS(65),
    [sym_binary_integer_literal] = ACTIONS(65),
    [anon_sym_DQUOTE] = ACTIONS(67),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(69),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
  [73] = {
    [sym__expression] = STATE(167),
    [sym_union_expression] = STATE(167),
    [sym_intersection_expression] = STATE(167),
    [sym_value_of_expression] = STATE(167),
    [sym_array_expression] = STATE(167),
    [sym__primary_expression] = STATE(158),
    [sym_tuple_expression] = STATE(158),
    [sym_model_expression] = STATE(158),
    [sym_reference_expression] = STATE(158),
    [sym_parenthesized_expression] = STATE(158),
    [sym_identifier_or_member_expression] = STATE(146),
    [sym_identifier] = STATE(134),
    [sym_builtin_type] = STATE(127),
    [sym_backticked_identifier] = STATE(127),
    [sym_member_expression] = STATE(147),
    [sym__literal] = STATE(158),
    [sym_boolean_literal] = STATE(158),
    [sym__numeric_literal] = STATE(158),
    [sym__string_literal] = STATE(158),
    [sym_quoted_string_literal] = STATE(158),
    [sym_triple_quoted_string_literal] = STATE(158),
    [anon_sym_LPAREN] = ACTIONS(186),
    [anon_sym_LBRACE] = ACTIONS(188),
    [anon_sym_PIPE] = ACTIONS(190),
    [anon_sym_AMP] = ACTIONS(192),
    [anon_sym_valueof] = ACTIONS(194),
    [anon_sym_LBRACK] = ACTIONS(196),
    [anon_sym_numeric] = ACTIONS(198),
    [anon_sym_integer] = ACTIONS(198),
    [anon_sym_float] = ACTIONS(198),
    [anon_sym_int64] = ACTIONS(198),
    [anon_sym_int32] = ACTIONS(198),
    [anon_sym_int16] = ACTIONS(198),
    [anon_sym_int] = ACTIONS(198),
    [anon_sym_safeint] = ACTIONS(198),
    [anon_sym_uint6] = ACTIONS(198),
    [anon_sym_uint32] = ACTIONS(198),
    [anon_sym_uint16] = ACTIONS(198),
    [anon_sym_uint8] = ACTIONS(198),
    [anon_sym_float32] = ACTIONS(198),
    [anon_sym_float64] = ACTIONS(198),
    [anon_sym_decimal] = ACTIONS(198),
    [anon_sym_decimal128] = ACTIONS(198),
    [anon_sym_plainDate] = ACTIONS(198),
    [anon_sym_plainTime] = ACTIONS(198),
    [anon_sym_utcDateTime] = ACTIONS(198),
    [anon_sym_offsetDateTime] = ACTIONS(198),
    [anon_sym_duration] = ACTIONS(198),
    [anon_sym_bytes] = ACTIONS(198),
    [anon_sym_string] = ACTIONS(198),
    [anon_sym_boolean] = ACTIONS(198),
    [anon_sym_null] = ACTIONS(198),
    [anon_sym_Array] = ACTIONS(198),
    [anon_sym_Record] = ACTIONS(198),
    [anon_sym_unknown] = ACTIONS(198),
    [anon_sym_void] = ACTIONS(198),
    [anon_sym_never] = ACTIONS(198),
    [sym_plain_identifier] = ACTIONS(200),
    [anon_sym_BQUOTE] = ACTIONS(202),
    [anon_sym_true] = ACTIONS(204),
    [anon_sym_false] = ACTIONS(204),
    [sym_decimal_literal] = ACTIONS(206),
    [sym_hex_integer_literal] = ACTIONS(208),
    [sym_binary_integer_literal] = ACTIONS(208),
    [anon_sym_DQUOTE] = ACTIONS(210),
    [anon_sym_DQUOTE_DQUOTE_DQUOTE] = ACTIONS(212),
    [sym_single_line_comment] = ACTIONS(3),
    [sym_multi_line_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(236), 19,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(238), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [64] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(240), 19,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(242), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [128] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(244), 19,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(246), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [192] = 5,
    ACTIONS(252), 1,
      anon_sym_LT,
    STATE(93), 1,
      sym_template_arguments,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(248), 17,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(250), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [260] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(254), 19,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(256), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [324] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(258), 17,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(260), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [386] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(262), 17,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(264), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [448] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(266), 17,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(268), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [510] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(270), 17,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(272), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [572] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(274), 17,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(276), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [634] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(278), 17,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(280), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [696] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(282), 17,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(284), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [758] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(286), 17,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(288), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [820] = 6,
    ACTIONS(294), 1,
      anon_sym_COLON,
    ACTIONS(296), 1,
      anon_sym_DOT,
    STATE(94), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(290), 14,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(292), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [888] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(298), 17,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(300), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [950] = 6,
    ACTIONS(296), 1,
      anon_sym_DOT,
    ACTIONS(302), 1,
      anon_sym_COLON,
    STATE(94), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(290), 14,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(292), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [1018] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(304), 17,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(306), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [1080] = 4,
    ACTIONS(312), 1,
      anon_sym_LBRACK,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(308), 16,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_RBRACK,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(310), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [1144] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(314), 17,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(316), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [1206] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(318), 17,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_EQ,
      anon_sym_GT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(320), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [1268] = 5,
    ACTIONS(296), 1,
      anon_sym_DOT,
    STATE(95), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(322), 14,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(324), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [1333] = 5,
    ACTIONS(330), 1,
      anon_sym_DOT,
    STATE(95), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(326), 14,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(328), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [1398] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(333), 16,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(335), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [1459] = 5,
    ACTIONS(296), 1,
      anon_sym_DOT,
    STATE(94), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(290), 14,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(292), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [1524] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(337), 16,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(339), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [1585] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(341), 16,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(343), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [1646] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(345), 16,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_LT,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(347), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [1707] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(349), 15,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BQUOTE,
      anon_sym_DOT,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(351), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [1767] = 16,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    ACTIONS(353), 1,
      anon_sym_AT,
    ACTIONS(355), 1,
      anon_sym_RBRACE,
    ACTIONS(357), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(178), 1,
      sym_decorator_list,
    STATE(196), 1,
      sym_model_spread_property,
    STATE(633), 1,
      sym_model_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(118), 2,
      sym_model_property,
      aux_sym_model_body_repeat1,
    STATE(228), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(610), 4,
      sym_identifier,
      sym__string_literal,
      sym_quoted_string_literal,
      sym_triple_quoted_string_literal,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [1852] = 16,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    ACTIONS(353), 1,
      anon_sym_AT,
    ACTIONS(357), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(359), 1,
      anon_sym_RBRACE,
    STATE(178), 1,
      sym_decorator_list,
    STATE(196), 1,
      sym_model_spread_property,
    STATE(647), 1,
      sym_model_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(118), 2,
      sym_model_property,
      aux_sym_model_body_repeat1,
    STATE(228), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(610), 4,
      sym_identifier,
      sym__string_literal,
      sym_quoted_string_literal,
      sym_triple_quoted_string_literal,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [1937] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(290), 14,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_LT,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(292), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [1996] = 4,
    ACTIONS(365), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(361), 13,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(363), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [2057] = 16,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    ACTIONS(353), 1,
      anon_sym_AT,
    ACTIONS(357), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(367), 1,
      anon_sym_RBRACE,
    STATE(178), 1,
      sym_decorator_list,
    STATE(196), 1,
      sym_model_spread_property,
    STATE(649), 1,
      sym_model_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(118), 2,
      sym_model_property,
      aux_sym_model_body_repeat1,
    STATE(228), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(610), 4,
      sym_identifier,
      sym__string_literal,
      sym_quoted_string_literal,
      sym_triple_quoted_string_literal,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [2142] = 15,
    ACTIONS(369), 1,
      anon_sym_AT,
    ACTIONS(374), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(380), 1,
      sym_plain_identifier,
    ACTIONS(383), 1,
      anon_sym_BQUOTE,
    ACTIONS(386), 1,
      anon_sym_DQUOTE,
    ACTIONS(389), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(178), 1,
      sym_decorator_list,
    STATE(196), 1,
      sym_model_spread_property,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(372), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    STATE(107), 2,
      sym_model_property,
      aux_sym_model_body_repeat1,
    STATE(228), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(610), 4,
      sym_identifier,
      sym__string_literal,
      sym_quoted_string_literal,
      sym_triple_quoted_string_literal,
    ACTIONS(377), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [2225] = 16,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    ACTIONS(353), 1,
      anon_sym_AT,
    ACTIONS(357), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(392), 1,
      anon_sym_RBRACE,
    STATE(178), 1,
      sym_decorator_list,
    STATE(196), 1,
      sym_model_spread_property,
    STATE(645), 1,
      sym_model_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(118), 2,
      sym_model_property,
      aux_sym_model_body_repeat1,
    STATE(228), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(610), 4,
      sym_identifier,
      sym__string_literal,
      sym_quoted_string_literal,
      sym_triple_quoted_string_literal,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [2310] = 4,
    ACTIONS(394), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(361), 13,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(363), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [2371] = 14,
    ACTIONS(200), 1,
      sym_plain_identifier,
    ACTIONS(202), 1,
      anon_sym_BQUOTE,
    ACTIONS(210), 1,
      anon_sym_DQUOTE,
    ACTIONS(212), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(353), 1,
      anon_sym_AT,
    ACTIONS(396), 1,
      anon_sym_RBRACE,
    ACTIONS(398), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(179), 1,
      sym_decorator_list,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(127), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(228), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(114), 3,
      sym_enum_spread_member,
      sym_enum_member,
      aux_sym_enum_body_repeat1,
    STATE(176), 4,
      sym_identifier,
      sym__string_literal,
      sym_quoted_string_literal,
      sym_triple_quoted_string_literal,
    ACTIONS(198), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [2451] = 6,
    ACTIONS(404), 1,
      anon_sym_PIPE,
    ACTIONS(406), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(400), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(402), 9,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(408), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [2515] = 6,
    ACTIONS(404), 1,
      anon_sym_PIPE,
    ACTIONS(406), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(410), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(412), 9,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(414), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [2579] = 14,
    ACTIONS(416), 1,
      anon_sym_AT,
    ACTIONS(419), 1,
      anon_sym_RBRACE,
    ACTIONS(421), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(427), 1,
      sym_plain_identifier,
    ACTIONS(430), 1,
      anon_sym_BQUOTE,
    ACTIONS(433), 1,
      anon_sym_DQUOTE,
    ACTIONS(436), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(179), 1,
      sym_decorator_list,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(127), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(228), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(113), 3,
      sym_enum_spread_member,
      sym_enum_member,
      aux_sym_enum_body_repeat1,
    STATE(176), 4,
      sym_identifier,
      sym__string_literal,
      sym_quoted_string_literal,
      sym_triple_quoted_string_literal,
    ACTIONS(424), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [2659] = 14,
    ACTIONS(200), 1,
      sym_plain_identifier,
    ACTIONS(202), 1,
      anon_sym_BQUOTE,
    ACTIONS(210), 1,
      anon_sym_DQUOTE,
    ACTIONS(212), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(353), 1,
      anon_sym_AT,
    ACTIONS(398), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(439), 1,
      anon_sym_RBRACE,
    STATE(179), 1,
      sym_decorator_list,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(127), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(228), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(113), 3,
      sym_enum_spread_member,
      sym_enum_member,
      aux_sym_enum_body_repeat1,
    STATE(176), 4,
      sym_identifier,
      sym__string_literal,
      sym_quoted_string_literal,
      sym_triple_quoted_string_literal,
    ACTIONS(198), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [2739] = 6,
    ACTIONS(404), 1,
      anon_sym_PIPE,
    ACTIONS(406), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(441), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(443), 9,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(445), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [2803] = 4,
    ACTIONS(406), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(447), 12,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(449), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [2863] = 6,
    ACTIONS(404), 1,
      anon_sym_PIPE,
    ACTIONS(406), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(451), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(453), 9,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(455), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [2927] = 15,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    ACTIONS(353), 1,
      anon_sym_AT,
    ACTIONS(357), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(457), 1,
      anon_sym_RBRACE,
    STATE(178), 1,
      sym_decorator_list,
    STATE(196), 1,
      sym_model_spread_property,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(107), 2,
      sym_model_property,
      aux_sym_model_body_repeat1,
    STATE(228), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(610), 4,
      sym_identifier,
      sym__string_literal,
      sym_quoted_string_literal,
      sym_triple_quoted_string_literal,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [3009] = 14,
    ACTIONS(200), 1,
      sym_plain_identifier,
    ACTIONS(202), 1,
      anon_sym_BQUOTE,
    ACTIONS(210), 1,
      anon_sym_DQUOTE,
    ACTIONS(212), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(353), 1,
      anon_sym_AT,
    ACTIONS(398), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(459), 1,
      anon_sym_RBRACE,
    STATE(179), 1,
      sym_decorator_list,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(127), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(228), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(123), 3,
      sym_enum_spread_member,
      sym_enum_member,
      aux_sym_enum_body_repeat1,
    STATE(176), 4,
      sym_identifier,
      sym__string_literal,
      sym_quoted_string_literal,
      sym_triple_quoted_string_literal,
    ACTIONS(198), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [3089] = 6,
    ACTIONS(404), 1,
      anon_sym_PIPE,
    ACTIONS(406), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(461), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(463), 9,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(465), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [3153] = 4,
    ACTIONS(406), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(467), 12,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(469), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [3213] = 15,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    ACTIONS(353), 1,
      anon_sym_AT,
    ACTIONS(357), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(471), 1,
      anon_sym_RPAREN,
    STATE(178), 1,
      sym_decorator_list,
    STATE(196), 1,
      sym_model_spread_property,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(107), 2,
      sym_model_property,
      aux_sym_model_body_repeat1,
    STATE(228), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(610), 4,
      sym_identifier,
      sym__string_literal,
      sym_quoted_string_literal,
      sym_triple_quoted_string_literal,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [3295] = 14,
    ACTIONS(200), 1,
      sym_plain_identifier,
    ACTIONS(202), 1,
      anon_sym_BQUOTE,
    ACTIONS(210), 1,
      anon_sym_DQUOTE,
    ACTIONS(212), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(353), 1,
      anon_sym_AT,
    ACTIONS(398), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(473), 1,
      anon_sym_RBRACE,
    STATE(179), 1,
      sym_decorator_list,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(127), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(228), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(113), 3,
      sym_enum_spread_member,
      sym_enum_member,
      aux_sym_enum_body_repeat1,
    STATE(176), 4,
      sym_identifier,
      sym__string_literal,
      sym_quoted_string_literal,
      sym_triple_quoted_string_literal,
    ACTIONS(198), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [3375] = 15,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    ACTIONS(353), 1,
      anon_sym_AT,
    ACTIONS(357), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(475), 1,
      anon_sym_RPAREN,
    STATE(178), 1,
      sym_decorator_list,
    STATE(196), 1,
      sym_model_spread_property,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(122), 2,
      sym_model_property,
      aux_sym_model_body_repeat1,
    STATE(228), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(610), 4,
      sym_identifier,
      sym__string_literal,
      sym_quoted_string_literal,
      sym_triple_quoted_string_literal,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [3457] = 6,
    ACTIONS(404), 1,
      anon_sym_PIPE,
    ACTIONS(406), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(477), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(479), 9,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(481), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [3521] = 5,
    ACTIONS(39), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(130), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    ACTIONS(483), 9,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(485), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [3582] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(333), 15,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(335), 33,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DOT,
      anon_sym_DQUOTE,
  [3639] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(337), 15,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(339), 33,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DOT,
      anon_sym_DQUOTE,
  [3696] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(345), 15,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(347), 33,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DOT,
      anon_sym_DQUOTE,
  [3753] = 5,
    ACTIONS(487), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(130), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    ACTIONS(490), 9,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(492), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [3814] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(341), 15,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(343), 33,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DOT,
      anon_sym_DQUOTE,
  [3871] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(494), 11,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(496), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [3927] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(443), 11,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(445), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [3983] = 5,
    ACTIONS(498), 1,
      anon_sym_DOT,
    STATE(136), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(290), 13,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(292), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [4043] = 5,
    ACTIONS(502), 1,
      anon_sym_LPAREN,
    STATE(144), 1,
      sym_decorator_arguments,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(500), 9,
      anon_sym_AT,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(504), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [4103] = 5,
    ACTIONS(498), 1,
      anon_sym_DOT,
    STATE(141), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(322), 13,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(324), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [4163] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(453), 11,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(455), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [4219] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(479), 11,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(481), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [4275] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(506), 11,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(508), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [4331] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(510), 11,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(512), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [4387] = 5,
    ACTIONS(514), 1,
      anon_sym_DOT,
    STATE(141), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(326), 13,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(328), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [4447] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(517), 10,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(519), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [4502] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(349), 13,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(351), 33,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DOT,
      anon_sym_DQUOTE,
  [4557] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(521), 10,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(523), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [4612] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(525), 10,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_BQUOTE,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(527), 36,
      anon_sym_valueof,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_decimal_literal,
      anon_sym_DQUOTE,
  [4667] = 5,
    ACTIONS(529), 1,
      anon_sym_LT,
    STATE(164), 1,
      sym_template_arguments,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(248), 11,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(250), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [4725] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(290), 13,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_LT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(292), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [4779] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(254), 12,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(256), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [4832] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(244), 12,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(246), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [4885] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(236), 12,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(238), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [4938] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(240), 12,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(242), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [4991] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(304), 11,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(306), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [5043] = 12,
    ACTIONS(531), 1,
      anon_sym_AT,
    ACTIONS(534), 1,
      anon_sym_RBRACE,
    ACTIONS(536), 1,
      anon_sym_op,
    ACTIONS(542), 1,
      sym_plain_identifier,
    ACTIONS(545), 1,
      anon_sym_BQUOTE,
    STATE(243), 1,
      sym_decorator_list,
    STATE(491), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(153), 2,
      sym_interface_member,
      aux_sym_interface_body_repeat1,
    STATE(237), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(539), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [5113] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(298), 11,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(300), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [5165] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(270), 11,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(272), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [5217] = 12,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    ACTIONS(548), 1,
      anon_sym_AT,
    ACTIONS(550), 1,
      anon_sym_RBRACE,
    ACTIONS(552), 1,
      anon_sym_op,
    STATE(243), 1,
      sym_decorator_list,
    STATE(491), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(161), 2,
      sym_interface_member,
      aux_sym_interface_body_repeat1,
    STATE(237), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [5287] = 12,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    ACTIONS(548), 1,
      anon_sym_AT,
    ACTIONS(552), 1,
      anon_sym_op,
    ACTIONS(554), 1,
      anon_sym_RBRACE,
    STATE(243), 1,
      sym_decorator_list,
    STATE(491), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(159), 2,
      sym_interface_member,
      aux_sym_interface_body_repeat1,
    STATE(237), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [5357] = 4,
    ACTIONS(556), 1,
      anon_sym_LBRACK,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(308), 10,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(310), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [5411] = 12,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    ACTIONS(548), 1,
      anon_sym_AT,
    ACTIONS(552), 1,
      anon_sym_op,
    ACTIONS(558), 1,
      anon_sym_RBRACE,
    STATE(243), 1,
      sym_decorator_list,
    STATE(491), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(153), 2,
      sym_interface_member,
      aux_sym_interface_body_repeat1,
    STATE(237), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [5481] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(278), 11,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(280), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [5533] = 12,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    ACTIONS(548), 1,
      anon_sym_AT,
    ACTIONS(552), 1,
      anon_sym_op,
    ACTIONS(560), 1,
      anon_sym_RBRACE,
    STATE(243), 1,
      sym_decorator_list,
    STATE(491), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(153), 2,
      sym_interface_member,
      aux_sym_interface_body_repeat1,
    STATE(237), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [5603] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(314), 11,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(316), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [5655] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(286), 11,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(288), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [5707] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(318), 11,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(320), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [5759] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(258), 11,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(260), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [5811] = 6,
    ACTIONS(566), 1,
      anon_sym_PIPE,
    ACTIONS(568), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(562), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(564), 6,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(570), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [5868] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(266), 10,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(268), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [5919] = 4,
    ACTIONS(568), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(467), 9,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(469), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [5972] = 6,
    ACTIONS(566), 1,
      anon_sym_PIPE,
    ACTIONS(568), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(572), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(574), 6,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(576), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [6029] = 6,
    ACTIONS(566), 1,
      anon_sym_PIPE,
    ACTIONS(568), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(578), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(580), 6,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(582), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [6086] = 4,
    ACTIONS(568), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(447), 9,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(449), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [6139] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(282), 10,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(284), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [6190] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(274), 10,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(276), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [6241] = 6,
    ACTIONS(566), 1,
      anon_sym_PIPE,
    ACTIONS(568), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(584), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(586), 6,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(588), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [6298] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(262), 10,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(264), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [6349] = 6,
    ACTIONS(594), 1,
      anon_sym_COLON,
    STATE(186), 1,
      sym_enum_member_value,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(590), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(592), 5,
      anon_sym_AT,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(596), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [6405] = 6,
    ACTIONS(594), 1,
      anon_sym_COLON,
    STATE(185), 1,
      sym_enum_member_value,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(598), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(600), 5,
      anon_sym_AT,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(602), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [6461] = 8,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(595), 4,
      sym_identifier,
      sym__string_literal,
      sym_quoted_string_literal,
      sym_triple_quoted_string_literal,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [6520] = 8,
    ACTIONS(200), 1,
      sym_plain_identifier,
    ACTIONS(202), 1,
      anon_sym_BQUOTE,
    ACTIONS(210), 1,
      anon_sym_DQUOTE,
    ACTIONS(212), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(127), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(177), 4,
      sym_identifier,
      sym__string_literal,
      sym_quoted_string_literal,
      sym_triple_quoted_string_literal,
    ACTIONS(198), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [6579] = 9,
    ACTIONS(200), 1,
      sym_plain_identifier,
    ACTIONS(202), 1,
      anon_sym_BQUOTE,
    ACTIONS(604), 1,
      anon_sym_RPAREN,
    ACTIONS(606), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(199), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(127), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(192), 2,
      sym_function_parameter,
      aux_sym_function_parameter_list_repeat1,
    ACTIONS(198), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [6639] = 9,
    ACTIONS(200), 1,
      sym_plain_identifier,
    ACTIONS(202), 1,
      anon_sym_BQUOTE,
    ACTIONS(606), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(608), 1,
      anon_sym_RPAREN,
    STATE(199), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(127), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(189), 2,
      sym_function_parameter,
      aux_sym_function_parameter_list_repeat1,
    ACTIONS(198), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [6699] = 10,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    ACTIONS(610), 1,
      anon_sym_LBRACE,
    STATE(77), 1,
      sym_identifier_or_member_expression,
    STATE(312), 1,
      sym_identifier,
    STATE(315), 1,
      sym_member_expression,
    STATE(597), 1,
      sym_reference_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [6761] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(612), 7,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(614), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [6809] = 22,
    ACTIONS(9), 1,
      anon_sym_AT,
    ACTIONS(11), 1,
      anon_sym_import,
    ACTIONS(13), 1,
      anon_sym_using,
    ACTIONS(15), 1,
      anon_sym_namespace,
    ACTIONS(17), 1,
      anon_sym_model,
    ACTIONS(19), 1,
      anon_sym_union,
    ACTIONS(21), 1,
      anon_sym_scalar,
    ACTIONS(23), 1,
      anon_sym_interface,
    ACTIONS(25), 1,
      anon_sym_op,
    ACTIONS(27), 1,
      anon_sym_enum,
    ACTIONS(29), 1,
      anon_sym_alias,
    ACTIONS(31), 1,
      anon_sym_AT_AT,
    ACTIONS(33), 1,
      anon_sym_dec,
    ACTIONS(35), 1,
      anon_sym_extern,
    ACTIONS(37), 1,
      anon_sym_fn,
    ACTIONS(616), 1,
      ts_builtin_sym_end,
    STATE(490), 1,
      sym_decorator_list,
    STATE(630), 1,
      sym_function_modifiers,
    STATE(631), 1,
      sym_decorator_modifiers,
    STATE(474), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    ACTIONS(618), 3,
      anon_sym_SEMI,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(187), 17,
      sym__item,
      sym__statement,
      sym_import_statement,
      sym_using_statement,
      sym_namespace_statement,
      sym_model_statement,
      sym_union_statement,
      sym_scalar_statement,
      sym_interface_statement,
      sym_enum_statement,
      sym_alias_statement,
      sym_augment_decorator_statement,
      sym_operation_statement,
      sym_decorator_declaration_statement,
      sym_function_declaration_statement,
      sym__comment,
      aux_sym_source_file_repeat1,
  [6895] = 4,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(620), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(622), 5,
      anon_sym_AT,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(624), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [6945] = 4,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(626), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(628), 5,
      anon_sym_AT,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(630), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [6995] = 22,
    ACTIONS(632), 1,
      ts_builtin_sym_end,
    ACTIONS(637), 1,
      anon_sym_AT,
    ACTIONS(640), 1,
      anon_sym_import,
    ACTIONS(643), 1,
      anon_sym_using,
    ACTIONS(646), 1,
      anon_sym_namespace,
    ACTIONS(649), 1,
      anon_sym_model,
    ACTIONS(652), 1,
      anon_sym_union,
    ACTIONS(655), 1,
      anon_sym_scalar,
    ACTIONS(658), 1,
      anon_sym_interface,
    ACTIONS(661), 1,
      anon_sym_op,
    ACTIONS(664), 1,
      anon_sym_enum,
    ACTIONS(667), 1,
      anon_sym_alias,
    ACTIONS(670), 1,
      anon_sym_AT_AT,
    ACTIONS(673), 1,
      anon_sym_dec,
    ACTIONS(676), 1,
      anon_sym_extern,
    ACTIONS(679), 1,
      anon_sym_fn,
    STATE(490), 1,
      sym_decorator_list,
    STATE(630), 1,
      sym_function_modifiers,
    STATE(631), 1,
      sym_decorator_modifiers,
    STATE(474), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    ACTIONS(634), 3,
      anon_sym_SEMI,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(187), 17,
      sym__item,
      sym__statement,
      sym_import_statement,
      sym_using_statement,
      sym_namespace_statement,
      sym_model_statement,
      sym_union_statement,
      sym_scalar_statement,
      sym_interface_statement,
      sym_enum_statement,
      sym_alias_statement,
      sym_augment_decorator_statement,
      sym_operation_statement,
      sym_decorator_declaration_statement,
      sym_function_declaration_statement,
      sym__comment,
      aux_sym_source_file_repeat1,
  [7081] = 9,
    ACTIONS(200), 1,
      sym_plain_identifier,
    ACTIONS(202), 1,
      anon_sym_BQUOTE,
    ACTIONS(606), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(682), 1,
      anon_sym_RPAREN,
    STATE(199), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(127), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(180), 2,
      sym_function_parameter,
      aux_sym_function_parameter_list_repeat1,
    ACTIONS(198), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [7141] = 9,
    ACTIONS(200), 1,
      sym_plain_identifier,
    ACTIONS(202), 1,
      anon_sym_BQUOTE,
    ACTIONS(606), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(684), 1,
      anon_sym_RPAREN,
    STATE(199), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(127), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(192), 2,
      sym_function_parameter,
      aux_sym_function_parameter_list_repeat1,
    ACTIONS(198), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [7201] = 10,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(77), 1,
      sym_identifier_or_member_expression,
    STATE(312), 1,
      sym_identifier,
    STATE(315), 1,
      sym_member_expression,
    STATE(569), 1,
      sym_reference_expression,
    STATE(622), 1,
      sym_reference_expression_list,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [7263] = 10,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    ACTIONS(686), 1,
      anon_sym_LBRACE,
    STATE(77), 1,
      sym_identifier_or_member_expression,
    STATE(312), 1,
      sym_identifier,
    STATE(315), 1,
      sym_member_expression,
    STATE(597), 1,
      sym_reference_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [7325] = 9,
    ACTIONS(688), 1,
      anon_sym_RPAREN,
    ACTIONS(690), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(696), 1,
      sym_plain_identifier,
    ACTIONS(699), 1,
      anon_sym_BQUOTE,
    STATE(199), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(127), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    STATE(192), 2,
      sym_function_parameter,
      aux_sym_function_parameter_list_repeat1,
    ACTIONS(693), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [7385] = 7,
    ACTIONS(704), 1,
      anon_sym_COMMA,
    ACTIONS(706), 1,
      anon_sym_QMARK,
    ACTIONS(708), 1,
      anon_sym_COLON,
    STATE(270), 1,
      sym_type_annotation,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(702), 3,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
    ACTIONS(710), 31,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [7440] = 9,
    ACTIONS(200), 1,
      sym_plain_identifier,
    ACTIONS(202), 1,
      anon_sym_BQUOTE,
    STATE(134), 1,
      sym_identifier,
    STATE(146), 1,
      sym_identifier_or_member_expression,
    STATE(147), 1,
      sym_member_expression,
    STATE(200), 1,
      sym_reference_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(127), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(198), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [7499] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(580), 6,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(582), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [7546] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(712), 6,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(714), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [7593] = 9,
    ACTIONS(200), 1,
      sym_plain_identifier,
    ACTIONS(202), 1,
      anon_sym_BQUOTE,
    STATE(134), 1,
      sym_identifier,
    STATE(146), 1,
      sym_identifier_or_member_expression,
    STATE(147), 1,
      sym_member_expression,
    STATE(221), 1,
      sym_reference_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(127), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(198), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [7652] = 9,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(77), 1,
      sym_identifier_or_member_expression,
    STATE(312), 1,
      sym_identifier,
    STATE(315), 1,
      sym_member_expression,
    STATE(651), 1,
      sym_reference_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [7711] = 7,
    ACTIONS(708), 1,
      anon_sym_COLON,
    ACTIONS(718), 1,
      anon_sym_COMMA,
    ACTIONS(720), 1,
      anon_sym_QMARK,
    STATE(260), 1,
      sym_type_annotation,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(716), 3,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
    ACTIONS(722), 31,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [7766] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(724), 6,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(726), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [7813] = 9,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(77), 1,
      sym_identifier_or_member_expression,
    STATE(312), 1,
      sym_identifier,
    STATE(315), 1,
      sym_member_expression,
    STATE(597), 1,
      sym_reference_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [7872] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(728), 6,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(730), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [7919] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(586), 6,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(588), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [7966] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(732), 6,
      anon_sym_AT,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(734), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [8013] = 6,
    ACTIONS(708), 1,
      anon_sym_COLON,
    ACTIONS(738), 1,
      anon_sym_COMMA,
    STATE(296), 1,
      sym_type_annotation,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(736), 3,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
    ACTIONS(740), 31,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [8065] = 8,
    ACTIONS(172), 1,
      sym_plain_identifier,
    ACTIONS(174), 1,
      anon_sym_BQUOTE,
    STATE(318), 1,
      sym_identifier,
    STATE(324), 1,
      sym_member_expression,
    STATE(355), 1,
      sym_identifier_or_member_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(320), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(170), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [8121] = 8,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(312), 1,
      sym_identifier,
    STATE(315), 1,
      sym_member_expression,
    STATE(475), 1,
      sym_identifier_or_member_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [8177] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(622), 5,
      anon_sym_AT,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(624), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [8223] = 8,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(312), 1,
      sym_identifier,
    STATE(315), 1,
      sym_member_expression,
    STATE(676), 1,
      sym_identifier_or_member_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [8279] = 5,
    ACTIONS(742), 1,
      anon_sym_DOT,
    STATE(212), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(290), 3,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_BQUOTE,
    ACTIONS(292), 32,
      anon_sym_op,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [8329] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(628), 5,
      anon_sym_AT,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(630), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [8375] = 5,
    ACTIONS(742), 1,
      anon_sym_DOT,
    STATE(218), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(322), 3,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_BQUOTE,
    ACTIONS(324), 32,
      anon_sym_op,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [8425] = 23,
    ACTIONS(744), 1,
      anon_sym_SEMI,
    ACTIONS(747), 1,
      anon_sym_AT,
    ACTIONS(750), 1,
      anon_sym_import,
    ACTIONS(753), 1,
      anon_sym_using,
    ACTIONS(756), 1,
      anon_sym_namespace,
    ACTIONS(759), 1,
      anon_sym_RBRACE,
    ACTIONS(761), 1,
      anon_sym_model,
    ACTIONS(764), 1,
      anon_sym_union,
    ACTIONS(767), 1,
      anon_sym_scalar,
    ACTIONS(770), 1,
      anon_sym_interface,
    ACTIONS(773), 1,
      anon_sym_op,
    ACTIONS(776), 1,
      anon_sym_enum,
    ACTIONS(779), 1,
      anon_sym_alias,
    ACTIONS(782), 1,
      anon_sym_AT_AT,
    ACTIONS(785), 1,
      anon_sym_dec,
    ACTIONS(788), 1,
      anon_sym_extern,
    ACTIONS(791), 1,
      anon_sym_fn,
    STATE(496), 1,
      sym_decorator_list,
    STATE(673), 1,
      sym_decorator_modifiers,
    STATE(674), 1,
      sym_function_modifiers,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(474), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(213), 15,
      sym__statement,
      sym_import_statement,
      sym_using_statement,
      sym_namespace_statement,
      sym_model_statement,
      sym_union_statement,
      sym_scalar_statement,
      sym_interface_statement,
      sym_enum_statement,
      sym_alias_statement,
      sym_augment_decorator_statement,
      sym_operation_statement,
      sym_decorator_declaration_statement,
      sym_function_declaration_statement,
      aux_sym_namespace_body_repeat1,
  [8511] = 23,
    ACTIONS(9), 1,
      anon_sym_AT,
    ACTIONS(35), 1,
      anon_sym_extern,
    ACTIONS(794), 1,
      anon_sym_SEMI,
    ACTIONS(796), 1,
      anon_sym_import,
    ACTIONS(798), 1,
      anon_sym_using,
    ACTIONS(800), 1,
      anon_sym_namespace,
    ACTIONS(802), 1,
      anon_sym_RBRACE,
    ACTIONS(804), 1,
      anon_sym_model,
    ACTIONS(806), 1,
      anon_sym_union,
    ACTIONS(808), 1,
      anon_sym_scalar,
    ACTIONS(810), 1,
      anon_sym_interface,
    ACTIONS(812), 1,
      anon_sym_op,
    ACTIONS(814), 1,
      anon_sym_enum,
    ACTIONS(816), 1,
      anon_sym_alias,
    ACTIONS(818), 1,
      anon_sym_AT_AT,
    ACTIONS(820), 1,
      anon_sym_dec,
    ACTIONS(822), 1,
      anon_sym_fn,
    STATE(496), 1,
      sym_decorator_list,
    STATE(673), 1,
      sym_decorator_modifiers,
    STATE(674), 1,
      sym_function_modifiers,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(474), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(225), 15,
      sym__statement,
      sym_import_statement,
      sym_using_statement,
      sym_namespace_statement,
      sym_model_statement,
      sym_union_statement,
      sym_scalar_statement,
      sym_interface_statement,
      sym_enum_statement,
      sym_alias_statement,
      sym_augment_decorator_statement,
      sym_operation_statement,
      sym_decorator_declaration_statement,
      sym_function_declaration_statement,
      aux_sym_namespace_body_repeat1,
  [8597] = 5,
    ACTIONS(824), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(490), 2,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(215), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    ACTIONS(492), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [8647] = 5,
    ACTIONS(566), 1,
      anon_sym_PIPE,
    ACTIONS(568), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(827), 4,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
    ACTIONS(829), 31,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [8697] = 5,
    ACTIONS(831), 1,
      anon_sym_LPAREN,
    STATE(286), 1,
      sym_decorator_arguments,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(500), 3,
      anon_sym_AT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(504), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [8747] = 5,
    ACTIONS(833), 1,
      anon_sym_DOT,
    STATE(218), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(326), 3,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_BQUOTE,
    ACTIONS(328), 32,
      anon_sym_op,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [8797] = 8,
    ACTIONS(200), 1,
      sym_plain_identifier,
    ACTIONS(202), 1,
      anon_sym_BQUOTE,
    STATE(134), 1,
      sym_identifier,
    STATE(147), 1,
      sym_member_expression,
    STATE(217), 1,
      sym_identifier_or_member_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(127), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(198), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [8853] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(836), 5,
      anon_sym_AT,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(838), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [8899] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(840), 5,
      anon_sym_AT,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(842), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [8945] = 8,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(312), 1,
      sym_identifier,
    STATE(315), 1,
      sym_member_expression,
    STATE(357), 1,
      sym_identifier_or_member_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [9001] = 8,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(312), 1,
      sym_identifier,
    STATE(315), 1,
      sym_member_expression,
    STATE(551), 1,
      sym_identifier_or_member_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [9057] = 23,
    ACTIONS(9), 1,
      anon_sym_AT,
    ACTIONS(35), 1,
      anon_sym_extern,
    ACTIONS(796), 1,
      anon_sym_import,
    ACTIONS(798), 1,
      anon_sym_using,
    ACTIONS(800), 1,
      anon_sym_namespace,
    ACTIONS(804), 1,
      anon_sym_model,
    ACTIONS(806), 1,
      anon_sym_union,
    ACTIONS(808), 1,
      anon_sym_scalar,
    ACTIONS(810), 1,
      anon_sym_interface,
    ACTIONS(812), 1,
      anon_sym_op,
    ACTIONS(814), 1,
      anon_sym_enum,
    ACTIONS(816), 1,
      anon_sym_alias,
    ACTIONS(818), 1,
      anon_sym_AT_AT,
    ACTIONS(820), 1,
      anon_sym_dec,
    ACTIONS(822), 1,
      anon_sym_fn,
    ACTIONS(844), 1,
      anon_sym_SEMI,
    ACTIONS(846), 1,
      anon_sym_RBRACE,
    STATE(496), 1,
      sym_decorator_list,
    STATE(673), 1,
      sym_decorator_modifiers,
    STATE(674), 1,
      sym_function_modifiers,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(474), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(227), 15,
      sym__statement,
      sym_import_statement,
      sym_using_statement,
      sym_namespace_statement,
      sym_model_statement,
      sym_union_statement,
      sym_scalar_statement,
      sym_interface_statement,
      sym_enum_statement,
      sym_alias_statement,
      sym_augment_decorator_statement,
      sym_operation_statement,
      sym_decorator_declaration_statement,
      sym_function_declaration_statement,
      aux_sym_namespace_body_repeat1,
  [9143] = 23,
    ACTIONS(9), 1,
      anon_sym_AT,
    ACTIONS(35), 1,
      anon_sym_extern,
    ACTIONS(796), 1,
      anon_sym_import,
    ACTIONS(798), 1,
      anon_sym_using,
    ACTIONS(800), 1,
      anon_sym_namespace,
    ACTIONS(804), 1,
      anon_sym_model,
    ACTIONS(806), 1,
      anon_sym_union,
    ACTIONS(808), 1,
      anon_sym_scalar,
    ACTIONS(810), 1,
      anon_sym_interface,
    ACTIONS(812), 1,
      anon_sym_op,
    ACTIONS(814), 1,
      anon_sym_enum,
    ACTIONS(816), 1,
      anon_sym_alias,
    ACTIONS(818), 1,
      anon_sym_AT_AT,
    ACTIONS(820), 1,
      anon_sym_dec,
    ACTIONS(822), 1,
      anon_sym_fn,
    ACTIONS(848), 1,
      anon_sym_SEMI,
    ACTIONS(850), 1,
      anon_sym_RBRACE,
    STATE(496), 1,
      sym_decorator_list,
    STATE(673), 1,
      sym_decorator_modifiers,
    STATE(674), 1,
      sym_function_modifiers,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(474), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(213), 15,
      sym__statement,
      sym_import_statement,
      sym_using_statement,
      sym_namespace_statement,
      sym_model_statement,
      sym_union_statement,
      sym_scalar_statement,
      sym_interface_statement,
      sym_enum_statement,
      sym_alias_statement,
      sym_augment_decorator_statement,
      sym_operation_statement,
      sym_decorator_declaration_statement,
      sym_function_declaration_statement,
      aux_sym_namespace_body_repeat1,
  [9229] = 6,
    ACTIONS(708), 1,
      anon_sym_COLON,
    ACTIONS(854), 1,
      anon_sym_COMMA,
    STATE(268), 1,
      sym_type_annotation,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(852), 3,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
    ACTIONS(856), 31,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [9281] = 23,
    ACTIONS(9), 1,
      anon_sym_AT,
    ACTIONS(35), 1,
      anon_sym_extern,
    ACTIONS(796), 1,
      anon_sym_import,
    ACTIONS(798), 1,
      anon_sym_using,
    ACTIONS(800), 1,
      anon_sym_namespace,
    ACTIONS(804), 1,
      anon_sym_model,
    ACTIONS(806), 1,
      anon_sym_union,
    ACTIONS(808), 1,
      anon_sym_scalar,
    ACTIONS(810), 1,
      anon_sym_interface,
    ACTIONS(812), 1,
      anon_sym_op,
    ACTIONS(814), 1,
      anon_sym_enum,
    ACTIONS(816), 1,
      anon_sym_alias,
    ACTIONS(818), 1,
      anon_sym_AT_AT,
    ACTIONS(820), 1,
      anon_sym_dec,
    ACTIONS(822), 1,
      anon_sym_fn,
    ACTIONS(848), 1,
      anon_sym_SEMI,
    ACTIONS(858), 1,
      anon_sym_RBRACE,
    STATE(496), 1,
      sym_decorator_list,
    STATE(673), 1,
      sym_decorator_modifiers,
    STATE(674), 1,
      sym_function_modifiers,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(474), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    STATE(213), 15,
      sym__statement,
      sym_import_statement,
      sym_using_statement,
      sym_namespace_statement,
      sym_model_statement,
      sym_union_statement,
      sym_scalar_statement,
      sym_interface_statement,
      sym_enum_statement,
      sym_alias_statement,
      sym_augment_decorator_statement,
      sym_operation_statement,
      sym_decorator_declaration_statement,
      sym_function_declaration_statement,
      aux_sym_namespace_body_repeat1,
  [9367] = 5,
    ACTIONS(353), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(483), 2,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(215), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    ACTIONS(485), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [9417] = 8,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(312), 1,
      sym_identifier,
    STATE(315), 1,
      sym_member_expression,
    STATE(565), 1,
      sym_identifier_or_member_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [9473] = 8,
    ACTIONS(57), 1,
      sym_plain_identifier,
    ACTIONS(59), 1,
      anon_sym_BQUOTE,
    STATE(97), 1,
      sym_identifier,
    STATE(104), 1,
      sym_member_expression,
    STATE(135), 1,
      sym_identifier_or_member_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(96), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(55), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [9529] = 8,
    ACTIONS(862), 1,
      sym_plain_identifier,
    ACTIONS(864), 1,
      anon_sym_BQUOTE,
    STATE(210), 1,
      sym_identifier,
    STATE(238), 1,
      sym_identifier_or_member_expression,
    STATE(266), 1,
      sym_member_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(245), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(860), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [9585] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(866), 5,
      anon_sym_AT,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(868), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [9631] = 8,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(312), 1,
      sym_identifier,
    STATE(315), 1,
      sym_member_expression,
    STATE(640), 1,
      sym_identifier_or_member_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [9687] = 8,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(312), 1,
      sym_identifier,
    STATE(315), 1,
      sym_member_expression,
    STATE(561), 1,
      sym_identifier_or_member_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [9743] = 8,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(312), 1,
      sym_identifier,
    STATE(315), 1,
      sym_member_expression,
    STATE(556), 1,
      sym_identifier_or_member_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [9799] = 8,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(501), 1,
      sym_identifier,
    STATE(554), 1,
      sym_template_parameter,
    STATE(642), 1,
      sym_template_parameter_list,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [9855] = 5,
    ACTIONS(483), 1,
      anon_sym_BQUOTE,
    ACTIONS(548), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(239), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    ACTIONS(485), 32,
      anon_sym_op,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [9904] = 5,
    ACTIONS(870), 1,
      anon_sym_LPAREN,
    STATE(300), 1,
      sym_decorator_arguments,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(500), 2,
      anon_sym_AT,
      anon_sym_BQUOTE,
    ACTIONS(504), 32,
      anon_sym_op,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [9953] = 5,
    ACTIONS(490), 1,
      anon_sym_BQUOTE,
    ACTIONS(872), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(239), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    ACTIONS(492), 32,
      anon_sym_op,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [10002] = 7,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(501), 1,
      sym_identifier,
    STATE(585), 1,
      sym_template_parameter,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [10055] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(349), 4,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_DOT,
    ACTIONS(351), 32,
      anon_sym_op,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [10100] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(341), 4,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_DOT,
    ACTIONS(343), 32,
      anon_sym_op,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [10145] = 7,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    ACTIONS(875), 1,
      anon_sym_op,
    STATE(494), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [10198] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(345), 4,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_DOT,
    ACTIONS(347), 32,
      anon_sym_op,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [10243] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(333), 4,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_DOT,
    ACTIONS(335), 32,
      anon_sym_op,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [10288] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(337), 4,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_BQUOTE,
      anon_sym_DOT,
    ACTIONS(339), 32,
      anon_sym_op,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [10333] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(877), 3,
      anon_sym_AT,
      anon_sym_RBRACE,
      anon_sym_BQUOTE,
    ACTIONS(879), 32,
      anon_sym_op,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [10377] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(482), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [10427] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(568), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [10477] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(469), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [10527] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(506), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [10577] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(480), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [10627] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(538), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [10677] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(881), 3,
      anon_sym_AT,
      anon_sym_RBRACE,
      anon_sym_BQUOTE,
    ACTIONS(883), 32,
      anon_sym_op,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [10721] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(509), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [10771] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(616), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [10821] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(577), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [10871] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(588), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [10921] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(591), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [10971] = 4,
    ACTIONS(854), 1,
      anon_sym_COMMA,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(852), 3,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
    ACTIONS(856), 31,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [11017] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(615), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [11067] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(481), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [11117] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(612), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [11167] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(502), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [11217] = 6,
    ACTIONS(862), 1,
      sym_plain_identifier,
    ACTIONS(864), 1,
      anon_sym_BQUOTE,
    STATE(241), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(245), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(860), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [11267] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(290), 3,
      anon_sym_AT,
      anon_sym_LPAREN,
      anon_sym_BQUOTE,
    ACTIONS(292), 32,
      anon_sym_op,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [11311] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(314), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [11361] = 4,
    ACTIONS(887), 1,
      anon_sym_COMMA,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(885), 3,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
    ACTIONS(889), 31,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [11407] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(479), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [11457] = 4,
    ACTIONS(738), 1,
      anon_sym_COMMA,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(736), 3,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
    ACTIONS(740), 31,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [11503] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(478), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [11553] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(614), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [11603] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(500), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [11653] = 6,
    ACTIONS(200), 1,
      sym_plain_identifier,
    ACTIONS(202), 1,
      anon_sym_BQUOTE,
    STATE(143), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(127), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(198), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [11703] = 6,
    ACTIONS(200), 1,
      sym_plain_identifier,
    ACTIONS(202), 1,
      anon_sym_BQUOTE,
    STATE(193), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(127), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(198), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [11753] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(517), 3,
      anon_sym_AT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(519), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [11797] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(594), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [11847] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(613), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [11897] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(477), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [11947] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(540), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [11997] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(529), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [12047] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(511), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [12097] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(495), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [12147] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(525), 3,
      anon_sym_AT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(527), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [12191] = 6,
    ACTIONS(57), 1,
      sym_plain_identifier,
    ACTIONS(59), 1,
      anon_sym_BQUOTE,
    STATE(101), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(96), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(55), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [12241] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(521), 3,
      anon_sym_AT,
      anon_sym_BQUOTE,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(523), 32,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
      anon_sym_DQUOTE,
  [12285] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(611), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [12335] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(473), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [12385] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(539), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [12435] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(494), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [12485] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(504), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [12535] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(606), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [12585] = 6,
    ACTIONS(172), 1,
      sym_plain_identifier,
    ACTIONS(174), 1,
      anon_sym_BQUOTE,
    STATE(319), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(320), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(170), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [12635] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(555), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [12685] = 6,
    ACTIONS(134), 1,
      sym_plain_identifier,
    ACTIONS(136), 1,
      anon_sym_BQUOTE,
    STATE(596), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(307), 2,
      sym_builtin_type,
      sym_backticked_identifier,
    ACTIONS(132), 30,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
  [12735] = 4,
    ACTIONS(893), 1,
      anon_sym_COMMA,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(891), 3,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
    ACTIONS(895), 31,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [12781] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(897), 3,
      anon_sym_AT,
      anon_sym_RBRACE,
      anon_sym_BQUOTE,
    ACTIONS(899), 32,
      anon_sym_op,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [12825] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(517), 2,
      anon_sym_AT,
      anon_sym_BQUOTE,
    ACTIONS(519), 32,
      anon_sym_op,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [12868] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(901), 3,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
    ACTIONS(903), 31,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [12911] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(521), 2,
      anon_sym_AT,
      anon_sym_BQUOTE,
    ACTIONS(523), 32,
      anon_sym_op,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [12954] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(736), 3,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
    ACTIONS(740), 31,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [12997] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(905), 3,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
    ACTIONS(907), 31,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [13040] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(885), 3,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
    ACTIONS(889), 31,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [13083] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(891), 3,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
    ACTIONS(895), 31,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [13126] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(852), 3,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_BQUOTE,
    ACTIONS(856), 31,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [13169] = 3,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(525), 2,
      anon_sym_AT,
      anon_sym_BQUOTE,
    ACTIONS(527), 32,
      anon_sym_op,
      anon_sym_numeric,
      anon_sym_integer,
      anon_sym_float,
      anon_sym_int64,
      anon_sym_int32,
      anon_sym_int16,
      anon_sym_int,
      anon_sym_safeint,
      anon_sym_uint6,
      anon_sym_uint32,
      anon_sym_uint16,
      anon_sym_uint8,
      anon_sym_float32,
      anon_sym_float64,
      anon_sym_decimal,
      anon_sym_decimal128,
      anon_sym_plainDate,
      anon_sym_plainTime,
      anon_sym_utcDateTime,
      anon_sym_offsetDateTime,
      anon_sym_duration,
      anon_sym_bytes,
      anon_sym_string,
      anon_sym_boolean,
      anon_sym_null,
      anon_sym_Array,
      anon_sym_Record,
      anon_sym_unknown,
      anon_sym_void,
      anon_sym_never,
      sym_plain_identifier,
  [13212] = 3,
    ACTIONS(335), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(333), 32,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_is,
      anon_sym_extends,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_EQ,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DOT,
  [13254] = 3,
    ACTIONS(343), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(341), 32,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_is,
      anon_sym_extends,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_EQ,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DOT,
  [13296] = 3,
    ACTIONS(339), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(337), 32,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_is,
      anon_sym_extends,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_EQ,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DOT,
  [13338] = 3,
    ACTIONS(347), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(345), 32,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_is,
      anon_sym_extends,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_QMARK,
      anon_sym_COLON,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_EQ,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DOT,
  [13380] = 5,
    ACTIONS(328), 1,
      anon_sym_AT,
    ACTIONS(909), 1,
      anon_sym_DOT,
    STATE(311), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(326), 27,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_EQ,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_GT,
  [13423] = 5,
    ACTIONS(292), 1,
      anon_sym_AT,
    ACTIONS(912), 1,
      anon_sym_DOT,
    STATE(313), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(290), 27,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_EQ,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_GT,
  [13466] = 5,
    ACTIONS(324), 1,
      anon_sym_AT,
    ACTIONS(912), 1,
      anon_sym_DOT,
    STATE(311), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(322), 27,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_EQ,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_GT,
  [13509] = 3,
    ACTIONS(351), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(349), 28,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_EQ,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_DOT,
  [13547] = 3,
    ACTIONS(292), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(290), 27,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_EQ,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_GT,
  [13584] = 4,
    ACTIONS(328), 1,
      anon_sym_AT,
    ACTIONS(914), 1,
      anon_sym_DOT,
    STATE(316), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(326), 23,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      anon_sym_LT,
      sym_single_line_comment,
      sym_multi_line_comment,
  [13619] = 4,
    ACTIONS(324), 1,
      anon_sym_AT,
    ACTIONS(917), 1,
      anon_sym_DOT,
    STATE(316), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(322), 23,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      anon_sym_LT,
      sym_single_line_comment,
      sym_multi_line_comment,
  [13654] = 4,
    ACTIONS(292), 1,
      anon_sym_AT,
    ACTIONS(917), 1,
      anon_sym_DOT,
    STATE(317), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(290), 23,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      anon_sym_LT,
      sym_single_line_comment,
      sym_multi_line_comment,
  [13689] = 2,
    ACTIONS(351), 1,
      anon_sym_AT,
    ACTIONS(349), 24,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_DOT,
      sym_single_line_comment,
      sym_multi_line_comment,
  [13719] = 2,
    ACTIONS(335), 1,
      anon_sym_AT,
    ACTIONS(333), 24,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_DOT,
      sym_single_line_comment,
      sym_multi_line_comment,
  [13749] = 2,
    ACTIONS(339), 1,
      anon_sym_AT,
    ACTIONS(337), 24,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_DOT,
      sym_single_line_comment,
      sym_multi_line_comment,
  [13779] = 2,
    ACTIONS(343), 1,
      anon_sym_AT,
    ACTIONS(341), 24,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_DOT,
      sym_single_line_comment,
      sym_multi_line_comment,
  [13809] = 2,
    ACTIONS(347), 1,
      anon_sym_AT,
    ACTIONS(345), 24,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      anon_sym_LT,
      anon_sym_DOT,
      sym_single_line_comment,
      sym_multi_line_comment,
  [13839] = 2,
    ACTIONS(292), 1,
      anon_sym_AT,
    ACTIONS(290), 23,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      anon_sym_LT,
      sym_single_line_comment,
      sym_multi_line_comment,
  [13868] = 5,
    ACTIONS(250), 1,
      anon_sym_AT,
    ACTIONS(919), 1,
      anon_sym_LT,
    STATE(338), 1,
      sym_template_arguments,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(248), 19,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [13903] = 4,
    ACTIONS(250), 1,
      anon_sym_AT,
    ACTIONS(921), 1,
      anon_sym_LT,
    STATE(350), 1,
      sym_template_arguments,
    ACTIONS(248), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [13936] = 4,
    ACTIONS(310), 1,
      anon_sym_AT,
    ACTIONS(923), 1,
      anon_sym_LBRACK,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(308), 18,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [13967] = 2,
    ACTIONS(280), 1,
      anon_sym_AT,
    ACTIONS(278), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [13994] = 2,
    ACTIONS(238), 1,
      anon_sym_AT,
    ACTIONS(236), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [14021] = 2,
    ACTIONS(256), 1,
      anon_sym_AT,
    ACTIONS(254), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [14048] = 3,
    ACTIONS(310), 1,
      anon_sym_AT,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(308), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [14077] = 2,
    ACTIONS(316), 1,
      anon_sym_AT,
    ACTIONS(314), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [14104] = 3,
    ACTIONS(280), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(278), 19,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [14133] = 2,
    ACTIONS(300), 1,
      anon_sym_AT,
    ACTIONS(298), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [14160] = 2,
    ACTIONS(260), 1,
      anon_sym_AT,
    ACTIONS(258), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [14187] = 3,
    ACTIONS(306), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(304), 19,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [14216] = 3,
    ACTIONS(288), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(286), 19,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [14245] = 3,
    ACTIONS(320), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(318), 19,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [14274] = 3,
    ACTIONS(260), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(258), 19,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [14303] = 3,
    ACTIONS(272), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(270), 19,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [14332] = 2,
    ACTIONS(306), 1,
      anon_sym_AT,
    ACTIONS(304), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [14359] = 2,
    ACTIONS(246), 1,
      anon_sym_AT,
    ACTIONS(244), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [14386] = 2,
    ACTIONS(242), 1,
      anon_sym_AT,
    ACTIONS(240), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [14413] = 3,
    ACTIONS(238), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(236), 19,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [14442] = 3,
    ACTIONS(256), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(254), 19,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [14471] = 3,
    ACTIONS(316), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(314), 19,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [14500] = 3,
    ACTIONS(246), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(244), 19,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [14529] = 3,
    ACTIONS(242), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(240), 19,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [14558] = 2,
    ACTIONS(288), 1,
      anon_sym_AT,
    ACTIONS(286), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [14585] = 2,
    ACTIONS(320), 1,
      anon_sym_AT,
    ACTIONS(318), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [14612] = 2,
    ACTIONS(272), 1,
      anon_sym_AT,
    ACTIONS(270), 21,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [14639] = 3,
    ACTIONS(300), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(298), 19,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_LBRACK,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [14668] = 3,
    ACTIONS(268), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(266), 18,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [14696] = 3,
    ACTIONS(449), 1,
      anon_sym_AT,
    ACTIONS(927), 1,
      anon_sym_AMP,
    ACTIONS(447), 19,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [14724] = 4,
    ACTIONS(931), 1,
      anon_sym_AT,
    ACTIONS(933), 1,
      anon_sym_LPAREN,
    STATE(446), 1,
      sym_decorator_arguments,
    ACTIONS(929), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [14754] = 5,
    ACTIONS(829), 1,
      anon_sym_AT,
    ACTIONS(935), 1,
      anon_sym_PIPE,
    ACTIONS(937), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(827), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [14786] = 5,
    ACTIONS(931), 1,
      anon_sym_AT,
    ACTIONS(939), 1,
      anon_sym_LPAREN,
    STATE(388), 1,
      sym_decorator_arguments,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(929), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [14818] = 3,
    ACTIONS(469), 1,
      anon_sym_AT,
    ACTIONS(927), 1,
      anon_sym_AMP,
    ACTIONS(467), 19,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [14846] = 4,
    ACTIONS(943), 1,
      anon_sym_AT,
    ACTIONS(945), 1,
      anon_sym_COLON,
    STATE(466), 1,
      sym_type_annotation,
    ACTIONS(941), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [14876] = 4,
    ACTIONS(449), 1,
      anon_sym_AT,
    ACTIONS(937), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(447), 17,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [14906] = 4,
    ACTIONS(945), 1,
      anon_sym_COLON,
    ACTIONS(949), 1,
      anon_sym_AT,
    STATE(436), 1,
      sym_type_annotation,
    ACTIONS(947), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [14936] = 3,
    ACTIONS(264), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(262), 18,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [14964] = 5,
    ACTIONS(949), 1,
      anon_sym_AT,
    ACTIONS(951), 1,
      anon_sym_COLON,
    STATE(426), 1,
      sym_type_annotation,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(947), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [14996] = 4,
    ACTIONS(469), 1,
      anon_sym_AT,
    ACTIONS(937), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(467), 17,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15026] = 2,
    ACTIONS(264), 1,
      anon_sym_AT,
    ACTIONS(262), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [15052] = 2,
    ACTIONS(268), 1,
      anon_sym_AT,
    ACTIONS(266), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [15078] = 2,
    ACTIONS(276), 1,
      anon_sym_AT,
    ACTIONS(274), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [15104] = 4,
    ACTIONS(829), 1,
      anon_sym_AT,
    ACTIONS(927), 1,
      anon_sym_AMP,
    ACTIONS(953), 1,
      anon_sym_PIPE,
    ACTIONS(827), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [15134] = 2,
    ACTIONS(284), 1,
      anon_sym_AT,
    ACTIONS(282), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [15160] = 3,
    ACTIONS(276), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(274), 18,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15188] = 5,
    ACTIONS(943), 1,
      anon_sym_AT,
    ACTIONS(951), 1,
      anon_sym_COLON,
    STATE(402), 1,
      sym_type_annotation,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(941), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15220] = 3,
    ACTIONS(284), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(282), 18,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15248] = 3,
    ACTIONS(957), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(955), 17,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_COLON,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15275] = 3,
    ACTIONS(961), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(959), 17,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_COLON,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15302] = 2,
    ACTIONS(957), 1,
      anon_sym_AT,
    ACTIONS(955), 19,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_COLON,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [15327] = 2,
    ACTIONS(961), 1,
      anon_sym_AT,
    ACTIONS(959), 19,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_COLON,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [15352] = 3,
    ACTIONS(965), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(963), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15378] = 2,
    ACTIONS(969), 1,
      anon_sym_AT,
    ACTIONS(967), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [15402] = 2,
    ACTIONS(973), 1,
      anon_sym_AT,
    ACTIONS(971), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [15426] = 3,
    ACTIONS(977), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(975), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15452] = 3,
    ACTIONS(981), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(979), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15478] = 3,
    ACTIONS(985), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(983), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15504] = 3,
    ACTIONS(989), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(987), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15530] = 3,
    ACTIONS(993), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(991), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15556] = 3,
    ACTIONS(997), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(995), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15582] = 3,
    ACTIONS(1001), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(999), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15608] = 3,
    ACTIONS(1005), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1003), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15634] = 3,
    ACTIONS(1009), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1007), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15660] = 3,
    ACTIONS(1013), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1011), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15686] = 2,
    ACTIONS(527), 1,
      anon_sym_AT,
    ACTIONS(525), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [15710] = 3,
    ACTIONS(1017), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1015), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15736] = 2,
    ACTIONS(1021), 1,
      anon_sym_AT,
    ACTIONS(1019), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [15760] = 3,
    ACTIONS(1025), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1023), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15786] = 3,
    ACTIONS(1029), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1027), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15812] = 3,
    ACTIONS(1033), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1031), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15838] = 3,
    ACTIONS(969), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(967), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15864] = 3,
    ACTIONS(1037), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1035), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15890] = 3,
    ACTIONS(1021), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1019), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15916] = 3,
    ACTIONS(973), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(971), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15942] = 3,
    ACTIONS(1041), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1039), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [15968] = 2,
    ACTIONS(1045), 1,
      anon_sym_AT,
    ACTIONS(1043), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [15992] = 3,
    ACTIONS(1049), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1047), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16018] = 3,
    ACTIONS(1053), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1051), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16044] = 3,
    ACTIONS(1057), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1055), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16070] = 3,
    ACTIONS(1061), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1059), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16096] = 3,
    ACTIONS(1065), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1063), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16122] = 3,
    ACTIONS(1069), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1067), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16148] = 2,
    ACTIONS(519), 1,
      anon_sym_AT,
    ACTIONS(517), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [16172] = 2,
    ACTIONS(997), 1,
      anon_sym_AT,
    ACTIONS(995), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [16196] = 2,
    ACTIONS(1061), 1,
      anon_sym_AT,
    ACTIONS(1059), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [16220] = 3,
    ACTIONS(1073), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1071), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16246] = 2,
    ACTIONS(1037), 1,
      anon_sym_AT,
    ACTIONS(1035), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [16270] = 3,
    ACTIONS(1077), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1075), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16296] = 3,
    ACTIONS(1081), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1079), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16322] = 3,
    ACTIONS(1085), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1083), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16348] = 3,
    ACTIONS(1089), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1087), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16374] = 3,
    ACTIONS(1045), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1043), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16400] = 3,
    ACTIONS(1093), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1091), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16426] = 3,
    ACTIONS(1097), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1095), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16452] = 3,
    ACTIONS(1101), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1099), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16478] = 2,
    ACTIONS(1057), 1,
      anon_sym_AT,
    ACTIONS(1055), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [16502] = 3,
    ACTIONS(1105), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1103), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16528] = 3,
    ACTIONS(1109), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1107), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16554] = 3,
    ACTIONS(1113), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1111), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16580] = 3,
    ACTIONS(1117), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1115), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16606] = 3,
    ACTIONS(1121), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1119), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16632] = 2,
    ACTIONS(989), 1,
      anon_sym_AT,
    ACTIONS(987), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [16656] = 3,
    ACTIONS(1125), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1123), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16682] = 3,
    ACTIONS(1129), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1127), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16708] = 3,
    ACTIONS(1133), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1131), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16734] = 3,
    ACTIONS(1137), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1135), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [16760] = 2,
    ACTIONS(993), 1,
      anon_sym_AT,
    ACTIONS(991), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [16784] = 2,
    ACTIONS(1001), 1,
      anon_sym_AT,
    ACTIONS(999), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [16808] = 2,
    ACTIONS(1033), 1,
      anon_sym_AT,
    ACTIONS(1031), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [16832] = 2,
    ACTIONS(1029), 1,
      anon_sym_AT,
    ACTIONS(1027), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [16856] = 2,
    ACTIONS(1121), 1,
      anon_sym_AT,
    ACTIONS(1119), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [16880] = 2,
    ACTIONS(1093), 1,
      anon_sym_AT,
    ACTIONS(1091), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [16904] = 2,
    ACTIONS(1025), 1,
      anon_sym_AT,
    ACTIONS(1023), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [16928] = 2,
    ACTIONS(1065), 1,
      anon_sym_AT,
    ACTIONS(1063), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [16952] = 2,
    ACTIONS(1041), 1,
      anon_sym_AT,
    ACTIONS(1039), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [16976] = 2,
    ACTIONS(1005), 1,
      anon_sym_AT,
    ACTIONS(1003), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17000] = 2,
    ACTIONS(1097), 1,
      anon_sym_AT,
    ACTIONS(1095), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17024] = 2,
    ACTIONS(1101), 1,
      anon_sym_AT,
    ACTIONS(1099), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17048] = 2,
    ACTIONS(1069), 1,
      anon_sym_AT,
    ACTIONS(1067), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17072] = 2,
    ACTIONS(1105), 1,
      anon_sym_AT,
    ACTIONS(1103), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17096] = 2,
    ACTIONS(1009), 1,
      anon_sym_AT,
    ACTIONS(1007), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17120] = 2,
    ACTIONS(1109), 1,
      anon_sym_AT,
    ACTIONS(1107), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17144] = 2,
    ACTIONS(1073), 1,
      anon_sym_AT,
    ACTIONS(1071), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17168] = 2,
    ACTIONS(1017), 1,
      anon_sym_AT,
    ACTIONS(1015), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17192] = 2,
    ACTIONS(1113), 1,
      anon_sym_AT,
    ACTIONS(1111), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17216] = 2,
    ACTIONS(1117), 1,
      anon_sym_AT,
    ACTIONS(1115), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17240] = 2,
    ACTIONS(1077), 1,
      anon_sym_AT,
    ACTIONS(1075), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17264] = 3,
    ACTIONS(519), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(517), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [17290] = 2,
    ACTIONS(1013), 1,
      anon_sym_AT,
    ACTIONS(1011), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17314] = 2,
    ACTIONS(1053), 1,
      anon_sym_AT,
    ACTIONS(1051), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17338] = 3,
    ACTIONS(527), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(525), 16,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_RBRACE,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
  [17364] = 2,
    ACTIONS(1125), 1,
      anon_sym_AT,
    ACTIONS(1123), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17388] = 2,
    ACTIONS(977), 1,
      anon_sym_AT,
    ACTIONS(975), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17412] = 2,
    ACTIONS(1081), 1,
      anon_sym_AT,
    ACTIONS(1079), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17436] = 2,
    ACTIONS(1129), 1,
      anon_sym_AT,
    ACTIONS(1127), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17460] = 2,
    ACTIONS(1089), 1,
      anon_sym_AT,
    ACTIONS(1087), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17484] = 2,
    ACTIONS(1085), 1,
      anon_sym_AT,
    ACTIONS(1083), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17508] = 2,
    ACTIONS(981), 1,
      anon_sym_AT,
    ACTIONS(979), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17532] = 2,
    ACTIONS(1137), 1,
      anon_sym_AT,
    ACTIONS(1135), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17556] = 2,
    ACTIONS(985), 1,
      anon_sym_AT,
    ACTIONS(983), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17580] = 2,
    ACTIONS(1049), 1,
      anon_sym_AT,
    ACTIONS(1047), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17604] = 2,
    ACTIONS(965), 1,
      anon_sym_AT,
    ACTIONS(963), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17628] = 2,
    ACTIONS(1133), 1,
      anon_sym_AT,
    ACTIONS(1131), 18,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_import,
      anon_sym_using,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_interface,
      anon_sym_op,
      anon_sym_enum,
      anon_sym_alias,
      anon_sym_AT_AT,
      anon_sym_dec,
      anon_sym_extern,
      anon_sym_fn,
      sym_single_line_comment,
      sym_multi_line_comment,
  [17652] = 9,
    ACTIONS(160), 1,
      anon_sym_LBRACE,
    ACTIONS(1139), 1,
      anon_sym_is,
    ACTIONS(1141), 1,
      anon_sym_extends,
    ACTIONS(1143), 1,
      anon_sym_LT,
    STATE(455), 1,
      sym_model_expression,
    STATE(487), 1,
      sym_template_parameters,
    STATE(599), 1,
      sym_model_is_heritage,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(604), 2,
      sym__model_heritage,
      sym_model_extends_heritage,
  [17682] = 3,
    ACTIONS(1145), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(447), 8,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_EQ,
      anon_sym_GT,
  [17700] = 4,
    ACTIONS(1147), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(471), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    ACTIONS(490), 6,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_op,
      anon_sym_enum,
  [17720] = 6,
    ACTIONS(210), 1,
      anon_sym_DQUOTE,
    ACTIONS(212), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(1150), 1,
      sym_decimal_literal,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1152), 2,
      sym_hex_integer_literal,
      sym_binary_integer_literal,
    STATE(183), 4,
      sym__numeric_literal,
      sym__string_literal,
      sym_quoted_string_literal,
      sym_triple_quoted_string_literal,
  [17744] = 9,
    ACTIONS(216), 1,
      anon_sym_LBRACE,
    ACTIONS(1139), 1,
      anon_sym_is,
    ACTIONS(1141), 1,
      anon_sym_extends,
    ACTIONS(1143), 1,
      anon_sym_LT,
    STATE(383), 1,
      sym_model_expression,
    STATE(485), 1,
      sym_template_parameters,
    STATE(580), 1,
      sym_model_is_heritage,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(586), 2,
      sym__model_heritage,
      sym_model_extends_heritage,
  [17774] = 4,
    ACTIONS(1154), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(471), 2,
      sym_decorator,
      aux_sym_decorator_list_repeat1,
    ACTIONS(483), 6,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_op,
      anon_sym_enum,
  [17794] = 4,
    ACTIONS(939), 1,
      anon_sym_LPAREN,
    STATE(484), 1,
      sym_decorator_arguments,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(500), 7,
      anon_sym_AT,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_op,
      anon_sym_enum,
  [17814] = 3,
    ACTIONS(1145), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(467), 8,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_PIPE,
      anon_sym_RBRACK,
      anon_sym_EQ,
      anon_sym_GT,
  [17832] = 9,
    ACTIONS(216), 1,
      anon_sym_LBRACE,
    ACTIONS(1139), 1,
      anon_sym_is,
    ACTIONS(1141), 1,
      anon_sym_extends,
    ACTIONS(1143), 1,
      anon_sym_LT,
    STATE(403), 1,
      sym_model_expression,
    STATE(488), 1,
      sym_template_parameters,
    STATE(590), 1,
      sym_model_is_heritage,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(589), 2,
      sym__model_heritage,
      sym_model_extends_heritage,
  [17862] = 9,
    ACTIONS(160), 1,
      anon_sym_LBRACE,
    ACTIONS(1139), 1,
      anon_sym_is,
    ACTIONS(1141), 1,
      anon_sym_extends,
    ACTIONS(1143), 1,
      anon_sym_LT,
    STATE(427), 1,
      sym_model_expression,
    STATE(486), 1,
      sym_template_parameters,
    STATE(619), 1,
      sym_model_is_heritage,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(618), 2,
      sym__model_heritage,
      sym_model_extends_heritage,
  [17892] = 7,
    ACTIONS(1143), 1,
      anon_sym_LT,
    ACTIONS(1156), 1,
      anon_sym_LPAREN,
    ACTIONS(1158), 1,
      anon_sym_is,
    STATE(497), 1,
      sym_template_parameters,
    STATE(628), 1,
      sym_operation_arguments,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(664), 3,
      sym__operation_signature,
      sym_operation_signature_declaration,
      sym_operation_signature_reference,
  [17917] = 7,
    ACTIONS(1143), 1,
      anon_sym_LT,
    ACTIONS(1156), 1,
      anon_sym_LPAREN,
    ACTIONS(1158), 1,
      anon_sym_is,
    STATE(498), 1,
      sym_template_parameters,
    STATE(628), 1,
      sym_operation_arguments,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(659), 3,
      sym__operation_signature,
      sym_operation_signature_declaration,
      sym_operation_signature_reference,
  [17942] = 7,
    ACTIONS(1143), 1,
      anon_sym_LT,
    ACTIONS(1156), 1,
      anon_sym_LPAREN,
    ACTIONS(1158), 1,
      anon_sym_is,
    STATE(492), 1,
      sym_template_parameters,
    STATE(628), 1,
      sym_operation_arguments,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(666), 3,
      sym__operation_signature,
      sym_operation_signature_declaration,
      sym_operation_signature_reference,
  [17967] = 7,
    ACTIONS(1143), 1,
      anon_sym_LT,
    ACTIONS(1156), 1,
      anon_sym_LPAREN,
    ACTIONS(1158), 1,
      anon_sym_is,
    STATE(489), 1,
      sym_template_parameters,
    STATE(628), 1,
      sym_operation_arguments,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(627), 3,
      sym__operation_signature,
      sym_operation_signature_declaration,
      sym_operation_signature_reference,
  [17992] = 6,
    ACTIONS(1145), 1,
      anon_sym_AMP,
    ACTIONS(1162), 1,
      anon_sym_COMMA,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    STATE(508), 1,
      aux_sym_expression_list_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1160), 3,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT,
  [18014] = 2,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(521), 7,
      anon_sym_AT,
      anon_sym_namespace,
      anon_sym_model,
      anon_sym_union,
      anon_sym_scalar,
      anon_sym_op,
      anon_sym_enum,
  [18028] = 7,
    ACTIONS(216), 1,
      anon_sym_LBRACE,
    ACTIONS(1139), 1,
      anon_sym_is,
    ACTIONS(1141), 1,
      anon_sym_extends,
    STATE(393), 1,
      sym_model_expression,
    STATE(579), 1,
      sym_model_is_heritage,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(603), 2,
      sym__model_heritage,
      sym_model_extends_heritage,
  [18052] = 7,
    ACTIONS(160), 1,
      anon_sym_LBRACE,
    ACTIONS(1139), 1,
      anon_sym_is,
    ACTIONS(1141), 1,
      anon_sym_extends,
    STATE(438), 1,
      sym_model_expression,
    STATE(608), 1,
      sym_model_is_heritage,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(609), 2,
      sym__model_heritage,
      sym_model_extends_heritage,
  [18076] = 7,
    ACTIONS(160), 1,
      anon_sym_LBRACE,
    ACTIONS(1139), 1,
      anon_sym_is,
    ACTIONS(1141), 1,
      anon_sym_extends,
    STATE(445), 1,
      sym_model_expression,
    STATE(582), 1,
      sym_model_is_heritage,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(581), 2,
      sym__model_heritage,
      sym_model_extends_heritage,
  [18100] = 7,
    ACTIONS(216), 1,
      anon_sym_LBRACE,
    ACTIONS(1139), 1,
      anon_sym_is,
    ACTIONS(1141), 1,
      anon_sym_extends,
    STATE(422), 1,
      sym_model_expression,
    STATE(602), 1,
      sym_model_is_heritage,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(601), 2,
      sym__model_heritage,
      sym_model_extends_heritage,
  [18124] = 5,
    ACTIONS(1156), 1,
      anon_sym_LPAREN,
    ACTIONS(1158), 1,
      anon_sym_is,
    STATE(628), 1,
      sym_operation_arguments,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(652), 3,
      sym__operation_signature,
      sym_operation_signature_declaration,
      sym_operation_signature_reference,
  [18143] = 7,
    ACTIONS(1166), 1,
      anon_sym_namespace,
    ACTIONS(1168), 1,
      anon_sym_model,
    ACTIONS(1170), 1,
      anon_sym_union,
    ACTIONS(1172), 1,
      anon_sym_scalar,
    ACTIONS(1174), 1,
      anon_sym_op,
    ACTIONS(1176), 1,
      anon_sym_enum,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18166] = 5,
    ACTIONS(1156), 1,
      anon_sym_LPAREN,
    ACTIONS(1158), 1,
      anon_sym_is,
    STATE(628), 1,
      sym_operation_arguments,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(678), 3,
      sym__operation_signature,
      sym_operation_signature_declaration,
      sym_operation_signature_reference,
  [18185] = 5,
    ACTIONS(1156), 1,
      anon_sym_LPAREN,
    ACTIONS(1158), 1,
      anon_sym_is,
    STATE(628), 1,
      sym_operation_arguments,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(655), 3,
      sym__operation_signature,
      sym_operation_signature_declaration,
      sym_operation_signature_reference,
  [18204] = 2,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1178), 6,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_is,
      anon_sym_extends,
      anon_sym_EQ,
  [18217] = 5,
    ACTIONS(1156), 1,
      anon_sym_LPAREN,
    ACTIONS(1158), 1,
      anon_sym_is,
    STATE(628), 1,
      sym_operation_arguments,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(663), 3,
      sym__operation_signature,
      sym_operation_signature_declaration,
      sym_operation_signature_reference,
  [18236] = 7,
    ACTIONS(1143), 1,
      anon_sym_LT,
    ACTIONS(1180), 1,
      anon_sym_LBRACE,
    ACTIONS(1182), 1,
      anon_sym_extends,
    STATE(433), 1,
      sym_interface_body,
    STATE(544), 1,
      sym_template_parameters,
    STATE(617), 1,
      sym_interface_heritage,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18259] = 7,
    ACTIONS(1184), 1,
      anon_sym_namespace,
    ACTIONS(1186), 1,
      anon_sym_model,
    ACTIONS(1188), 1,
      anon_sym_union,
    ACTIONS(1190), 1,
      anon_sym_scalar,
    ACTIONS(1192), 1,
      anon_sym_op,
    ACTIONS(1194), 1,
      anon_sym_enum,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18282] = 5,
    ACTIONS(1156), 1,
      anon_sym_LPAREN,
    ACTIONS(1158), 1,
      anon_sym_is,
    STATE(628), 1,
      sym_operation_arguments,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(675), 3,
      sym__operation_signature,
      sym_operation_signature_declaration,
      sym_operation_signature_reference,
  [18301] = 5,
    ACTIONS(1156), 1,
      anon_sym_LPAREN,
    ACTIONS(1158), 1,
      anon_sym_is,
    STATE(628), 1,
      sym_operation_arguments,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(671), 3,
      sym__operation_signature,
      sym_operation_signature_declaration,
      sym_operation_signature_reference,
  [18320] = 4,
    ACTIONS(1145), 1,
      anon_sym_AMP,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1196), 4,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_GT,
  [18337] = 5,
    ACTIONS(1156), 1,
      anon_sym_LPAREN,
    ACTIONS(1158), 1,
      anon_sym_is,
    STATE(628), 1,
      sym_operation_arguments,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(656), 3,
      sym__operation_signature,
      sym_operation_signature_declaration,
      sym_operation_signature_reference,
  [18356] = 6,
    ACTIONS(1198), 1,
      anon_sym_extends,
    ACTIONS(1202), 1,
      anon_sym_EQ,
    STATE(518), 1,
      sym_template_constraint,
    STATE(584), 1,
      sym_template_default,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1200), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [18377] = 7,
    ACTIONS(1143), 1,
      anon_sym_LT,
    ACTIONS(1182), 1,
      anon_sym_extends,
    ACTIONS(1204), 1,
      anon_sym_LBRACE,
    STATE(386), 1,
      sym_interface_body,
    STATE(541), 1,
      sym_template_parameters,
    STATE(587), 1,
      sym_interface_heritage,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18400] = 4,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(668), 3,
      sym__string_literal,
      sym_quoted_string_literal,
      sym_triple_quoted_string_literal,
  [18416] = 6,
    ACTIONS(1143), 1,
      anon_sym_LT,
    ACTIONS(1206), 1,
      anon_sym_SEMI,
    ACTIONS(1208), 1,
      anon_sym_extends,
    STATE(552), 1,
      sym_template_parameters,
    STATE(621), 1,
      sym_scalar_extends,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18436] = 4,
    ACTIONS(67), 1,
      anon_sym_DQUOTE,
    ACTIONS(69), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    STATE(644), 3,
      sym__string_literal,
      sym_quoted_string_literal,
      sym_triple_quoted_string_literal,
  [18452] = 6,
    ACTIONS(1143), 1,
      anon_sym_LT,
    ACTIONS(1208), 1,
      anon_sym_extends,
    ACTIONS(1210), 1,
      anon_sym_SEMI,
    STATE(559), 1,
      sym_template_parameters,
    STATE(658), 1,
      sym_scalar_extends,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18472] = 4,
    ACTIONS(1145), 1,
      anon_sym_AMP,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1212), 3,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_GT,
  [18488] = 4,
    ACTIONS(1214), 1,
      anon_sym_COMMA,
    STATE(510), 1,
      aux_sym_expression_list_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(124), 3,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT,
  [18504] = 6,
    ACTIONS(1143), 1,
      anon_sym_LT,
    ACTIONS(1208), 1,
      anon_sym_extends,
    ACTIONS(1216), 1,
      anon_sym_SEMI,
    STATE(570), 1,
      sym_template_parameters,
    STATE(667), 1,
      sym_scalar_extends,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18524] = 4,
    ACTIONS(1218), 1,
      anon_sym_COMMA,
    STATE(510), 1,
      aux_sym_expression_list_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1196), 3,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_GT,
  [18540] = 6,
    ACTIONS(1143), 1,
      anon_sym_LT,
    ACTIONS(1208), 1,
      anon_sym_extends,
    ACTIONS(1221), 1,
      anon_sym_SEMI,
    STATE(562), 1,
      sym_template_parameters,
    STATE(626), 1,
      sym_scalar_extends,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18560] = 5,
    ACTIONS(1223), 1,
      anon_sym_DQUOTE,
    ACTIONS(1225), 1,
      sym_escape_sequence,
    ACTIONS(1227), 1,
      sym_quoted_string_fragment,
    STATE(546), 1,
      aux_sym_quoted_string_literal_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18577] = 5,
    ACTIONS(1231), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(1233), 1,
      sym_escape_sequence,
    ACTIONS(1235), 1,
      sym_triple_quoted_string_fragment,
    STATE(528), 1,
      aux_sym_triple_quoted_string_literal_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18594] = 5,
    ACTIONS(1237), 1,
      anon_sym_DQUOTE,
    ACTIONS(1239), 1,
      sym_escape_sequence,
    ACTIONS(1241), 1,
      sym_quoted_string_fragment,
    STATE(543), 1,
      aux_sym_quoted_string_literal_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18611] = 5,
    ACTIONS(1243), 1,
      anon_sym_BQUOTE,
    ACTIONS(1245), 1,
      sym_backticked_identifier_fragment,
    ACTIONS(1247), 1,
      sym_escape_sequence,
    STATE(549), 1,
      aux_sym_backticked_identifier_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18628] = 5,
    ACTIONS(1249), 1,
      anon_sym_BQUOTE,
    ACTIONS(1251), 1,
      sym_backticked_identifier_fragment,
    ACTIONS(1254), 1,
      sym_escape_sequence,
    STATE(516), 1,
      aux_sym_backticked_identifier_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18645] = 5,
    ACTIONS(1257), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(1259), 1,
      sym_escape_sequence,
    ACTIONS(1261), 1,
      sym_triple_quoted_string_fragment,
    STATE(522), 1,
      aux_sym_triple_quoted_string_literal_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18662] = 4,
    ACTIONS(1202), 1,
      anon_sym_EQ,
    STATE(593), 1,
      sym_template_default,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1263), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [18677] = 5,
    ACTIONS(1265), 1,
      anon_sym_BQUOTE,
    ACTIONS(1267), 1,
      sym_backticked_identifier_fragment,
    ACTIONS(1269), 1,
      sym_escape_sequence,
    STATE(527), 1,
      aux_sym_backticked_identifier_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18694] = 5,
    ACTIONS(1271), 1,
      anon_sym_DQUOTE,
    ACTIONS(1273), 1,
      sym_escape_sequence,
    ACTIONS(1275), 1,
      sym_quoted_string_fragment,
    STATE(521), 1,
      aux_sym_quoted_string_literal_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18711] = 5,
    ACTIONS(1277), 1,
      anon_sym_DQUOTE,
    ACTIONS(1279), 1,
      sym_escape_sequence,
    ACTIONS(1282), 1,
      sym_quoted_string_fragment,
    STATE(521), 1,
      aux_sym_quoted_string_literal_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18728] = 5,
    ACTIONS(1285), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(1287), 1,
      sym_escape_sequence,
    ACTIONS(1290), 1,
      sym_triple_quoted_string_fragment,
    STATE(522), 1,
      aux_sym_triple_quoted_string_literal_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18745] = 5,
    ACTIONS(1293), 1,
      anon_sym_DQUOTE,
    ACTIONS(1295), 1,
      sym_escape_sequence,
    ACTIONS(1297), 1,
      sym_quoted_string_fragment,
    STATE(520), 1,
      aux_sym_quoted_string_literal_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18762] = 5,
    ACTIONS(1299), 1,
      anon_sym_BQUOTE,
    ACTIONS(1301), 1,
      sym_backticked_identifier_fragment,
    ACTIONS(1303), 1,
      sym_escape_sequence,
    STATE(516), 1,
      aux_sym_backticked_identifier_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18779] = 5,
    ACTIONS(1305), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(1307), 1,
      sym_escape_sequence,
    ACTIONS(1309), 1,
      sym_triple_quoted_string_fragment,
    STATE(517), 1,
      aux_sym_triple_quoted_string_literal_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18796] = 5,
    ACTIONS(1311), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(1313), 1,
      sym_escape_sequence,
    ACTIONS(1315), 1,
      sym_triple_quoted_string_fragment,
    STATE(542), 1,
      aux_sym_triple_quoted_string_literal_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18813] = 5,
    ACTIONS(1301), 1,
      sym_backticked_identifier_fragment,
    ACTIONS(1303), 1,
      sym_escape_sequence,
    ACTIONS(1317), 1,
      anon_sym_BQUOTE,
    STATE(516), 1,
      aux_sym_backticked_identifier_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18830] = 5,
    ACTIONS(1259), 1,
      sym_escape_sequence,
    ACTIONS(1261), 1,
      sym_triple_quoted_string_fragment,
    ACTIONS(1319), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(522), 1,
      aux_sym_triple_quoted_string_literal_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18847] = 5,
    ACTIONS(1143), 1,
      anon_sym_LT,
    ACTIONS(1321), 1,
      anon_sym_LBRACE,
    STATE(432), 1,
      sym_union_body,
    STATE(578), 1,
      sym_template_parameters,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18864] = 4,
    ACTIONS(1145), 1,
      anon_sym_AMP,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1323), 2,
      anon_sym_SEMI,
      anon_sym_LBRACE,
  [18879] = 5,
    ACTIONS(1301), 1,
      sym_backticked_identifier_fragment,
    ACTIONS(1303), 1,
      sym_escape_sequence,
    ACTIONS(1325), 1,
      anon_sym_BQUOTE,
    STATE(516), 1,
      aux_sym_backticked_identifier_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18896] = 5,
    ACTIONS(1327), 1,
      anon_sym_BQUOTE,
    ACTIONS(1329), 1,
      sym_backticked_identifier_fragment,
    ACTIONS(1331), 1,
      sym_escape_sequence,
    STATE(545), 1,
      aux_sym_backticked_identifier_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18913] = 5,
    ACTIONS(1333), 1,
      anon_sym_BQUOTE,
    ACTIONS(1335), 1,
      sym_backticked_identifier_fragment,
    ACTIONS(1337), 1,
      sym_escape_sequence,
    STATE(531), 1,
      aux_sym_backticked_identifier_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18930] = 5,
    ACTIONS(1339), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    ACTIONS(1341), 1,
      sym_escape_sequence,
    ACTIONS(1343), 1,
      sym_triple_quoted_string_fragment,
    STATE(547), 1,
      aux_sym_triple_quoted_string_literal_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18947] = 5,
    ACTIONS(1345), 1,
      anon_sym_DQUOTE,
    ACTIONS(1347), 1,
      sym_escape_sequence,
    ACTIONS(1349), 1,
      sym_quoted_string_fragment,
    STATE(548), 1,
      aux_sym_quoted_string_literal_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18964] = 5,
    ACTIONS(1351), 1,
      anon_sym_BQUOTE,
    ACTIONS(1353), 1,
      sym_backticked_identifier_fragment,
    ACTIONS(1355), 1,
      sym_escape_sequence,
    STATE(524), 1,
      aux_sym_backticked_identifier_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [18981] = 4,
    ACTIONS(1145), 1,
      anon_sym_AMP,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1357), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [18996] = 5,
    ACTIONS(1143), 1,
      anon_sym_LT,
    ACTIONS(1359), 1,
      anon_sym_LBRACE,
    STATE(404), 1,
      sym_union_body,
    STATE(592), 1,
      sym_template_parameters,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19013] = 5,
    ACTIONS(1143), 1,
      anon_sym_LT,
    ACTIONS(1359), 1,
      anon_sym_LBRACE,
    STATE(384), 1,
      sym_union_body,
    STATE(600), 1,
      sym_template_parameters,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19030] = 5,
    ACTIONS(1143), 1,
      anon_sym_LT,
    ACTIONS(1321), 1,
      anon_sym_LBRACE,
    STATE(421), 1,
      sym_union_body,
    STATE(598), 1,
      sym_template_parameters,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19047] = 5,
    ACTIONS(1182), 1,
      anon_sym_extends,
    ACTIONS(1204), 1,
      anon_sym_LBRACE,
    STATE(398), 1,
      sym_interface_body,
    STATE(583), 1,
      sym_interface_heritage,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19064] = 5,
    ACTIONS(1259), 1,
      sym_escape_sequence,
    ACTIONS(1261), 1,
      sym_triple_quoted_string_fragment,
    ACTIONS(1361), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(522), 1,
      aux_sym_triple_quoted_string_literal_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19081] = 5,
    ACTIONS(1273), 1,
      sym_escape_sequence,
    ACTIONS(1275), 1,
      sym_quoted_string_fragment,
    ACTIONS(1363), 1,
      anon_sym_DQUOTE,
    STATE(521), 1,
      aux_sym_quoted_string_literal_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19098] = 5,
    ACTIONS(1180), 1,
      anon_sym_LBRACE,
    ACTIONS(1182), 1,
      anon_sym_extends,
    STATE(392), 1,
      sym_interface_body,
    STATE(607), 1,
      sym_interface_heritage,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19115] = 5,
    ACTIONS(1301), 1,
      sym_backticked_identifier_fragment,
    ACTIONS(1303), 1,
      sym_escape_sequence,
    ACTIONS(1365), 1,
      anon_sym_BQUOTE,
    STATE(516), 1,
      aux_sym_backticked_identifier_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19132] = 5,
    ACTIONS(1273), 1,
      sym_escape_sequence,
    ACTIONS(1275), 1,
      sym_quoted_string_fragment,
    ACTIONS(1367), 1,
      anon_sym_DQUOTE,
    STATE(521), 1,
      aux_sym_quoted_string_literal_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19149] = 5,
    ACTIONS(1259), 1,
      sym_escape_sequence,
    ACTIONS(1261), 1,
      sym_triple_quoted_string_fragment,
    ACTIONS(1369), 1,
      anon_sym_DQUOTE_DQUOTE_DQUOTE,
    STATE(522), 1,
      aux_sym_triple_quoted_string_literal_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19166] = 5,
    ACTIONS(1273), 1,
      sym_escape_sequence,
    ACTIONS(1275), 1,
      sym_quoted_string_fragment,
    ACTIONS(1371), 1,
      anon_sym_DQUOTE,
    STATE(521), 1,
      aux_sym_quoted_string_literal_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19183] = 5,
    ACTIONS(1301), 1,
      sym_backticked_identifier_fragment,
    ACTIONS(1303), 1,
      sym_escape_sequence,
    ACTIONS(1373), 1,
      anon_sym_BQUOTE,
    STATE(516), 1,
      aux_sym_backticked_identifier_repeat1,
    ACTIONS(1229), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19200] = 4,
    ACTIONS(1375), 1,
      anon_sym_LBRACE,
    ACTIONS(1377), 1,
      anon_sym_COMMA,
    STATE(550), 1,
      aux_sym_reference_expression_list_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19214] = 4,
    ACTIONS(1380), 1,
      anon_sym_SEMI,
    ACTIONS(1382), 1,
      anon_sym_LBRACE,
    STATE(467), 1,
      sym_namespace_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19228] = 4,
    ACTIONS(1208), 1,
      anon_sym_extends,
    ACTIONS(1384), 1,
      anon_sym_SEMI,
    STATE(634), 1,
      sym_scalar_extends,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19242] = 4,
    ACTIONS(1145), 1,
      anon_sym_AMP,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1386), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19256] = 4,
    ACTIONS(1388), 1,
      anon_sym_COMMA,
    ACTIONS(1390), 1,
      anon_sym_GT,
    STATE(567), 1,
      aux_sym_template_parameter_list_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19270] = 4,
    ACTIONS(1143), 1,
      anon_sym_LT,
    ACTIONS(1392), 1,
      anon_sym_EQ,
    STATE(629), 1,
      sym_template_parameters,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19284] = 4,
    ACTIONS(1394), 1,
      anon_sym_SEMI,
    ACTIONS(1396), 1,
      anon_sym_LBRACE,
    STATE(377), 1,
      sym_namespace_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19298] = 4,
    ACTIONS(1145), 1,
      anon_sym_AMP,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1398), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19312] = 4,
    ACTIONS(1145), 1,
      anon_sym_AMP,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1400), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19326] = 4,
    ACTIONS(1208), 1,
      anon_sym_extends,
    ACTIONS(1402), 1,
      anon_sym_SEMI,
    STATE(672), 1,
      sym_scalar_extends,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19340] = 4,
    ACTIONS(1404), 1,
      anon_sym_COMMA,
    ACTIONS(1407), 1,
      anon_sym_GT,
    STATE(560), 1,
      aux_sym_template_parameter_list_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19354] = 4,
    ACTIONS(1396), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      anon_sym_SEMI,
    STATE(382), 1,
      sym_namespace_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19368] = 4,
    ACTIONS(1208), 1,
      anon_sym_extends,
    ACTIONS(1411), 1,
      anon_sym_SEMI,
    STATE(646), 1,
      sym_scalar_extends,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19382] = 4,
    ACTIONS(1145), 1,
      anon_sym_AMP,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1413), 1,
      anon_sym_LBRACE,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19396] = 4,
    ACTIONS(1145), 1,
      anon_sym_AMP,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1415), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19410] = 4,
    ACTIONS(1382), 1,
      anon_sym_LBRACE,
    ACTIONS(1417), 1,
      anon_sym_SEMI,
    STATE(465), 1,
      sym_namespace_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19424] = 4,
    ACTIONS(1145), 1,
      anon_sym_AMP,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1419), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19438] = 4,
    ACTIONS(1388), 1,
      anon_sym_COMMA,
    ACTIONS(1421), 1,
      anon_sym_GT,
    STATE(560), 1,
      aux_sym_template_parameter_list_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19452] = 4,
    ACTIONS(1143), 1,
      anon_sym_LT,
    ACTIONS(1423), 1,
      anon_sym_EQ,
    STATE(677), 1,
      sym_template_parameters,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19466] = 4,
    ACTIONS(1425), 1,
      anon_sym_LBRACE,
    ACTIONS(1427), 1,
      anon_sym_COMMA,
    STATE(574), 1,
      aux_sym_reference_expression_list_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19480] = 4,
    ACTIONS(1208), 1,
      anon_sym_extends,
    ACTIONS(1429), 1,
      anon_sym_SEMI,
    STATE(620), 1,
      sym_scalar_extends,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19494] = 4,
    ACTIONS(1145), 1,
      anon_sym_AMP,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1431), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19508] = 4,
    ACTIONS(1145), 1,
      anon_sym_AMP,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1433), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19522] = 4,
    ACTIONS(1145), 1,
      anon_sym_AMP,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1435), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19536] = 4,
    ACTIONS(686), 1,
      anon_sym_LBRACE,
    ACTIONS(1437), 1,
      anon_sym_COMMA,
    STATE(550), 1,
      aux_sym_reference_expression_list_repeat1,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19550] = 4,
    ACTIONS(1145), 1,
      anon_sym_AMP,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1439), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19564] = 4,
    ACTIONS(1145), 1,
      anon_sym_AMP,
    ACTIONS(1164), 1,
      anon_sym_PIPE,
    ACTIONS(1441), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19578] = 3,
    ACTIONS(1443), 1,
      anon_sym_LPAREN,
    STATE(444), 1,
      sym_function_parameter_list,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19589] = 3,
    ACTIONS(1321), 1,
      anon_sym_LBRACE,
    STATE(434), 1,
      sym_union_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19600] = 3,
    ACTIONS(1445), 1,
      anon_sym_SEMI,
    ACTIONS(1447), 1,
      anon_sym_LBRACE,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19611] = 3,
    ACTIONS(1447), 1,
      anon_sym_LBRACE,
    ACTIONS(1449), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19622] = 3,
    ACTIONS(160), 1,
      anon_sym_LBRACE,
    STATE(460), 1,
      sym_model_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19633] = 3,
    ACTIONS(1447), 1,
      anon_sym_LBRACE,
    ACTIONS(1451), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19644] = 3,
    ACTIONS(1204), 1,
      anon_sym_LBRACE,
    STATE(417), 1,
      sym_interface_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19655] = 2,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1453), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [19664] = 2,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1407), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [19673] = 3,
    ACTIONS(216), 1,
      anon_sym_LBRACE,
    STATE(393), 1,
      sym_model_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19684] = 3,
    ACTIONS(1204), 1,
      anon_sym_LBRACE,
    STATE(398), 1,
      sym_interface_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19695] = 3,
    ACTIONS(1455), 1,
      anon_sym_LBRACE,
    STATE(406), 1,
      sym_enum_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19706] = 3,
    ACTIONS(216), 1,
      anon_sym_LBRACE,
    STATE(422), 1,
      sym_model_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19717] = 3,
    ACTIONS(1447), 1,
      anon_sym_LBRACE,
    ACTIONS(1457), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19728] = 3,
    ACTIONS(1459), 1,
      anon_sym_LPAREN,
    STATE(407), 1,
      sym_function_parameter_list,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19739] = 3,
    ACTIONS(1359), 1,
      anon_sym_LBRACE,
    STATE(423), 1,
      sym_union_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19750] = 2,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1461), 2,
      anon_sym_COMMA,
      anon_sym_GT,
  [19759] = 3,
    ACTIONS(1459), 1,
      anon_sym_LPAREN,
    STATE(363), 1,
      sym_function_parameter_list,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19770] = 3,
    ACTIONS(1463), 1,
      anon_sym_QMARK,
    ACTIONS(1465), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19781] = 3,
    ACTIONS(1443), 1,
      anon_sym_LPAREN,
    STATE(454), 1,
      sym_function_parameter_list,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19792] = 2,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
    ACTIONS(1375), 2,
      anon_sym_LBRACE,
      anon_sym_COMMA,
  [19801] = 3,
    ACTIONS(1321), 1,
      anon_sym_LBRACE,
    STATE(447), 1,
      sym_union_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19812] = 3,
    ACTIONS(1447), 1,
      anon_sym_LBRACE,
    ACTIONS(1467), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19823] = 3,
    ACTIONS(1359), 1,
      anon_sym_LBRACE,
    STATE(395), 1,
      sym_union_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19834] = 3,
    ACTIONS(216), 1,
      anon_sym_LBRACE,
    STATE(429), 1,
      sym_model_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19845] = 3,
    ACTIONS(1447), 1,
      anon_sym_LBRACE,
    ACTIONS(1469), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19856] = 3,
    ACTIONS(216), 1,
      anon_sym_LBRACE,
    STATE(413), 1,
      sym_model_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19867] = 3,
    ACTIONS(160), 1,
      anon_sym_LBRACE,
    STATE(445), 1,
      sym_model_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19878] = 3,
    ACTIONS(1471), 1,
      anon_sym_dec,
    ACTIONS(1473), 1,
      anon_sym_fn,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19889] = 3,
    ACTIONS(1475), 1,
      anon_sym_LBRACE,
    STATE(441), 1,
      sym_enum_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19900] = 3,
    ACTIONS(1180), 1,
      anon_sym_LBRACE,
    STATE(401), 1,
      sym_interface_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19911] = 3,
    ACTIONS(1447), 1,
      anon_sym_LBRACE,
    ACTIONS(1477), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19922] = 3,
    ACTIONS(160), 1,
      anon_sym_LBRACE,
    STATE(452), 1,
      sym_model_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19933] = 3,
    ACTIONS(1479), 1,
      anon_sym_QMARK,
    ACTIONS(1481), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19944] = 3,
    ACTIONS(1443), 1,
      anon_sym_LPAREN,
    STATE(359), 1,
      sym_function_parameter_list,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19955] = 3,
    ACTIONS(1459), 1,
      anon_sym_LPAREN,
    STATE(371), 1,
      sym_function_parameter_list,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19966] = 3,
    ACTIONS(1459), 1,
      anon_sym_LPAREN,
    STATE(389), 1,
      sym_function_parameter_list,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19977] = 3,
    ACTIONS(1455), 1,
      anon_sym_LBRACE,
    STATE(387), 1,
      sym_enum_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19988] = 3,
    ACTIONS(1443), 1,
      anon_sym_LPAREN,
    STATE(361), 1,
      sym_function_parameter_list,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [19999] = 3,
    ACTIONS(1475), 1,
      anon_sym_LBRACE,
    STATE(439), 1,
      sym_enum_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20010] = 3,
    ACTIONS(1180), 1,
      anon_sym_LBRACE,
    STATE(392), 1,
      sym_interface_body,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20021] = 3,
    ACTIONS(160), 1,
      anon_sym_LBRACE,
    STATE(438), 1,
      sym_model_expression,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20032] = 3,
    ACTIONS(1447), 1,
      anon_sym_LBRACE,
    ACTIONS(1483), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20043] = 2,
    ACTIONS(1485), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20051] = 2,
    ACTIONS(1384), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20059] = 2,
    ACTIONS(1487), 1,
      anon_sym_LBRACE,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20067] = 2,
    ACTIONS(1489), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20075] = 2,
    ACTIONS(1491), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20083] = 2,
    ACTIONS(1493), 1,
      anon_sym_GT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20091] = 2,
    ACTIONS(1411), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20099] = 2,
    ACTIONS(1495), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20107] = 2,
    ACTIONS(1497), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20115] = 2,
    ACTIONS(1499), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20123] = 2,
    ACTIONS(1501), 1,
      anon_sym_fn,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20131] = 2,
    ACTIONS(1503), 1,
      anon_sym_dec,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20139] = 2,
    ACTIONS(1505), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20147] = 2,
    ACTIONS(1507), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20155] = 2,
    ACTIONS(1509), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20163] = 2,
    ACTIONS(1511), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20171] = 2,
    ACTIONS(1513), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20179] = 2,
    ACTIONS(1515), 1,
      anon_sym_GT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20187] = 2,
    ACTIONS(1517), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20195] = 2,
    ACTIONS(1519), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20203] = 2,
    ACTIONS(1521), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20211] = 2,
    ACTIONS(1523), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20219] = 2,
    ACTIONS(1525), 1,
      anon_sym_GT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20227] = 2,
    ACTIONS(1527), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20235] = 2,
    ACTIONS(1529), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20243] = 2,
    ACTIONS(1531), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20251] = 2,
    ACTIONS(1533), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20259] = 2,
    ACTIONS(1535), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20267] = 2,
    ACTIONS(1537), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20275] = 2,
    ACTIONS(1539), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20283] = 2,
    ACTIONS(1541), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20291] = 2,
    ACTIONS(1543), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20299] = 2,
    ACTIONS(1545), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20307] = 2,
    ACTIONS(1547), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20315] = 2,
    ACTIONS(1549), 1,
      anon_sym_GT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20323] = 2,
    ACTIONS(1551), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20331] = 2,
    ACTIONS(1553), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20339] = 2,
    ACTIONS(1555), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20347] = 2,
    ACTIONS(1402), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20355] = 2,
    ACTIONS(1557), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20363] = 2,
    ACTIONS(1559), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20371] = 2,
    ACTIONS(1561), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20379] = 2,
    ACTIONS(1563), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20387] = 2,
    ACTIONS(1565), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20395] = 2,
    ACTIONS(1567), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20403] = 2,
    ACTIONS(1569), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20411] = 2,
    ACTIONS(1571), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20419] = 2,
    ACTIONS(1429), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20427] = 2,
    ACTIONS(1573), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20435] = 2,
    ACTIONS(1575), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20443] = 2,
    ACTIONS(1577), 1,
      anon_sym_GT,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20451] = 2,
    ACTIONS(1579), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20459] = 2,
    ACTIONS(1581), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20467] = 2,
    ACTIONS(1583), 1,
      anon_sym_dec,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20475] = 2,
    ACTIONS(1585), 1,
      anon_sym_fn,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20483] = 2,
    ACTIONS(1587), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20491] = 2,
    ACTIONS(1589), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20499] = 2,
    ACTIONS(1591), 1,
      anon_sym_EQ,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
  [20507] = 2,
    ACTIONS(1593), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_single_line_comment,
      sym_multi_line_comment,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(74)] = 0,
  [SMALL_STATE(75)] = 64,
  [SMALL_STATE(76)] = 128,
  [SMALL_STATE(77)] = 192,
  [SMALL_STATE(78)] = 260,
  [SMALL_STATE(79)] = 324,
  [SMALL_STATE(80)] = 386,
  [SMALL_STATE(81)] = 448,
  [SMALL_STATE(82)] = 510,
  [SMALL_STATE(83)] = 572,
  [SMALL_STATE(84)] = 634,
  [SMALL_STATE(85)] = 696,
  [SMALL_STATE(86)] = 758,
  [SMALL_STATE(87)] = 820,
  [SMALL_STATE(88)] = 888,
  [SMALL_STATE(89)] = 950,
  [SMALL_STATE(90)] = 1018,
  [SMALL_STATE(91)] = 1080,
  [SMALL_STATE(92)] = 1144,
  [SMALL_STATE(93)] = 1206,
  [SMALL_STATE(94)] = 1268,
  [SMALL_STATE(95)] = 1333,
  [SMALL_STATE(96)] = 1398,
  [SMALL_STATE(97)] = 1459,
  [SMALL_STATE(98)] = 1524,
  [SMALL_STATE(99)] = 1585,
  [SMALL_STATE(100)] = 1646,
  [SMALL_STATE(101)] = 1707,
  [SMALL_STATE(102)] = 1767,
  [SMALL_STATE(103)] = 1852,
  [SMALL_STATE(104)] = 1937,
  [SMALL_STATE(105)] = 1996,
  [SMALL_STATE(106)] = 2057,
  [SMALL_STATE(107)] = 2142,
  [SMALL_STATE(108)] = 2225,
  [SMALL_STATE(109)] = 2310,
  [SMALL_STATE(110)] = 2371,
  [SMALL_STATE(111)] = 2451,
  [SMALL_STATE(112)] = 2515,
  [SMALL_STATE(113)] = 2579,
  [SMALL_STATE(114)] = 2659,
  [SMALL_STATE(115)] = 2739,
  [SMALL_STATE(116)] = 2803,
  [SMALL_STATE(117)] = 2863,
  [SMALL_STATE(118)] = 2927,
  [SMALL_STATE(119)] = 3009,
  [SMALL_STATE(120)] = 3089,
  [SMALL_STATE(121)] = 3153,
  [SMALL_STATE(122)] = 3213,
  [SMALL_STATE(123)] = 3295,
  [SMALL_STATE(124)] = 3375,
  [SMALL_STATE(125)] = 3457,
  [SMALL_STATE(126)] = 3521,
  [SMALL_STATE(127)] = 3582,
  [SMALL_STATE(128)] = 3639,
  [SMALL_STATE(129)] = 3696,
  [SMALL_STATE(130)] = 3753,
  [SMALL_STATE(131)] = 3814,
  [SMALL_STATE(132)] = 3871,
  [SMALL_STATE(133)] = 3927,
  [SMALL_STATE(134)] = 3983,
  [SMALL_STATE(135)] = 4043,
  [SMALL_STATE(136)] = 4103,
  [SMALL_STATE(137)] = 4163,
  [SMALL_STATE(138)] = 4219,
  [SMALL_STATE(139)] = 4275,
  [SMALL_STATE(140)] = 4331,
  [SMALL_STATE(141)] = 4387,
  [SMALL_STATE(142)] = 4447,
  [SMALL_STATE(143)] = 4502,
  [SMALL_STATE(144)] = 4557,
  [SMALL_STATE(145)] = 4612,
  [SMALL_STATE(146)] = 4667,
  [SMALL_STATE(147)] = 4725,
  [SMALL_STATE(148)] = 4779,
  [SMALL_STATE(149)] = 4832,
  [SMALL_STATE(150)] = 4885,
  [SMALL_STATE(151)] = 4938,
  [SMALL_STATE(152)] = 4991,
  [SMALL_STATE(153)] = 5043,
  [SMALL_STATE(154)] = 5113,
  [SMALL_STATE(155)] = 5165,
  [SMALL_STATE(156)] = 5217,
  [SMALL_STATE(157)] = 5287,
  [SMALL_STATE(158)] = 5357,
  [SMALL_STATE(159)] = 5411,
  [SMALL_STATE(160)] = 5481,
  [SMALL_STATE(161)] = 5533,
  [SMALL_STATE(162)] = 5603,
  [SMALL_STATE(163)] = 5655,
  [SMALL_STATE(164)] = 5707,
  [SMALL_STATE(165)] = 5759,
  [SMALL_STATE(166)] = 5811,
  [SMALL_STATE(167)] = 5868,
  [SMALL_STATE(168)] = 5919,
  [SMALL_STATE(169)] = 5972,
  [SMALL_STATE(170)] = 6029,
  [SMALL_STATE(171)] = 6086,
  [SMALL_STATE(172)] = 6139,
  [SMALL_STATE(173)] = 6190,
  [SMALL_STATE(174)] = 6241,
  [SMALL_STATE(175)] = 6298,
  [SMALL_STATE(176)] = 6349,
  [SMALL_STATE(177)] = 6405,
  [SMALL_STATE(178)] = 6461,
  [SMALL_STATE(179)] = 6520,
  [SMALL_STATE(180)] = 6579,
  [SMALL_STATE(181)] = 6639,
  [SMALL_STATE(182)] = 6699,
  [SMALL_STATE(183)] = 6761,
  [SMALL_STATE(184)] = 6809,
  [SMALL_STATE(185)] = 6895,
  [SMALL_STATE(186)] = 6945,
  [SMALL_STATE(187)] = 6995,
  [SMALL_STATE(188)] = 7081,
  [SMALL_STATE(189)] = 7141,
  [SMALL_STATE(190)] = 7201,
  [SMALL_STATE(191)] = 7263,
  [SMALL_STATE(192)] = 7325,
  [SMALL_STATE(193)] = 7385,
  [SMALL_STATE(194)] = 7440,
  [SMALL_STATE(195)] = 7499,
  [SMALL_STATE(196)] = 7546,
  [SMALL_STATE(197)] = 7593,
  [SMALL_STATE(198)] = 7652,
  [SMALL_STATE(199)] = 7711,
  [SMALL_STATE(200)] = 7766,
  [SMALL_STATE(201)] = 7813,
  [SMALL_STATE(202)] = 7872,
  [SMALL_STATE(203)] = 7919,
  [SMALL_STATE(204)] = 7966,
  [SMALL_STATE(205)] = 8013,
  [SMALL_STATE(206)] = 8065,
  [SMALL_STATE(207)] = 8121,
  [SMALL_STATE(208)] = 8177,
  [SMALL_STATE(209)] = 8223,
  [SMALL_STATE(210)] = 8279,
  [SMALL_STATE(211)] = 8329,
  [SMALL_STATE(212)] = 8375,
  [SMALL_STATE(213)] = 8425,
  [SMALL_STATE(214)] = 8511,
  [SMALL_STATE(215)] = 8597,
  [SMALL_STATE(216)] = 8647,
  [SMALL_STATE(217)] = 8697,
  [SMALL_STATE(218)] = 8747,
  [SMALL_STATE(219)] = 8797,
  [SMALL_STATE(220)] = 8853,
  [SMALL_STATE(221)] = 8899,
  [SMALL_STATE(222)] = 8945,
  [SMALL_STATE(223)] = 9001,
  [SMALL_STATE(224)] = 9057,
  [SMALL_STATE(225)] = 9143,
  [SMALL_STATE(226)] = 9229,
  [SMALL_STATE(227)] = 9281,
  [SMALL_STATE(228)] = 9367,
  [SMALL_STATE(229)] = 9417,
  [SMALL_STATE(230)] = 9473,
  [SMALL_STATE(231)] = 9529,
  [SMALL_STATE(232)] = 9585,
  [SMALL_STATE(233)] = 9631,
  [SMALL_STATE(234)] = 9687,
  [SMALL_STATE(235)] = 9743,
  [SMALL_STATE(236)] = 9799,
  [SMALL_STATE(237)] = 9855,
  [SMALL_STATE(238)] = 9904,
  [SMALL_STATE(239)] = 9953,
  [SMALL_STATE(240)] = 10002,
  [SMALL_STATE(241)] = 10055,
  [SMALL_STATE(242)] = 10100,
  [SMALL_STATE(243)] = 10145,
  [SMALL_STATE(244)] = 10198,
  [SMALL_STATE(245)] = 10243,
  [SMALL_STATE(246)] = 10288,
  [SMALL_STATE(247)] = 10333,
  [SMALL_STATE(248)] = 10377,
  [SMALL_STATE(249)] = 10427,
  [SMALL_STATE(250)] = 10477,
  [SMALL_STATE(251)] = 10527,
  [SMALL_STATE(252)] = 10577,
  [SMALL_STATE(253)] = 10627,
  [SMALL_STATE(254)] = 10677,
  [SMALL_STATE(255)] = 10721,
  [SMALL_STATE(256)] = 10771,
  [SMALL_STATE(257)] = 10821,
  [SMALL_STATE(258)] = 10871,
  [SMALL_STATE(259)] = 10921,
  [SMALL_STATE(260)] = 10971,
  [SMALL_STATE(261)] = 11017,
  [SMALL_STATE(262)] = 11067,
  [SMALL_STATE(263)] = 11117,
  [SMALL_STATE(264)] = 11167,
  [SMALL_STATE(265)] = 11217,
  [SMALL_STATE(266)] = 11267,
  [SMALL_STATE(267)] = 11311,
  [SMALL_STATE(268)] = 11361,
  [SMALL_STATE(269)] = 11407,
  [SMALL_STATE(270)] = 11457,
  [SMALL_STATE(271)] = 11503,
  [SMALL_STATE(272)] = 11553,
  [SMALL_STATE(273)] = 11603,
  [SMALL_STATE(274)] = 11653,
  [SMALL_STATE(275)] = 11703,
  [SMALL_STATE(276)] = 11753,
  [SMALL_STATE(277)] = 11797,
  [SMALL_STATE(278)] = 11847,
  [SMALL_STATE(279)] = 11897,
  [SMALL_STATE(280)] = 11947,
  [SMALL_STATE(281)] = 11997,
  [SMALL_STATE(282)] = 12047,
  [SMALL_STATE(283)] = 12097,
  [SMALL_STATE(284)] = 12147,
  [SMALL_STATE(285)] = 12191,
  [SMALL_STATE(286)] = 12241,
  [SMALL_STATE(287)] = 12285,
  [SMALL_STATE(288)] = 12335,
  [SMALL_STATE(289)] = 12385,
  [SMALL_STATE(290)] = 12435,
  [SMALL_STATE(291)] = 12485,
  [SMALL_STATE(292)] = 12535,
  [SMALL_STATE(293)] = 12585,
  [SMALL_STATE(294)] = 12635,
  [SMALL_STATE(295)] = 12685,
  [SMALL_STATE(296)] = 12735,
  [SMALL_STATE(297)] = 12781,
  [SMALL_STATE(298)] = 12825,
  [SMALL_STATE(299)] = 12868,
  [SMALL_STATE(300)] = 12911,
  [SMALL_STATE(301)] = 12954,
  [SMALL_STATE(302)] = 12997,
  [SMALL_STATE(303)] = 13040,
  [SMALL_STATE(304)] = 13083,
  [SMALL_STATE(305)] = 13126,
  [SMALL_STATE(306)] = 13169,
  [SMALL_STATE(307)] = 13212,
  [SMALL_STATE(308)] = 13254,
  [SMALL_STATE(309)] = 13296,
  [SMALL_STATE(310)] = 13338,
  [SMALL_STATE(311)] = 13380,
  [SMALL_STATE(312)] = 13423,
  [SMALL_STATE(313)] = 13466,
  [SMALL_STATE(314)] = 13509,
  [SMALL_STATE(315)] = 13547,
  [SMALL_STATE(316)] = 13584,
  [SMALL_STATE(317)] = 13619,
  [SMALL_STATE(318)] = 13654,
  [SMALL_STATE(319)] = 13689,
  [SMALL_STATE(320)] = 13719,
  [SMALL_STATE(321)] = 13749,
  [SMALL_STATE(322)] = 13779,
  [SMALL_STATE(323)] = 13809,
  [SMALL_STATE(324)] = 13839,
  [SMALL_STATE(325)] = 13868,
  [SMALL_STATE(326)] = 13903,
  [SMALL_STATE(327)] = 13936,
  [SMALL_STATE(328)] = 13967,
  [SMALL_STATE(329)] = 13994,
  [SMALL_STATE(330)] = 14021,
  [SMALL_STATE(331)] = 14048,
  [SMALL_STATE(332)] = 14077,
  [SMALL_STATE(333)] = 14104,
  [SMALL_STATE(334)] = 14133,
  [SMALL_STATE(335)] = 14160,
  [SMALL_STATE(336)] = 14187,
  [SMALL_STATE(337)] = 14216,
  [SMALL_STATE(338)] = 14245,
  [SMALL_STATE(339)] = 14274,
  [SMALL_STATE(340)] = 14303,
  [SMALL_STATE(341)] = 14332,
  [SMALL_STATE(342)] = 14359,
  [SMALL_STATE(343)] = 14386,
  [SMALL_STATE(344)] = 14413,
  [SMALL_STATE(345)] = 14442,
  [SMALL_STATE(346)] = 14471,
  [SMALL_STATE(347)] = 14500,
  [SMALL_STATE(348)] = 14529,
  [SMALL_STATE(349)] = 14558,
  [SMALL_STATE(350)] = 14585,
  [SMALL_STATE(351)] = 14612,
  [SMALL_STATE(352)] = 14639,
  [SMALL_STATE(353)] = 14668,
  [SMALL_STATE(354)] = 14696,
  [SMALL_STATE(355)] = 14724,
  [SMALL_STATE(356)] = 14754,
  [SMALL_STATE(357)] = 14786,
  [SMALL_STATE(358)] = 14818,
  [SMALL_STATE(359)] = 14846,
  [SMALL_STATE(360)] = 14876,
  [SMALL_STATE(361)] = 14906,
  [SMALL_STATE(362)] = 14936,
  [SMALL_STATE(363)] = 14964,
  [SMALL_STATE(364)] = 14996,
  [SMALL_STATE(365)] = 15026,
  [SMALL_STATE(366)] = 15052,
  [SMALL_STATE(367)] = 15078,
  [SMALL_STATE(368)] = 15104,
  [SMALL_STATE(369)] = 15134,
  [SMALL_STATE(370)] = 15160,
  [SMALL_STATE(371)] = 15188,
  [SMALL_STATE(372)] = 15220,
  [SMALL_STATE(373)] = 15248,
  [SMALL_STATE(374)] = 15275,
  [SMALL_STATE(375)] = 15302,
  [SMALL_STATE(376)] = 15327,
  [SMALL_STATE(377)] = 15352,
  [SMALL_STATE(378)] = 15378,
  [SMALL_STATE(379)] = 15402,
  [SMALL_STATE(380)] = 15426,
  [SMALL_STATE(381)] = 15452,
  [SMALL_STATE(382)] = 15478,
  [SMALL_STATE(383)] = 15504,
  [SMALL_STATE(384)] = 15530,
  [SMALL_STATE(385)] = 15556,
  [SMALL_STATE(386)] = 15582,
  [SMALL_STATE(387)] = 15608,
  [SMALL_STATE(388)] = 15634,
  [SMALL_STATE(389)] = 15660,
  [SMALL_STATE(390)] = 15686,
  [SMALL_STATE(391)] = 15710,
  [SMALL_STATE(392)] = 15736,
  [SMALL_STATE(393)] = 15760,
  [SMALL_STATE(394)] = 15786,
  [SMALL_STATE(395)] = 15812,
  [SMALL_STATE(396)] = 15838,
  [SMALL_STATE(397)] = 15864,
  [SMALL_STATE(398)] = 15890,
  [SMALL_STATE(399)] = 15916,
  [SMALL_STATE(400)] = 15942,
  [SMALL_STATE(401)] = 15968,
  [SMALL_STATE(402)] = 15992,
  [SMALL_STATE(403)] = 16018,
  [SMALL_STATE(404)] = 16044,
  [SMALL_STATE(405)] = 16070,
  [SMALL_STATE(406)] = 16096,
  [SMALL_STATE(407)] = 16122,
  [SMALL_STATE(408)] = 16148,
  [SMALL_STATE(409)] = 16172,
  [SMALL_STATE(410)] = 16196,
  [SMALL_STATE(411)] = 16220,
  [SMALL_STATE(412)] = 16246,
  [SMALL_STATE(413)] = 16270,
  [SMALL_STATE(414)] = 16296,
  [SMALL_STATE(415)] = 16322,
  [SMALL_STATE(416)] = 16348,
  [SMALL_STATE(417)] = 16374,
  [SMALL_STATE(418)] = 16400,
  [SMALL_STATE(419)] = 16426,
  [SMALL_STATE(420)] = 16452,
  [SMALL_STATE(421)] = 16478,
  [SMALL_STATE(422)] = 16502,
  [SMALL_STATE(423)] = 16528,
  [SMALL_STATE(424)] = 16554,
  [SMALL_STATE(425)] = 16580,
  [SMALL_STATE(426)] = 16606,
  [SMALL_STATE(427)] = 16632,
  [SMALL_STATE(428)] = 16656,
  [SMALL_STATE(429)] = 16682,
  [SMALL_STATE(430)] = 16708,
  [SMALL_STATE(431)] = 16734,
  [SMALL_STATE(432)] = 16760,
  [SMALL_STATE(433)] = 16784,
  [SMALL_STATE(434)] = 16808,
  [SMALL_STATE(435)] = 16832,
  [SMALL_STATE(436)] = 16856,
  [SMALL_STATE(437)] = 16880,
  [SMALL_STATE(438)] = 16904,
  [SMALL_STATE(439)] = 16928,
  [SMALL_STATE(440)] = 16952,
  [SMALL_STATE(441)] = 16976,
  [SMALL_STATE(442)] = 17000,
  [SMALL_STATE(443)] = 17024,
  [SMALL_STATE(444)] = 17048,
  [SMALL_STATE(445)] = 17072,
  [SMALL_STATE(446)] = 17096,
  [SMALL_STATE(447)] = 17120,
  [SMALL_STATE(448)] = 17144,
  [SMALL_STATE(449)] = 17168,
  [SMALL_STATE(450)] = 17192,
  [SMALL_STATE(451)] = 17216,
  [SMALL_STATE(452)] = 17240,
  [SMALL_STATE(453)] = 17264,
  [SMALL_STATE(454)] = 17290,
  [SMALL_STATE(455)] = 17314,
  [SMALL_STATE(456)] = 17338,
  [SMALL_STATE(457)] = 17364,
  [SMALL_STATE(458)] = 17388,
  [SMALL_STATE(459)] = 17412,
  [SMALL_STATE(460)] = 17436,
  [SMALL_STATE(461)] = 17460,
  [SMALL_STATE(462)] = 17484,
  [SMALL_STATE(463)] = 17508,
  [SMALL_STATE(464)] = 17532,
  [SMALL_STATE(465)] = 17556,
  [SMALL_STATE(466)] = 17580,
  [SMALL_STATE(467)] = 17604,
  [SMALL_STATE(468)] = 17628,
  [SMALL_STATE(469)] = 17652,
  [SMALL_STATE(470)] = 17682,
  [SMALL_STATE(471)] = 17700,
  [SMALL_STATE(472)] = 17720,
  [SMALL_STATE(473)] = 17744,
  [SMALL_STATE(474)] = 17774,
  [SMALL_STATE(475)] = 17794,
  [SMALL_STATE(476)] = 17814,
  [SMALL_STATE(477)] = 17832,
  [SMALL_STATE(478)] = 17862,
  [SMALL_STATE(479)] = 17892,
  [SMALL_STATE(480)] = 17917,
  [SMALL_STATE(481)] = 17942,
  [SMALL_STATE(482)] = 17967,
  [SMALL_STATE(483)] = 17992,
  [SMALL_STATE(484)] = 18014,
  [SMALL_STATE(485)] = 18028,
  [SMALL_STATE(486)] = 18052,
  [SMALL_STATE(487)] = 18076,
  [SMALL_STATE(488)] = 18100,
  [SMALL_STATE(489)] = 18124,
  [SMALL_STATE(490)] = 18143,
  [SMALL_STATE(491)] = 18166,
  [SMALL_STATE(492)] = 18185,
  [SMALL_STATE(493)] = 18204,
  [SMALL_STATE(494)] = 18217,
  [SMALL_STATE(495)] = 18236,
  [SMALL_STATE(496)] = 18259,
  [SMALL_STATE(497)] = 18282,
  [SMALL_STATE(498)] = 18301,
  [SMALL_STATE(499)] = 18320,
  [SMALL_STATE(500)] = 18337,
  [SMALL_STATE(501)] = 18356,
  [SMALL_STATE(502)] = 18377,
  [SMALL_STATE(503)] = 18400,
  [SMALL_STATE(504)] = 18416,
  [SMALL_STATE(505)] = 18436,
  [SMALL_STATE(506)] = 18452,
  [SMALL_STATE(507)] = 18472,
  [SMALL_STATE(508)] = 18488,
  [SMALL_STATE(509)] = 18504,
  [SMALL_STATE(510)] = 18524,
  [SMALL_STATE(511)] = 18540,
  [SMALL_STATE(512)] = 18560,
  [SMALL_STATE(513)] = 18577,
  [SMALL_STATE(514)] = 18594,
  [SMALL_STATE(515)] = 18611,
  [SMALL_STATE(516)] = 18628,
  [SMALL_STATE(517)] = 18645,
  [SMALL_STATE(518)] = 18662,
  [SMALL_STATE(519)] = 18677,
  [SMALL_STATE(520)] = 18694,
  [SMALL_STATE(521)] = 18711,
  [SMALL_STATE(522)] = 18728,
  [SMALL_STATE(523)] = 18745,
  [SMALL_STATE(524)] = 18762,
  [SMALL_STATE(525)] = 18779,
  [SMALL_STATE(526)] = 18796,
  [SMALL_STATE(527)] = 18813,
  [SMALL_STATE(528)] = 18830,
  [SMALL_STATE(529)] = 18847,
  [SMALL_STATE(530)] = 18864,
  [SMALL_STATE(531)] = 18879,
  [SMALL_STATE(532)] = 18896,
  [SMALL_STATE(533)] = 18913,
  [SMALL_STATE(534)] = 18930,
  [SMALL_STATE(535)] = 18947,
  [SMALL_STATE(536)] = 18964,
  [SMALL_STATE(537)] = 18981,
  [SMALL_STATE(538)] = 18996,
  [SMALL_STATE(539)] = 19013,
  [SMALL_STATE(540)] = 19030,
  [SMALL_STATE(541)] = 19047,
  [SMALL_STATE(542)] = 19064,
  [SMALL_STATE(543)] = 19081,
  [SMALL_STATE(544)] = 19098,
  [SMALL_STATE(545)] = 19115,
  [SMALL_STATE(546)] = 19132,
  [SMALL_STATE(547)] = 19149,
  [SMALL_STATE(548)] = 19166,
  [SMALL_STATE(549)] = 19183,
  [SMALL_STATE(550)] = 19200,
  [SMALL_STATE(551)] = 19214,
  [SMALL_STATE(552)] = 19228,
  [SMALL_STATE(553)] = 19242,
  [SMALL_STATE(554)] = 19256,
  [SMALL_STATE(555)] = 19270,
  [SMALL_STATE(556)] = 19284,
  [SMALL_STATE(557)] = 19298,
  [SMALL_STATE(558)] = 19312,
  [SMALL_STATE(559)] = 19326,
  [SMALL_STATE(560)] = 19340,
  [SMALL_STATE(561)] = 19354,
  [SMALL_STATE(562)] = 19368,
  [SMALL_STATE(563)] = 19382,
  [SMALL_STATE(564)] = 19396,
  [SMALL_STATE(565)] = 19410,
  [SMALL_STATE(566)] = 19424,
  [SMALL_STATE(567)] = 19438,
  [SMALL_STATE(568)] = 19452,
  [SMALL_STATE(569)] = 19466,
  [SMALL_STATE(570)] = 19480,
  [SMALL_STATE(571)] = 19494,
  [SMALL_STATE(572)] = 19508,
  [SMALL_STATE(573)] = 19522,
  [SMALL_STATE(574)] = 19536,
  [SMALL_STATE(575)] = 19550,
  [SMALL_STATE(576)] = 19564,
  [SMALL_STATE(577)] = 19578,
  [SMALL_STATE(578)] = 19589,
  [SMALL_STATE(579)] = 19600,
  [SMALL_STATE(580)] = 19611,
  [SMALL_STATE(581)] = 19622,
  [SMALL_STATE(582)] = 19633,
  [SMALL_STATE(583)] = 19644,
  [SMALL_STATE(584)] = 19655,
  [SMALL_STATE(585)] = 19664,
  [SMALL_STATE(586)] = 19673,
  [SMALL_STATE(587)] = 19684,
  [SMALL_STATE(588)] = 19695,
  [SMALL_STATE(589)] = 19706,
  [SMALL_STATE(590)] = 19717,
  [SMALL_STATE(591)] = 19728,
  [SMALL_STATE(592)] = 19739,
  [SMALL_STATE(593)] = 19750,
  [SMALL_STATE(594)] = 19759,
  [SMALL_STATE(595)] = 19770,
  [SMALL_STATE(596)] = 19781,
  [SMALL_STATE(597)] = 19792,
  [SMALL_STATE(598)] = 19801,
  [SMALL_STATE(599)] = 19812,
  [SMALL_STATE(600)] = 19823,
  [SMALL_STATE(601)] = 19834,
  [SMALL_STATE(602)] = 19845,
  [SMALL_STATE(603)] = 19856,
  [SMALL_STATE(604)] = 19867,
  [SMALL_STATE(605)] = 19878,
  [SMALL_STATE(606)] = 19889,
  [SMALL_STATE(607)] = 19900,
  [SMALL_STATE(608)] = 19911,
  [SMALL_STATE(609)] = 19922,
  [SMALL_STATE(610)] = 19933,
  [SMALL_STATE(611)] = 19944,
  [SMALL_STATE(612)] = 19955,
  [SMALL_STATE(613)] = 19966,
  [SMALL_STATE(614)] = 19977,
  [SMALL_STATE(615)] = 19988,
  [SMALL_STATE(616)] = 19999,
  [SMALL_STATE(617)] = 20010,
  [SMALL_STATE(618)] = 20021,
  [SMALL_STATE(619)] = 20032,
  [SMALL_STATE(620)] = 20043,
  [SMALL_STATE(621)] = 20051,
  [SMALL_STATE(622)] = 20059,
  [SMALL_STATE(623)] = 20067,
  [SMALL_STATE(624)] = 20075,
  [SMALL_STATE(625)] = 20083,
  [SMALL_STATE(626)] = 20091,
  [SMALL_STATE(627)] = 20099,
  [SMALL_STATE(628)] = 20107,
  [SMALL_STATE(629)] = 20115,
  [SMALL_STATE(630)] = 20123,
  [SMALL_STATE(631)] = 20131,
  [SMALL_STATE(632)] = 20139,
  [SMALL_STATE(633)] = 20147,
  [SMALL_STATE(634)] = 20155,
  [SMALL_STATE(635)] = 20163,
  [SMALL_STATE(636)] = 20171,
  [SMALL_STATE(637)] = 20179,
  [SMALL_STATE(638)] = 20187,
  [SMALL_STATE(639)] = 20195,
  [SMALL_STATE(640)] = 20203,
  [SMALL_STATE(641)] = 20211,
  [SMALL_STATE(642)] = 20219,
  [SMALL_STATE(643)] = 20227,
  [SMALL_STATE(644)] = 20235,
  [SMALL_STATE(645)] = 20243,
  [SMALL_STATE(646)] = 20251,
  [SMALL_STATE(647)] = 20259,
  [SMALL_STATE(648)] = 20267,
  [SMALL_STATE(649)] = 20275,
  [SMALL_STATE(650)] = 20283,
  [SMALL_STATE(651)] = 20291,
  [SMALL_STATE(652)] = 20299,
  [SMALL_STATE(653)] = 20307,
  [SMALL_STATE(654)] = 20315,
  [SMALL_STATE(655)] = 20323,
  [SMALL_STATE(656)] = 20331,
  [SMALL_STATE(657)] = 20339,
  [SMALL_STATE(658)] = 20347,
  [SMALL_STATE(659)] = 20355,
  [SMALL_STATE(660)] = 20363,
  [SMALL_STATE(661)] = 20371,
  [SMALL_STATE(662)] = 20379,
  [SMALL_STATE(663)] = 20387,
  [SMALL_STATE(664)] = 20395,
  [SMALL_STATE(665)] = 20403,
  [SMALL_STATE(666)] = 20411,
  [SMALL_STATE(667)] = 20419,
  [SMALL_STATE(668)] = 20427,
  [SMALL_STATE(669)] = 20435,
  [SMALL_STATE(670)] = 20443,
  [SMALL_STATE(671)] = 20451,
  [SMALL_STATE(672)] = 20459,
  [SMALL_STATE(673)] = 20467,
  [SMALL_STATE(674)] = 20475,
  [SMALL_STATE(675)] = 20483,
  [SMALL_STATE(676)] = 20491,
  [SMALL_STATE(677)] = 20499,
  [SMALL_STATE(678)] = 20507,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0, 0, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(207),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(503),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(605),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(91),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(523),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [75] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0), SHIFT_REPEAT(230),
  [78] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0), SHIFT_REPEAT(39),
  [81] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0), SHIFT_REPEAT(108),
  [84] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0),
  [86] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0), SHIFT_REPEAT(49),
  [89] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0), SHIFT_REPEAT(46),
  [92] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0), SHIFT_REPEAT(22),
  [95] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0), SHIFT_REPEAT(9),
  [98] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0), SHIFT_REPEAT(98),
  [101] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0), SHIFT_REPEAT(96),
  [104] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0), SHIFT_REPEAT(515),
  [107] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0), SHIFT_REPEAT(92),
  [110] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0), SHIFT_REPEAT(91),
  [113] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0), SHIFT_REPEAT(91),
  [116] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0), SHIFT_REPEAT(523),
  [119] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0), SHIFT_REPEAT(525),
  [122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [124] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression_list, 2, 0, 0),
  [126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [130] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [132] = {.entry = {.count = 1, .reusable = false}}, SHIFT(309),
  [134] = {.entry = {.count = 1, .reusable = false}}, SHIFT(307),
  [136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(536),
  [138] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression_list, 3, 0, 0),
  [140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [144] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [166] = {.entry = {.count = 1, .reusable = false}}, SHIFT(32),
  [168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [170] = {.entry = {.count = 1, .reusable = false}}, SHIFT(321),
  [172] = {.entry = {.count = 1, .reusable = false}}, SHIFT(320),
  [174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [176] = {.entry = {.count = 1, .reusable = false}}, SHIFT(332),
  [178] = {.entry = {.count = 1, .reusable = false}}, SHIFT(331),
  [180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [182] = {.entry = {.count = 1, .reusable = false}}, SHIFT(514),
  [184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [194] = {.entry = {.count = 1, .reusable = false}}, SHIFT(73),
  [196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [198] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [200] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(533),
  [204] = {.entry = {.count = 1, .reusable = false}}, SHIFT(162),
  [206] = {.entry = {.count = 1, .reusable = false}}, SHIFT(158),
  [208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [210] = {.entry = {.count = 1, .reusable = false}}, SHIFT(512),
  [212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(534),
  [214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [222] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [226] = {.entry = {.count = 1, .reusable = false}}, SHIFT(346),
  [228] = {.entry = {.count = 1, .reusable = false}}, SHIFT(327),
  [230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [232] = {.entry = {.count = 1, .reusable = false}}, SHIFT(535),
  [234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [236] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_triple_quoted_string_literal, 3, 0, 0),
  [238] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_triple_quoted_string_literal, 3, 0, 0),
  [240] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_string_literal, 2, 0, 0),
  [242] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoted_string_literal, 2, 0, 0),
  [244] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_triple_quoted_string_literal, 2, 0, 0),
  [246] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_triple_quoted_string_literal, 2, 0, 0),
  [248] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_reference_expression, 1, 0, 0),
  [250] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_reference_expression, 1, 0, 0),
  [252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_string_literal, 3, 0, 0),
  [256] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoted_string_literal, 3, 0, 0),
  [258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_expression, 2, 0, 0),
  [260] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_expression, 2, 0, 0),
  [262] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_intersection_expression, 2, 0, 0),
  [264] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_intersection_expression, 2, 0, 0),
  [266] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_of_expression, 2, 0, 0),
  [268] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_of_expression, 2, 0, 0),
  [270] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_expression, 2, 0, 0),
  [272] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_model_expression, 2, 0, 0),
  [274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array_expression, 3, 0, 0),
  [276] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array_expression, 3, 0, 0),
  [278] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_arguments, 3, 0, 0),
  [280] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_template_arguments, 3, 0, 0),
  [282] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_intersection_expression, 3, 0, 0),
  [284] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_intersection_expression, 3, 0, 0),
  [286] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3, 0, 0),
  [288] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3, 0, 0),
  [290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_identifier_or_member_expression, 1, 0, 0),
  [292] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_identifier_or_member_expression, 1, 0, 0),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [298] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_expression, 3, 0, 0),
  [300] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_model_expression, 3, 0, 0),
  [302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [304] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_expression, 3, 0, 0),
  [306] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_expression, 3, 0, 0),
  [308] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1, 0, 0),
  [310] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1, 0, 0),
  [312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(661),
  [314] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean_literal, 1, 0, 0),
  [316] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean_literal, 1, 0, 0),
  [318] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_reference_expression, 2, 0, 0),
  [320] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_reference_expression, 2, 0, 0),
  [322] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member_expression, 2, 0, 2),
  [324] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member_expression, 2, 0, 2),
  [326] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_member_expression_repeat1, 2, 0, 5),
  [328] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_member_expression_repeat1, 2, 0, 5),
  [330] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_member_expression_repeat1, 2, 0, 5), SHIFT_REPEAT(285),
  [333] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_identifier, 1, 0, 0),
  [335] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_identifier, 1, 0, 0),
  [337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_builtin_type, 1, 0, 0),
  [339] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_builtin_type, 1, 0, 0),
  [341] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_backticked_identifier, 3, 0, 0),
  [343] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_backticked_identifier, 3, 0, 0),
  [345] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_backticked_identifier, 2, 0, 0),
  [347] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_backticked_identifier, 2, 0, 0),
  [349] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_member_expression_repeat1, 2, 0, 4),
  [351] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_member_expression_repeat1, 2, 0, 4),
  [353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [361] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__literal, 1, 0, 0),
  [363] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__literal, 1, 0, 0),
  [365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [369] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_model_body_repeat1, 2, 0, 0), SHIFT_REPEAT(219),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_model_body_repeat1, 2, 0, 0),
  [374] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_model_body_repeat1, 2, 0, 0), SHIFT_REPEAT(194),
  [377] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_model_body_repeat1, 2, 0, 0), SHIFT_REPEAT(309),
  [380] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_model_body_repeat1, 2, 0, 0), SHIFT_REPEAT(307),
  [383] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_model_body_repeat1, 2, 0, 0), SHIFT_REPEAT(536),
  [386] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_model_body_repeat1, 2, 0, 0), SHIFT_REPEAT(523),
  [389] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_model_body_repeat1, 2, 0, 0), SHIFT_REPEAT(525),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [402] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_variant, 1, 0, 0),
  [404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [408] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_variant, 1, 0, 0),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [412] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_variant, 3, 0, 6),
  [414] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_variant, 3, 0, 6),
  [416] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_body_repeat1, 2, 0, 0), SHIFT_REPEAT(219),
  [419] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_body_repeat1, 2, 0, 0),
  [421] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_body_repeat1, 2, 0, 0), SHIFT_REPEAT(197),
  [424] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_enum_body_repeat1, 2, 0, 0), SHIFT_REPEAT(128),
  [427] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_enum_body_repeat1, 2, 0, 0), SHIFT_REPEAT(127),
  [430] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_body_repeat1, 2, 0, 0), SHIFT_REPEAT(533),
  [433] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_enum_body_repeat1, 2, 0, 0), SHIFT_REPEAT(512),
  [436] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_body_repeat1, 2, 0, 0), SHIFT_REPEAT(534),
  [439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [443] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_variant, 2, 0, 0),
  [445] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_variant, 2, 0, 0),
  [447] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_expression, 2, 0, 0),
  [449] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_expression, 2, 0, 0),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [453] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_variant, 3, 0, 0),
  [455] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_variant, 3, 0, 0),
  [457] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_body, 1, 0, 0),
  [459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [463] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_variant, 4, 0, 1),
  [465] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_variant, 4, 0, 1),
  [467] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_expression, 3, 0, 0),
  [469] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_expression, 3, 0, 0),
  [471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(648),
  [473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(650),
  [477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [479] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_variant, 4, 0, 0),
  [481] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_variant, 4, 0, 0),
  [483] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_decorator_list, 1, 0, 0),
  [485] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_decorator_list, 1, 0, 0),
  [487] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_decorator_list_repeat1, 2, 0, 0), SHIFT_REPEAT(230),
  [490] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_decorator_list_repeat1, 2, 0, 0),
  [492] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_decorator_list_repeat1, 2, 0, 0),
  [494] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_variant, 4, 0, 6),
  [496] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_variant, 4, 0, 6),
  [498] = {.entry = {.count = 1, .reusable = false}}, SHIFT(274),
  [500] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_decorator, 2, 0, 1),
  [502] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [504] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_decorator, 2, 0, 1),
  [506] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_variant, 5, 0, 1),
  [508] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_variant, 5, 0, 1),
  [510] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_variant, 5, 0, 0),
  [512] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_variant, 5, 0, 0),
  [514] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_member_expression_repeat1, 2, 0, 5), SHIFT_REPEAT(274),
  [517] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_decorator_arguments, 3, 0, 0),
  [519] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_decorator_arguments, 3, 0, 0),
  [521] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_decorator, 3, 0, 1),
  [523] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_decorator, 3, 0, 1),
  [525] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_decorator_arguments, 2, 0, 0),
  [527] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_decorator_arguments, 2, 0, 0),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [531] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_interface_body_repeat1, 2, 0, 0), SHIFT_REPEAT(231),
  [534] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_interface_body_repeat1, 2, 0, 0),
  [536] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_interface_body_repeat1, 2, 0, 0), SHIFT_REPEAT(290),
  [539] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_interface_body_repeat1, 2, 0, 0), SHIFT_REPEAT(309),
  [542] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_interface_body_repeat1, 2, 0, 0), SHIFT_REPEAT(307),
  [545] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_interface_body_repeat1, 2, 0, 0), SHIFT_REPEAT(536),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [552] = {.entry = {.count = 1, .reusable = false}}, SHIFT(290),
  [554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(624),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [564] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_property, 4, 0, 1),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [570] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_model_property, 4, 0, 1),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [574] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_property, 3, 0, 6),
  [576] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_model_property, 3, 0, 6),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [580] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_property, 4, 0, 6),
  [582] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_model_property, 4, 0, 6),
  [584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [586] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_property, 5, 0, 1),
  [588] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_model_property, 5, 0, 1),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [592] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_member, 1, 0, 6),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [596] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_member, 1, 0, 6),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [600] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_member, 2, 0, 1),
  [602] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_member, 2, 0, 1),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [610] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_reference_expression_list, 3, 0, 0),
  [612] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_member_value, 2, 0, 0),
  [614] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_member_value, 2, 0, 0),
  [616] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1, 0, 0),
  [618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [620] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [622] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_member, 3, 0, 1),
  [624] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_member, 3, 0, 1),
  [626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [628] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_member, 2, 0, 6),
  [630] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_member, 2, 0, 6),
  [632] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0),
  [634] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(187),
  [637] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(207),
  [640] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(503),
  [643] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(209),
  [646] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(229),
  [649] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(271),
  [652] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(281),
  [655] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(282),
  [658] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(283),
  [661] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(248),
  [664] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(292),
  [667] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(294),
  [670] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(206),
  [673] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(295),
  [676] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(605),
  [679] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(287),
  [682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [686] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_reference_expression_list, 2, 0, 0),
  [688] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_parameter_list_repeat1, 2, 0, 0),
  [690] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_parameter_list_repeat1, 2, 0, 0), SHIFT_REPEAT(275),
  [693] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_parameter_list_repeat1, 2, 0, 0), SHIFT_REPEAT(128),
  [696] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_parameter_list_repeat1, 2, 0, 0), SHIFT_REPEAT(127),
  [699] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_parameter_list_repeat1, 2, 0, 0), SHIFT_REPEAT(533),
  [702] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameter, 2, 0, 1),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [710] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_parameter, 2, 0, 1),
  [712] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_property, 1, 0, 0),
  [714] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_model_property, 1, 0, 0),
  [716] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameter, 1, 0, 6),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [722] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_parameter, 1, 0, 6),
  [724] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_spread_property, 2, 0, 0),
  [726] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_model_spread_property, 2, 0, 0),
  [728] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_property, 6, 0, 1),
  [730] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_model_property, 6, 0, 1),
  [732] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_property, 5, 0, 6),
  [734] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_model_property, 5, 0, 6),
  [736] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameter, 3, 0, 1),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [740] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_parameter, 3, 0, 1),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [744] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_namespace_body_repeat1, 2, 0, 0), SHIFT_REPEAT(213),
  [747] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_namespace_body_repeat1, 2, 0, 0), SHIFT_REPEAT(207),
  [750] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_namespace_body_repeat1, 2, 0, 0), SHIFT_REPEAT(505),
  [753] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_namespace_body_repeat1, 2, 0, 0), SHIFT_REPEAT(233),
  [756] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_namespace_body_repeat1, 2, 0, 0), SHIFT_REPEAT(234),
  [759] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_namespace_body_repeat1, 2, 0, 0),
  [761] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_namespace_body_repeat1, 2, 0, 0), SHIFT_REPEAT(288),
  [764] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_namespace_body_repeat1, 2, 0, 0), SHIFT_REPEAT(289),
  [767] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_namespace_body_repeat1, 2, 0, 0), SHIFT_REPEAT(291),
  [770] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_namespace_body_repeat1, 2, 0, 0), SHIFT_REPEAT(264),
  [773] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_namespace_body_repeat1, 2, 0, 0), SHIFT_REPEAT(269),
  [776] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_namespace_body_repeat1, 2, 0, 0), SHIFT_REPEAT(272),
  [779] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_namespace_body_repeat1, 2, 0, 0), SHIFT_REPEAT(249),
  [782] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_namespace_body_repeat1, 2, 0, 0), SHIFT_REPEAT(222),
  [785] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_namespace_body_repeat1, 2, 0, 0), SHIFT_REPEAT(278),
  [788] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_namespace_body_repeat1, 2, 0, 0), SHIFT_REPEAT(605),
  [791] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_namespace_body_repeat1, 2, 0, 0), SHIFT_REPEAT(263),
  [794] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [796] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [800] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [812] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [816] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [818] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [820] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [822] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [824] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_decorator_list_repeat1, 2, 0, 0), SHIFT_REPEAT(219),
  [827] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_annotation, 2, 0, 0),
  [829] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_annotation, 2, 0, 0),
  [831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [833] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_member_expression_repeat1, 2, 0, 5), SHIFT_REPEAT(265),
  [836] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_member, 3, 0, 6),
  [838] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_member, 3, 0, 6),
  [840] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_spread_member, 2, 0, 0),
  [842] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_spread_member, 2, 0, 0),
  [844] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [846] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [848] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [850] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [852] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameter, 2, 0, 6),
  [854] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [856] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_parameter, 2, 0, 6),
  [858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [860] = {.entry = {.count = 1, .reusable = false}}, SHIFT(246),
  [862] = {.entry = {.count = 1, .reusable = false}}, SHIFT(245),
  [864] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [866] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_member, 4, 0, 1),
  [868] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_member, 4, 0, 1),
  [870] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [872] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_decorator_list_repeat1, 2, 0, 0), SHIFT_REPEAT(231),
  [875] = {.entry = {.count = 1, .reusable = false}}, SHIFT(273),
  [877] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_member, 5, 0, 0),
  [879] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface_member, 5, 0, 0),
  [881] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_member, 4, 0, 0),
  [883] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface_member, 4, 0, 0),
  [885] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameter, 3, 0, 6),
  [887] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [889] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_parameter, 3, 0, 6),
  [891] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameter, 4, 0, 1),
  [893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [895] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_parameter, 4, 0, 1),
  [897] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_member, 3, 0, 0),
  [899] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface_member, 3, 0, 0),
  [901] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameter, 4, 0, 6),
  [903] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_parameter, 4, 0, 6),
  [905] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameter, 5, 0, 1),
  [907] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_parameter, 5, 0, 1),
  [909] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_member_expression_repeat1, 2, 0, 5), SHIFT_REPEAT(267),
  [912] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [914] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_member_expression_repeat1, 2, 0, 5), SHIFT_REPEAT(293),
  [917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [923] = {.entry = {.count = 1, .reusable = true}}, SHIFT(636),
  [925] = {.entry = {.count = 1, .reusable = true}}, SHIFT(657),
  [927] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [929] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_augment_decorator_statement, 2, 0, 1),
  [931] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_augment_decorator_statement, 2, 0, 1),
  [933] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [935] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [937] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [939] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [941] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration_statement, 3, 0, 1),
  [943] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_declaration_statement, 3, 0, 1),
  [945] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [947] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration_statement, 4, 0, 7),
  [949] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_declaration_statement, 4, 0, 7),
  [951] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [953] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [955] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameter_list, 3, 0, 0),
  [957] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_parameter_list, 3, 0, 0),
  [959] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameter_list, 2, 0, 0),
  [961] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_parameter_list, 2, 0, 0),
  [963] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_statement, 4, 0, 7),
  [965] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_namespace_statement, 4, 0, 7),
  [967] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scalar_statement, 4, 0, 1),
  [969] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_scalar_statement, 4, 0, 1),
  [971] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operation_statement, 4, 0, 1),
  [973] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operation_statement, 4, 0, 1),
  [975] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 3, 0, 0),
  [977] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_statement, 3, 0, 0),
  [979] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_using_statement, 3, 0, 3),
  [981] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_using_statement, 3, 0, 3),
  [983] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_statement, 3, 0, 1),
  [985] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_namespace_statement, 3, 0, 1),
  [987] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_statement, 3, 0, 1),
  [989] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_model_statement, 3, 0, 1),
  [991] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_statement, 3, 0, 1),
  [993] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_statement, 3, 0, 1),
  [995] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scalar_statement, 3, 0, 1),
  [997] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_scalar_statement, 3, 0, 1),
  [999] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_statement, 3, 0, 1),
  [1001] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface_statement, 3, 0, 1),
  [1003] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_statement, 3, 0, 1),
  [1005] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_statement, 3, 0, 1),
  [1007] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_augment_decorator_statement, 3, 0, 1),
  [1009] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_augment_decorator_statement, 3, 0, 1),
  [1011] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_decorator_declaration_statement, 3, 0, 1),
  [1013] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_decorator_declaration_statement, 3, 0, 1),
  [1015] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_body, 2, 0, 0),
  [1017] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_namespace_body, 2, 0, 0),
  [1019] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_statement, 4, 0, 1),
  [1021] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface_statement, 4, 0, 1),
  [1023] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_statement, 4, 0, 1),
  [1025] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_model_statement, 4, 0, 1),
  [1027] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_body, 2, 0, 0),
  [1029] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_body, 2, 0, 0),
  [1031] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_statement, 4, 0, 1),
  [1033] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_statement, 4, 0, 1),
  [1035] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_body, 2, 0, 0),
  [1037] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface_body, 2, 0, 0),
  [1039] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 2, 0, 0),
  [1041] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_body, 2, 0, 0),
  [1043] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_statement, 5, 0, 1),
  [1045] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface_statement, 5, 0, 1),
  [1047] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration_statement, 4, 0, 1),
  [1049] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_declaration_statement, 4, 0, 1),
  [1051] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_statement, 4, 0, 7),
  [1053] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_model_statement, 4, 0, 7),
  [1055] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_statement, 4, 0, 7),
  [1057] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_statement, 4, 0, 7),
  [1059] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scalar_statement, 4, 0, 7),
  [1061] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_scalar_statement, 4, 0, 7),
  [1063] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_statement, 4, 0, 7),
  [1065] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_statement, 4, 0, 7),
  [1067] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_decorator_declaration_statement, 4, 0, 7),
  [1069] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_decorator_declaration_statement, 4, 0, 7),
  [1071] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_body, 3, 0, 0),
  [1073] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_namespace_body, 3, 0, 0),
  [1075] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_statement, 5, 0, 1),
  [1077] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_model_statement, 5, 0, 1),
  [1079] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_body, 3, 0, 0),
  [1081] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_body, 3, 0, 0),
  [1083] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scalar_statement, 5, 0, 1),
  [1085] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_scalar_statement, 5, 0, 1),
  [1087] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_body, 3, 0, 0),
  [1089] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface_body, 3, 0, 0),
  [1091] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operation_statement, 5, 0, 1),
  [1093] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operation_statement, 5, 0, 1),
  [1095] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 3, 0, 0),
  [1097] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum_body, 3, 0, 0),
  [1099] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_alias_statement, 5, 0, 1),
  [1101] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_alias_statement, 5, 0, 1),
  [1103] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_statement, 5, 0, 7),
  [1105] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_model_statement, 5, 0, 7),
  [1107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_statement, 5, 0, 7),
  [1109] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_statement, 5, 0, 7),
  [1111] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scalar_statement, 5, 0, 7),
  [1113] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_scalar_statement, 5, 0, 7),
  [1115] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operation_statement, 5, 0, 7),
  [1117] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operation_statement, 5, 0, 7),
  [1119] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration_statement, 5, 0, 7),
  [1121] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_declaration_statement, 5, 0, 7),
  [1123] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_alias_statement, 6, 0, 1),
  [1125] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_alias_statement, 6, 0, 1),
  [1127] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_statement, 6, 0, 7),
  [1129] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_model_statement, 6, 0, 7),
  [1131] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scalar_statement, 6, 0, 7),
  [1133] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_scalar_statement, 6, 0, 7),
  [1135] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operation_statement, 6, 0, 7),
  [1137] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operation_statement, 6, 0, 7),
  [1139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [1141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [1143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [1145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [1147] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_decorator_list_repeat1, 2, 0, 0), SHIFT_REPEAT(207),
  [1150] = {.entry = {.count = 1, .reusable = false}}, SHIFT(183),
  [1152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [1154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [1156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [1158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [1160] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression_list, 1, 0, 0),
  [1162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [1164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [1168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [1170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [1172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [1174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [1176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [1178] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_parameters, 3, 0, 0),
  [1180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [1182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [1184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [1186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [1188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [1192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [1194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [1196] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_expression_list_repeat1, 2, 0, 0),
  [1198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [1200] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_parameter, 1, 0, 6),
  [1202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [1204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [1206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [1208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [1210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [1212] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_constraint, 2, 0, 0),
  [1214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [1216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [1218] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_expression_list_repeat1, 2, 0, 0), SHIFT_REPEAT(72),
  [1221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [1223] = {.entry = {.count = 1, .reusable = false}}, SHIFT(151),
  [1225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(546),
  [1227] = {.entry = {.count = 1, .reusable = false}}, SHIFT(546),
  [1229] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [1231] = {.entry = {.count = 1, .reusable = false}}, SHIFT(347),
  [1233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [1235] = {.entry = {.count = 1, .reusable = false}}, SHIFT(528),
  [1237] = {.entry = {.count = 1, .reusable = false}}, SHIFT(343),
  [1239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [1241] = {.entry = {.count = 1, .reusable = false}}, SHIFT(543),
  [1243] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [1245] = {.entry = {.count = 1, .reusable = false}}, SHIFT(549),
  [1247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [1249] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_backticked_identifier_repeat1, 2, 0, 0),
  [1251] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_backticked_identifier_repeat1, 2, 0, 0), SHIFT_REPEAT(516),
  [1254] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_backticked_identifier_repeat1, 2, 0, 0), SHIFT_REPEAT(516),
  [1257] = {.entry = {.count = 1, .reusable = false}}, SHIFT(74),
  [1259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [1261] = {.entry = {.count = 1, .reusable = false}}, SHIFT(522),
  [1263] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_parameter, 2, 0, 8),
  [1265] = {.entry = {.count = 1, .reusable = false}}, SHIFT(244),
  [1267] = {.entry = {.count = 1, .reusable = false}}, SHIFT(527),
  [1269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [1271] = {.entry = {.count = 1, .reusable = false}}, SHIFT(78),
  [1273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [1275] = {.entry = {.count = 1, .reusable = false}}, SHIFT(521),
  [1277] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_quoted_string_literal_repeat1, 2, 0, 0),
  [1279] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_quoted_string_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(521),
  [1282] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_quoted_string_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(521),
  [1285] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_triple_quoted_string_literal_repeat1, 2, 0, 0),
  [1287] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_triple_quoted_string_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(522),
  [1290] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_triple_quoted_string_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(522),
  [1293] = {.entry = {.count = 1, .reusable = false}}, SHIFT(75),
  [1295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [1297] = {.entry = {.count = 1, .reusable = false}}, SHIFT(520),
  [1299] = {.entry = {.count = 1, .reusable = false}}, SHIFT(308),
  [1301] = {.entry = {.count = 1, .reusable = false}}, SHIFT(516),
  [1303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(516),
  [1305] = {.entry = {.count = 1, .reusable = false}}, SHIFT(76),
  [1307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [1309] = {.entry = {.count = 1, .reusable = false}}, SHIFT(517),
  [1311] = {.entry = {.count = 1, .reusable = false}}, SHIFT(342),
  [1313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(542),
  [1315] = {.entry = {.count = 1, .reusable = false}}, SHIFT(542),
  [1317] = {.entry = {.count = 1, .reusable = false}}, SHIFT(242),
  [1319] = {.entry = {.count = 1, .reusable = false}}, SHIFT(344),
  [1321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [1323] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_is_heritage, 2, 0, 0),
  [1325] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [1327] = {.entry = {.count = 1, .reusable = false}}, SHIFT(323),
  [1329] = {.entry = {.count = 1, .reusable = false}}, SHIFT(545),
  [1331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [1333] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [1335] = {.entry = {.count = 1, .reusable = false}}, SHIFT(531),
  [1337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [1339] = {.entry = {.count = 1, .reusable = false}}, SHIFT(149),
  [1341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [1343] = {.entry = {.count = 1, .reusable = false}}, SHIFT(547),
  [1345] = {.entry = {.count = 1, .reusable = false}}, SHIFT(348),
  [1347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [1349] = {.entry = {.count = 1, .reusable = false}}, SHIFT(548),
  [1351] = {.entry = {.count = 1, .reusable = false}}, SHIFT(310),
  [1353] = {.entry = {.count = 1, .reusable = false}}, SHIFT(524),
  [1355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [1357] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_default, 2, 0, 0),
  [1359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [1361] = {.entry = {.count = 1, .reusable = false}}, SHIFT(329),
  [1363] = {.entry = {.count = 1, .reusable = false}}, SHIFT(330),
  [1365] = {.entry = {.count = 1, .reusable = false}}, SHIFT(322),
  [1367] = {.entry = {.count = 1, .reusable = false}}, SHIFT(148),
  [1369] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [1371] = {.entry = {.count = 1, .reusable = false}}, SHIFT(345),
  [1373] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [1375] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_reference_expression_list_repeat1, 2, 0, 0),
  [1377] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_reference_expression_list_repeat1, 2, 0, 0), SHIFT_REPEAT(201),
  [1380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [1382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [1384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [1386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [1388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [1390] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_parameter_list, 1, 0, 0),
  [1392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [1394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [1396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [1398] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_scalar_extends, 2, 0, 0),
  [1400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [1402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [1404] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_template_parameter_list_repeat1, 2, 0, 0), SHIFT_REPEAT(240),
  [1407] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_template_parameter_list_repeat1, 2, 0, 0),
  [1409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [1411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [1413] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_model_extends_heritage, 2, 0, 0),
  [1415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [1417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [1419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [1421] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_parameter_list, 2, 0, 0),
  [1423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [1425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_reference_expression_list, 1, 0, 0),
  [1427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [1429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [1431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [1433] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operation_signature_declaration, 3, 0, 0),
  [1435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [1437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [1439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [1441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [1443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [1445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [1447] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__model_heritage, 1, 0, 0),
  [1449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [1451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [1453] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_parameter, 2, 0, 9),
  [1455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [1457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [1459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [1461] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_parameter, 3, 0, 10),
  [1463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(669),
  [1465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [1469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [1471] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_decorator_modifiers, 1, 0, 0),
  [1473] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_modifiers, 1, 0, 0),
  [1475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [1477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [1479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(665),
  [1481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [1485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [1487] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface_heritage, 2, 0, 0),
  [1489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [1491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [1493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [1495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [1497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [1501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [1503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [1505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [1507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [1509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [1511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [1513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [1515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [1517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [1519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [1521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [1523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [1525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [1527] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [1531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [1533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [1535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [1537] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operation_arguments, 3, 0, 0),
  [1539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [1541] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operation_arguments, 2, 0, 0),
  [1543] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operation_signature_reference, 2, 0, 0),
  [1545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [1547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [1549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [1551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [1553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [1555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [1557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [1559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [1561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [1567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [1569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [1571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [1573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [1575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [1577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [1579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [1581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [1583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [1585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [1587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [1589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [1591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_typespec(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
