%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0":  ["0x3FF0000000000000", "0x3FF0000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM1":  ["0x4000000000000000", "0x4010000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM2":  ["0x4008000000000000", "0x4022000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM3":  ["0x4010000000000000", "0x4030000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM4":  ["0x3FF0000000000000", "0x4039000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM5":  ["0x4000000000000000", "0x4010000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM6":  ["0x4008000000000000", "0x4022000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM7":  ["0x4010000000000000", "0x4030000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM8":  ["0x3FF0000000000000", "0x4030000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM9":  ["0x4000000000000000", "0x4039000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM10": ["0x4008000000000000", "0x4010000000000000", "0x0000000000000000", "0x0000000000000000"],
    "XMM11": ["0x4010000000000000", "0x4022000000000000", "0x0000000000000000", "0x0000000000000000"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rdx + 32 * 0]
vmovapd ymm1, [rdx + 32 * 1]
vmovapd ymm2, [rdx + 32 * 2]
vmovapd ymm3, [rdx + 32 * 3]
vmovapd ymm4, [rdx + 32 * 4]
vmovapd ymm5, [rdx + 32 * 1]
vmovapd ymm6, [rdx + 32 * 2]
vmovapd ymm7, [rdx + 32 * 3]

; Register only
vsqrtsd xmm0, xmm0, xmm0
vsqrtsd xmm1, xmm1, xmm1
vsqrtsd xmm2, xmm2, xmm2
vsqrtsd xmm3, xmm3, xmm3

; Memory operand
vsqrtsd xmm4, xmm4, [rdx + 32 * 0]
vsqrtsd xmm5, xmm5, [rdx + 32 * 1]
vsqrtsd xmm6, xmm6, [rdx + 32 * 2]
vsqrtsd xmm7, xmm7, [rdx + 32 * 3]

; Merge different source register
vsqrtsd xmm8, xmm3, [rdx + 32 * 0]
vsqrtsd xmm9, xmm4, [rdx + 32 * 1]
vsqrtsd xmm10, xmm5, [rdx + 32 * 2]
vsqrtsd xmm11, xmm6, [rdx + 32 * 3]

hlt

align 32
.data:
dq 0x3FF0000000000000 ; 1.0
dq 0x3FF0000000000000
dq 0x3FF0000000000000
dq 0x3FF0000000000000

dq 0x4010000000000000 ; 4.0
dq 0x4010000000000000
dq 0x4010000000000000
dq 0x4010000000000000

dq 0x4022000000000000 ; 9.0
dq 0x4022000000000000
dq 0x4022000000000000
dq 0x4022000000000000

dq 0x4030000000000000 ; 16.0
dq 0x4030000000000000
dq 0x4030000000000000
dq 0x4030000000000000

dq 0x4039000000000000 ; 25.0
dq 0x4039000000000000
dq 0x4039000000000000
dq 0x4039000000000000
