import os
import re
import json

header = '''//===----------------------------------------------------------------------===//
//                         DuckDB
//
// duckdb/catalog/default/builtin_types/types.hpp
//
//
//===----------------------------------------------------------------------===//
// This file is generated by scripts/generate_builtin_types.py

#pragma once

#include "duckdb/common/types.hpp"
#include "duckdb/common/array.hpp"

namespace duckdb {
'''

footer = '''} // namespace duckdb
'''


def normalize_path_separators(x):
    return os.path.sep.join(x.split('/'))


def legal_struct_name(name):
    return name.isalnum()


def get_struct_name(function_name):
    return function_name.replace('_', ' ').title().replace(' ', '') + 'Fun'


def sanitize_string(text):
    return text.replace('"', '\\"')


new_text = header

type_entries = []
json_path = normalize_path_separators(f'src/include/duckdb/catalog/default/builtin_types/types.json')
with open(json_path, 'r') as f:
    parsed_json = json.load(f)

# Extract all the types from the json
for type in parsed_json:
    names = type['names']

    type_id = type['id']

    type_entries += ['\t{' + f'''"{name}", LogicalTypeId::{type_id}''' + '}' for name in names]

TYPE_COUNT = len(type_entries)
new_text += '''
struct DefaultType {
	const char *name;
	LogicalTypeId type;
};
'''
new_text += f'''
using builtin_type_array = std::array<DefaultType, {TYPE_COUNT}>;
'''
new_text += '''
static constexpr const builtin_type_array BUILTIN_TYPES{{
'''

type_text = ",\n".join(type_entries)
new_text += type_text
new_text += '''
}};

'''

new_text += footer

with open('src/include/duckdb/catalog/default/builtin_types/types.hpp', 'w+') as f:
    f.write(new_text)
