// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`PutBucketEncryption`](crate::operation::put_bucket_encryption::builders::PutBucketEncryptionFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::put_bucket_encryption::builders::PutBucketEncryptionFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::put_bucket_encryption::builders::PutBucketEncryptionFluentBuilder::set_bucket):<br>required: **true**<br><p>Specifies default encryption for a bucket using server-side encryption with different key options.</p> <p><b>Directory buckets </b> - When you use this operation with a directory bucket, you must use path-style requests in the format <code>https://s3express-control.<i>region-code</i>.amazonaws.com/<i>bucket-name</i> </code>. Virtual-hosted-style requests aren't supported. Directory bucket names must be unique in the chosen Zone (Availability Zone or Local Zone). Bucket names must also follow the format <code> <i>bucket-base-name</i>--<i>zone-id</i>--x-s3</code> (for example, <code> <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az1</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i></p><br>
    ///   - [`content_md5(impl Into<String>)`](crate::operation::put_bucket_encryption::builders::PutBucketEncryptionFluentBuilder::content_md5) / [`set_content_md5(Option<String>)`](crate::operation::put_bucket_encryption::builders::PutBucketEncryptionFluentBuilder::set_content_md5):<br>required: **false**<br><p>The Base64 encoded 128-bit <code>MD5</code> digest of the server-side encryption configuration.</p> <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`checksum_algorithm(ChecksumAlgorithm)`](crate::operation::put_bucket_encryption::builders::PutBucketEncryptionFluentBuilder::checksum_algorithm) / [`set_checksum_algorithm(Option<ChecksumAlgorithm>)`](crate::operation::put_bucket_encryption::builders::PutBucketEncryptionFluentBuilder::set_checksum_algorithm):<br>required: **false**<br><p>Indicates the algorithm used to create the checksum for the request when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding <code>x-amz-checksum</code> or <code>x-amz-trailer</code> header sent. Otherwise, Amazon S3 fails the request with the HTTP status code <code>400 Bad Request</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p> <p>If you provide an individual checksum, Amazon S3 ignores any provided <code>ChecksumAlgorithm</code> parameter.</p><note>  <p>For directory buckets, when you use Amazon Web Services SDKs, <code>CRC32</code> is the default checksum algorithm that's used for performance.</p> </note><br>
    ///   - [`server_side_encryption_configuration(ServerSideEncryptionConfiguration)`](crate::operation::put_bucket_encryption::builders::PutBucketEncryptionFluentBuilder::server_side_encryption_configuration) / [`set_server_side_encryption_configuration(Option<ServerSideEncryptionConfiguration>)`](crate::operation::put_bucket_encryption::builders::PutBucketEncryptionFluentBuilder::set_server_side_encryption_configuration):<br>required: **true**<br><p>Specifies the default server-side-encryption configuration.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::put_bucket_encryption::builders::PutBucketEncryptionFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::put_bucket_encryption::builders::PutBucketEncryptionFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><note>  <p>For directory buckets, this header is not supported in this API operation. If you specify this header, the request fails with the HTTP status code <code>501 Not Implemented</code>.</p> </note><br>
    /// - On success, responds with [`PutBucketEncryptionOutput`](crate::operation::put_bucket_encryption::PutBucketEncryptionOutput)
    /// - On failure, responds with [`SdkError<PutBucketEncryptionError>`](crate::operation::put_bucket_encryption::PutBucketEncryptionError)
    pub fn put_bucket_encryption(&self) -> crate::operation::put_bucket_encryption::builders::PutBucketEncryptionFluentBuilder {
        crate::operation::put_bucket_encryption::builders::PutBucketEncryptionFluentBuilder::new(self.handle.clone())
    }
}
