# 0.76.0 release notes

**Release date:** 2020-12-03

## How to upgrade

Download and launch the latest version:

<div class="compact" markdown>

- [Linux](../linux.md) (or [Steam on Linux](../linux.md#steam))
- [Windows](../windows.md)
- [macOS](../macos.md)

</div>

At the`Z:\>` prompt, run `config -wc` to write the new configuration file. Any
existing settings will be retained, however, extraneous comments will be
dropped.


## Summary

This release introduces significant enhancements to the quality of audio
emulation (GUS, built-in MIDI, PC speaker), improved support for PowerPC
and POWER8 architectures, and a healthy mix of usability, documentation,
code quality improvements.

Enjoy! :smile:


## New features in detail

### Gravis UltraSound emulation improvements

Sample from [Rise of the Triad][rott] (1995). For other comparisons see [link].

Using headphones is highly recommended!

| GUS emulator                           | Sample (FLAC)                                                                                                                                                                                    |
|----------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Old implementation                     | <audio controls src="https://www.dosbox-staging.org/static/audio/release-notes/0.76.0/rott-before.flac"> Your browser does not support the <code>audio</code> element.</audio> |
| New implementation (with improvements) | <audio controls src="https://www.dosbox-staging.org/static/audio/release-notes/0.76.0/rott-after.flac"> Your browser does not support the <code>audio</code> element.</audio>  |

Several changes have been made to the GUS emulation resulting in (sometimes)
audible differences, as follows:

- Output volume is now typically on-par with other audio devices.

- Panning of voices is now performed using constant-power, as described in the
  Gravis' SDK documentation. Constant-power panning was originally researched by
  the British Broadcasting Corporation (BBC) and found to produce the most
  realistic perception of voice placement on a radial axis from the listener.

- When quitting DOSBox Staging, information about the game's GUS audio stream
  will be provided, such as the breakdown of 8-bit versus 16-bit samples. A
  potential suggestion to adjust the game's GUS mixer level, either upward or
  downward may also be provided, which you could paste into your game's startup
  batch file or `[autoexec]` section.

We recommend using GUS emulation for the handful of DOS games that
[natively support](https://github.com/dosbox-staging/dosbox-staging/wiki/Gravis-Ultrasound-(GUS)#gus-native-games)
the GUS's multi-voice feature. For a list of these games, see:
[GUS Native games](https://github.com/dosbox-staging/dosbox-staging/wiki/CDDA-GUS-&-MIDI-compatible-games).

For more details about DOSBox Staging's GUS support and enhancements, see:
[GUS&nbsp;Enhancements](https://github.com/dosbox-staging/dosbox-staging/wiki/Gravis-UltraSound-Enhancements).

For information about constant-power panning, see pages 7 and 8 of the
[BBC R&D White Paper](http://downloads.bbc.co.uk/rd/pubs/whp/whp-pdf-files/WHP051.pdf).

[link]: https://github.com/dosbox-staging/dosbox-staging/wiki/Gravis-UltraSound-Enhancements#audio-comparisons
[rott]: https://www.pcgamingwiki.com/wiki/Rise_of_the_Triad


### Built-in GLSL shaders

Two high-quality shaders that emulate the visual look of an analog CRT monitor
are now included:

- `glshader = crt-easymode-flat`: for DOS games using resolutions 640&times;400
   or higher.
- `glshader = crt-fakelottes-flat`: for DOS games using smaller resolutions
   (e.g. 320&times;200).

<figure markdown>
  ![Jazz Jackrabbit (Holiday Hare 1995 Edition)](https://www.dosbox-staging.org/static/images/release-notes/0.76.0/jazz-jackrabbit-full.png)

  <figcaption markdown>
  [Jazz Jackrabbit (Holiday Hare 1995 Edition)](https://en.wikipedia.org/wiki/Jazz_Jackrabbit_(1994_video_game)) --- showcasing `crt-fakelottes-flat`
  </figcaption>
</figure>

<figure markdown>
  ![Jazz Jackrabbit (Holiday Hare 1995 Edition) -- zoomed-in view](https://www.dosbox-staging.org/static/images/release-notes/0.76.0/jazz-jackrabbit-crt-shader.png)

  <figcaption markdown>
  [Jazz Jackrabbit (Holiday Hare 1995 Edition)](https://en.wikipedia.org/wiki/Jazz_Jackrabbit_(1994_video_game)) --- showcasing `crt-fakelottes-flat` (zoomed-in view)
  </figcaption>
</figure>


### Built-in MIDI support via FluidSynth

[FluidSynth 2.x](http://www.fluidsynth.org/), a powerful and accurate MIDI
synthesizer, has been integrated into DOSBox to directly support MIDI
playback. This means you no longer need to use an external MIDI synthesizer
(but it's still possible, of course).

Configure your game to use General MIDI (GM) output on port `330` and update
your DOSBOX Staging config as follows to start using it:

``` ini
[midi]
mididevice = fluidsynth
mpu401     = intelligent

[fluidsynth]
soundfont = my-favourite-soundfont.sf2
```

DOSBox will look for soundfont files in the `soundfonts` directory within your
configuration directory and in additional platform-specific directories (e.g.
`/usr/share/soundfonts/` on Linux).

You can also use absolute paths or paths relative to the current working
directory (for bundling `.sf2` files in game directories).


#### Fine-grained MIDI level controls

Some SoundFonts can be "louder" than others, such as [Timbres of Heaven][toh].
You can provide an optional volume-scaling percentage after the SF2 filename,
such as:

``` ini
soundfont = timbres_of_heaven.sf2 20
```

This will reduce the SoundFont's volume to 20%.

Most games that play MIDI music provide an in-game volume adjustment, but
some games may not save your settings while others may not even allow this
adjustment. For these games, use the `mixer FSYNTH` command to set your desired
MIDI output volume either in your startup batch file or the `[autoexec]` section
in the game's config file, e.g.:

```{ . .dos-prompt }
C:\>mixer FSYNTH 33
```

[toh]: http://midkar.com/soundfonts/

#### What soundfont should I use?

This is very much a matter of personal opinion. We've compiled a list of
SoundFont recommendations suitable for DOS gaming on our
[wiki](https://github.com/dosbox-staging/dosbox-staging/wiki/MIDI#soundfonts).

Linux users: if you have the [fluid-soundfont][fluidr3] installed on your OS, it
will be picked up automatically by default.

[fluidr3]: https://repology.org/project/fluid-soundfont/versions


### Integer scaling (pixel-perfect) option for OpenGL output

Integer scaling (aka pixel-perfect mode) is now also available via OpenGL.

You can test integer scaling by setting the following `output` options:

- `output = openglpp` --- OpenGL + integer scaling. This option is used to provide
  backwards compatibility with other DOSBox forks.

- `output = texturepp` --- SDL2 texture backend + integer scaling. This option
  was added in 0.75.0.

These two options behave pretty much the same, except Linux users can enjoy
resizable windows with `output = openglpp`.

Examples running fullscreen on 1080p display:

<figure markdown>
  ![The Lost Vikings (1993)](https://www.dosbox-staging.org/static/images/release-notes/0.76.0/the-lost-vikings-integer-scaling.png)

  <figcaption markdown>
  [The Lost Vikings (1993)](https://en.wikipedia.org/wiki/The_Lost_Vikings) --- with integer scaling
  </figcaption>
</figure>

<figure markdown>
  ![Epic Pinball (1993)](https://www.dosbox-staging.org/static/images/release-notes/0.76.0/epic-pinball-integer-scaling.png)

  <figcaption markdown>
  [Epic Pinball (1993)](https://en.wikipedia.org/wiki/Epic_Pinball) --- with integer scaling
  </figcaption>
</figure>

!!! tip

    Integer scaling works best for games that use square pixels; most DOS
    games use non-square pixels (often using resolution 320&times;200 / [PAR] 5:6)---for
    those titles sharp-bilinear scaling (DOSBox Staging default setting) works
    better.

This video essay by **Displaced Gamers** provides a great explanation:

<figure markdown>
  <iframe width="840" height="472" src="https://www.youtube-nocookie.com/embed/YvckyWxHAIw" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>

  <figcaption markdown>
  DOS Gaming Aspect Ratio --- 320&times;200
  </figcaption>
</figure>

[PAR]: https://en.wikipedia.org/wiki/Pixel_aspect_ratio

The `output = openglpp` option with `windowresolution = resizable` is also a good choice
for text mode DOS applications as it produces sharp text (but
sacrifices the proper DOS font aspect ratio):

<figure markdown>
  ![Turbo Pascal in windowed mode with pixel-perfect scaling](https://www.dosbox-staging.org/static/images/release-notes/0.76.0/desktop-turbo-openglpp.png)

  <figcaption markdown>
  Turbo Pascal in windowed mode with pixel-perfect scaling
  </figcaption>
</figure>


### Dynamic recompilation for PowerPC and POWER8 (ppc64le)

Roughly two years ago *jmarsh* of the vogons.org forums published a
feature-complete
[dynamic recompilation](https://en.wikipedia.org/wiki/Dynamic_recompilation)
patch supporting the PowerPC (32-bit) architecture. This was quickly
expanded by the community to support the POWER8 (64-bit) architecture as
well. Both patches (with slight improvements) were merged to DOSBox Staging.

Shoutout to the AmigaOS community for the help with thoroughly testing this
significant PowerPC contribution! :smile:


### Quick-edit and find your configuration file

It can be cumbersome to edit and find your default `dosbox-staging.conf` file.
You might not know where it's located or it might be hidden away due to certain
OS settings.

These two command-line options can help:

- `dosbox --editconf`, opens the `.conf` file in a text editor.

    This option respects the `EDITOR` environment variable if set to your
    prefered editor. Otherwise, it uses one of the following: `nano`,
    `vim`, `vi`, `notepad++.exe`, or `notepad.exe`.

- `dosbox --printconf`, prints the path to the `.conf` file.


### LS command

The `ls` (list directory contents) command is widely available across Unix-based
operating systems. Most users of modern OSes are more likely to have it in their
muscle memory rather than the `DIR` DOS command.

A very simple implementation of `ls` has been added that resembles the default
operation of GNU `ls`:

- Fits as many directory entries as possible on the screen
- Differentiates directories, executables, and plain files using color
- Prints files in lowercase and directories in uppercase, Norton Commander style

<figure markdown>
  ![Example: DIR /W /P](https://www.dosbox-staging.org/static/images/release-notes/0.76.0/dir.png)

  <figcaption markdown>
  Windows 3.11 listed using `dir /w /p` --- not enough space to show all
  files, hard to distinguish between files and directories
  </figcaption>
</figure>

<figure markdown>
  ![Example: LS](https://www.dosbox-staging.org/static/images/release-notes/0.76.0/ls.png)

  <figcaption markdown>
  The same directory listed using `ls` --- more efficient utilisation of space
  in 80&times;25 DOS text mode, easier to read
  </figcaption>
</figure>


### Rapid DC offset correction for the emulated PC speaker

Audio speakers work by pushing and pulling their diaphragm at a rate equal to the
audio's frequency.

Physical PC speakers can sometimes be left in a pushed-out or pulled-in state
through constant voltage, called DC offset, which typically isn't a problem on
real hardware. However in DOSBox, the PC speaker's offset samples mix with those
from other audio sources such as the Sound Blaster or Adlib, which can:

- Cause a pop if the next sample played has a position significantly different
  from the position of the DC offset.

- Harm accurate sound reproduction of other sound devices by moving half the
  waveform further away from the center line (making it louder) and the other
  half of the waveform closer to the center line (making it quieter).

This new configuration option, `zero_offset` under the `[speaker]` section,
defaults to `'auto'`. It's enabled for non-Windows systems and  disabled on
Windows as some of its audio drivers appear to attempt their own DC offset
correction.

For more details about this change, see: #480

For a discussion about Windows 10 performing DC offset correction,
see: #625

<figure markdown>
  ![Example: DC offset correction](https://www.dosbox-staging.org/static/images/release-notes/0.76.0/dc-offset.png)

  <figcaption markdown>
  The game has left the PC speaker in an offset position, which is detected
  and silently "wound down" in a fraction of a second.
  </figcaption>
</figure>


### Audio pop and click prevention

Some games generate audio pops or clicks during startup. We've added
two changes to reduce these occurences:

- Initial audio by all emulated devices is fed through a 15-ms envelope
  specifically timed to prevent unnatural electronic pops and clicks, yet fast
  enough to ensure that sharp-attack natural sounds (such as a cymbal crash) are
  not affected.

<figure markdown>
  ![Example: Unenveloped](https://www.dosbox-staging.org/static/images/release-notes/0.76.0/pop-and-click-1.png)
  ![Example: Enveloped](https://www.dosbox-staging.org/static/images/release-notes/0.76.0/pop-and-click-2.png)

  <figcaption markdown>
  On startup, the game greets our ears with an unatural instantaneous pop. In
  the second image, we see the enveloper briefly in action ramping the
  instaneous volume to prevent the pop.
  </figcaption>
</figure>

For more visuals and detail about the enveloper, see: #442

- Some games test their interface to the Sound Blaster 16 using one or more
  small "junk" DMA transfers. Unfortunately on actual hardware, these result in
  startup clicks and pops, which can be jarring when using a headset.  We now
  suppress these initial junk transfers.

For a list of many more games that had their pops cleaned up, see: #411

<figure markdown>
  ![Example: SB16 junk suppression](https://www.dosbox-staging.org/static/images/release-notes/0.76.0/pop-and-click-3.png)

  <figcaption markdown>
  On startup, [Lands of Lore: The Throne of
  Chaos](https://en.wikipedia.org/wiki/Lands_of_Lore:_The_Throne_of_Chaos)'s
  audio driver blasts our ears with two instantaneous pops, which are
  eliminated after suppression.
  </figcaption>
</figure>


### Splash screen and help banner verbosity control

The splash screen and its delay, as well as the blue help banner, can now be
skipped using the `startup_verbosity` setting in the `[dosbox]` section in the
config file.  The verbosity can be set as follows:

- `high` shows everything: the splash screen, blue help banner, and initial
  console output.

- `medium` skips just the splash screen and its delay, but still shows the blue
  help banner and initial console output.

- `low` skips both the splash screen, delay, and blue help banner, but still
  shows  initial console output.

- `quiet` skips all of the above. The first output will either be the command
  prompt or output from startup executables or batch files.

By default, the verbosity is set to `auto`, which is either `low` when an
executable or directory is passed on the command-line or `high` when DOSBox
Staging is started without initial commands.

For a visual depiction of the options, see: #477


### Revise help messages for MOUNT and IMGMOUNT commands

These commands are usually thoroughly documented in the [manual], but having
usage examples at your fingertips is more convenient. Help can be invoked
by passing one of the following parameters: `/?` (DOS style), or `-h`, `--help`
(GNU style).

Read more in: #729

[manual]: https://github.com/dosbox-staging/dosbox-staging/blob/main/README

<figure markdown>
  ![Example: MOUNT help](https://www.dosbox-staging.org/static/images/release-notes/0.76.0/mount-help.png)

  <figcaption markdown>
  Revised help messages provide usage examples, common parameter descriptions,
  and use a limited set of colours to improve readability.
  </figcaption>
</figure>


### Improve Telnet-mode handling for modem emulation

For those hosting a BBS behind a Telnet interface, you can now pre-configure
your serial port in Telnet-mode with the `telnet:1` argument, as follows:

``` ini
[serial]
serial1 = modem telnet:1 listenport:2323
```

For those dialling BBSs hosted behind a Telnet interface, use the following
dial-prefix: `AT+NET1DT`. In general, the `+NET1` or `+NET0` AT-command will
enable or disable Telnet-mode, respectively.

This change brings Telnet-mode in-line with the Hayes multi-character command
specification, which should be compatible with existing BBS software.

For more background about this change, see: #582

<figure markdown>
  ![Example: large-modem-transfer](https://www.dosbox-staging.org/static/images/release-notes/0.76.0/telnet.png)

  <figcaption markdown>
  When telnet-mode is set according to the remote BBS's needs, you will
  experience fast and corruption-free transfers.
  </figcaption>
</figure>



### Fix setting file timestamp

DOS function [5701h "Set File Time/Date"][5701h] was implemented.

This corrects a long-standing emulation issue when it comes to date handling of
files created in DOS (e.g. when files are being unpacked from an archive). This
fixes some game installers and other software that checks file modification
times.

[5701h]: https://dos4gw.org/DOS_Fn_5701H_Set_File_Time_Date


### Case-insensitive paths handling

Paths passed to commands `mount`, `imgmount`, and audio track paths in
`.cue` and `.ins` files are now treated as case-insensitive, regardless
of the operating system.

Fixes numerous issues with running DOS games on Linux or FreeBSD. This change
alone corrects the vast majority of Windows-only DOS game releases on [GOG] or
[Steam][steam-curator] (such as e.g. **Settlers II**, **Redneck Rampage**, or
*Mortal Kombat** series)---users no longer need to manually adjust the paths
after unpacking games from Windows installer. This should significantly
improve the quality of [Lutris] installers as well.

[gog]: https://www.gog.com/games?sort=release_asc&page=1
[steam-curator]: https://store.steampowered.com/curator/35328265-Powered-by-DOSBox/
[Lutris]: https://lutris.net/


### Revise default keyboard shortcuts

The default keyboard shortcuts were revised to avoid triggering conflicting OS
default shortcuts. We've only changed those that that were not typically used by
general users.

The list of new default shortcuts are:

- ++alt+enter++ -- Switch between fullscreen and window mode
- ++alt+pause++ -- Pause/Unpause emulator
- ++ctrl+f1++ -- Start the keymapper
- ++ctrl+f4++ -- Change between mounted floppy/CD images
- ++ctrl+f5++ -- Save a screenshot
- ++ctrl+f6++ -- Start/Stop recording sound output to a wave file
- ++ctrl+f7++ -- Start/Stop recording video output to a zmbv file
- ++ctrl+f9++ -- Shutdown emulator
- ++ctrl+f10++ -- Capture/Release the mouse
- ++ctrl+f11++ -- Slow down emulation
- ++ctrl+f12++ -- Speed up emulation
- ++ctrl+alt+home++ -- Restart emulator
- Hold ++alt+f12++ -- Fast forward

Keymapper received tiny usability improvements as well: it displays the
keyboard shortcut (binding) for the selected action.


### Monochrome palette colour setting

When emulating monochrome displays (Hercules or CGA/monochrome), the default
colour palette can now be selected in the configuration file.

*This feature was backported to 0.75.2 release;
[read more](0.75.2.md#select-monochrome-palette-colour).*


### Raw mouse input setting

User can now bypass the operating system's mouse acceleration and sensitivity
settings. This works in fullscreen or when the mouse is captured in window mode.

*This feature was backported to 0.75.2 release;
[read more](0.75.2.md#raw-mouse-input).*


### 10-axis controller support

Old joysticks compatible with DOS games can be emulated using modern 10-axis
controllers (like DualShock or Xbox controllers).

*This feature was backported to 0.75.1 release;
[read more](0.75.1.md#add-support-for-binding-more-controller-axes).*


### Log memory base address

The base memory address of DOS's emulated memory region is now logged to the
console to help some users of external software, such as **Cheat Engine**.

*This feature was backported to 0.75.1 release;
[read more](0.75.1.md#log-base-address-of-emulated-memory).*


## Bugfixes

Some notable bugfixes:

- Prevent SDL2 crash on exit when using Wayland. (#336)
- Fix sound effects in Prince of Persia on Tandy. (#457)
- Prevent crash on SDL2 re-creating OpenGL window. (#510)
- Fix `dir /p` in non-standard text modes. (#528)
- Prevent injection of spurious newlines in autoexec and bat files. (#536)
- Fix `capture_mouse` `middlegame` setting. (#563)
- Fix a CD-DA roll-over bug when calculating PCM frames. (#569)
- Fix boot failure from an image mounted as C:. (#589)
- Fix memory leak in the modem phone book. (#622)
- Fix `cls` command. (#639)
- Increase default DOS file limit for emulation of program Subiekt 4. (#656)
- Fix Pentium CPUID to indicate CPU without FDIV bug. (#694)

- *(from SVN)* Multiple bugfixes and regression fixes for various games or demoscene
  productions, such as
  [Clue: Master Detective](https://www.mobygames.com/game/dos/clue-master-detective)
  (1989), ([8c002]),
  [Pleasure'n Pain](https://demozoo.org/productions/102239/) demo
  ([8c07c], [e9a67]), MayDay demo ([b6e77]), PC Tools 9, and others.

- *(from SVN)* Set Precision Exception in `FRNDINT` (Round to Integer instruction),
   to avoid bug when running Borland Pascal `pow` implementation. ([7892b])

[8c002]: https://github.com/dosbox-staging/dosbox-staging/commit/8c0021ab2a0ae56a413e12816c0cb8a472f36cd0
[8c07c]: https://github.com/dosbox-staging/dosbox-staging/commit/8c07c9bcae56dfff9602995aad39708d1c8c975a
[e9a67]: https://github.com/dosbox-staging/dosbox-staging/commit/e9a67fcaa73dcdc66d6ab2477821d3ddc2034fbf
[b6e77]: https://github.com/dosbox-staging/dosbox-staging/commit/b6e7718ebc6cd93498f4b4505bc2e5be6f09edcb
[7892b]: https://github.com/dosbox-staging/dosbox-staging/commit/7892be26c72f812c0f58d17524516370fbde9bd6


## Known issues

- *(added on 2020-12-04)* Windows x64 builds are not available for now due
  to regression after building in Visual Studio 16.8.2. (#746)

- The W^X memory protection (enabled by default via e.g. SELinux) prevents
  dynamic recompiler from working. (#253)

- Keymapper has problems with mapping multiple axes when multiple controllers
  are plugged in (e.g. notably when using modern joysticks and throttles
  connected at the same time). (#342)

- GLSL shader implementation crashes on certain Intel GPUs on Arch. (#319)

- Mapping key scancodes on X11 using `xmodmap` can break SDL2 ability to
  detect your keyboard layout and leave you with non-functional keyboard input.
  Use udev instead of xmodmap to prevent this problem.

- Some users of Gnome 3.38.1 experience problems when toggling fullscreen (both
  X11 and Wayland). This seems to be a Gnome issue; if you experience it as
  well, please make a report in the bugtracker.


## Removed features

- Option `gusrate` in the `[gus]` section was removed. The revised Gravis UltraSound
  emulation implementation made this option obsolete.

- Option `oplrate` in the `[sblaster]` section was removed. This value is now
  automatically tied to `rate` in `[mixer]` to avoid resampling (so users do not
  need to manually correlate values for these two options any more).


## Notes for developers

- Project switched to using C++14.

- We introduced [unit tests][UT] (using Google Test framework). At the moment,
  unit tests are running on Linux only---to build them use `--enable-tests`
  configure flag and `make test` to run them. They are included in CI gating.

- Windows x64 builds were added to Visual Studio solution (both Debug and
  Release profiles).

- CI was extended with gating based on MSVC (32-bit and 64-bit builds)

- Due to instability and extremely slow installation times MSYS2 was
  removed from gating CI. It is still included in our daily builds, but we do
  not recommend using MSYS2 for development.

- Linux builds for ARMv6, ARMv7, ARMv8 (AArch64), ppc64le, and s390x
  architectures were added to our set of daily builds.

- We fixed all `-Wall -Weffc++` warnings on Linux and macOS and corrected
  a large number of issues detected via static and dynamic code analysis tools.

<figure markdown>
  ![Warnings graph](https://www.dosbox-staging.org/static/images/release-notes/0.76.0/dosbox-staging-warnings-nov-2020.png)

  <figcaption markdown>
  When the project started we inherited 1411 warnings from DOSBox; as of
  November 2020, the builds are finally clean, so it's easier to make sure we
  do not introduce new warnings.
  </figcaption>
</figure>


[UT]: https://en.wikipedia.org/wiki/Unit_testing


## Changes merged from upstream projects

- Merge DOSBox SVN changes up to revision 4392
- Sync dr\_mp3 v0.6.11 from upstream
- Sync dr\_flac v0.12.13 from upstream
- Sync dr\_wav v0.12.4 from upstream
- Sync xxhash 0.8.0 from upstream
- Sync stb header v2.36 from upstream
- Sync stb\_vorbis v1.19 from upstream


## Contributors

During DOSBox Staging 0.76 development period we merged **1035** commits,
including **55** commits originating from the DOSBox project.

### Maintainers

<div class="compact" markdown>

- Patryk Obara
- kcgen
- nemo93

</div>

### Direct contributors

<div class="compact" markdown>

- Affonso Amendola
- Bernard Cafarelli
- cfoesch
- ClassicHasClass
- David Heidelberg
- drfiemost
- Edward Betts
- Erlotinib
- Expack3
- Feignint
- Jonathan Campbell
- MasterO2
- NicknineTheEagle
- Nikos Chantziaras
- Robert de Rooy
- Troy Campbell
- Tyrell Sassen
- Vladimir Serbinenko
- Wengier

</div>

### DOSBox contributors

SVN r4336:r4392

<div class="compact" markdown>

- Harekiet
- jmarsh
- Jonathan Campbell
- NewRisingSun
- Qbix
- ripsaw8080

</div>


## Thank you

We are extremely grateful for all contributions, including the invaluable
improvements merged in from the DOSBox project.

